<CFINCLUDE TEMPLATE="security.cfm">

<HTML>
<HEAD><TITLE>Conference Status</TITLE></HEAD>
<BODY BGCOLOR=white>

<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">

<CFIF IsDefined("first")>
	<CFIF #Form.edit# EQ " < ">
		<!--- Make active --->
		<CFLOOP INDEX=count LIST="#Form.inactiveConfs#">
			<CFQUERY NAME=makeActive DATASOURCE="#CFdatasource#">
				UPDATE Conference
				SET confStatus = 1
				WHERE confID = #count#
			</CFQUERY>
		</CFLOOP>
		<H3>Conferences were made active.</H3>
	<CFELSEIF #Form.edit# EQ " > "><!--- Make inactive --->
		<CFLOOP INDEX=count LIST="#Form.activeConfs#">
			<CFQUERY NAME=makeInactive DATASOURCE="#CFdatasource#">
				UPDATE Conference
				SET confStatus = 0
				WHERE confID = #count#
			</CFQUERY>
		</CFLOOP>
		<H3>Conferences were made <I>in</I>active.</H3>
	<CFELSEIF NOT IsDefined("Form.okDelete")>
		<H3>Checkbox was not checked. Conference(s) not deleted.</H3>
	<CFELSE><!--- Delete inactive conferences --->
		<!---
		Deleting conferences:
			1. Group files in conf directory
			2. Conf files in conf directory
			3. Conference table
			4. ConfForum table
			5. GrpConf table
			6. Alias files
		Deleting forums:
			7. Forum files in forum directory
			8. Forum table
			9. Message table
			10. UserForumAdmin table
			11. UserMsgSubscribe table
		--->

		<CFIF IsDefined("Form.okDeleteForums")>
			<CFQUERY NAME=getDupForums DATASOURCE="#CFdatasource#">
				SELECT DISTINCTROW First(ConfForum.forumID) AS [forumIDField],
					Count(ConfForum.forumID) AS NumberOfDups
				FROM ConfForum
				GROUP BY ConfForum.forumID
				HAVING Count(ConfForum.forumID) > 1
			</CFQUERY>
		</CFIF>

		<CFLOOP INDEX=count LIST="#Form.deleteConfs#">
			<CFQUERY NAME=getAlias DATASOURCE="#CFdatasource#">
				SELECT urlAnonAlias, urlLoginAlias, urlAdduserAlias
				FROM Conference
				WHERE confID = #count#
			</CFQUERY>
			<CFIF #getAlias.urlAnonAlias# NEQ "" AND #getAlias.urlAnonAlias# NEQ " ">
				<CFIF #FileExists("#systemPath#\#getAlias.urlAnonAlias#.cfm")# EQ "YES">
					<CFFILE ACTION=Delete FILE="#systemPath#\#getAlias.urlAnonAlias#.cfm">
				</CFIF>
			</CFIF>
			<CFIF #getAlias.urlLoginAlias# NEQ "" AND #getAlias.urlLoginAlias# NEQ " ">
				<CFIF #FileExists("#systemPath#\#getAlias.urlLoginAlias#.cfm")# EQ "YES">
					<CFFILE ACTION=Delete FILE="#systemPath#\#getAlias.urlLoginAlias#.cfm">
				</CFIF>
			</CFIF>
			<CFIF #getAlias.urlAdduserAlias# NEQ "" AND #getAlias.urlAdduserAlias# NEQ " ">
				<CFIF #FileExists("#systemPath#\#getAlias.urlAdduserAlias#.cfm")# EQ "YES">
					<CFFILE ACTION=Delete FILE="#systemPath#\#getAlias.urlAdduserAlias#.cfm">
				</CFIF>
			</CFIF>

			<CFQUERY NAME=getGroups DATASOURCE="#CFdatasource#">
				SELECT groupID FROM GrpConf WHERE confID = #count#
			</CFQUERY>
			<CFFILE ACTION=Read FILE="#systemPath#\default\confDeleteList.cfm" VARIABLE="deleteList">
			<CFLOOP INDEX=cntList LIST="#deleteList#">
				<CFIF #FileExists("#systemPath#\conf\#count##cntList#.cfm")# EQ "YES">
					<CFFILE ACTION=Delete FILE="#systemPath#\conf\#count##cntList#.cfm">
				</CFIF>
			</CFLOOP>
			<CFIF #FileExists("#systemPath#\conf\#count#Forums.cfm")# EQ "YES">
				<CFFILE ACTION=Delete FILE="#systemPath#\conf\#count#Forums.cfm">
			</CFIF>

			<CFIF IsDefined("Form.okDeleteForums")>
				<CFQUERY NAME=getForums DATASOURCE="#CFdatasource#">
					SELECT forumID FROM ConfForum WHERE confID = #count#
				</CFQUERY>
				<CFLOOP QUERY="getForums">
					<CFIF #ListFind("#ValueList(getDupForums.forumIDField)#",#getForums.forumID#)# EQ 0>
						<CFIF IsDefined("deleteForumList")>
							<CFSET deleteForumList = #ListAppend("#deleteForumList#",#getForums.forumID#)#>
						<CFELSE>
							<CFSET deleteForumList = #getForums.forumID#>
						</CFIF>
					</CFIF>
				</CFLOOP>
				<CFIF IsDefined("deleteForumList")>
					<CFSET count = 2>
					<CFQUERY NAME=deleteForum DATASOURCE="#CFdatasource#">
						DELETE FROM Forum
						WHERE forumID = #ListFirst("#deleteForumList#")#
						<CFLOOP INDEX=forumCount4 LIST="#deleteForumList#">
							OR forumID = #forumCount4#
						</CFLOOP>
					</CFQUERY>

					<!--- Delete from UserForumAdmin table --->
					<CFSET count = 2>
					<CFQUERY NAME=deleteForumAdmin DATASOURCE="#CFdatasource#">
						DELETE FROM UserForumAdmin
						WHERE forumID = #ListFirst("#deleteForumList#")#
						<CFLOOP INDEX=count LIST="#deleteForumList#">
							OR forumID = #count#
						</CFLOOP>
					</CFQUERY>

					<CFSET count = 1>
					<CFLOOP INDEX=count LIST="#deleteForumList#">
						<CFIF #FileExists("#systemPath#\forum\#count#Description.cfm")# EQ "YES">
							<CFFILE ACTION=Delete FILE="#systemPath#\forum\#count#Description.cfm">
						</CFIF>
						<CFIF #FileExists("#systemPath#\forum\#count#Footer.cfm")# EQ "YES">
							<CFFILE ACTION=Delete FILE="#systemPath#\forum\#count#Footer.cfm">
						</CFIF>
						<CFIF #FileExists("#systemPath#\forum\#count#Header.cfm")# EQ "YES">
							<CFFILE ACTION=Delete FILE="#systemPath#\forum\#count#Header.cfm">
						</CFIF>
						<CFIF #FileExists("#systemPath#\forum\#count#HeaderFooter.cfm")# EQ "YES">
							<CFFILE ACTION=Delete FILE="#systemPath#\forum\#count#HeaderFooter.cfm">
						</CFIF>
						<CFIF #FileExists("#systemPath#\forum\#count#Name.cfm")# EQ "YES">
							<CFFILE ACTION=Delete FILE="#systemPath#\forum\#count#Name.cfm">
						</CFIF>
						<CFIF #FileExists("#systemPath#\forum\#count#Status.cfm")# EQ "YES">
							<CFFILE ACTION=Delete FILE="#systemPath#\forum\#count#Status.cfm">
						</CFIF>
					</CFLOOP>

					<!--- Delete from UserMsgSubscribe if msgID is in forumID --->
					<CFSET count = 2>
					<CFQUERY NAME=getSubscribe DATASOURCE="#CFdatasource#">
						SELECT UserMsgSubscribe.msgID
						FROM Message INNER JOIN UserMsgSubscribe ON Message.msgID = UserMsgSubscribe.msgID
						WHERE Message.forumID = #ListFirst("#deleteForumList#")#
						<CFLOOP INDEX=count LIST="#deleteForumList#">
							OR forumID = #count#
						</CFLOOP>
					</CFQUERY>
	
					<CFSET count = 2>
					<CFIF #getSubscribe.RecordCount# GT 0>
						<CFQUERY NAME=deleteSubscribe DATASOURCE="#CFdatasource#">
							DELETE
							FROM UserMsgSubscribe
							WHERE msgID = #ListFirst("#ValueList(getSubscribe.msgList)#", ",")#
							<CFLOOP INDEX=count LIST="#ValueList(getSubscribe.msgList)#">
								OR msgID = '#count#'
							</CFLOOP>
						</CFQUERY>
					</CFIF>
	
					<!--- Delete from Message table --->
					<CFSET count = 2>
					<CFQUERY NAME=deleteMessage DATASOURCE="#CFdatasource#">
						DELETE
						FROM Message
						WHERE forumID = #ListFirst("#deleteForumList#")#
						<CFLOOP INDEX=count LIST="#deleteForumList#">
							OR forumID = #count#
						</CFLOOP>
					</CFQUERY>
				</CFIF>
			</CFIF>
		</CFLOOP>

		<CFSET count = 2>
		<CFQUERY NAME=deleteConference DATASOURCE="#CFdatasource#">
			DELETE FROM Conference
			WHERE confID = #ListFirst("#Form.deleteConfs#")#
			<CFLOOP INDEX=count LIST="#Form.deleteConfs#">
				OR confID = #count#
			</CFLOOP>
		</CFQUERY>

		<CFSET count = 2>
		<CFQUERY NAME=deleteGrpConf DATASOURCE="#CFdatasource#">
			DELETE FROM GrpConf
			WHERE confID = #ListFirst("#Form.deleteConfs#")#
			<CFLOOP INDEX=count LIST="#Form.deleteConfs#">
				OR confID = #count#
			</CFLOOP>
		</CFQUERY>

		<CFSET count = 2>
		<CFQUERY NAME=deleteConfForum DATASOURCE="#CFdatasource#">
			DELETE FROM ConfForum
			WHERE confID = #ListFirst("#Form.deleteConfs#")#
			<CFLOOP INDEX=count LIST="#Form.deleteConfs#">
				OR confID = #count#
			</CFLOOP>
		</CFQUERY>

		<H3>Conferences deleted.</H3>
	</CFIF>

	<!--- Create list of conferences for navigation --->
	<CFINCLUDE TEMPLATE="confSelectList.cfm">

	<P><HR NOSHADE COLOR=purple><P>
</CFIF>

<H1 ALIGN=center><FONT COLOR=purple>Conference Status</FONT></H1>
<FORM METHOD=post ACTION=confStatus.cfm>
<INPUT TYPE=hidden NAME=first VALUE=1>
<CFQUERY NAME=getConferences DATASOURCE="#CFdatasource#">
	SELECT confID, confName, confStatus FROM Conference
</CFQUERY>

To make a conference(s) active, highlight the conference(s) to make active in the <I>Inactive Conferences</I> list and click on the &quot;<I>&lt;</I>&quot; button. To make a conference(s) inactive, highlight the conference(s) to make inactive in the <I>Active Conferences</I> list and click on the &quot;<I>&gt;</I>&quot; button. Please note you cannot perform both actions at the same time.
<P>
NOTE: If you only see one select box above, then all conferences are either active or inactive. (Some browsers will not display an empty select box.)
<P>
<CENTER><TABLE BORDER=0 CELLSPACING=1 CELLPADDING=2>
<TH>Active Conferences</TH>
<TH></TH>
<TH><I>In</I>active Conferences</TH>
<TR>
<TD ALIGN=center><SELECT NAME="activeConfs" SIZE=10 MULTIPLE>
<CFLOOP QUERY="getConferences">
	<CFIF #confStatus# EQ 1>
		<CFOUTPUT><OPTION VALUE=#confID#>#confName# (#confID#)</CFOUTPUT>
		<CFSET blank = 0>
	</CFIF>
</CFLOOP>
<CFIF NOT IsDefined("blank")><OPTION VALUE=""></CFIF>
	</SELECT></TD>
	<TD VALIGN=center ALIGN=center>
	<INPUT TYPE=submit NAME=edit VALUE=" &gt; "><P>
	<INPUT TYPE=submit NAME=edit VALUE=" &lt; "><P><BR>
	<INPUT TYPE=reset VALUE=Clear>
	</TD>
	<TD ALIGN=center>
	<SELECT NAME="inactiveConfs" SIZE=10 MULTIPLE>
<CFLOOP QUERY="getConferences">
	<CFIF #confStatus# EQ 0>
		<CFOUTPUT><OPTION VALUE=#confID#>#confName# (#confID#)</CFOUTPUT>
		<CFSET blank2 = 0>
	</CFIF>
</CFLOOP>
<CFIF NOT IsDefined("blank2")><OPTION VALUE=""></CFIF>
</SELECT></TD>
</TR>
</TABLE></CENTER>

<P><HR NOSHADE COLOR=purple><P>
To delete an inactive conference(s), highlight the conference(s) to delete in the list below and click on the &quot;<I>Delete</I>&quot; button. To avoid accidently deleting conferences, the checkbox must be checked to delete the conference(s). Note that if there is no select box below, then there are no inactive conferences. (Some browsers will not display an empty select box.)
<P>
<CENTER><TABLE BORDER=0 CELLSPACING=1 CELLPADDING=2>
<TH>Delete <I>In</I>active Conferences</TH>
<TR>
<TD ALIGN=center><SELECT NAME="deleteConfs" SIZE=10 MULTIPLE>
<CFLOOP QUERY="getConferences">
	<CFIF #confStatus# EQ 0>
		<CFOUTPUT><OPTION VALUE=#confID#>#confName# (#confID#)</CFOUTPUT>
		<CFSET blank3 = 0>
	</CFIF>
</CFLOOP>
<CFIF NOT IsDefined("blank3")><OPTION VALUE=""></CFIF>
</SELECT></TD>
</TR>
<TR><TD ALIGN=center><INPUT TYPE=reset VALUE=Clear> &nbsp; <INPUT TYPE=submit NAME=edit VALUE="Delete"><BR>
<INPUT TYPE=checkbox NAME=okDelete VALUE=1> Must be checked to delete.<BR>
<INPUT TYPE=checkbox NAME=okDeleteForums VALUE=1> Check to delete all forums (and messages)<BR>&nbsp; &nbsp; which are in these conferences only.</TD></TR>
</TABLE></CENTER>

</FORM>
<CFINCLUDE TEMPLATE="../program/copyright.cfm">
</BODY>
</HTML>