<CFINCLUDE TEMPLATE="security.cfm">

<HTML>
<HEAD><TITLE>Emaze Forums: Default Conference Options</TITLE></HEAD>
<BODY BGCOLOR=white>

<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">

<FORM METHOD=post ACTION=confDefault.cfm>

<!---
This page is confusing, but was easier to consolidate in one big file.
Here is an explanation of how this page works:
1. If this is the first the file is called (first does not exist), display the default options.
2. If 2nd time, (first=1) display the edit screen for that option.
3. If 3rd time, (first=2) process the changes and re-display options.
--->

<CFIF NOT IsDefined("first")><!--- 1st time calling file. Display default options --->
	<CFINCLUDE TEMPLATE="confDefaultHome.cfm">

<CFELSEIF #Form.first# EQ 1><!--- 2nd time. Display edit page. --->
	<!--- Process results upon submitting form. Set variable to the default option being edited. --->
	<INPUT TYPE=hidden NAME=first VALUE=2>
	<CFOUTPUT><INPUT TYPE=hidden NAME=confOption VALUE=#Form.confOption#></CFOUTPUT>

	<!--- The following IF statement displays the proper edit page based on the default option chosen. --->
	<CFIF #Form.confOption# EQ "basic">
		<!--- basic = New user group; message, forum order; logout URL, access, search, other options --->
		<!--- Read the default basic options from the text files --->
		<CFINCLUDE TEMPLATE="../default/confAnonPermissions.cfm">
		<CFINCLUDE TEMPLATE="../default/confLogoutURL.cfm">
		<CFINCLUDE TEMPLATE="../default/confForumOrder.cfm">
		<CFINCLUDE TEMPLATE="../default/confHypertext.cfm">
		<CFINCLUDE TEMPLATE="../default/confIncludeIndex.cfm">
		<CFINCLUDE TEMPLATE="../default/confLoginCookie.cfm">
		<CFINCLUDE TEMPLATE="../default/confModerated.cfm">
		<CFINCLUDE TEMPLATE="../default/confMsgOrder.cfm">
		<CFINCLUDE TEMPLATE="../default/confNewUserGroup.cfm">
		<CFINCLUDE TEMPLATE="../default/confSearch.cfm">

		<!--- Get list of groups for determining new user group(s). --->
		<CFQUERY NAME="getGroups" DATASOURCE="#CFdatasource#">
			SELECT groupID, groupName FROM Grp ORDER BY groupName
		</CFQUERY>

		<!--- Display the table with the appropriate value checked for each option --->
		<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=2>
		<TR><TD ALIGN=right>Logout URL: </TD><TD><CFOUTPUT><INPUT TYPE=text SIZE=30 NAME=confLogoutURL VALUE=#logoutURL#></CFOUTPUT></TD></TR>
		<TR><TD ALIGN=right VALIGN=top>New user group(s): </TD>
		<TD><SELECT NAME=newUserGroup SIZE=4 MULTIPLE>
		<CFOUTPUT QUERY="getGroups">
			<CFIF #ListContains("#newUserGroup#",#groupID#)# NEQ 0><OPTION VALUE=#groupID# SELECTED>#groupName#
			<CFELSE><OPTION VALUE=#groupID#>#groupName#
			</CFIF>
		</CFOUTPUT>
		</SELECT></TD></TR>
		<TR><TD ALIGN=right VALIGN=top>Message Order: </TD>
		<TD><INPUT TYPE=radio NAME=msgOrder VALUE=0 <CFIF #msgOrder# EQ 0>CHECKED</CFIF>>Threaded (indented)<BR>
		<INPUT TYPE=radio NAME=msgOrder VALUE=1 <CFIF #msgOrder# EQ 1>CHECKED</CFIF>>Chronological, newest at top<BR>
		<INPUT TYPE=radio NAME=msgOrder VALUE=2 <CFIF #msgOrder# EQ 2>CHECKED</CFIF>>Chronological, newest at bottom</TD></TR>
		<TR><TD ALIGN=right VALIGN=top>Forum Order: </TD>
		<TD><INPUT TYPE=radio NAME=forumOrder VALUE=0 <CFIF #forumOrder# EQ 0>CHECKED</CFIF>> Chronological by creation date (oldest - newest)<BR>
		<INPUT TYPE=radio NAME=forumOrder VALUE=1 <CFIF #forumOrder# EQ 1>CHECKED</CFIF>> Reverse chronological (newest - oldest)<BR>
		<INPUT TYPE=radio NAME=forumOrder VALUE=2 <CFIF #forumOrder# EQ 2>CHECKED</CFIF>> Alphabetical (A-Z)<BR>
		<INPUT TYPE=radio NAME=forumOrder VALUE=3 <CFIF #forumOrder# EQ 3>CHECKED</CFIF>> Reverse alphabetical (Z-A)<BR>
		&nbsp; <B>-</B> &nbsp;Custom order (cannot be default value)</TD></TR>
		<TR><TD ALIGN=right VALIGN=top>Access options: </TD>
		<TD><INPUT TYPE=checkbox NAME=loginUserCookie VALUE=1 <CFIF #loginUserCookie# EQ 1>CHECKED</CFIF>> Allow automated login via cookie<BR>
		<I>Anonymous access permissions</I>:<BR>
		&nbsp; <INPUT TYPE=checkbox NAME=confAnonPermissions VALUE=read <CFIF #ListContains("#confAnonPermissions#", "read")#>CHECKED</CFIF>> Read<BR>
		&nbsp; <INPUT TYPE=checkbox NAME=confAnonPermissions VALUE=post <CFIF #ListContains("#confAnonPermissions#", "post")#>CHECKED</CFIF>> Post<BR>
		&nbsp; <INPUT TYPE=checkbox NAME=confAnonPermissions VALUE=create <CFIF #ListContains("#confAnonPermissions#", "create")#>CHECKED</CFIF>> Create new forums<BR>
		&nbsp; <INPUT TYPE=checkbox NAME=confAnonPermissions VALUE=postAttachments <CFIF #ListContains("#confAnonPermissions#", "postAttachments")#>CHECKED</CFIF>> Attachments
		</TD></TR>
		<TR><TD ALIGN=right VALIGN=top>Search options: </TD>
		<TD><INPUT TYPE=checkbox NAME=search VALUE=author <CFIF #ListContains("#search#", "author")#>CHECKED</CFIF>> By author<BR>
		<INPUT TYPE=checkbox NAME=search VALUE=date <CFIF #ListContains("#search#", "date")#>CHECKED</CFIF>> By date posted<BR>
		<INPUT TYPE=checkbox NAME=search VALUE=subject <CFIF #ListContains("#search#", "subject")#>CHECKED</CFIF>> By subject of message<BR>
		<INPUT TYPE=checkbox NAME=search VALUE=message <CFIF #ListContains("#search#", "message")#>CHECKED</CFIF>> By text of message</TD></TR>
		<TR><TD ALIGN=right VALIGN=top>Other options: </TD>
		<TD><INPUT TYPE=checkbox NAME=moderated VALUE=1 <CFIF #moderated# EQ 1>CHECKED</CFIF>> Moderated<BR>
		<INPUT TYPE=checkbox NAME=includeIndex VALUE=1 <CFIF #includeIndex# EQ 1>CHECKED</CFIF>> Include index<BR>
		<INPUT TYPE=checkbox NAME=hypertextURL VALUE=1 <CFIF #hypertextURL# EQ 1>CHECKED</CFIF>> Hypertext URLs<BR>
		<INPUT TYPE=checkbox NAME=mailtoEmails VALUE=1 <CFIF #mailtoEmails# EQ 1>CHECKED</CFIF>> Mailto email addresses</TD></TR>
		</TABLE>
		<P>
		<INPUT TYPE=reset VALUE=Clear> &nbsp; <INPUT TYPE=submit NAME=edit VALUE="Edit Conference">
		<!--- End of basic options --->
	<CFELSEIF #Form.confOption# EQ "body"><!--- Body tag options --->
		<!--- Read list of default body tag values. Save each value as a separate varaible. --->
		<CFINCLUDE TEMPLATE="../default/confBodyList.cfm">

		<!--- Display table of body tag options with default value checked and displayed in text field --->
		<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=2>
		<TH COLSPAN=2>Body tag options</TH>
		<TR><TD ALIGN=right VALIGN=top>Body bgcolor: </TD><TD><INPUT TYPE=radio NAME=bodyBgcolorRadio VALUE=select> <SELECT NAME=bodyBgcolorSelect SIZE=1>
		<OPTION VALUE=black>black<OPTION VALUE=blue>blue<OPTION VALUE=cyan>cyan
		<OPTION VALUE=gray>gray<OPTION VALUE=green>green<OPTION VALUE=navy>navy
		<OPTION VALUE=olive>olive<OPTION VALUE=orange>orange<OPTION VALUE=purple>purple<OPTION VALUE=red>red<OPTION VALUE=silver>silver
		<OPTION VALUE=teal>teal<OPTION VALUE=white SELECTED>white<OPTION VALUE=yellow>yellow
		</SELECT><BR>
		<INPUT TYPE=radio NAME=bodyBgcolorRadio VALUE=other CHECKED> <CFOUTPUT><INPUT TYPE=text NAME=bodyBgcolorText VALUE="#bodyBgcolor#" SIZE=15></CFOUTPUT></TD></TR>
		<TR><TD ALIGN=right VALIGN=top>Body background: </TD>
		<TD>
		<CFIF #bodyBackground# EQ "" OR #bodyBackground# EQ " ">
			<INPUT TYPE=checkbox NAME=useBodyBackground VALUE=1> <INPUT TYPE=text NAME=bodyBackground SIZE=25 VALUE="http://">
		<CFELSE><INPUT TYPE=checkbox NAME=useBodyBackground VALUE=1 CHECKED> <CFOUTPUT><INPUT TYPE=text NAME=bodyBackground SIZE=25 VALUE="#bodyBackground#"></CFOUTPUT>
		</CFIF> (full URL)</TD></TR>
		<TR><TD ALIGN=right VALIGN=top>Body text: </TD><TD><INPUT TYPE=radio NAME=bodyTextRadio VALUE=select> <SELECT NAME=bodyTextSelect SIZE=1>
		<OPTION VALUE=black SELECTED>black<OPTION VALUE=blue>blue<OPTION VALUE=cyan>cyan
		<OPTION VALUE=gray>gray<OPTION VALUE=green>green<OPTION VALUE=navy>navy
		<OPTION VALUE=olive>olive<OPTION VALUE=orange>orange<OPTION VALUE=purple>purple<OPTION VALUE=red>red<OPTION VALUE=silver>silver
		<OPTION VALUE=teal>teal<OPTION VALUE=white>white<OPTION VALUE=yellow>yellow
		</SELECT><BR>
		<INPUT TYPE=radio NAME=bodyTextRadio VALUE=other CHECKED> <CFOUTPUT><INPUT TYPE=text NAME=bodyTextText SIZE=15 VALUE="#bodyText#"></CFOUTPUT></TD></TR>
		<TR><TD ALIGN=right VALIGN=top>Body link: </TD><TD><INPUT TYPE=radio NAME=bodyLinkRadio VALUE=select> <SELECT NAME=bodyLinkSelect SIZE=1>
		<OPTION VALUE=black>black<OPTION VALUE=blue SELECTED>blue<OPTION VALUE=cyan>cyan
		<OPTION VALUE=gray>gray<OPTION VALUE=green>green<OPTION VALUE=navy>navy
		<OPTION VALUE=olive>olive<OPTION VALUE=orange>orange<OPTION VALUE=purple>purple<OPTION VALUE=red>red<OPTION VALUE=silver>silver
		<OPTION VALUE=teal>teal<OPTION VALUE=white>white<OPTION VALUE=yellow>yellow
		</SELECT><BR>
		<INPUT TYPE=radio NAME=bodyLinkRadio VALUE=other CHECKED> <CFOUTPUT><INPUT TYPE=text NAME=bodyLinkText SIZE=15 VALUE="#bodyLink#"></CFOUTPUT></TD></TR>
		<TR><TD ALIGN=right VALIGN=top>Body alink: </TD><TD><INPUT TYPE=radio NAME=bodyALinkRadio VALUE=select> <SELECT NAME=bodyALinkSelect SIZE=1>
		<OPTION VALUE=black>black<OPTION VALUE=blue>blue<OPTION VALUE=cyan>cyan
		<OPTION VALUE=gray>gray<OPTION VALUE=green>green<OPTION VALUE=navy>navy
		<OPTION VALUE=olive>olive<OPTION VALUE=orange>orange<OPTION VALUE=purple SELECTED>purple
		<OPTION VALUE=red>red<OPTION VALUE=silver>silver
		<OPTION VALUE=teal>teal<OPTION VALUE=white>white<OPTION VALUE=yellow>yellow
		</SELECT><BR>
		<INPUT TYPE=radio NAME=bodyALinkRadio VALUE=other CHECKED> <CFOUTPUT><INPUT TYPE=text NAME=bodyAlinkText SIZE=15 VALUE="#bodyAlink#"></CFOUTPUT></TD></TR>
		<TR><TD ALIGN=right VALIGN=top>Body vlink: </TD><TD><INPUT TYPE=radio NAME=bodyVLinkRadio VALUE=select> <SELECT NAME=bodyVLinkSelect SIZE=1>
		<OPTION VALUE=black>black<OPTION VALUE=blue>blue<OPTION VALUE=cyan>cyan
		<OPTION VALUE=gray>gray<OPTION VALUE=green>green<OPTION VALUE=navy>navy
		<OPTION VALUE=olive>olive<OPTION VALUE=orange>orange<OPTION VALUE=purple SELECTED>purple
		<OPTION VALUE=red>red<OPTION VALUE=silver>silver
		<OPTION VALUE=teal>teal<OPTION VALUE=white>white<OPTION VALUE=yellow>yellow
		</SELECT><BR>
		<INPUT TYPE=radio NAME=bodyVLinkRadio VALUE=other CHECKED> <CFOUTPUT><INPUT TYPE=text NAME=bodyVlinkText SIZE=15 VALUE="#bodyVlink#"></CFOUTPUT></TD></TR>
		<TR><TD ALIGN=right VALIGN=top>Other body tags: </TD>
		<TD><!--- Because bodyOther is last value in list, it may be read as a hard return --->
		<CFIF #bodyOther# EQ "" OR #bodyOther# EQ " " OR #bodyOther# EQ " 
" OR #Asc("#bodyOther#")# EQ 32>
			<INPUT TYPE=checkbox NAME=useBodyOther VALUE=1> <INPUT TYPE=text NAME=bodyOther SIZE=25>
		<CFELSE><INPUT TYPE=checkbox NAME=useBodyOther VALUE=1 CHECKED> <CFOUTPUT><INPUT TYPE=text NAME=bodyOther SIZE=25 VALUE="#bodyOther#"></CFOUTPUT>
		</CFIF> (full options)</TD></TR>
		</TABLE><P>
		<INPUT TYPE=reset VALUE=Clear> &nbsp; <INPUT TYPE=submit NAME=edit VALUE="Edit Conference">
		<!--- End of body tag options --->

	<CFELSEIF #Form.confOption# EQ "confHomepage"><!--- Conference homepage header and footer --->
		<!--- Read default header and footer. Display in textarea. --->
		The checkbox must be checked for template changes to take effect.<P>
		<DL>
		<DT><INPUT TYPE=checkbox NAME=okHomepageHeader VALUE=1> <B>Homepage Header</B>
		<CFFILE ACTION=Read FILE="#systemPath#\default\confHomepageHeader.cfm" VARIABLE="homepageHeader">
		<DD><TEXTAREA NAME="confHomepageHeader" COLS="50" ROWS="5" WRAP="off"><CFOUTPUT>#homepageHeader#</CFOUTPUT></TEXTAREA>
		<P><HR NOSHADE COLOR=purple><P>
		<DT><INPUT TYPE=checkbox NAME=okHomepageFooter VALUE=1> <B>Homepage Footer</B>
		<CFFILE ACTION=Read FILE="#systemPath#\default\confHomepageFooter.cfm" VARIABLE="homepageFooter">
		<DD><TEXTAREA NAME="confHomepageFooter" COLS="50" ROWS="5" WRAP="off"><CFOUTPUT>#homepageFooter#</CFOUTPUT></TEXTAREA>
		</DL>
		<P>
		<INPUT TYPE=reset VALUE=Clear> &nbsp; <INPUT TYPE=submit NAME=edit VALUE="Edit Default Options">

	<CFELSEIF #Form.confOption# EQ "confLogin"><!--- Conference login screen header and footer --->
		<!--- Read default header and footer. Display in textarea. --->
		The checkbox must be checked for template changes to take effect.<P>
		<DL>
		<DT><INPUT TYPE=checkbox NAME=okLoginHeader VALUE=1> <B>Login Screen Header</B>
		<CFFILE ACTION=Read FILE="#systemPath#\default\confLoginHeader.cfm" VARIABLE="loginHeader">
		<DD><TEXTAREA NAME="confLoginHeader" COLS="50" ROWS="5" WRAP="off"><CFOUTPUT>#loginHeader#</CFOUTPUT></TEXTAREA>
		<P><HR NOSHADE COLOR=purple><P>
		<DT><INPUT TYPE=checkbox NAME=okLoginFooter VALUE=1> <B>Login Screen Footer</B>
		<CFFILE ACTION=Read FILE="#systemPath#\default\confLoginFooter.cfm" VARIABLE="loginFooter">
		<DD><TEXTAREA NAME="confLoginFooter" COLS="50" ROWS="5" WRAP="off"><CFOUTPUT>#loginFooter#</CFOUTPUT></TEXTAREA>
		</DL>
		<P>
		<INPUT TYPE=reset VALUE=Clear> &nbsp; <INPUT TYPE=submit NAME=edit VALUE="Edit Default Options">

	<CFELSEIF #Form.confOption# EQ "confAdduser"><!--- Conference add user header --->
		<!--- Read default add user headers. Display in textarea. --->
		The checkbox must be checked for template changes to take effect.<P>
		<DL>
		<DT><INPUT TYPE=checkbox NAME=okAdduser VALUE=1> <B>Add User Screen Header</B>
		<CFFILE ACTION=Read FILE="#systemPath#\default\confAdduserHeader.cfm" VARIABLE="adduser">
		<DD><TEXTAREA NAME="confAdduserHeader" COLS="50" ROWS="5" WRAP="off"><CFOUTPUT>#adduser#</CFOUTPUT></TEXTAREA>
		</DL>
		<P>
		<INPUT TYPE=reset VALUE=Clear> &nbsp; <INPUT TYPE=submit NAME=edit VALUE="Edit Default Options">

	<CFELSEIF #Form.confOption# EQ "confHeaderFooter"><!--- Conference forum header and footer --->
		<!--- Read header and footer values. Save settings as individual variables to make life easier --->
		<CFFILE ACTION=Read FILE="#systemPath#\default\confForumHeader.cfm" VARIABLE="header">
		<CFFILE ACTION=Read FILE="#systemPath#\default\confForumFooter.cfm" VARIABLE="footer">
		<CFINCLUDE TEMPLATE="../default/confHeaderFooter.cfm">

		<!--- Display options and current values. --->
		Checkboxes must be checked for template changes to take effect.<P>
		<DL>
		<DT><INPUT TYPE=checkbox NAME=okHeader VALUE=1> <B>Conference header template</B>
		<DD>
		<INPUT TYPE=radio NAME=confHeader VALUE=0 <CFIF #confHeader# EQ 0>CHECKED</CFIF>> No conference header<BR>
		<INPUT TYPE=radio NAME=confHeader VALUE=2 <CFIF #confHeader# EQ 2>CHECKED</CFIF>>
		Use external file: <INPUT TYPE=text SIZE=38 NAME=confHeaderPath VALUE=<CFIF #confHeader# EQ 2><CFOUTPUT>"#header#"</CFOUTPUT><CFELSE><CFOUTPUT>"#systemPath#\"</CFOUTPUT></CFIF>><BR>
		<INPUT TYPE=radio NAME=confHeader VALUE=1 <CFIF #confHeader# EQ 1>CHECKED</CFIF>>
		Use internal template below:<BR>
		&nbsp; &nbsp; &nbsp; <TEXTAREA NAME="confHeaderTemplate" COLS="50" ROWS="5" WRAP="off"><CFIF #confHeader# EQ 1><CFOUTPUT>#header#</CFOUTPUT></CFIF></TEXTAREA><BR>

		<P><HR NOSHADE COLOR=purple><P>

		<DT><INPUT TYPE=checkbox NAME=okFooter VALUE=1> <B>Conference footer template</B>
		<DD>
		<INPUT TYPE=radio NAME=confFooter VALUE=0 <CFIF #confFooter# EQ 0>CHECKED</CFIF>> No conference footer<BR>
		<INPUT TYPE=radio NAME=confFooter VALUE=2 <CFIF #confFooter# EQ 2>CHECKED</CFIF>>
		Use external file: <INPUT TYPE=text SIZE=38 NAME=confFooterPath VALUE=<CFIF #confFooter# EQ 2><CFOUTPUT>"#footer#"</CFOUTPUT><CFELSE><CFOUTPUT>"#systemPath#\"</CFOUTPUT></CFIF>><BR>
		<INPUT TYPE=radio NAME=confFooter VALUE=1 <CFIF #confFooter# EQ 1>CHECKED</CFIF>>
		Use internal template below:<BR>
		&nbsp; &nbsp; &nbsp; <TEXTAREA NAME="confFooterTemplate" COLS="50" ROWS="5" WRAP="off"><CFIF #confHeader# EQ 1><CFOUTPUT>#footer#</CFOUTPUT></CFIF></TEXTAREA><BR>
		</DL>
		<P>
		<INPUT TYPE=reset VALUE=Clear> &nbsp; <INPUT TYPE=submit NAME=edit VALUE="Edit Default Options">

	<CFELSE><!--- Form.confOption EQ "searchQueryResults" (search query, results headers)--->
		<!--- Read default headers. --->
		<CFFILE ACTION=Read FILE="#systemPath#\default\confSearchQueryHeader.cfm" VARIABLE="query">
		<CFFILE ACTION=Read FILE="#systemPath#\default\confSearchResultsHeader.cfm" VARIABLE="results">

		<!--- Display options and current values. --->	
		The checkbox must be checked for template changes to take effect.<P>
		<DL>
		<DT><INPUT TYPE=checkbox NAME=okQuery VALUE=1> <B>Search Query Template</B>
		<DD><TEXTAREA NAME="confSearchQueryHeader" COLS="50" ROWS="5" WRAP="off"><CFOUTPUT>#query#</CFOUTPUT></TEXTAREA><BR>
		<P><HR NOSHADE COLOR=purple><P>
	
		<DT><INPUT TYPE=checkbox NAME=okResults VALUE=1> <B>Search Results Template</B>
		<DD><TEXTAREA NAME="confSearchResultsHeader" COLS="50" ROWS="5" WRAP="off"><CFOUTPUT>#results#</CFOUTPUT></TEXTAREA><BR>
		</DL>
		<P>
		<INPUT TYPE=reset VALUE=Clear> &nbsp; <INPUT TYPE=submit NAME=edit VALUE="Edit Default Options">
	</CFIF><!--- End of first=1, display default options edit screen. --->

<CFELSE><!--- first EQ 2. Process new default options. --->
	<CFIF #Form.confOption# EQ "basic"><!--- Process basic options --->
		<!--- Write new default options to the default text files --->
		<CFFILE ACTION=Write FILE="#systemPath#\default\confLogoutURL.cfm"
			OUTPUT="<CFSET logoutURL = ""#Form.confLogoutURL#"">">
		<CFFILE ACTION=Write FILE="#systemPath#\default\confForumOrder.cfm"
			OUTPUT="<CFSET forumOrder = #Form.forumOrder#>">
		<CFFILE ACTION=Write FILE="#systemPath#\default\confMsgOrder.cfm"
			OUTPUT="<CFSET msgOrder = #Form.msgOrder#>">
		<CFFILE ACTION=Write FILE="#systemPath#\default\confnewUserGroup.cfm"
			OUTPUT="<CFSET newUserGroup = ""#Form.newUserGroup#"">">

		<!--- If loginUserCookie was checked, write 1. If not, write 0. --->
		<CFIF IsDefined("Form.loginUserCookie")>
			<CFFILE ACTION=Write FILE="#systemPath#\default\confLoginCookie.cfm"
				OUTPUT="<CFSET loginUserCookie = 1>">
		<CFELSE>
			<CFFILE ACTION=Write FILE="#systemPath#\default\confLoginCookie.cfm"
				OUTPUT="<CFSET loginUserCookie = 0>">
		</CFIF>

		<!--- If any anon permissions were checked, write them. If not, write blank space. --->
		<CFIF IsDefined("Form.confAnonPermissions")>
			<CFFILE ACTION=Write FILE="#systemPath#\default\confAnonPermissions.cfm"
				OUTPUT="<CFSET confAnonPermissions = ""#Form.confAnonPermissions#"">">
		<CFELSE>
			<CFFILE ACTION=Write FILE="#systemPath#\default\confAnonPermissions.cfm"
				OUTPUT="<CFSET confAnonPermissions = "" "">">
		</CFIF>

		<!--- If either hypertext checkbox checked, write 1 for that value. Otherwise, write 0. --->
		<CFIF IsDefined("Form.hypertextURL")><CFSET url = 1>
			<CFELSE><CFSET url = 0></CFIF>
		<CFIF IsDefined("Form.mailtoEmails")><CFSET email = 1>
			<CFELSE><CFSET email = 0></CFIF>
		<!--- Write hypertext values to text file --->
		<CFFILE ACTION=Write FILE="#systemPath#\default\confHypertext.cfm"
			OUTPUT="<CFSET hypertextURL = #url#>
<CFSET mailtoEmails = #email#>">

		<!--- If index checkbox was checked, write 1. Otherwise, wrote 0. --->
		<CFIF IsDefined("Form.includeIndex")>
			<CFFILE ACTION=Write FILE="#systemPath#\default\confIncludeIndex.cfm"
				OUTPUT="<CFSET includeIndex = 1>">
		<CFELSE>
			<CFFILE ACTION=Write FILE="#systemPath#\default\confIncludeIndex.cfm"
				OUTPUT="<CFSET includeIndex = 0>">
		</CFIF>

		<!--- If moderated checkbox was checked, write 1. Otherwise, wrote 0. --->
		<CFIF IsDefined("Form.moderated")>
			<CFFILE ACTION=Write FILE="#systemPath#\default\confModerated.cfm"
				OUTPUT="<CFSET moderated = 1>">
		<CFELSE>
			<CFFILE ACTION=Write FILE="#systemPath#\default\confModerated.cfm"
				OUTPUT="<CFSET moderated = 0>">
		</CFIF>

		<!--- If any search permissions were checked, write them. If not, write blank space. --->
		<CFIF IsDefined("Form.search")>
			<CFFILE ACTION=Write FILE="#systemPath#\default\confSearch.cfm"
				OUTPUT="<CFSET search = ""#Form.search#"">">
		<CFELSE>
			<CFFILE ACTION=Write FILE="#systemPath#\default\confSearch.cfm"
				OUTPUT="<CFSET search = "" "">">
		</CFIF>

		<H3>Default conference options updated.</H3>
	<CFELSEIF #Form.confOption# EQ "body"><!--- Process body tag options. --->
		<!--- bodyEdit.cfm determines the proper body tag values to use. --->
		<CFINCLUDE TEMPLATE="bodyEdit.cfm">
		<!--- Write default body tag and default body tag list files. --->
		<CFFILE ACTION=Write FILE="#systemPath#\default\confBody.cfm" OUTPUT="<BODY #bodyBgcolor# #bodyBackground# #bodyText# #bodyLink# #bodyAlink# #bodyVlink# #bodyOther#>">
		<CFFILE ACTION=Write FILE="#systemPath#\default\confBodyList.cfm"
			OUTPUT="<CFSET bodyBgcolor = ""#bodyBgcolorDB#"">
<CFSET bodyBackground = ""#bodyBackgroundDB#"">
<CFSET bodyText = ""#bodyTextDB#"">
<CFSET bodyLink = ""#bodyLinkDB#"">
<CFSET bodyAlink = ""#bodyAlinkDB#"">
<CFSET bodyVlink = ""#bodyVlinkDB#"">
<CFSET bodyOther = ""#bodyOtherDB#"">">
		<H3>Default conference body tag options updated.</H3>

	<CFELSEIF #Form.confOption# EQ "confHomepage"><!--- Process homepage header and footer changes. --->
		<!--- Options are only updated if checkbox was checked. --->
		<!--- If header checkbox was checked, update header. --->
		<CFIF IsDefined("Form.okHomepageHeader")>
			<CFFILE ACTION=Write FILE="#systemPath#\default\confHomepageHeader.cfm" OUTPUT="#Form.confHomepageHeader#">
			<H3>Default conference homepage header updated.</H3>
		</CFIF>
		<!--- If footer checkbox was checked, update footer. --->
		<CFIF IsDefined("Form.okHomepageFooter")>
			<CFFILE ACTION=Write FILE="#systemPath#\default\confHomepageFooter.cfm" OUTPUT="#Form.confHomepageFooter#">
			<H3>Default conference homepage footer updated.</H3>
		</CFIF>

	<CFELSEIF #Form.confOption# EQ "confLogin"><!--- Process login header and footer changes. --->
		<!--- Options are only updated if checkbox was checked. --->
		<!--- If header checkbox was checked, update header. --->
		<CFIF IsDefined("Form.okLoginHeader")>
			<CFFILE ACTION=Write FILE="#systemPath#\default\confLoginHeader.cfm" OUTPUT="#Form.confLoginHeader#">
			<H3>Default conference login screen header updated.</H3>
		</CFIF>
		<!--- If footer checkbox was checked, update footer. --->
		<CFIF IsDefined("Form.okLoginFooter")>
			<CFFILE ACTION=Write FILE="#systemPath#\default\confLoginFooter.cfm" OUTPUT="#Form.confLoginFooter#">
			<H3>Default conference login screen footer updated.</H3>
		</CFIF>

	<CFELSEIF #Form.confOption# EQ "confAdduser"><!--- Process add user header changes. --->
		<!--- Option is only updated if checkbox was checked. --->
		<CFIF IsDefined("Form.okAdduser")>
			<CFFILE ACTION=Write FILE="#systemPath#\default\confAdduserHeader.cfm" OUTPUT="#Form.confAdduserHeader#">
			<H3>Default conference add user screen header updated.</H3>
		</CFIF>

	<CFELSEIF #Form.confOption# EQ "confHeaderFooter"><!--- Update forum header and footer --->
		<!--- Get default values. Even if not updated, need to rewrite confHeaderFooter.cfm file. --->
		<CFINCLUDE TEMPLATE="../default/confHeaderFooter.cfm">

		<!--- If checkbox to change header is checked --->
		<CFIF IsDefined("Form.okHeader")>
			<CFSET confHeader = #Form.confHeader#><!--- Update new setting --->
			<CFIF #Form.confHeader# EQ 1><!--- Internal template: write header to text file --->
				<CFFILE ACTION=Write FILE="#systemPath#\default\confForumHeader.cfm" OUTPUT="#Form.confHeaderTemplate#">
			<CFELSE><!--- Form.confHeader=2. External template. Write path to file in text file. --->
				<CFFILE ACTION=Write FILE="#systemPath#\default\confForumHeader.cfm" OUTPUT="#Form.confHeaderPath#">
			</CFIF>
			<H3>Default forum header updated.</H3>
		</CFIF>

		<!--- If checkbox to change footer is checked --->
		<CFIF IsDefined("Form.okFooter")>
			<CFSET confFooter = #Form.confFooter#><!--- Update new setting --->
			<CFIF #Form.confFooter# EQ 1><!--- Internal template: write header to text file --->
				<CFFILE ACTION=Write FILE="#systemPath#\default\confForumFooter.cfm" OUTPUT="#Form.confFooterTemplate#">
			<CFELSE><!--- Form.confFooter=2. External template. Write path to file in text file. --->
				<CFFILE ACTION=Write FILE="#systemPath#\default\confForumFooter.cfm" OUTPUT="#Form.confFooterPath#">
			</CFIF>
			<H3>Default forum footer updated.</H3>
		</CFIF>

		<!--- Write new confHeaderFooter file with updated values. --->
		<CFFILE ACTION=Write FILE="#systemPath#\default\confHeaderFooter.cfm"
			OUTPUT="<CFSET confHeader = #confHeader#>
<CFSET confFooter = #confFooter#>">

	<CFELSE><!--- Form.confOption EQ "searchQueryResults". Update search query and results headers. --->
		<!--- If query header checkbox was checked, update query header. --->
		<CFIF IsDefined("Form.okQuery")>
			<CFFILE ACTION=Write FILE="#systemPath#\default\confSearchQueryHeader.cfm" OUTPUT="#Form.confSearchQueryHeader#">
			<H3>Default search query header updated.</H3>
		</CFIF>

		<!--- If results header checkbox was checked, update results header. --->
		<CFIF IsDefined("Form.okResults")>
			<CFFILE ACTION=Write FILE="#systemPath#\default\confSearchResultsHeader.cfm" OUTPUT="#Form.confSearchResultsHeader#">
			<H3>Default search results header updated.</H3>
		</CFIF>
	</CFIF>

	<!--- After updating results and outputting confirmation, include default options screen. --->
	<P><HR NOSHADE COLOR=purple><P>
	<CFINCLUDE TEMPLATE="confDefaultHome.cfm">
</CFIF>

</FORM>
<CFINCLUDE TEMPLATE="../program/copyright.cfm">
</BODY>
</HTML>