<CFINCLUDE TEMPLATE="security.cfm">

<HTML>
<HEAD><TITLE>Emaze Forums: Create a new conference</TITLE></HEAD>
<BODY BGCOLOR=white>

<!--- 
Insert default values into database when create new conference
--->

<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">

<!---
1. Check if urlAnonAlias is empty
	a. If no, is the name taken?
		i. If yes, must re-enter it. again=1. anonError = Name already used.
	b. If yes: can write to database and create file
2. Check if urlLoginAlias is empty
	a. If no, is the name taken?
		i. If yes, must re-enter it. again=1. userError = Name already used.
	b. If yes: can write to database and create file
3. Check if confName is empty
	a. If yes, must re-enter it. again=1
	b. If no, is name taken?
		i. If yes, must re-enter it. again=1
		ii. If no, can write to database and create file
4. If repeat=1, re-display form,
	If repeat does not exist, write options to database, create alias files,
	create files for new conference, and write default conference options to database.
--->

<!--- If this is not the first time the file was called, process form --->
<CFIF IsDefined("Form.first")>
	<!--- If conference name is blank, they must enter a conference name. --->
	<CFIF #Form.confName# EQ "">
		<H2>You must enter a conference name.</H2>
		<CFSET again = 1>
	<CFELSE>
		<!--- Conference name is not blank. Ensure name is not already being used. If yes, choose another name. --->
		<CFQUERY NAME=checkName DATASOURCE="#CFdatasource#">
			SELECT confID FROM Conference WHERE confName= '#Form.confName#'
		</CFQUERY>
		<CFIF #checkName.RecordCount# GT 0>
			<CFSET again = 1>
			<H3><I><CFOUTPUT>#Form.confName#</CFOUTPUT></I> is already being used by another conference. Please choose another conference name.</H3>
		</CFIF>
	</CFIF>

	<!--- If login alias is blank, don't create it.
		If not blank, ensure alias is not already being used. If yes, choose another alias. --->
	<CFIF #Form.urlLoginAlias# EQ "">
		<CFSET loginAliasTextfile = 0>
	<CFELSEIF #FileExists("#systemPath#\#Form.urlLoginAlias#.cfm")# EQ "YES">
		<CFSET again = 1>
		<CFSET loginAliasTextfile = 1>
		<H3><I><CFOUTPUT>#Form.urlLoginAlias#</CFOUTPUT></I> is already being used by another conference. Please choose another Login Alias.</H3>
	<CFELSE><!--- Alias is unique. Ok to create it. --->
		<CFSET loginAliasTextfile = 1>
	</CFIF>

	<!--- If login alias is blank, don't create it.
		If not blank, ensure alias is not already being used. If yes, choose another alias. --->
	<CFIF #Form.urlAnonAlias# EQ "">
		<CFSET anonAliasTextfile = 0>
	<CFELSEIF #FileExists("#systemPath#\#Form.urlAnonAlias#.cfm")# EQ "YES">
		<CFSET again = 1>
		<CFSET anonAliasTextfile = 1>
		<H3><I><CFOUTPUT>#Form.urlAnonAlias#</CFOUTPUT></I> is already being used by another conference. Please choose another Anon Alias.</H3>
	<CFELSE><!--- Alias is unique. Ok to create it. --->
		<CFSET anonAliasTextfile = 1>
	</CFIF>

	<!--- If conference name, login alias, and/or anon alias need to be re-entered --->
	<CFIF IsDefined("again")>
		<!--- Redisplay form with values inserted into the text fields --->
		<FORM METHOD=post ACTION=confCreate.cfm>
		<INPUT TYPE=hidden NAME=first VALUE=0>
		<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=2>
		<TR><TD ALIGN=right><FONT COLOR=red><B>*</B></FONT> Name: </TD><TD><CFOUTPUT><INPUT TYPE=text NAME=confName SIZE=30 MAXLENGTH=50 VALUE="#Form.confName#"></CFOUTPUT></TD></TR>
		<TR><TD ALIGN=right VALIGN=top>Description: </TD><TD><CFOUTPUT><TEXTAREA NAME=confDescription COLS=50 ROWS=3 WRAP=virtual>#Form.confDescription#</TEXTAREA></CFOUTPUT></TD></TR>
		<TR><TD ALIGN=right>User Login Alias: </TD><TD><CFOUTPUT><INPUT TYPE=text NAME=urlLoginAlias SIZE=30 MAXLENGTH=50 VALUE="#Form.urlLoginAlias#"></CFOUTPUT></TD></TR>
		<TR><TD ALIGN=right>Anon Login Alias: </TD><TD><CFOUTPUT><INPUT TYPE=text NAME=urlAnonAlias SIZE=30 MAXLENGTH=50 VALUE="#Form.urlAnonAlias#"></CFOUTPUT></TD></TR>
		<TR><TD COLSPAN=2 ALIGN=center HEIGHT=40><INPUT TYPE=reset VALUE=Clear> <INPUT TYPE=submit VALUE="Create New Conference"></TD></TR>
		</TABLE><P>
		</FORM>
	<CFELSE><!--- ALl is well. Create the conference. --->
		<!--- Get, incrememt next conference ID (confID). --->
		<CFINCLUDE TEMPLATE="../system/nextConfID.cfm">
		<CFSET nextConfID = confID + 1>
		<CFFILE ACTION=Write FILE="#systemPath#\system\nextConfID.cfm"
			OUTPUT="<CFSET confID = #nextConfID#>">

		<!---
		For each variable, if they are blank, replace with a space.
		This is necessary because you cannot write nothing to the database.
		So use a new variable to store what is being written to the database.
		The alternative is a bunch of IF statements in the SQL query.
		If not blank, set variable to form value. If blank, set to a space.
		--->

		<CFIF #Form.confDescription# EQ ""><CFSET confD = " ">
		<CFELSE><CFSET confD = "#Form.confDescription#">
		</CFIF>

		<CFIF #Form.urlLoginAlias# EQ ""><CFSET loginAlias = " ">
		<CFELSE><CFSET loginAlias = "#Form.urlLoginAlias#">
		</CFIF>

		<CFIF #Form.urlAnonAlias# EQ ""><CFSET anonAlias = " ">
		<CFELSE><CFSET anonAlias = "#Form.urlAnonAlias#">
		</CFIF>

		<!--- Query to insert the new conference info into the database. --->
		<CFQUERY NAME="CreateConference" DATASOURCE="#CFdatasource#">
			INSERT INTO Conference (confID, confDescription, confName, confStatus, urlAnonAlias, urlLoginAlias)
			VALUES (#confID#, '#confD#', '#Form.confName#', 1, '#anonAlias#', '#loginAlias#')
        </CFQUERY>

		<!---
		Emaze Forums uses text file to store many of the conference variables for quick retrieval.
		All of the names should be self-explanatory. If not, they are described in code.html .

		Default conference variables are stored in text files rather than the database.
		We could store them in the database just as easily, but chose to use the text files
		to require less initial information in the database, in case you are not using Access.
		
		First, we read the default values for new conferences which need to be inserted into teh database.
		 --->
		<CFINCLUDE TEMPLATE="../default/confAnonPermissions.cfm">
		<CFINCLUDE TEMPLATE="../default/confLogoutURL.cfm">
		<CFINCLUDE TEMPLATE="../default/confForumOrder.cfm">
		<CFINCLUDE TEMPLATE="../default/confHeaderFooter.cfm">
		<CFINCLUDE TEMPLATE="../default/confHypertext.cfm">
		<CFINCLUDE TEMPLATE="../default/confIncludeIndex.cfm">
		<CFINCLUDE TEMPLATE="../default/confLoginCookie.cfm">
		<CFINCLUDE TEMPLATE="../default/confModerated.cfm">
		<CFINCLUDE TEMPLATE="../default/confMsgOrder.cfm">
		<CFINCLUDE TEMPLATE="../default/confNewUserGroup.cfm">
		<CFINCLUDE TEMPLATE="../default/confSearch.cfm">
		<CFINCLUDE TEMPLATE="../default/confBodyList.cfm">

		<!--- Write default new conference options to database.
		We could have simply consolidated this query with the above one,
		but we chose not to since these are not critical, i.e., it won't
		cause a major problem if they do not get written immediately.
		--->
		<CFQUERY NAME="CreateConference" DATASOURCE="#CFdatasource#">
			UPDATE Conference
			SET bodyAlink = '#bodyAlink#',
				bodyBackground = '#bodyBackground#',
				bodyBgcolor = '#bodyBgcolor#',
				bodyLink = '#bodyLink#',
				bodyOther = '#bodyOther#',
				bodyText = '#bodyText#',
				bodyVlink = '#bodyVlink#',
				confFooter = #confFooter#,
				confHeader = #confHeader#,
				logoutURL = '#logoutURL#',
				forumOrder = #forumOrder#,
				hypertextURL = #hypertextURL#,
				includeIndex = #includeIndex#,
				confAnonPermissions = '#confAnonPermissions#',
				loginUserCookie = #loginUserCookie#,
				mailtoEmails = #mailtoEmails#,
				moderated = #moderated#,
				msgOrder = #msgOrder#,
				newUserGroup = '#newUserGroup#',
				search = '#search#'
			WHERE confID = #confID#
        </CFQUERY>

		<!--- Write conference name and description to text files. --->
		<CFFILE ACTION=Write FILE="#systemPath#\conf\#confID#Name.cfm"
			OUTPUT="<CFSET confName = ""#Form.confName#"">">
		<CFFILE ACTION=Write FILE="#systemPath#\conf\#confID#Description.cfm" OUTPUT="#Form.confDescription#">

		<!--- If necessary, create login alias file. File sets confID value and includes login file. --->
		<CFIF #loginAliasTextfile# EQ 1>
			<CFFILE ACTION=Write FILE="#systemPath#\#urlLoginAlias#.cfm"
				OUTPUT="<CFSET confID = #confID#>
<CFINCLUDE TEMPLATE=""program/login.cfm"">">
		</CFIF>

		<!--- If necessary, create anon alias file. File sets confID value and includes anon login file. --->
		<CFIF #anonAliasTextfile# EQ 1>
			<CFFILE ACTION=Write FILE="#systemPath#\#urlAnonAlias#.cfm"
				OUTPUT="<CFSET confID = #confID#>
<CFINCLUDE TEMPLATE=""program/anonLogin.cfm"">">
		</CFIF>

		<!---
		Read file containing list of default new conference files which need to be copied
		for the new conference. New conferences are automatically given the default options,
		so we need to copy the default files to the conf directory, and rename the files with
		the new confID at the beginning rather than "conf".
		
		The list of files does not include "conf" or ".cfm" since all default files begin
		and end with these values.
		--->
		<CFFILE ACTION=Read FILE="#systemPath#\default\confCreateList.cfm" VARIABLE="confCreateList">
		<CFLOOP INDEX=confFile LIST="#confCreateList#">
			<CFFILE ACTION=Copy SOURCE="#systemPath#\default\conf#confFile#.cfm" DESTINATION="#systemPath#\conf\">
			<CFFILE ACTION=Rename SOURCE="#systemPath#\conf\conf#confFile#.cfm" DESTINATION="#systemPath#\conf\#confID##confFile#.cfm">
		</CFLOOP>
		<CFFILE ACTION=Write FILE="#systemPath#\conf\#confID#ForumSelect.cfm" OUTPUT=" ">

		<!---
		Get list of groups from database. For each group, create blank text file
		with name #confID#-#groupID#Permissions.cfm . Later, the group's permissions
		to this conference will be written to this file. In the meantime, the file is
		blank, meaning the group has no permissions for this conference.
		--->
		<CFQUERY NAME=getGroups DATASOURCE="#CFdatasource#">
			SELECT groupID FROM Grp
		</CFQUERY>
		<CFLOOP QUERY="getGroups">
			<CFQUERY NAME=insertGrpConf DATASOURCE="#CFdatasource#">
				INSERT INTO GrpConf (confID, groupID)
				VALUES (#confID#, #getGroups.groupID#)
			</CFQUERY>
		</CFLOOP>

		<!--- Create list of conferences for navigation --->
		<CFINCLUDE TEMPLATE="confSelectList.cfm">
		<CFINCLUDE TEMPLATE="forumSelectList.cfm">

		<H2 ALIGN=center>The following conference has been created<BR><I><CFOUTPUT>#Form.confName#</CFOUTPUT></I></H2>
		<P><HR NOSHADE COLOR=purple><P>
		<!--- Display main edit conference screen. --->
		<CFINCLUDE TEMPLATE="conferenceHome.cfm">
	</CFIF>

<CFELSE><!--- First time file is called. Display form. --->
<H1 ALIGN=center><FONT COLOR=purple>Create a new conference</FONT></H1>

To create a new conference, please fill in the fields below. Required fields are marked with a red star (<FONT COLOR=red><B>*</B></FONT>). All fields can be changed at a later time.
<P>
The alias names must be a typical word. They cannot contain any spaces or other characters which are not permitted in filenames. They also cannot be named <I>index</I> as that is a reserved name. Please note that the system will automatically place a <I>.cfm</I> extension after the alias, so please do not include it in your chosen name.
<P>
If you do not enter a <I>User Login Alias</I> or <I>Anon Login Alias</I>, users will only be able to enter the conference by using the URLs supplied by the system until enter a value for these fields. The values must be unique, i.e, you cannot already be using it for another conference. The alias must have a .cfm extension to work.
<P>
Entering a value for the <I>Anon Login Alias</I> does not mean that users may enter the conference anonymously. That is determined in the <I>Access Options</I> setting, which you can change at any time.
<P>
<FORM METHOD=POST ACTION="confCreate.cfm">
<INPUT TYPE=hidden NAME=first VALUE=0>
<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=2>
<TR><TD ALIGN=right><FONT COLOR=red><B>*</B></FONT> Name: </TD><TD><INPUT TYPE=text NAME=confName SIZE=30 MAXLENGTH=50></TD></TR>
<TR><TD ALIGN=right VALIGN=top>Description: </TD><TD><TEXTAREA NAME=confDescription COLS=50 ROWS=3 WRAP=virtual></TEXTAREA></TD></TR>
<TR><TD ALIGN=right>User Login Alias: </TD><TD><INPUT TYPE=text NAME=urlLoginAlias SIZE=30 MAXLENGTH=50></TD></TR>
<TR><TD ALIGN=right>Anon Login Alias: </TD><TD><INPUT TYPE=text NAME=urlAnonAlias SIZE=30 MAXLENGTH=50></TD></TR>
<TR><TD COLSPAN=2 ALIGN=center HEIGHT=40><INPUT TYPE=reset VALUE=Clear> <INPUT TYPE=submit VALUE="Create New Conference"></TD></TR>
</TABLE>
</FORM>
</CFIF>

<CFINCLUDE TEMPLATE="../program/copyright.cfm">
</BODY>
</HTML>