<CFINCLUDE TEMPLATE="secure.cfm">

<CFIF NOT IsDefined("displayHeader")>
	<HTML>
	<HEAD><TITLE>Emaze Recruiter: Hiring Process</TITLE></HEAD>
	<BODY BGCOLOR=white>
	<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">
	<CFSET helpContext = "interviewOption">
	<P><CFINCLUDE TEMPLATE="navigate.cfm"><HR NOSHADE WIDTH=600 ALIGN=left><P>
</CFIF>

<CFIF IsDefined("viewDays")>
	<FONT SIZE=6 COLOR=blue><CFOUTPUT><B>New Applicants</B></FONT> <FONT SIZE=5 COLOR=blue><B>(past #viewDays# days)</B></CFOUTPUT></FONT>

	<CFSET todayDate = "#Now()#">
	<CFSET startDate = #DateFormat("#todayDate#" - CreateTimeSpan(#viewDays#,0,0,0))#>
	<CFSET startODBCDate = #CreateODBCDate("#startDate#")#>

	<CFQUERY NAME=getNewApplicants DATASOURCE="#ERdatasource#">
		SELECT Applicant.applicantFirstName, Applicant.applicantLastName,
			Applicant.applicantID, Applicant.applicantDate, ApplicantJob.jobID,
			Job.jobTitle, Department.departmentName, Location.locationName,
			Department.departmentID, Location.locationID
		FROM (((Applicant INNER JOIN ApplicantJob ON Applicant.applicantID = ApplicantJob.applicantID)
			INNER JOIN Job ON ApplicantJob.jobID = Job.jobID)
			INNER JOIN Location ON Job.locationID = Location.locationID)
			INNER JOIN Department ON Job.departmentID = Department.departmentID
		WHERE Applicant.applicantDate >= #startODBCDate#
		ORDER BY Applicant.applicantDate DESC
	</CFQUERY>

	<CFIF #getNewApplicants.RecordCount# GT 0>
		<CFQUERY NAME=getInterviewerPermissions DATASOURCE="#ERdatasource#">
			SELECT jobs, locations, departments, locationDepartments, departmentID, locationID
			FROM Interviewer
			WHERE interviewerID = #Cookie.EmazeRecruiter_interviewer#
		</CFQUERY>

		<CFSET applicantCount = 2>
		<CFQUERY NAME=getApplicantPermissions DATASOURCE="#ERdatasource#">
			SELECT interviewers, locations, departments, locationDepartments
			FROM ApplicantJob
			WHERE applicantID = #ListGetAt("#ValueList(getNewApplicants.applicantID)#",1)#
				<CFLOOP INDEX="applicantCount" LIST="#ValueList(getNewApplicants.applicantID)#">
					OR applicantID = #applicantCount#
				</CFLOOP>
		</CFQUERY>
	</CFIF>

	<P>
	<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=2>
	<TH BGCOLOR="#20A491">Applicant Name</TH>
	<TH BGCOLOR="#20A491">Job Title</TH>
	<TH BGCOLOR="#20A491">Department Name</TH>
	<TH BGCOLOR="#20A491">Location Name</TH>
	<TH BGCOLOR="#20A491">Application Date</TH>

	<CFIF #getNewApplicants.RecordCount# GT 0>
		<CFSET rowTint = 0>
		<CFSET previousApplicantID = 0>
		<CFOUTPUT QUERY="getNewApplicants">
			<CFIF #Cookie.EmazeRecruiter_interviewer# EQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.jobs)#",#getNewApplicants.jobID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.locations)#",#getNewApplicants.locationID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.departments)#",#getNewApplicants.departmentID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.locationDepartments)#","#getNewApplicants.locationID#-#getNewApplicants.departmentID#")# NEQ 0
					OR #ListContains("#ValueList(getApplicantPermissions.interviewers)#",#Cookie.EmazeRecruiter_interviewer#)# NEQ 0
					OR #ListContains("#ValueList(getApplicantPermissions.locations)#",#getInterviewerPermissions.locationID#)# NEQ 0
					OR #ListContains("#ValueList(getApplicantPermissions.departments)#",#getInterviewerPermissions.departmentID#)# NEQ 0
					OR #ListContains("#ValueList(getApplicantPermissions.locationDepartments)#","#getInterviewerPermissions.locationID#-#getInterviewerPermissions.departmentID#")# NEQ 0>
	
				<CFIF #previousApplicantID# NEQ #applicantID#>
					<CFIF #rowTint# EQ 1><CFSET rowTint = 0>
						<CFELSE><CFSET rowTint = 1></CFIF>
				</CFIF>
				<CFIF #rowTint# EQ 1><TR BGCOLOR="##CDCDCD">
					<CFELSE><TR></CFIF>
				<TD><A HREF="interviewOption.cfm?jobID=#jobID#&applicantID=#applicantID#">#applicantLastName#, #applicantFirstName#</A></TD>
				<TD>#jobTitle#</TD>
				<TD>#departmentName#</TD>
				<TD>#locationName#</TD>
				<TD>#DateFormat("#applicantDate#", "dddd, mmmm dd, yyyy")#</TD>
				</TR>
				<CFSET previousApplicantID = #getNewApplicants.applicantID#>
			</CFIF>
		</CFOUTPUT>
	<CFELSE>
		<TR><TD COLSPAN=5 ALIGN=center><B>There are no new applicants within the past number of days you chose.</B></TD></TR>
	</CFIF>
	</TABLE>
	<CFINCLUDE TEMPLATE="copyright.cfm">
	</BODY></HTML>
	<P><HR NOSHADE WIDTH=600 ALIGN=left><CFINCLUDE TEMPLATE="navigate.cfm"><P>
	<CFABORT>
</CFIF>

<CFIF NOT IsDefined("applicantID")>
	This is where you edit the applicant.
	<CFINCLUDE TEMPLATE="copyright.cfm">
	</BODY></HTML>
	<P><HR NOSHADE WIDTH=600 ALIGN=left><CFINCLUDE TEMPLATE="navigate.cfm"><P>
	<CFABORT>
</CFIF>

<CFQUERY NAME=getApplicantName DATASOURCE="#ERdatasource#">
	SELECT applicantLastName, applicantFirstName, resume
	FROM Applicant
	WHERE applicantID = #applicantID#
</CFQUERY>

<CFOUTPUT QUERY="getApplicantName">
	<H2>#applicantFirstName# #applicantLastName#</H2>
</CFOUTPUT>

<CFINCLUDE TEMPLATE="getApplicantJobs.cfm">

<P>

<CFIF #getApplicantJobs.RecordCount# NEQ 1>
	<CFIF NOT IsDefined("jobID")><CFSET noJobID = 1>
	<CFELSEIF #jobID# EQ 0><CFSET noJobID = 1>
	</CFIF>
<CFELSE><!--- only one jobID anyway --->
	<CFSET jobID = #getApplicantJobs.jobID#>
</CFIF>
<CFIF #getApplicantJobs.RecordCount# EQ 0>
	<CFSET noJobID = 1>
</CFIF>
<CFIF IsDefined("noJobID")>
	<FONT SIZE=4 COLOR=blue><I>
	<CFIF #getApplicantJobs.RecordCount# GT 0>
		Please select a job for this applicant from the above table.
	<CFELSE>This applicant has no associated jobs. Please click the Edit Applicant
			button below to choose the job(s) for which this person is applying.
	</CFIF>
	</I></FONT>
	<P>
	<FORM METHOD=post ACTION=interviewAction.cfm>
	<INPUT TYPE=hidden NAME=applicantOption VALUE="info">
	<INPUT TYPE=hidden NAME=jobID VALUE=0>
	<CFOUTPUT><INPUT TYPE=hidden NAME=applicantID VALUE=#applicantID#></CFOUTPUT>
	Edit applicant's information and job(s): <INPUT TYPE=submit VALUE="Edit Applicant">
	</FORM>
	<P><HR NOSHADE WIDTH=600 ALIGN=left><CFINCLUDE TEMPLATE="navigate.cfm"><P>
	<CFINCLUDE TEMPLATE="copyright.cfm">
	</BODY></HTML>
	<CFABORT>
</CFIF>

<FORM METHOD=post ACTION=interviewAction.cfm>
<CFOUTPUT>
<INPUT TYPE=hidden NAME=jobID VALUE=#jobID#>
<INPUT TYPE=hidden NAME=applicantID VALUE=#applicantID#>
</CFOUTPUT>

<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=2>
<TH BGCOLOR="#CDCDCD">Interview Process</TH>
<TH COLSPAN=3 BGCOLOR="#CDCDCD">Correspondence</TH>

<TR><TD ROWSPAN=5>
<INPUT TYPE=radio NAME=applicantOption VALUE="info" CHECKED> View, edit applicant info<BR>
<INPUT TYPE=radio NAME=applicantOption VALUE="interviewers"> Determine interviewers<BR>
<INPUT TYPE=radio NAME=applicantOption VALUE="schedule"> Interview schedule<BR>
<INPUT TYPE=radio NAME=applicantOption VALUE="notes"> View notes on separate page<BR>
<INPUT TYPE=radio NAME=applicantOption VALUE="archive"> Archive applicant
</TD>
<TH BGCOLOR="#20A491"><FONT SIZE=2>Letter</FONT></TH>
<TH BGCOLOR="#20A491"><FONT SIZE=2>Email</FONT></TH>
<TH BGCOLOR="#20A491"><FONT SIZE=2>Type</FONT></TH>
</TR>
<TR><TD ALIGN=center><INPUT TYPE=radio NAME=applicantOption VALUE="interviewLetter"></TD>
	<TD ALIGN=center><INPUT TYPE=radio NAME=applicantOption VALUE="interviewEmail"></TD>
	<TD>Interview</TD></TR>
<TR><TD ALIGN=center><INPUT TYPE=radio NAME=applicantOption VALUE="noInterviewLetter"></TD>
	<TD ALIGN=center><INPUT TYPE=radio NAME=applicantOption VALUE="noInterviewEmail"></TD>
	<TD>No interview</TD></TR>
<TR><TD ALIGN=center><INPUT TYPE=radio NAME=applicantOption VALUE="offerLetter"></TD>
	<TD ALIGN=center><INPUT TYPE=radio NAME=applicantOption VALUE="offerEmail"></TD>
	<TD>Job offer</TD></TR>
<TR><TD ALIGN=center><INPUT TYPE=radio NAME=applicantOption VALUE="noOfferLetter"></TD>
	<TD ALIGN=center><INPUT TYPE=radio NAME=applicantOption VALUE="noOfferEmail"></TD>
	<TD>No job offer</TD></TR>

<CFSET job = #jobID#>
<CFLOOP QUERY=getApplicantJobs>
	<CFIF #job# EQ #getApplicantJobs.jobID#>
		<CFSET status = "#getApplicantJobs.applicantStatus#">
		<CFSET round = "#getApplicantJobs.interviewRound#">
		<CFBREAK>
	</CFIF>
</CFLOOP>

<TR><TD COLSPAN=4>
<INPUT TYPE=radio NAME=applicantOption VALUE="status"> <FONT SIZE=2>Status, interview round: </FONT>
<SELECT NAME=applicantStatus SIZE=1>
<OPTION VALUE="New"<CFIF #status# EQ "New"> SELECTED</CFIF>>New
<OPTION VALUE="Interview?"<CFIF #status# EQ "Interview?"> SELECTED</CFIF>>Interview?
<OPTION VALUE="Arrange interview"<CFIF #status# EQ "Arrange interview"> SELECTED</CFIF>>Arrange interview
<OPTION VALUE="Interview next round?"<CFIF #status# EQ "Interview next round?"> SELECTED</CFIF>>Interview next round?
<OPTION VALUE="Offer job?"<CFIF #status# EQ "Offer job?"> SELECTED</CFIF>>Offer job?
<OPTION VALUE="Send offer letter"<CFIF #status# EQ "Send offer letter"> SELECTED</CFIF>>Send offer letter
<OPTION VALUE="Accept job?"<CFIF #status# EQ "Accept job?"> SELECTED</CFIF>>Accept job?
<OPTION VALUE="Turned down offer"<CFIF #status# EQ "Turned down offer"> SELECTED</CFIF>>Turned down offer
<OPTION VALUE="Accepted offer"<CFIF #status# EQ "Accepted offer"> SELECTED</CFIF>>Accepted offer
<OPTION VALUE="Archived"<CFIF #status# EQ "Archived"> SELECTED</CFIF>>Archived
</SELECT> 
<CFOUTPUT><INPUT TYPE=text NAME=interviewRound SIZE=2 VALUE="#round#"></CFOUTPUT>
</TD></TR>

<TR><TD HEIGHT=65 BGCOLOR="#CDCDCD" COLSPAN=4 ALIGN=center><INPUT TYPE=submit VALUE="Do Something"><BR>
<FONT SIZE=2>All actions are for this job only unless checked below.</FONT></TD></TR>
<TR><TD COLSPAN=4>
<TABLE BORDER=0 WIDTH=100%><TR><TD BGCOLOR="#20A491"><FONT SIZE=2>
&quot;<I>Archive applicant</I>&quot; above must be checked for options below.
</FONT></TD></TR></TABLE>
<FONT SIZE=2>
<INPUT TYPE=checkbox NAME=archive VALUE=archiveAllJobs> Archive applicant for <I>all</I> jobs<BR>
<INPUT TYPE=checkbox NAME=archive VALUE=deleteJob> Permanently delete applicant for <I>this</I> job<BR>
<INPUT TYPE=checkbox NAME=archive VALUE=deleteAll> Permanently delete applicant for <I>all</I> jobs
</FONT></TD></TR>
</TABLE>
</FORM>
<P>

<HR NOSHADE SIZE=3 WIDTH=600 ALIGN=left>

<CFDIRECTORY ACTION=List
	DIRECTORY="#systemPath#\applicants\#applicantID#"
	NAME="correspond"
	SORT="dateLastModified DESC">

<CFIF #getApplicantName.resume# NEQ "" AND #getApplicantName.resume# NEQ " ">
	<CFSET num = 3>
<CFELSE><CFSET num = 2>
</CFIF>

<CFIF #correspond.RecordCount# GT #num#>
	<CFLOOP QUERY="correspond">
		<CFIF #Find("#jobID#.cfm","#name#",1)# NEQ 0>
			<CFSET displayLetters = 1>
			<CFBREAK>
		</CFIF>
	</CFLOOP>
</CFIF>

<CFIF NOT IsDefined("displayLetters")>
	<FONT SIZE=5 COLOR=blue><B>No correspondence for this applicant/job.</B></FONT><P>
<CFELSE>
	<FORM METHOD=post ACTION=interviewAction.cfm>
	<CFOUTPUT>
	<INPUT TYPE=hidden NAME=jobID VALUE=#jobID#>
	<INPUT TYPE=hidden NAME=applicantOption VALUE=nothing>
	<INPUT TYPE=hidden NAME=applicantID VALUE=#applicantID#>
	</CFOUTPUT>
	
	<FONT COLOR=blue>To view an email or letter in print-ready form, click on the Letter/Email<BR>
	column. This will open the letter or email in a separate window.</FONT>
	<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=2>
	<TH BGCOLOR="#20A491" COLSPAN=4>Edit, View Existing Letters/Emails</TH>
	<TR>
	<TH BGCOLOR="#CDCDCD">Edit</TH>
	<TH BGCOLOR="#CDCDCD"><FONT SIZE=2>Letter/Email</FONT></TH>
	<TH BGCOLOR="#CDCDCD">Type</TH>
	<TH BGCOLOR="#CDCDCD">Date Last Modified</TH>
	</TR>

	<CFOUTPUT QUERY="correspond">
		<CFIF #name# NEQ "." AND #name# NEQ ".." AND #Find("#jobID#.cfm","#name#",1)# NEQ 0>
			<TR>
			<TD ALIGN=center><INPUT TYPE=radio NAME=filename VALUE="#name#"<CFIF #correspond.CurrentRow# EQ 1> CHECKED</CFIF>></TD>
			<TD ALIGN=center>
			<CFIF #Find("letter","#name#",1)# NEQ 0>
				<A HREF="correspond.cfm?applicantID=#applicantID#&filename=#name#" TARGET="window.open">Letter</A>
			<CFELSE><A HREF="correspond.cfm?applicantID=#applicantID#&filename=#name#" TARGET="window.open">Email</A>
			</CFIF>
			</TD>
			<TD>
			<CFIF #Find("_i_","#name#",1)# NEQ 0>Interview
			<CFELSEIF #Find("_ni_","#name#",1)# NEQ 0>No Interview
			<CFELSEIF #Find("_o_","#name#",1)# NEQ 0>Offer
			<CFELSE><!--- #Find("_no_","#name#",1)# NEQ 0 --->No Offer
			</CFIF>
			</TD>
			<TD>#DateFormat("#datelastmodified#","ddd, mmm dd, yyyy")# #TimeFormat("#datelastmodified#","hh:mm tt")#</TD>
			</TR>
		</CFIF>
	</CFOUTPUT>
	<TR><TD COLSPAN=4 ALIGN=center HEIGHT=40 BGCOLOR="#20A491"><INPUT TYPE=submit VALUE="Edit Letter/Email"></TD></TR>
	</TABLE>
	</FORM>
	<P>
</CFIF>

<HR NOSHADE SIZE=3 WIDTH=600 ALIGN=left>
<FONT COLOR=blue SIZE=5><B>Notes for this job:</B></FONT>

<CFQUERY NAME=getNotes DATASOURCE="#ERdatasource#">
	SELECT noteDateTime, noteInterviewerName, theNote
	FROM Notes
	WHERE applicantID = #applicantID#
		AND jobID = #jobID#
	ORDER BY noteDateTime DESC
</CFQUERY>

<DL>
<CFOUTPUT QUERY=getNotes>
	<DT><B>#noteInterviewerName#</B> (#DateFormat("#noteDateTime#","dddd, mmmm dd, yyyy")# #TimeFormat("#noteDateTime#",'hh:mm tt')#)
	<DD>#theNote#
	<HR NOSHADE WIDTH=450 ALIGN=left>
</CFOUTPUT>
</DL>

<FORM METHOD=post ACTION=notes.cfm>
<CFOUTPUT>
<INPUT TYPE=hidden NAME=applicantID VALUE=#applicantID#>
<INPUT TYPE=hidden NAME=jobID VALUE=#jobID#>
</CFOUTPUT>
<FONT SIZE=4><B>Post Note:</B></FONT><BR>
<TEXTAREA NAME=note ROWS=5 COLS=55 WRAP=virtual></TEXTAREA><BR>
<INPUT TYPE=reset VALUE="Clear"> <INPUT TYPE=submit VALUE="Post Note">
</FORM>

<P><HR NOSHADE WIDTH=600 ALIGN=left><CFINCLUDE TEMPLATE="navigate.cfm"><P>
<CFINCLUDE TEMPLATE="copyright.cfm">
</BODY>
</HTML>