<!---
If admin (interviewerID = 1)
	Edit system options
	Edit discussion forum options
	Edit templates
	Add/edit locations, departments
	JOBS AWAITING APPROVAL FOR POSTING

Interviewer can have the following permissions:
  Edit their own user info
  Post/edit jobs in list below
  APPLICANTS: View applicants, discussion forum, interview schedule
	1. All locations, departments and jobs (company)
	2. Entire location(s)
	3. Entire department(s)
	4. Specific location/department combination(s)
	5. Specific job(s)
	6. Specific applicants
  INTERVIEWERS
	1. Add/edit interviewers, including permissions within your scope
		(department, location, location/department, job)
  JOBS
	Create/edit interview schedules for each applicant

If no permission other than to inverview applicants
(i.e,. no create job, location, department, or location/department permissions)
then simply display options of schedules and discussion forums for the applicants
and jobs for which they have permission.
--->

<CFINCLUDE TEMPLATE="secure.cfm">

<CFIF NOT IsDefined("displayHeader")>
	<HTML>
	<HEAD><TITLE>Emaze Recruiter: Home</TITLE></HEAD>
	<BODY BGCOLOR=white>
	<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">
	<CFSET helpContext = "homepage">
	<P><CFINCLUDE TEMPLATE="navigate.cfm"><HR NOSHADE WIDTH=600 ALIGN=left><P>
</CFIF>

<H1><FONT COLOR=purple>Emaze Recruiter: Home</FONT></H1>

<!--- ADMIN: system options, locations, departments --->
<CFIF #Cookie.EmazeRecruiter_interviewer# EQ 0>
	<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=3>
	<TH BGCOLOR="#20A491"><FONT SIZE=5><B><CFOUTPUT><A HREF="#systemURL#/program/admin.cfm"></CFOUTPUT>Admin Options</A></B></FONT></TH>
	<TR><TD>
		Edit System Information<BR>
		Edit Letter/Email Templates<BR>
		Add/Edit Locations<BR>
		Add/Edit Departments<BR>
		Unarchive Applicants
	</TD></TR>
	</TABLE>
</CFIF>

<P>

<CFOUTPUT><FORM METHOD=post ACTION="#systemURL#/program/options.cfm"></CFOUTPUT>
<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=4>

<!--- Get permissions --->
<CFQUERY NAME="getInterviewerPermissions" DATASOURCE="#ERdatasource#">
	SELECT createJobs, postJobs, jobs, departments, locations,
		locationDepartments, locationID, departmentID
	FROM Interviewer
	WHERE interviewerID = #Cookie.EmazeRecruiter_interviewer#
</CFQUERY>
<CFQUERY NAME="getInterviewerJobs" DATASOURCE="#ERdatasource#">
	SELECT jobID FROM Job WHERE interviewerID = #Cookie.EmazeRecruiter_interviewer#
</CFQUERY>

<!--- INTERVIEWERS --->
<CFQUERY NAME=getInterviewers DATASOURCE="#ERdatasource#">
	SELECT interviewerLastName, interviewerFirstName, interviewerID, locationID, departmentID
	FROM Interviewer
	WHERE interviewerID > 0 AND interviewerID <> #Cookie.EmazeRecruiter_interviewer#
	ORDER BY interviewerLastName, interviewerFirstName
</CFQUERY>

<CFIF #Cookie.EmazeRecruiter_interviewer# NEQ 0>
	<CFLOOP QUERY="getInterviewers">
		<CFIF #ListContains("#ValueList(getInterviewerPermissions.departments)#",#getInterviewers.departmentID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.locations)#",#getInterviewers.locationID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.locationDepartments)#","#getInterviewers.locationID#-#getInterviewers.departmentID#")# NEQ 0>
			<CFSET allowInterviewer = 1>
			<CFBREAK>
		</CFIF>
	</CFLOOP>
</CFIF>

<CFQUERY NAME=emptyDeptLoc DATASOURCE="#ERdatasource#" MAXROWS=1>
	SELECT locationID FROM DepartmentLocation
</CFQUERY>

<CFIF #Cookie.EmazeRecruiter_interviewer# EQ 0 OR IsDefined("allowInterviewer")>
	<TR><TH BGCOLOR="#CDCDCD" ROWSPAN=4>Interviewers</TH>
	<TD>
	<CFIF #emptyDeptLoc.RecordCount# GT 0>
		<INPUT TYPE=radio NAME=option VALUE="addInterviewer"> Add new interviewer(s)
	<CFELSE><FONT SIZE=2>(You cannot create interviewers until at least one location/department exists.)</FONT>
	</CFIF>
	</TD></TR>

	<TR><TD>
	<CFIF #getInterviewers.RecordCount# EQ 0>
		<FONT SIZE=2>(No interviewers to edit.)</FONT>
	<CFELSEIF #Cookie.EmazeRecruiter_interviewer# EQ 0>
		<INPUT TYPE=radio NAME=option VALUE="editInterviewer"> Edit: 
		<SELECT NAME="interviewerID" SIZE=1>
		<CFOUTPUT QUERY="getInterviewers">
			<OPTION VALUE=#interviewerID#>#interviewerLastName#, #interviewerFirstName#
		</CFOUTPUT>
		</SELECT> <FONT SIZE=2>(Last, First)</FONT>
	<CFELSE>
		<CFSET showSelect = 1>
		<CFOUTPUT QUERY="getInterviewers">
			<CFIF #ListContains("#ValueList(getInterviewerPermissions.departments)#",#getInterviewers.departmentID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.locations)#",#getInterviewers.locationID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.locationDepartments)#","#getInterviewers.locationID#-#getInterviewers.departmentID#")# NEQ 0>
				<CFIF #showSelect# EQ 1>
					<INPUT TYPE=radio NAME=option VALUE="editInterviewer"> Edit: 
					<SELECT NAME="interviewerID" SIZE=1>
					<CFSET showSelect = 0>
				</CFIF>
				<OPTION VALUE=#interviewerID#>#interviewerLastName#, #interviewerFirstName#
			</CFIF>
		</CFOUTPUT>
		<CFIF #showSelect# EQ 0>
			</SELECT> <FONT SIZE=2>(Last, First)</FONT>
		<CFELSE><FONT SIZE=2>(No interviewers to edit.)</FONT>
		</CFIF>
	</CFIF>
	</TD></TR>

	<CFQUERY NAME="nullInterviewers" DATASOURCE="#ERdatasource#">
		SELECT DISTINCTROW Interviewer.interviewerID, Interviewer.interviewerFirstName,
			Interviewer.interviewerLastName, Interviewer.departmentID, Interviewer.locationID
		FROM Interviewer LEFT JOIN Job ON Interviewer.interviewerID = Job.interviewerID
		WHERE Job.interviewerID Is Null AND Interviewer.interviewerID > 0
	</CFQUERY>

	<TR><TD>
	<CFIF #nullInterviewers.RecordCount# EQ 0>
		<FONT SIZE=2>(No interviewers to delete.)</FONT>
	<CFELSEIF #Cookie.EmazeRecruiter_interviewer# EQ 0>
		<INPUT TYPE=radio NAME=option VALUE="deleteInterviewer"> Delete: 
		<SELECT NAME=deleteInterviewerID SIZE=1>
		<CFOUTPUT QUERY="nullInterviewers">
			<OPTION VALUE=#interviewerID#>#interviewerLastName#, #interviewerFirstName#
		</CFOUTPUT>
		</SELECT><BR>
		&nbsp; &nbsp; &nbsp;<INPUT TYPE=checkbox NAME=okDeleteInterviewer VALUE=1> <FONT SIZE=2>(Must be checked to delete interviewer.)</FONT>
	<CFELSE>
		<CFSET showSelect = 1>
		<CFOUTPUT QUERY="nullInterviewers">
			<CFIF #ListContains("#ValueList(getInterviewerPermissions.departments)#",#nullInterviewers.departmentID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.locations)#",#nullInterviewers.locationID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.locationDepartments)#","#nullInterviewers.locationID#-#nullInterviewers.departmentID#")# NEQ 0>
				<CFIF #showSelect# EQ 1>
					<INPUT TYPE=radio NAME=option VALUE="deleteInterviewer"> Delete: 
					<SELECT NAME=deleteInterviewerID SIZE=1>
					<CFSET showSelect = 0>
				</CFIF>
				<OPTION VALUE=#interviewerID#>#interviewerLastName#, #interviewerFirstName#
			</CFIF>
		</CFOUTPUT>
		<CFIF #showSelect# EQ 0>
			</SELECT><BR>
			&nbsp; &nbsp; &nbsp;<INPUT TYPE=checkbox NAME=okDeleteInterviewer VALUE=1> <FONT SIZE=2>(Must be checked to delete interviewer.)</FONT>
		<CFELSE><FONT SIZE=2>(No interviewers to delete.)</FONT>
		</CFIF>
	</CFIF>
	</TD></TR>

	<TR><TD BGCOLOR="#CDCDCD">&nbsp; &nbsp; &nbsp; <INPUT TYPE=submit VALUE="Interviewer Action"></TD></TR>
</CFIF>

<!--- JOBS: creating, editing --->
<CFIF #Cookie.EmazeRecruiter_interviewer# EQ 0 OR #getInterviewerPermissions.createJobs# EQ 1>
	<CFQUERY NAME=getJobs DATASOURCE="#ERdatasource#">
		SELECT Job.jobID, Job.jobStatus, Job.locationID, Job.departmentID,
			Location.locationName, Department.departmentName, Job.jobTitle
		FROM (Job INNER JOIN Department ON Job.departmentID = Department.departmentID)
			INNER JOIN Location ON Job.locationID = Location.locationID
		ORDER BY Location.locationName, Department.departmentName, Job.jobTitle
	</CFQUERY>

	<CFIF #Cookie.EmazeRecruiter_interviewer# NEQ 0>
		<CFLOOP QUERY="getJobs">
			<CFIF #ListContains("#ValueList(getInterviewerJobs.jobID)#",#getJobs.jobID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.jobs)#",#getJobs.jobID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.departments)#",#getJobs.departmentID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.locations)#",#getJobs.locationID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.locationDepartments)#","#getJobs.locationID#-#getJobs.departmentID#")# NEQ 0>
				<CFSET allowJobs = 1>
				<CFBREAK>
			</CFIF>
		</CFLOOP>
	</CFIF>

	<TR>
	<CFIF #Cookie.EmazeRecruiter_interviewer# EQ 0 OR IsDefined("allowJobs")>
		<TH BGCOLOR="#CDCDCD" ROWSPAN=4>Jobs</TH>
	<CFELSE><TH BGCOLOR="#CDCDCD" ROWSPAN=2>Jobs</TH>
	</CFIF>
	
	<TD>
	<CFIF #emptyDeptLoc.RecordCount# GT 0>
		<INPUT TYPE=radio NAME=option VALUE="addJob" CHECKED> Add new job(s)
	<CFELSE><FONT SIZE=2>(You cannot create jobs until at least one location/department exists.)</FONT>
	</CFIF>
	</TD></TR>

	<CFIF #Cookie.EmazeRecruiter_interviewer# EQ 0 OR IsDefined("allowJobs")>
		<TR><TD NOWRAP>
		<CFIF #getJobs.RecordCount# EQ 0>
			<FONT SIZE=2>(No jobs to edit.)</FONT>
		<CFELSEIF #Cookie.EmazeRecruiter_interviewer# EQ 0>
			<INPUT TYPE=radio NAME=option VALUE="editJob"> Edit: 
			<SELECT NAME="jobID" SIZE=1>
			<CFOUTPUT QUERY="getJobs">
				<OPTION VALUE=#jobID#>#locationName# / #departmentName# / #jobTitle#
			</CFOUTPUT>
			</SELECT>
		<CFELSE>
			<CFSET showSelect = 1>
			<CFOUTPUT QUERY="getJobs">
				<CFIF #ListContains("#ValueList(getInterviewerJobs.jobID)#",#getJobs.jobID#)# NEQ 0
						OR #ListContains("#ValueList(getInterviewerPermissions.jobs)#",#getJobs.jobID#)# NEQ 0
						OR #ListContains("#ValueList(getInterviewerPermissions.departments)#",#getJobs.departmentID#)# NEQ 0
						OR #ListContains("#ValueList(getInterviewerPermissions.locations)#",#getJobs.locationID#)# NEQ 0
						OR #ListContains("#ValueList(getInterviewerPermissions.locationDepartments)#","#getJobs.locationID#-#getJobs.departmentID#")# NEQ 0>
					<CFIF #showSelect# EQ 1>
						<INPUT TYPE=radio NAME=option VALUE="editJob"> Edit: 
						<SELECT NAME="jobID" SIZE=1>
						<CFSET showSelect = 0>
					</CFIF>
					<OPTION VALUE=#jobID#>#locationName# / #departmentName# / #jobTitle#
				</CFIF>
			</CFOUTPUT>
			<CFIF #showSelect# EQ 0>
				</SELECT> <FONT SIZE=2>(Location / Department / Job)</FONT>
			<CFELSE><FONT SIZE=2>(No jobs to edit.)</FONT>
			</CFIF>
		</CFIF>
		</TD></TR>

		<CFQUERY NAME=nullJobs DATASOURCE="#ERdatasource#">
			SELECT DISTINCTROW Job.jobID, Job.jobTitle,
				Department.departmentName, Location.locationName
			FROM ((Job LEFT JOIN ApplicantJob ON Job.jobID = ApplicantJob.jobID)
				INNER JOIN Department ON Job.departmentID = Department.departmentID)
				INNER JOIN Location ON Job.locationID = Location.locationID
			WHERE Job.jobStatus = 0 AND ApplicantJob.jobID Is Null
		</CFQUERY>	

		<TR><TD>
		<CFIF #nullJobs.RecordCount# EQ 0>
			<FONT SIZE=2>(No jobs to delete.)</FONT>
		<CFELSEIF #Cookie.EmazeRecruiter_interviewer# EQ 0>
			<INPUT TYPE=radio NAME=option VALUE="deleteJob"> Delete: 
			<SELECT NAME=deleteJobID SIZE=1>
			<CFOUTPUT QUERY="nullJobs">
				<OPTION VALUE=#jobID#>#locationName# / #departmentName# / #jobTitle#
			</CFOUTPUT>
			</SELECT><BR>
			&nbsp; &nbsp; &nbsp;<INPUT TYPE=checkbox NAME=okDeleteJob VALUE=1> <FONT SIZE=2>(Must be checked to delete job.)</FONT>
		<CFELSE>
			<CFSET showSelect = 1>
			<CFOUTPUT QUERY="nullJobs">
				<CFIF #ListContains("#ValueList(getInterviewerJobs.jobID)#",#nullJobs.jobID#)# NEQ 0
						OR #ListContains("#ValueList(getInterviewerPermissions.jobs)#",#nullJobs.jobID#)# NEQ 0
						OR #ListContains("#ValueList(getInterviewerPermissions.departments)#",#nullJobs.departmentID#)# NEQ 0
						OR #ListContains("#ValueList(getInterviewerPermissions.locations)#",#nullJobs.locationID#)# NEQ 0
						OR #ListContains("#ValueList(getInterviewerPermissions.locationDepartments)#","#nullJobs.locationID#-#nullJobs.departmentID#")# NEQ 0>
					<CFIF #showSelect# EQ 1>
						<INPUT TYPE=radio NAME=option VALUE="deleteJob"> Delete: 
						<SELECT NAME=deleteJobID SIZE=1>
						<CFSET showSelect = 0>
					</CFIF>
					<OPTION VALUE=#jobID#>#locationName# / #departmentName# / #jobTitle#
				</CFIF>
			</CFOUTPUT>
			<CFIF #showSelect# EQ 0>
				</SELECT><BR>
				&nbsp; &nbsp; &nbsp;<INPUT TYPE=checkbox NAME=okDeleteJob VALUE=1> <FONT SIZE=2>(Must be checked to delete job.)</FONT>
			<CFELSE><FONT SIZE=2>(No jobs to delete.)</FONT>
			</CFIF>
		</CFIF>
		</TD></TR>

		<TR><TD BGCOLOR="#CDCDCD">&nbsp; &nbsp; &nbsp; <INPUT TYPE=submit VALUE="Job Action"></TD></TR>
	</CFIF>
</CFIF>

</TABLE>
</FORM>

<P>

<!--- get applicants. even if cannot edit, for viewing info, discussion forums. --->
<CFQUERY NAME=getApplicants DATASOURCE="#ERdatasource#">
	SELECT ApplicantJob.applicantID, Applicant.applicantFirstName, Applicant.applicantLastName,
		Job.jobID, Job.jobTitle, Job.departmentID, Department.departmentName,
		Job.locationID, Location.locationName
	FROM (Department INNER JOIN
		((Applicant INNER JOIN ApplicantJob ON Applicant.applicantID = ApplicantJob.applicantID)
		INNER JOIN Job ON ApplicantJob.jobID = Job.jobID) ON Department.departmentID = Job.departmentID)
		INNER JOIN Location ON Job.locationID = Location.locationID
	WHERE ApplicantJob.applicantStatus <> 'Archived'
	ORDER BY Applicant.applicantLastName, Applicant.applicantFirstName,
			Job.jobTitle, Location.locationName, Department.departmentName
</CFQUERY>

<!--- check whether they have any applicant or job permissions --->
<CFIF #Cookie.EmazeRecruiter_interviewer# NEQ 0 AND NOT IsDefined("allowJobs")>
	<CFLOOP QUERY="getApplicants">
		<CFIF #jobStatus# EQ 1
			AND (#ListContains("#ValueList(getInterviewerJobs.jobID)#",#getJobs.jobID#)# NEQ 0
				OR #ListContains("#ValueList(getInterviewerPermissions.jobs)#",#getJobs.jobID#)# NEQ 0
				OR #ListContains("#ValueList(getInterviewerPermissions.departments)#",#getJobs.departmentID#)# NEQ 0
				OR #ListContains("#ValueList(getInterviewerPermissions.locations)#",#getJobs.locationID#)# NEQ 0
				OR #ListContains("#ValueList(getInterviewerPermissions.locationDepartments)#","#getJobs.locationID#-#getJobs.departmentID#")# NEQ 0)>
			<CFSET allowJobs = 1>
			<CFBREAK>
		</CFIF>
	</CFLOOP>
</CFIF>

<CFIF #Cookie.EmazeRecruiter_interviewer# EQ 0 OR IsDefined("allowJobs")>
	<CFOUTPUT><FORM METHOD=post ACTION="#systemURL#/program/interview.cfm"></CFOUTPUT>
	<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=0>
	<TH BGCOLOR="#CDCDCD"><FONT SIZE=5 COLOR=blue>Interviewing Process</FONT></TH>
	
	<TR><TD><TABLE BORDER=0 CELLSPACING=4 CELLPADDING=4 WIDTH=100%>
	<TR><TD BGCOLOR="#20A491"><INPUT TYPE=submit NAME="button" VALUE="Create New Applicant"><BR>
		<FONT SIZE=2>&nbsp; &nbsp; &nbsp; New applicants may also be entered after selecting a job.<BR>
		&nbsp; &nbsp; &nbsp; You may choose multiple jobs when adding the applicant.</FONT></TD></TR>
	<TR><TD BGCOLOR=orange><FONT COLOR=blue><B>View new applicants from previous 
		<SELECT NAME=viewDays SIZE=1>
			<OPTION VALUE=1>1<OPTION VALUE=2>2<OPTION VALUE=3>3
			<OPTION VALUE=4>4<OPTION VALUE=5>5<OPTION VALUE=6>6
			<OPTION VALUE=7>7<OPTION VALUE=8>8<OPTION VALUE=9>9
			<OPTION VALUE=10>10<OPTION VALUE=11>11<OPTION VALUE=12>12
			<OPTION VALUE=13>13<OPTION VALUE=14>14<OPTION VALUE=15>15
			</SELECT> day(s):</B></FONT> <INPUT TYPE=submit NAME="button" VALUE="View"></TD>
	</TD></TR>
	</TABLE></TD></TR>
	<TR><TD><TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2 WIDTH=100%>
	<TR><TD ALIGN=right><B>By Job:</B> </TD>
	<TD>
	<CFIF #getJobs.RecordCount# EQ 0>
		<FONT SIZE=2>(No currently open jobs.)</FONT>
	<CFELSEIF #Cookie.EmazeRecruiter_interviewer# EQ 0>
		<INPUT TYPE=radio NAME=by VALUE="job" CHECKED> 
		<SELECT NAME=jobID SIZE=1>
		<CFOUTPUT QUERY="getJobs">
			<OPTION VALUE=#jobID#>#locationName# / #departmentName# / #jobTitle#
		</CFOUTPUT>
		</SELECT>
	<CFELSE>
		<CFSET showSelect = 1>
		<CFOUTPUT QUERY="getJobs">
			<CFIF #ListContains("#ValueList(getInterviewerJobs.jobID)#",#getJobs.jobID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.jobs)#",#getJobs.jobID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.departments)#",#getJobs.departmentID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.locations)#",#getJobs.locationID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.locationDepartments)#","#getJobs.locationID#-#getJobs.departmentID#")# NEQ 0>
				<CFIF #showSelect# EQ 1>
					<INPUT TYPE=radio NAME=by VALUE="job" CHECKED> 
					<SELECT NAME=jobID SIZE=1>
					<CFSET showSelect = 0>
				</CFIF>
				<OPTION VALUE=#jobID#>#locationName# / #departmentName# / #jobTitle#
			</CFIF>
		</CFOUTPUT>

		<CFIF #showSelect# EQ 0>
			</SELECT>
		<CFELSE><FONT SIZE=2>(No currently open jobs.)</FONT>
		</CFIF>
	</CFIF>
	</TD></TR>

	<CFSET previousApplicantID = 0>	
	<TR><TD ALIGN=right><B>By Applicant:</B> </TD>
	<TD>
	<CFIF #getApplicants.RecordCount# EQ 0>
		<FONT SIZE=2>(No current applicants.)</FONT>
	<CFELSEIF #Cookie.EmazeRecruiter_interviewer# EQ 0>
		<INPUT TYPE=radio NAME=by VALUE="applicant"> 
		<SELECT NAME="applicantID" SIZE=1>
		<CFOUTPUT QUERY="getApplicants">
			<CFIF #previousApplicantID# NEQ #applicantID#>
				<OPTION VALUE=#applicantID#>#applicantLastName#, #applicantFirstName#
			</CFIF>
			<CFSET previousApplicantID = #getApplicants.applicantID#>
		</CFOUTPUT>
		</SELECT>
	<CFELSE>
		<CFSET showSelect = 1>
		<CFOUTPUT QUERY="getApplicants">
			<CFIF #ListContains("#ValueList(getInterviewerJobs.jobID)#",#getJobs.jobID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.jobs)#",#getJobs.jobID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.departments)#",#getJobs.departmentID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.locations)#",#getJobs.locationID#)# NEQ 0
					OR #ListContains("#ValueList(getInterviewerPermissions.locationDepartments)#","#getJobs.locationID#-#getJobs.departmentID#")# NEQ 0>
				<CFIF #showSelect# EQ 1>
					<INPUT TYPE=radio NAME=by VALUE="applicant"> 
					<SELECT NAME="applicantID" SIZE=1>
					<CFSET showSelect = 0>
				</CFIF>
				<CFIF #previousApplicantID# NEQ #applicantID#>
					<OPTION VALUE=#applicantID#>#applicantLastName#, #applicantFirstName#
				</CFIF>
				<CFSET previousApplicantID = #getApplicants.applicantID#>
			</CFIF>
		</CFOUTPUT>

		<CFIF #showSelect# EQ 0>
			</SELECT>
		<CFELSE><FONT SIZE=2>(No current applicants.)</FONT>
		</CFIF>
	</CFIF>
	</TD></TR>

	<TR><TD COLSPAN=2 ALIGN=center><INPUT TYPE=submit NAME="button" VALUE="Perform Interviewing Actions"></TD></TR>
	</TD></TR></TABLE>
	</TABLE>
	</FORM>
</CFIF>

<P>

<CFINCLUDE TEMPLATE="../system/discussionInfo.cfm">

<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=2>
<TH COLSPAN=7 BGCOLOR="#CDCDCD"><FONT SIZE=4 COLOR=blue>Basic Interviewer Options</FONT></TH>
<TR BGCOLOR="#20A491">
<TH><FONT SIZE=2 COLOR=blue>info</FONT></TH>
<CFIF #discussionForum# EQ 1>
	<TH><FONT SIZE=2 COLOR=blue>forum</FONT></TH>
</CFIF>
<TH><FONT SIZE=1>Interview<BR>Schedule</FONT></TH>
<TH>Applicant (last,first)</TH>
<TH>Job</TH>
<TH>Department</TH>
<TH>Location</TH>
</TR>

<!---
List discussion forums for applicants where they have permission:
1. job is in location
2. job is in department
3. job is in location/department
4. they own that job
5. job is in jobs
6. applicant is in applicants
7. they interviewed that applicant for that job
--->

<CFSET applicantList = " ">
<CFIF #Cookie.EmazeRecruiter_interviewer# EQ 0>
	<CFQUERY NAME=getApplicantsInterviewers DATASOURCE="#ERdatasource#">
		SELECT applicantID, locations, departments, locationDepartments, interviewers
		FROM ApplicantJob
	</CFQUERY>

	<CFLOOP QUERY=getApplicantsInterviewers>
		<CFIF #ListContains("#ValueList(getApplicantsInterviewers.locations)#",#getInterviewerPermissions.locationID#)# NEQ 0
				OR #ListContains("#ValueList(getApplicantsInterviewers.departments)#",#getInterviewerPermissions.departmentID#)# NEQ 0
				OR #ListContains("#ValueList(getApplicantsInterviewers.locationDepartments)#","#getInterviewerPermissions.locationID#-#getInterviewerPermissions.departmentID#")# NEQ 0
				OR #ListContains("#ValueList(getApplicantsInterviewers.interviewers)#",#Cookie.EmazeRecruiter_interviewer#)# NEQ 0>
			<CFSET applicantList = #ListAppend("#applicantList#",#applicantID#)#>
		</CFIF>
	</CFLOOP>
</CFIF>

<CFSET rowTint = 0>
<CFSET forumCount = 1>
<CFSET infoCount = 0>
<CFSET previousApplicantID = 0>

<CFOUTPUT QUERY="getApplicants">
	<CFIF #Cookie.EmazeRecruiter_interviewer# EQ 0
			OR #ListContains("#applicantList#",#getApplicants.applicantID#)# NEQ 0
			OR #ListContains("#ValueList(getInterviewerJobs.jobID)#",#getApplicants.jobID#)# NEQ 0
			OR #ListContains("#ValueList(getInterviewerPermissions.jobs)#",#getApplicants.jobID#)# NEQ 0
			OR #ListContains("#ValueList(getInterviewerPermissions.departments)#",#getApplicants.departmentID#)# NEQ 0
			OR #ListContains("#ValueList(getInterviewerPermissions.locations)#",#getApplicants.locationID#)# NEQ 0
			OR #ListContains("#ValueList(getInterviewerPermissions.locationDepartments)#","#getApplicants.locationID#-#getApplicants.departmentID#")# NEQ 0>
		<CFIF #previousApplicantID# NEQ #applicantID#>
			<CFSET infoCount = infoCount + 1>
			<CFSET forumCount = 1>
			<CFIF #rowTint# EQ 1><CFSET rowTint = 0>
				<CFELSE><CFSET rowTint = 1></CFIF>
		</CFIF>
		<CFIF #rowTint# EQ 1><TR BGCOLOR="##CDCDCD">
			<CFELSE><TR></CFIF>

		<CFIF #previousApplicantID# NEQ #applicantID#>
			<TD ALIGN=center><A HREF="#systemURL#/program/viewApplicant.cfm?applicantID=#applicantID#"><B>#infoCount#</B></A></TD>
		<CFELSE><TD>&nbsp;</TD>
		</CFIF>
		<CFIF #discussionForum# EQ 1>
			<TD ALIGN=center><A HREF="#systemURL#/forums/readForum.cfm?jobID=#jobID#&applicantID=#applicantID#"><FONT SIZE=2><I>#infoCount#.#forumCount#</I></FONT></A></TD>
		</CFIF>
		<TD ALIGN=center><A HREF="#systemURL#/program/schedule.cfm?jobID=#jobID#&applicantID=#applicantID#"><FONT SIZE=2>#infoCount#.#forumCount#</FONT></A></TD>
		<CFIF #previousApplicantID# NEQ #applicantID#>
			<TD>#applicantLastName#, #applicantFirstName#</TD>
		<CFELSE><TD>&nbsp;</TD>
		</CFIF>
		<TD>#jobTitle#</TD>
		<TD>#departmentName#</TD>
		<TD>#locationName#</TD>
		</TR>

		<CFSET forumCount = forumCount + 1>
		<CFSET previousApplicantID = #getApplicants.applicantID#>
		<CFIF NOT IsDefined("forums")><CFSET forums = "#jobID#-#applicantID#">
		<CFELSE><CFSET forums = #ListAppend("#forums#","#jobID#-#applicantID#")#>
		</CFIF>
	</CFIF>
</CFOUTPUT>
<CFIF #forumCount# EQ 1>
	<TR><TD COLSPAN=7 ALIGN=center>You have no active applicants/jobs at this time.</TD></TR>
</CFIF>
</TABLE>

<P><HR NOSHADE WIDTH=600 ALIGN=left><CFINCLUDE TEMPLATE="navigate.cfm"><P>
<CFINCLUDE TEMPLATE="copyright.cfm">
</BODY>
</HTML>