<!---
This file serves 2 purposes:
1. Ensure a file exists before trying to let user download it
2. Prevents displaying full URL where attachment is stored for added security.
	(Not much added security, but more than just displaying the URL.)
--->

<CFINCLUDE TEMPLATE="secure.cfm">

<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">

<CFIF IsDefined("Form.applicantID")>
	<CFSET applicantID = #Form.applicantID#>
</CFIF>

<!--- Get attachment filename from database --->
<CFQUERY NAME=getAttachmentFile DATASOURCE="#ERdatasource#">
	SELECT resume FROM Applicant WHERE applicantID = #applicantID#
</CFQUERY>

<!--- If the file still exists, get URL to attachments directory and download it. --->
<CFIF #FileExists("#systemPath#\applicants\#applicantID#\#getAttachmentFile.resume#")# EQ "YES">
	<CFLOCATION URL="#systemURL#/applicants/#applicantID#/#getAttachmentFile.resume#">
<CFELSE><!--- Attachment is not there. Reload forum. --->
	<CFLOCATION URL="../forums/readForum.cfm?jobID=#jobID#&applicantID=#applicantID#">
</CFIF>