<CFINCLUDE TEMPLATE="secure.cfm">

<CFQUERY NAME=getApplicantJobs DATASOURCE="#ERdatasource#">
	SELECT ApplicantJob.jobID, ApplicantJob.applicantStatus, ApplicantJob.interviewRound,
		ApplicantJob.locations, ApplicantJob.departments, ApplicantJob.locationDepartments,
		ApplicantJob.interviewers, Job.departmentID, Job.locationID, Job.interviewerID,
		Department.departmentName, Location.locationName, Job.jobTitle
	FROM ((Job INNER JOIN ApplicantJob ON Job.jobID = ApplicantJob.jobID)
		INNER JOIN Department ON Job.departmentID = Department.departmentID)
		INNER JOIN Location ON Job.locationID = Location.locationID
	WHERE ApplicantJob.applicantID = #applicantID#
		AND ApplicantJob.applicantStatus <> 'Archived'
	ORDER BY Location.locationName, Department.departmentName, Job.jobTitle
</CFQUERY>

<CFIF #getApplicantJobs.RecordCount# GT 0>
	<CFINCLUDE TEMPLATE="../system/discussionInfo.cfm">

	<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1>
	<CFIF #discussionForum# EQ 1>
		<TH BGCOLOR="#CDCDCD" VALIGN=bottom><FONT SIZE=2>forum</FONT></TH>
	</CFIF>
	<TH BGCOLOR="#CDCDCD" VALIGN=bottom>Location / Department / Job</TH>
	<TH BGCOLOR="#CDCDCD" VALIGN=bottom><FONT SIZE=1>Interview<BR>Round</FONT></TH>
	<TH BGCOLOR="#CDCDCD" VALIGN=bottom>Status</TH>

	<CFQUERY NAME=checkPermissions DATASOURCE="#ERdatasource#">
		SELECT jobs, departmentID, locationID, locations, departments, locationDepartments
		FROM Interviewer
		WHERE interviewerID = #Cookie.EmazeRecruiter_interviewer#
	</CFQUERY>

	<CFIF IsDefined("jobID")><CFSET job = #jobID#>
		<CFELSE><CFSET job = 0></CFIF>

	<CFOUTPUT QUERY="getApplicantJobs">
		<CFIF #Cookie.EmazeRecruiter_interviewer# EQ 0
				OR #ListContains("#ValueList(getApplicantJobs.locations)#",#checkPermissions.locationID#)# NEQ 0
				OR #ListContains("#ValueList(getApplicantJobs.departments)#",#checkPermissions.departmentID#)# NEQ 0
				OR #ListContains("#ValueList(getApplicantJobs.locationDepartments)#","#checkPermissions.locationID#-#checkPermissions.departmentID#")# NEQ 0
				OR #ListContains("#ValueList(getApplicantJobs.interviewers)#",#Cookie.EmazeRecruiter_interviewer#)# NEQ 0
				OR #Cookie.EmazeRecruiter_interviewer# EQ #getApplicantJobs.interviewerID#
				OR #ListContains("#ValueList(checkPermissions.jobs)#",#getApplicantJobs.jobID#)# NEQ 0
				OR #ListContains("#ValueList(checkPermissions.departments)#",#getApplicantJobs.departmentID#)# NEQ 0
				OR #ListContains("#ValueList(checkPermissions.locations)#",#getApplicantJobs.locationID#)# NEQ 0
				OR #ListContains("#ValueList(checkPermissions.locationDepartments)#","#getApplicantJobs.locationID#-#getApplicantJobs.departmentID#")# NEQ 0>

			<CFIF #job# EQ #getApplicantJobs.jobID#><TR BGCOLOR=lime>
				<CFELSE><TR></CFIF>
			<CFIF #discussionForum# EQ 1>
				<TD ALIGN=center><A HREF="../forums/readForum.cfm?jobID=#jobID#&applicantID=#applicantID#" TARGET="window.open">#getApplicantJobs.CurrentRow#</A></TD>
			</CFIF>
			<CFIF #job# EQ #getApplicantJobs.jobID#>
				<TD><B><A HREF="interviewOption.cfm?jobID=#jobID#&applicantID=#applicantID#">#locationName# / #departmentName# / #jobTitle#</A></B></TD>
			<CFELSE><TD><A HREF="interviewOption.cfm?jobID=#jobID#&applicantID=#applicantID#">#locationName# / #departmentName# / #jobTitle#</A></TD>
			</CFIF>
			<TD ALIGN=center>#interviewRound#</TD>
			<TD><FONT SIZE=2>#applicantStatus#</FONT></TD>
			</TR>
		</CFIF>
	</CFOUTPUT>

	</TABLE>
</CFIF>