<!---
This page enables interviewers to add themselves to the database
without granting them access to the system first. If this page is
not being used, we suggest you delete it from the server to
prevent a situation where an interviewer adds themselves and is
accidently given permissions when granting permissions for an 
applicant to all interviewers in a location, department, or
location/department. Of course, the interviewer can only view the
applicant's uploaded information and interview schedule, and
join the discussion forum.
--->

<HTML>
<HEAD>
	<TITLE>Emaze Recruiter: Add New Interviewer</TITLE>
</HEAD>

<BODY BGCOLOR=white>

<CFINCLUDE TEMPLATE="system/systemInfo.cfm">
<H1><FONT COLOR=purple>Add Interviewer</FONT></H1>

<!--- If form has just been submitted, process it. --->
<CFIF IsDefined("Form.first")>
	<!--- Check that username is not blank. If so, must enter new username. --->
	<CFIF #Form.username# EQ "" OR #Form.username# EQ " ">
		<!--- Display header if must re-display form --->
		<H3>You cannot have a blank username. Please choose a username.</H3>
		<CFSET reUsername = 1>
	<CFELSE>
		<!--- Check that username is not taken. If so, must enter new username. --->
		<CFQUERY NAME="checkUsername" DATASOURCE="#ERdatasource#">
			SELECT username FROM Interviewer WHERE username = '#Form.username#'
		</CFQUERY>
		<!--- Check that name is not taken, if name has been changed --->
		<CFIF #checkUsername.RecordCount# GT 0>
			<H3>The username, <CFOUTPUT><I>#Form.username#</I></CFOUTPUT> is already being used. Please choose another username.</H3>
			<CFSET reUsername = 1>
		</CFIF>
	</CFIF>

	<!---
	Check that password is not blank and that it was verified correctly.
	If not, must enter new password or re-verify password.
	--->
	<CFIF #Form.password# EQ "" OR #Form.password# EQ " ">
		<H3>You must enter a password.</H3>
		<CFSET rePassword = 1>
	<CFELSEIF #Form.password# NEQ #Form.passwordVerify#>
		<H3>Your password was not verified correctly. Please try again.</H3>
		<CFSET rePassword = 1>
	</CFIF>

	<!--- ok to create interviewer --->
	<CFIF NOT IsDefined("reUsername") AND NOT IsDefined("rePassword")>
		<!--- For each text field, if blank, set to space. Avoids problem of writng nothing to database. --->
		<CFIF #Form.interviewerFirstName# EQ ""><CFSET intvwFirstName = " ">
			<CFELSE><CFSET intvwFirstName = "#Form.interviewerFirstName#"></CFIF>
		<CFIF #Form.interviewerLastName# EQ ""><CFSET intvwLastName = " ">
			<CFELSE><CFSET intvwLastName = "#Form.interviewerLastName#"></CFIF>
		<CFIF #Form.interviewerEmail# EQ ""><CFSET intvwEmail = " ">
			<CFELSE><CFSET intvwEmail = "#Form.interviewerEmail#"></CFIF>
		<CFIF #Form.interviewerPhone# EQ ""><CFSET intvwPhone = " ">
			<CFELSE><CFSET intvwPhone = "#Form.interviewerPhone#"></CFIF>
		<CFIF IsDefined("Form.useCookieLogin")><CFSET cookieLogin = 1>
			<CFELSE><CFSET cookieLogin = 0></CFIF>

		<!---
		Permissions that interviewers added on this screen may not choose.
		Admin or other interviewer may grant these permissions later.
		--->
		<CFSET create = 0>
		<CFSET post = 0>
		<CFSET locs = " ">
		<CFSET depts = " ">
		<CFSET locDepts = " ">
		<CFSET job = " ">

		<!--- Get next record ID. Increment next ID. --->
		<CFINCLUDE TEMPLATE="system/nextInterviewerID.cfm">
		<CFSET nextInterviewerID = interviewerID + 1>
		<CFFILE ACTION=Write FILE="#systemPath#\system\nextInterviewerID.cfm"
			OUTPUT="<CFSET interviewerID = #nextInterviewerID#>">

		<!--- Write new record to database --->
		<CFQUERY NAME="createInterviewer" DATASOURCE="#ERdatasource#">
			INSERT INTO Interviewer (interviewerID, username, password,
				interviewerFirstName, interviewerLastName, interviewerEmail,
				interviewerPhone, locationID, departmentID, useCookieLogin,
				createJobs, postJobs, locations, departments,
				locationDepartments, jobs)
			VALUES (#interviewerID#, '#Form.username#', '#Form.password#',
				'#intvwFirstName#', '#intvwLastName#', '#intvwEmail#',
				'#intvwPhone#', #ListGetAt("#Form.locationDept#",1)#,
				#ListGetAt("#Form.locationDept#",2)#, #cookieLogin#,
				#create#, #post#, '#locs#', '#depts#',
				'#locDepts#', '#job#')
		</CFQUERY>

		<!--- Interviewer added successfully. No need to re-display form, so end page here. --->
		<FONT SIZE=4><B>Interviewer <CFOUTPUT>#Form.interviewerFirstName# #Form.interviewerLastName# (<I>#Form.username#</I>)</CFOUTPUT> created.</B></FONT>
		<CFINCLUDE TEMPLATE="program/copyright.cfm">
		</BODY></HTML>
		<CFABORT>
	</CFIF>
</CFIF>

<FORM METHOD=post ACTION="newInterviewer.cfm">
<INPUT TYPE=hidden NAME=first VALUE=0>

<!---
For each field, if form is being re-displayed because of a problem
with the username or password, re-display original value.
 --->
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2>

<TR><TD ALIGN=right>Username: </TD>
<TD><INPUT TYPE=text NAME=username SIZE=20<CFIF IsDefined("Form.username") AND NOT IsDefined("reUsername")><CFOUTPUT> VALUE="#Form.username#"</CFOUTPUT></CFIF>></TD></TR>
<TR><TD ALIGN=right>Password: </TD>
<TD><INPUT TYPE=password NAME=password SIZE=20<CFIF IsDefined("Form.password") AND NOT IsDefined("rePassword")><CFOUTPUT> VALUE="#Form.password#"</CFOUTPUT></CFIF>></TD></TR>
<TR><TD ALIGN=right>(Verify) </TD>
<TD><INPUT TYPE=password NAME=passwordVerify SIZE=20<CFIF IsDefined("Form.passwordVerify") AND NOT IsDefined("rePassword")><CFOUTPUT> VALUE="#Form.passwordVerify#"</CFOUTPUT></CFIF>></TD></TR>

<CFINCLUDE TEMPLATE="system/systemDomain.cfm">
<CFIF #allowCookieLogin# EQ 1>
	<TR><TD ALIGN=right><INPUT TYPE=checkbox NAME=useCookieLogin VALUE=1<CFIF IsDefined("Form.useCookieLogin")> CHECKED</CFIF>> </TD>
	<TD>Use automatic cookie login (requires permanent cookie)</TD></TR>
</CFIF>

<TR><TD HEIGHT=40 VALIGN=bottom ALIGN=right>First Name: </TD>
<TD VALIGN=bottom><INPUT TYPE=text NAME=interviewerFirstName SIZE=20<CFIF IsDefined("Form.interviewerFirstName")><CFOUTPUT> VALUE="#Form.interviewerFirstName#"</CFOUTPUT></CFIF>></TD></TR>
<TR><TD ALIGN=right>Last Name: </TD>
<TD><INPUT TYPE=text NAME=interviewerLastName SIZE=20<CFIF IsDefined("Form.interviewerLastName")><CFOUTPUT> VALUE="#Form.interviewerLastName#"</CFOUTPUT></CFIF>></TD></TR>
<TR><TD ALIGN=right>Email: </TD>
<TD><INPUT TYPE=text NAME=interviewerEmail SIZE=20<CFIF IsDefined("Form.interviewerEmail")><CFOUTPUT> VALUE="#Form.interviewerEmail#"</CFOUTPUT></CFIF>></TD></TR>
<TR><TD ALIGN=right>Phone: </TD>
<TD><INPUT TYPE=text NAME=interviewerPhone SIZE=20<CFIF IsDefined("Form.interviewerPhone")><CFOUTPUT> VALUE="#Form.interviewerPhone#"</CFOUTPUT></CFIF>></TD></TR>

<!--- Get location/department combinations --->
<CFQUERY NAME=getDepartmentLocations DATASOURCE="#ERdatasource#">
	SELECT DepartmentLocation.locationID, DepartmentLocation.departmentID,
		Department.departmentName, Location.locationName
	FROM (Department
		INNER JOIN DepartmentLocation ON Department.departmentID = DepartmentLocation.departmentID)
		INNER JOIN Location ON DepartmentLocation.locationID = Location.locationID
	ORDER BY Location.locationName, Department.departmentName
</CFQUERY>
<TR><TD ALIGN=right>Loc/Dept: </TD>
<TD><SELECT NAME=locationDept SIZE=1>
<!--- If re-displaying form, check the location/department they chose before. --->
<CFIF IsDefined("Form.locationDept")>
	<CFOUTPUT QUERY=getDepartmentLocations>
		<CFIF #getDepartmentLocations.locationID# EQ #ListGetAt("#Form.locationDept#",1)#
				AND #getDepartmentLocations.departmentID# EQ #ListGetAt("#Form.locationDept#",2)#>
			<OPTION SELECTED VALUE="#locationID#,#departmentID#">#locationName# / #departmentName#
		<CFELSE><OPTION VALUE="#locationID#,#departmentID#">#locationName# / #departmentName#
		</CFIF>
	</CFOUTPUT>
<CFELSE>
	<CFOUTPUT QUERY=getDepartmentLocations><OPTION VALUE="#locationID#,#departmentID#">#locationName# / #departmentName#</CFOUTPUT>
</CFIF>
</SELECT> <FONT SIZE=2 COLOR=blue>(Location / Department)</FONT></TD></TR>

<TR><TD ALIGN=right HEIGHT=40><INPUT TYPE=reset VALUE=Clear></TD><TD><INPUT TYPE=submit VALUE="Create Interviewer"></TD></TR>
</TABLE>
</FORM>

<CFINCLUDE TEMPLATE="program/copyright.cfm">
</BODY>
</HTML>