<!--- If HTML page has not already been started from a previous file --->
<CFIF NOT IsDefined("displayHeader")>
	<CFINCLUDE TEMPLATE="system/systemInfo.cfm">
	<CFINCLUDE TEMPLATE="system/jobList.cfm">
	<CFINCLUDE TEMPLATE="system/jobTitle.cfm">

	<HTML>
	<HEAD><TITLE><CFOUTPUT>#jobTitle#</CFOUTPUT></TITLE></HEAD>
	<BODY BGCOLOR=white>
</CFIF>

<!--- Get all job fields for that job. --->
<CFQUERY NAME=getJobInfo DATASOURCE="#ERdatasource#">
	SELECT * FROM Job WHERE jobID = #jobID#
</CFQUERY>

<!--- If listing location and/or department, query for names. --->
<CFIF #ListContains("#listFields#","locationName")# NEQ 0
		OR #ListContains("#listFields#","departmentName")# NEQ 0>
	<CFQUERY NAME=getDeptLoc DATASOURCE="#ERdatasource#">
		SELECT locationName, departmentName
		FROM Location, Department
		WHERE locationID = #getJobInfo.locationID#
			AND departmentID = #getJobInfo.departmentID#
	</CFQUERY>
</CFIF>

<!--- Job Title is header. --->
<H2>Job: <CFOUTPUT>#getJobInfo.jobTitle#</CFOUTPUT></H2>

<!--- Insert header of page. --->
<CFINCLUDE TEMPLATE="system/viewJobHeader.cfm">

<P>

<!--- For each field, if ok, display field.  --->
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=3 WIDTH=600>

<CFIF #ListContains("#listFields#","locationName")# NEQ 0>
	<TR><TD ALIGN=right VALIGN=top>Location: </TD>
	<TD><CFOUTPUT>#getDeptLoc.locationName#</CFOUTPUT></TD></TR>
</CFIF>
<CFIF #ListContains("#listFields#","departmentName")# NEQ 0>
	<TR><TD ALIGN=right VALIGN=top>Department: </TD>
	<TD><CFOUTPUT>#getDeptLoc.departmentName#</CFOUTPUT></TD></TR>
</CFIF>
<CFIF #ListContains("#listFields#","jobSummary")# NEQ 0>
	<TR><TD ALIGN=right VALIGN=top>Summary: </TD>
	<TD><CFOUTPUT>#getJobInfo.jobSummary#</CFOUTPUT></TD></TR>
</CFIF>
<CFIF #ListContains("#listFields#","jobDescription")# NEQ 0>
	<TR><TD ALIGN=right VALIGN=top>Description: </TD>
	<TD><CFOUTPUT>#getJobInfo.jobDescription#</CFOUTPUT></TD></TR>
</CFIF>
<CFIF #ListContains("#listFields#","jobExperience")# NEQ 0>
	<TR><TD ALIGN=right VALIGN=top>Experience: </TD>
	<TD><CFOUTPUT>#getJobInfo.jobExperience#</CFOUTPUT></TD></TR>
</CFIF>
<CFIF #ListContains("#listFields#","jobStartDate")# NEQ 0>
	<TR><TD ALIGN=right VALIGN=top>Start Date: </TD>
	<TD>
	<!--- If start date is today or earlier, job is just waiting for someone.
		So use "Now." Otherwise, use real start date.
	--->
	<CFIF #getJobInfo.jobStartDate# LT Now()>Now
	<CFELSE><CFOUTPUT>#DateFormat("#getJobInfo.jobStartDate#", "mmmm dd, yyyy")#</CFOUTPUT>
	</CFIF>
	</TD></TR>
</CFIF>

<!--- This field is dangerous if you enter a non-number. Will cause error. --->
<CFIF #ListContains("#listFields#","jobSalary")# NEQ 0>
	<TR><TD ALIGN=right VALIGN=top>Salary: </TD>
	<TD><CFOUTPUT>#getJobInfo.jobSalary#</CFOUTPUT></TD></TR>
</CFIF>

<CFIF #ListContains("#listFields#","jobType")# NEQ 0>
	<TR><TD ALIGN=right VALIGN=top>Type: </TD>
	<TD><CFOUTPUT>#getJobInfo.jobType#</CFOUTPUT></TD></TR>
</CFIF>
<CFIF #ListContains("#listFields#","jobOpenings")# NEQ 0>
	<TR><TD ALIGN=right VALIGN=top># Openings: </TD>
	<TD><CFOUTPUT>#getJobInfo.jobOpenings#</CFOUTPUT></TD></TR>
</CFIF>

</TABLE>

<P><HR NOSHADE WIDTH=400 SIZE=3 ALIGN=left>

<FONT SIZE=5><B>Apply for this Job</B></FONT>
<P>

<!---
If applicant has already applied for a job, they have a temporary cookie
written to their browser so they can apply for additional jobs without
entering their information again. So if they have the cookie, only include
a button to add the job rather than the form to enter their information.
--->


<CFIF IsDefined("Cookie.EmazeRecruiter_applicant")>
	<!--- Already applied. Cookie exists. --->
	You have already applied for one job. Rather than enter all of your information again, simply click the button below to add this job to your application.
	<P>
	<FORM METHOD=post ACTION=jobsApply.cfm>
	<CFOUTPUT><INPUT TYPE=hidden NAME=jobID VALUE=#jobID#></CFOUTPUT>
	<INPUT TYPE=submit NAME=button VALUE="Apply for this job too">
	</FORM>
<CFELSE>
	<!--- First application or cookie does not exist. --->
	If you are interested in applying for multiple jobs, first submit your information for this job. We will then write a <I>temporary</I> cookie to your browser. This cookie will be deleted upon closing your browser. When you view other jobs, you will see a button to add that job to your application. This enables you to apply for multiple jobs without entering your information each time.
	<P>
	<CFINCLUDE TEMPLATE="system/appFields.cfm">
	<!--- If may upload resume, use FORM tag which includes that functionality.  --->
	<CFIF #ListContains("#appFields#","resume")# NEQ 0>
		<FORM METHOD=post ENCTYPE="multipart/form-data" ACTION=jobsApply.cfm>
	<CFELSE><FORM METHOD=post ACTION=jobsApply.cfm>
	</CFIF>
	<CFOUTPUT><INPUT TYPE=hidden NAME=jobID VALUE=#jobID#></CFOUTPUT>

	<!--- For each field, display if Admin chose to display. --->
	<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2>

	<CFIF #ListContains("#appFields#","applicantSalutation")# NEQ 0>
		<TR><TD ALIGN=right>Salutation: </TD>
		<TD><INPUT TYPE=radio NAME=applicantSalutation VALUE="Mr."> Mr. &nbsp;
			<INPUT TYPE=radio NAME=applicantSalutation VALUE="Ms." CHECKED> Ms.</TD>
	</CFIF>

	<TR><TD ALIGN=right>First Name: </TD>
		<TD><INPUT TYPE=text NAME=applicantFirstName SIZE=20 MAXLENGTH=50></TD></TR>
	<TR><TD ALIGN=right>Last Name: </TD>
		<TD><INPUT TYPE=text NAME=applicantLastName SIZE=20 MAXLENGTH=50></TD></TR>

	<CFIF #ListContains("#appFields#","applicantAddress")# NEQ 0>
		<TR><TD ALIGN=right>Address: </TD>
		<TD><INPUT TYPE=text NAME=applicantAddress SIZE=30 MAXLENGTH=50></TD></TR>
	</CFIF>
	<CFIF #ListContains("#appFields#","applicantAddress2")# NEQ 0>
		<TR><TD ALIGN=right></TD>
		<TD><INPUT TYPE=text NAME=applicantAddress2 SIZE=30 MAXLENGTH=50></TD></TR>
	</CFIF>
	<CFIF #ListContains("#appFields#","applicantCity")# NEQ 0>
		<TR><TD ALIGN=right>City: </TD>
		<TD><INPUT TYPE=text NAME=applicantCity SIZE=20 MAXLENGTH=50></TD></TR>
	</CFIF>
	<CFIF #ListContains("#appFields#","applicantState")# NEQ 0>
		<TR><TD ALIGN=right>State/Province: </TD>
		<TD><INPUT TYPE=text NAME=applicantState SIZE=10 MAXLENGTH=50></TD></TR>
	</CFIF>
	<CFIF #ListContains("#appFields#","applicantZipCode")# NEQ 0>
		<TR><TD ALIGN=right>Zip Code: </TD>
		<TD><INPUT TYPE=text NAME=applicantZipCode SIZE=10 MAXLENGTH=50></TD></TR>
	</CFIF>
	<CFIF #ListContains("#appFields#","applicantCountry")# NEQ 0>
		<TR><TD ALIGN=right>Country: </TD>
		<TD><INPUT TYPE=text NAME=applicantCountry SIZE=20 MAXLENGTH=50 VALUE="USA"></TD></TR>
	</CFIF>
	<CFIF #ListContains("#appFields#","applicantEmail")# NEQ 0>
		<TR><TD ALIGN=right>Email: </TD>
		<TD><INPUT TYPE=text NAME=applicantEmail SIZE=30 MAXLENGTH=50></TD></TR>
	</CFIF>
	<CFIF #ListContains("#appFields#","applicantHomePhone")# NEQ 0>
		<TR><TD ALIGN=right>Home Phone: </TD>
		<TD><INPUT TYPE=text NAME=applicantHomePhone SIZE=15 MAXLENGTH=50></TD></TR>
	</CFIF>
	<CFIF #ListContains("#appFields#","applicantWorkPhone")# NEQ 0>
		<TR><TD ALIGN=right>Work Phone: </TD>
		<TD><INPUT TYPE=text NAME=applicantWorkPhone SIZE=15 MAXLENGTH=50></TD></TR>
	</CFIF>
	<CFIF #ListContains("#appFields#","applicantFax")# NEQ 0>
		<TR><TD ALIGN=right>Fax: </TD>
		<TD><INPUT TYPE=text NAME=applicantFax SIZE=15 MAXLENGTH=50></TD></TR>
	</CFIF>
	<CFIF #ListContains("#appFields#","salaryDemand")# NEQ 0>
		<TR><TD ALIGN=right>Salary Demand: </TD>
		<TD><INPUT TYPE=text NAME=salaryDemand SIZE=20 MAXLENGTH=50></TD></TR>
	</CFIF>
	<CFIF #ListContains("#appFields#","applicantStartDate")# NEQ 0>
		<TR><TD ALIGN=right>Start Date: </TD>
		<TD><INPUT TYPE=text NAME=applicantStartDate SIZE=20 MAXLENGTH=50></TD></TR>
	</CFIF>
	<CFIF #ListContains("#appFields#","resume")# NEQ 0>
		<TR><TD ALIGN=right VALIGN=top>Resume: </TD>
		<TD><INPUT TYPE=file NAME=resume SIZE=30><BR>
			(Upload file in text or MS Word format)</TD></TR>
	</CFIF>
	<CFIF #ListContains("#appFields#","resumeText")# NEQ 0>
		<TR><TD ALIGN=right VALIGN=top>Resume: </TD>
		<TD><TEXTAREA NAME=resumeText ROWS=8 COLS=55 WRAP=off></TEXTAREA></TD></TR>
	</CFIF>

	<TR><TD HEIGHT=40 COLSPAN=2 ALIGN=center><INPUT TYPE=reset VALUE=Clear> <INPUT TYPE=submit NAME=button VALUE="Apply for this job"></TD></TR>
	</TABLE>
	</FORM>
</CFIF>

<CFINCLUDE TEMPLATE="program/copyright.cfm">
</BODY>
</HTML>