<!---
List locations and departments which have job openings.
For each location:
1. List all departments with anchor link to location-department with job openings.
2. In list below, for each department in location, list job title and summary.

Only want to list each location once. The query returns the jobs in order
of location, department, and then job title.
1. Output the location if different from previous location.
2. Output department if different from previous department or location is
	different from previous location. (A department can be in multiple
	locations, so a department could repeat, but be at a different location.)
--->

<DL>
<DT><B>Location/Department</B>
<CFSET previousLocationID = 0>
<CFSET previousDepartmentID = 0>
<CFLOOP QUERY=getPostedJobs>
	<CFIF #locationID# NEQ #previousLocationID#>
		<DT><CFOUTPUT><A HREF="###locationID#">#locationName#</A></CFOUTPUT>
	</CFIF>
	<CFIF #departmentID# NEQ #previousDepartmentID# OR #locationID# NEQ #previousLocationID#>
		<DD><CFOUTPUT><A HREF="###locationID#-#departmentID#">#departmentName#</A></CFOUTPUT>
	</CFIF>
	<CFSET previousLocationID = #locationID#>
	<CFSET previousDepartmentID = #departmentID#>
</CFLOOP>
</DL>

<P><HR NOSHADE SIZE=3 WIDTH=300 ALIGN=left><P>

<!---
Output list same as before, except include the job title and
job summary below the department name. Job title links to page
to view full job information and application.
--->

<DL>
<CFSET previousLocationID = 0>
<CFSET previousDepartmentID = 0>
<CFLOOP QUERY=getPostedJobs>
	<CFIF #locationID# NEQ #previousLocationID#>
		<DT><CFOUTPUT><FONT SIZE=5><A NAME="#locationID#">Location: <B>#locationName#</B></A></FONT></CFOUTPUT>
	</CFIF>
	<CFIF #departmentID# NEQ #previousDepartmentID#>
		<DD><CFOUTPUT><FONT SIZE=4><A NAME="#locationID#-#departmentID#">Department: <B>#departmentName#</B></A></FONT></CFOUTPUT>
	</CFIF>
	<DL>
	<DT><CFOUTPUT><A HREF="jobsView.cfm?jobID=#jobID#">#jobTitle#</A></CFOUTPUT>
	<DD><CFOUTPUT>#jobSummary#</CFOUTPUT>
	<P>
	</DL>
	<CFSET previousLocationID = #locationID#>
	<CFSET previousDepartmentID = #departmentID#>
</CFLOOP>
</DL>
