<CFINCLUDE TEMPLATE="system/systemInfo.cfm">
<CFINCLUDE TEMPLATE="system/jobList.cfm">
<CFINCLUDE TEMPLATE="system/jobTitle.cfm">

<HTML>
<HEAD><TITLE><CFOUTPUT>#jobTitle#</CFOUTPUT></TITLE></HEAD>
<BODY BGCOLOR=white>

<!--- UGLY FILE WARNING!!! --->
<!---
This file searches the database according to the search criteria.
However, you never know what those criteria will be since Admin
determines which fields may be searched, and then the applicant
decides which fields to search. So this is a flexible query that
searches only those fields chosen by applicant.
--->

<!--- If applicant may search by keyword --->
<CFIF IsDefined("Form.keyword")>
	<!--- If they entered keywords to search --->
	<CFIF #Form.keyword# NEQ "" AND #Form.keyword# NEQ " ">
		<!---
		Keyword fields include: title, summary, description, experience
		If may search by that field, add field to list.
		In query, will search for keyword in each field in list.
		 --->

		<CFIF #ListContains("#searchFields#","jobTitle")# NEQ 0>
			<CFIF IsDefined("keywordFields")>
				<CFSET keywordFields = #ListAppend("#keywordFields#","Jobs.jobTitle">
			<CFELSE><CFSET keywordFields = "Jobs.jobTitle">
			</CFIF>
		</CFIF>
		<CFIF #ListContains("#searchFields#","jobSummary")# NEQ 0>
			<CFIF IsDefined("keywordFields")>
				<CFSET keywordFields = #ListAppend("#keywordFields#","Jobs.jobSummary">
			<CFELSE><CFSET keywordFields = "Jobs.jobSummary">
			</CFIF>
		</CFIF>
		<CFIF #ListContains("#searchFields#","jobDescription")# NEQ 0>
			<CFIF IsDefined("keywordFields")>
				<CFSET keywordFields = #ListAppend("#keywordFields#","Jobs.jobDescription">
			<CFELSE><CFSET keywordFields = "Jobs.jobDescription">
			</CFIF>
		</CFIF>
		<CFIF #ListContains("#searchFields#","jobExperience")# NEQ 0>
			<CFIF IsDefined("keywordFields")>
				<CFSET keywordFields = #ListAppend("#keywordFields#","Jobs.jobExperience">
			<CFELSE><CFSET keywordFields = "Jobs.jobExperience">
			</CFIF>
		</CFIF>
	</CFIF>
</CFIF>

<!---
This is an explanation of the query below.
Search criteria:
1. jobStatus = 1 (job is posted to site)
2. If search by location, check for jobs in any of the locations chosen.
	Here is how the code for this works:
	a. If location = "any", no need to include location in search.
	b. Otherwise, search AND WHERE (LOCATION = choice 1 or choice 2 or ... choice x)
	c. Need an AND and "(" before listing locations, so need variable to determine first in list.
	d. After first location, separate with OR.
	e. After last location, ")"
3. If search by department, search for department like location search.
4. Keyword searches are complex because we need to search up to 4 fields (depending
	on Admin setting), the applicant can enter multiple search terms, and they
	can choose AND or OR search.
	a. Loop through list of fields to search.
		b. Loop through comma-delimited search criteria
5. If salary, if not any, search by upper and lower bound that applicant chose.
6. If job type, search by job type like location search.
--->


<CFQUERY NAME=getPostedJobs DATASOURCE="#ERdatasource#">
	SELECT Job.jobID, Job.jobSummary, Job.jobTitle, Job.departmentID,
		Job.locationID, Location.locationName, Department.departmentName
	FROM (Department INNER JOIN Job ON Department.departmentID = Job.departmentID)
		INNER JOIN Location ON Job.locationID = Location.locationID
	WHERE Job.jobStatus = 1
		<CFIF IsDefined("Form.locationID")>
			<CFIF #ListContains("#Form.locationID#","any")# EQ 0>
				<CFSET first = 1>
				AND (<CFLOOP INDEX="location" LIST="#Form.locationID#">
					<CFIF #location# NEQ "any">
						<CFIF #first# NEQ 1>OR</CFIF> Location.locationID = #location#
					</CFIF>
					<CFSET first = 0>
				</CFLOOP>)
			</CFIF>
		</CFIF>
		<CFIF IsDefined("Form.departmentID")>
			<CFIF #ListContains("#Form.departmentID#","any")# EQ 0>
				<CFSET first = 1>
				AND (<CFLOOP INDEX="department" LIST="#Form.departmentID#">
					<CFIF #department# NEQ "any">
						<CFIF #first# NEQ 1>OR</CFIF> Department.departmentID = #department#
					</CFIF>
					<CFSET first = 0>
				</CFLOOP>)
			</CFIF>
		</CFIF>
		<CFIF IsDefined("Form.keyword")>
			<CFIF #Form.keyword# NEQ "" AND #Form.keyword# NEQ " ">
				<CFSET first = 1>
				AND (<CFLOOP INDEX="keywords" LIST="#Form.keyword#">
						<CFIF #first# NEQ 1>#Form.keywordBoolean#</CFIF>
						<CFSET firstKeyword = 1>
						<CFSET tempKeywords = "#keywords#">
						(<CFLOOP INDEX=keywordCounter LIST="#keywordFields#">
							<CFIF #first# NEQ 1>OR</CFIF> #keywordCounter# LIKE '%#tempKeywords#%'
							<CFSET firstKeyword = 0>
						</CFLOOP>)
					<CFSET first = 0>
				</CFLOOP>)
			</CFIF>
		</CFIF>
		<CFIF IsDefined("Form.jobSalary")>
			<CFIF #Form.jobSalary# NEQ "any">
				AND (Job.jobSalary >= '#ListGetAt("#Form.jobSalary#",1)#'
					AND Job.jobSalary <= '#ListGetAt("#Form.jobSalary#",2)#')
			</CFIF>
		</CFIF>
		<CFIF IsDefined("Form.jobType")>
			<CFIF #ListContains("#Form.jobType#","any") EQ 0>
				<CFSET first = 1>
				AND (<CFLOOP INDEX="type" LIST="#Form.jobType#">
					<CFIF #jobType# NEQ "any">
						<CFIF #first# NEQ 1>OR</CFIF> jobType = #type#
					</CFIF>
					<CFSET first = 0>
				</CFLOOP>)
			</CFIF>
		</CFIF>
	ORDER BY Location.locationName, Department.departmentName, Job.jobTitle
</CFQUERY>

<!--- If no jobs meet criteria, tell them. Otherwise, display jobs. --->
<CFIF #getPostedJobs.RecordCount# EQ 0>
	<H3>Sorry, but there are no jobs which meet your search criteria. Please back up and try again or view the <A HREF="jobs.cfm">main job listings</A>.</H3>
<CFELSE>
	<CFINCLUDE TEMPLATE="jobsTemplate.cfm">
</CFIF>
<CFINCLUDE TEMPLATE="program/copyright.cfm">
</BODY>
</HTML>