<!--- Display search options which are allowed by Admin. --->

<CFINCLUDE TEMPLATE="system/systemInfo.cfm">
<CFINCLUDE TEMPLATE="system/jobList.cfm">
<CFINCLUDE TEMPLATE="system/jobTitle.cfm">

<HTML>
<HEAD><TITLE><CFOUTPUT>#jobTitle#</CFOUTPUT></TITLE></HEAD>
<BODY BGCOLOR=white>

<!--- Include search header. --->
<CFINCLUDE TEMPLATE="system/searchHeader.cfm">
<P>

<FORM METHOD=post ACTION=jobsSearchResults.cfm>
<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=3>

<!--- If search by location, list locations which have job openings. --->
<CFIF #ListContains("#searchFields#","locationName")# NEQ 0>
	<CFQUERY NAME=getLocations DATASOURCE="#ERdatasource#">
		SELECT Job.jobID, Job.locationID, Location.locationName
		FROM Job INNER JOIN Location ON Job.locationID = Location.locationID
		WHERE Job.jobStatus = 1
		ORDER BY Location.locationName
	</CFQUERY>
	<TR><TD ALIGN=right VALIGN=top>Location: </TD>
	<TD><SELECT NAME=locationID SIZE=3 MULTIPLE>
		<OPTION VALUE="any" SELECTED>(Any)
		<CFSET previousLocationID = 0>
		<CFLOOP QUERY="getLocations">
			<CFIF #locationID# NEQ #previousLocationID#>
				<CFOUTPUT><OPTION VALUE=#locationID#>#locationName#</CFOUTPUT>
			</CFIF>
			<CFSET previousLocationID = #locationID#>
		</CFLOOP>
	</SELECT></TD></TR>
</CFIF>

<!--- If search by department, list departments which have job openings. --->
<CFIF #ListContains("#searchFields#","departmentName")# NEQ 0>
	<CFQUERY NAME=getDepartments DATASOURCE="#ERdatasource#">
		SELECT Job.jobID, Job.departmentID, Department.departmentName
		FROM Job INNER JOIN Department ON Department.departmentID = Job.departmentID
		WHERE Job.jobStatus = 1
		ORDER BY Department.departmentName
	</CFQUERY>
	<TR><TD ALIGN=right VALIGN=top>Department: </TD>
	<TD><SELECT NAME=departmentID SIZE=5 MULTIPLE>
		<OPTION VALUE="any" SELECTED>(Any)
		<CFSET previousDepartmentID = 0>
		<CFLOOP QUERY="getDepartments">
			<CFIF #departmentID# NEQ #previousDepartmentID#>
				<CFOUTPUT><OPTION VALUE=#departmentID#>#departmentName#</CFOUTPUT>
			</CFIF>
			<CFSET previousDepartmentID = #departmentID#>
		</CFLOOP>
	</SELECT></TD></TR>
</CFIF>

<!--- If keyword search of at least one field, display keyword search option. --->
<CFIF #ListContains("#searchFields#","jobTitle")# NEQ 0
		OR #ListContains("#searchFields#","jobSummary")# NEQ 0
		OR #ListContains("#searchFields#","jobDescription")# NEQ 0
		OR #ListContains("#searchFields#","jobExperience")# NEQ 0>
	<TR><TD ALIGN=right VALIGN=top>Keyword <BR>Search: </TD>
	<TD>You may enter one or more keywords separated by commas.<BR>
	Words separated by a blank will be interpreted as phrases.<BR>
	<INPUT TYPE=text NAME=keyword SIZE=30 MAXLENGTH=50><BR>
		<INPUT TYPE=radio NAME=keywordBoolean VALUE="AND" CHECKED> Any keyword &nbsp; &nbsp; 
		<INPUT TYPE=radio NAME=keywordBoolean VALUE="OR"> All keywords</TD></TR>
</CFIF>

<!---
If search by salary, display salary options.
For salary, we use a lower and upper bound.
We did not want to set a maximum salary for the greatest option,
so we went with 10 million. If you are posting jobs with salaries
higher than that, please email me at steve@emaze.com . I will be
happy to work for you.
--->
<CFIF #ListContains("#searchFields#","jobSalary")# NEQ 0>
	<TR><TD ALIGN=right VALIGN=top>Salary: </TD>
	<TD>
	<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0><TR>
	<TD><INPUT TYPE=radio NAME=jobSalary VALUE=any CHECKED> Any<BR>
	<INPUT TYPE=radio NAME=jobSalary VALUE="0,20000">$0 - $20,000<BR>
	<INPUT TYPE=radio NAME=jobSalary VALUE="20001,30000">$20,001 - $30,000</TD>
	<TD>&nbsp; &nbsp; <INPUT TYPE=radio NAME=jobSalary VALUE="30001,50000">$30,001 - $50,000<BR>
	&nbsp; &nbsp; <INPUT TYPE=radio NAME=jobSalary VALUE="50001,70000">$50,001 - $70,000<BR>
	&nbsp; &nbsp; <INPUT TYPE=radio NAME=jobSalary VALUE="70001,10000000">$70,001 and up</TD>
	</TR></TABLE>
	</TD></TR>
</CFIF>

<!--- If search by job type, display job types of current openings. --->
<CFIF #ListContains("#searchFields#","jobType")# NEQ 0>
	<CFQUERY NAME=getJobTypes DATASOURCE="#ERdatasource#">
		SELECT jobType
		FROM Job
		WHERE jobStatus = 1
		GROUP BY jobType
		ORDER BY jobType
	</CFQUERY>
	<TR><TD ALIGN=right VALIGN=top>Type: </TD>
	<TD><SELECT NAME=departmentName SIZE=3 MULTIPLE>
		<OPTION VALUE="any" SELECTED>(Any)
		<CFOUTPUT QUERY="getJobTypes">
			<CFIF #jobType# NEQ " " AND #jobType# NEQ "">
				<OPTION VALUE=#jobType#>#jobType#
			</CFIF>
		</CFOUTPUT>
	</SELECT></TD></TR>
</CFIF>

<TR><TD COLSPAN=2 ALIGN=center HEIGHT=40><INPUT TYPE=reset VALUE=Clear> <INPUT TYPE=submit VALUE="Search Jobs"></TD></TR>
</TABLE>
</FORM>
<CFINCLUDE TEMPLATE="program/copyright.cfm">
</BODY>
</HTML>