<!--- Uploads applicant's information. Then reloads job page. --->

<CFINCLUDE TEMPLATE="system/systemInfo.cfm">
<CFINCLUDE TEMPLATE="system/jobList.cfm">
<CFINCLUDE TEMPLATE="system/jobTitle.cfm">

<HTML>
<HEAD><TITLE><CFOUTPUT>#jobTitle#</CFOUTPUT></TITLE></HEAD>
<BODY BGCOLOR=white>

<!---
If applicant has already applied for a job, they have a temporary cookie
written to their browser so they can apply for additional jobs without
entering their information again. So if they have the cookie, we simply
add the new job to their application. If the cookie does not exist, either
because they did not accept the cookie or have not applied a job, we
upload their information.

If they apply for multiple jobs but do not accept cookies, their
information will be inserted each time they apply for a job. This is
annoying, but can be dealt with by deleting the multiple entries
and adding all jobs to their first application.
--->

<!--- Cookie exists. Already applied for job. --->
<CFIF #Form.button# EQ "Apply for this job too">
	<!--- Cookie should exist. But check avoids error. --->
	<CFIF IsDefined("Cookie.EmazeRecruiter_applicant")>
		<!--- Adds job to list of jobs for which applicant has applied. --->
	  	<CFQUERY NAME=jobToo DATASOURCE="#ERdatasource#">
			INSERT INTO ApplicantJob (applicantID, jobID, interviewRound, applicantStatus)
			VALUES (#Cookie.EmazeRecruiter_applicant#, #Form.jobID#, '0', 'New')
		</CFQUERY>
	</CFIF>

<CFELSE><!--- #Form.button# EQ "Apply for this job" --->
	<!--- No cookie. Upload form. --->
	<!---
	For each variable, if it exists (included in fields),
	check that it is not blank. If blank or does not exist,
	set to blank space. If not blank, set to form value.
	--->

	<CFIF #Form.applicantFirstName# EQ ""><CFSET FirstName = " ">
		<CFELSE><CFSET FirstName = "#Form.applicantFirstName#"></CFIF>
	<CFIF #Form.applicantLastName# EQ ""><CFSET LastName = " ">
		<CFELSE><CFSET LastName = "#Form.applicantLastName#"></CFIF>

	<CFIF IsDefined("Form.applicantSalutation")><CFSET salutation = "#Form.applicantSalutation#">
		<CFELSE><CFSET salutation = " "></CFIF>

	<CFIF IsDefined("Form.applicantAddress")>
		<CFIF #Form.applicantAddress# EQ ""><CFSET Address = " ">
		<CFELSE><CFSET Address = "#Form.applicantAddress#"></CFIF>
	  <CFELSE><CFSET Address = " "></CFIF>
	<CFIF IsDefined("Form.applicantAddress2")>
		<CFIF #Form.applicantAddress2# EQ ""><CFSET Address2 = " ">
		<CFELSE><CFSET Address2 = "#Form.applicantAddress2#"></CFIF>
	  <CFELSE><CFSET Address2 = " "></CFIF>
	<CFIF IsDefined("Form.applicantCity")>
		<CFIF #Form.applicantCity# EQ ""><CFSET City = " ">
		<CFELSE><CFSET City = "#Form.applicantCity#"></CFIF>
	  <CFELSE><CFSET City = " "></CFIF>
	<CFIF IsDefined("Form.applicantState")>
		<CFIF #Form.applicantState# EQ ""><CFSET State = " ">
		<CFELSE><CFSET State = "#Form.applicantState#"></CFIF>
	  <CFELSE><CFSET State = " "></CFIF>
	<CFIF IsDefined("Form.applicantZipCode")>
		<CFIF #Form.applicantZipCode# EQ ""><CFSET ZipCode = " ">
		<CFELSE><CFSET ZipCode = "#Form.applicantZipCode#"></CFIF>
	  <CFELSE><CFSET ZipCode = " "></CFIF>
	<CFIF IsDefined("Form.applicantCountry")>
		<CFIF #Form.applicantCountry# EQ ""><CFSET Country = " ">
		<CFELSE><CFSET Country = "#Form.applicantCountry#"></CFIF>
	  <CFELSE><CFSET Country = " "></CFIF>
	<CFIF IsDefined("Form.applicantEmail")>
		<CFIF #Form.applicantEmail# EQ ""><CFSET Email = " ">
		<CFELSE><CFSET Email = "#Form.applicantEmail#"></CFIF>
	  <CFELSE><CFSET Email = " "></CFIF>
	<CFIF IsDefined("Form.applicantHomePhone")>
		<CFIF #Form.applicantHomePhone# EQ ""><CFSET HomePhone = " ">
		<CFELSE><CFSET HomePhone = "#Form.applicantHomePhone#"></CFIF>
	  <CFELSE><CFSET HomePhone = " "></CFIF>
	<CFIF IsDefined("Form.applicantWorkPhone")>
		<CFIF #Form.applicantWorkPhone# EQ ""><CFSET WorkPhone = " ">
		<CFELSE><CFSET WorkPhone = "#Form.applicantWorkPhone#"></CFIF>
	  <CFELSE><CFSET WorkPhone = " "></CFIF>
	<CFIF IsDefined("Form.applicantFax")>
		<CFIF #Form.applicantFax# EQ ""><CFSET Fax = " ">
		<CFELSE><CFSET Fax = "#Form.applicantFax#"></CFIF>
	  <CFELSE><CFSET Fax = " "></CFIF>
	<CFIF IsDefined("Form.salaryDemand")>
		<CFIF #Form.salaryDemand# EQ ""><CFSET sDemand = " ">
		<CFELSE><CFSET sDemand = "#Form.salaryDemand#"></CFIF>
	  <CFELSE><CFSET sDemand = " "></CFIF>
	<CFIF IsDefined("Form.applicantStartDate")>
		<CFIF #Form.applicantStartDate# EQ ""><CFSET StartDate = " ">
		<CFELSE><CFSET StartDate = "#Form.applicantStartDate#"></CFIF>
	  <CFELSE><CFSET StartDate = " "></CFIF>
	<CFIF IsDefined("Form.resumeText")>
		<CFIF #Form.resumeText# EQ ""><CFSET resumeForm = " ">
		<CFELSE><CFSET resumeForm = "#Form.resumeText#">
		</CFIF>
	  <CFELSE><CFSET resumeForm = " "></CFIF>

	<!--- Get next record ID. Increment next ID. --->
	<CFINCLUDE TEMPLATE="system/nextApplicantID.cfm">
	<CFSET nextApplicantID = applicantID + 1>
	<CFFILE ACTION=Write FILE="#systemPath#\system\nextApplicantID.cfm"
		OUTPUT="<CFSET applicantID = #nextApplicantID#>">

	<CFIF IsDefined("Form.applicantStatus")>
		<CFSET status = "#Form.applicantStatus#">
	<CFELSE><CFSET status = "New">
	</CFIF>

	<!--- Create directory for this applicant. --->
	<CFDIRECTORY ACTION=Create DIRECTORY="#systemPath#\applicants\#applicantID#">

	<!--- If resume to upload, do so. Text, html and MS Word documents. --->
	<CFIF IsDefined("Form.resume")>
		<CFIF #Form.resume# NEQ "">
			<CFFILE ACTION=Upload FILEFIELD="resume"
				DESTINATION="#applicantPath#\#applicantID#\"
				ACCEPT="text/html, application/msword">
			<CFSET resumeUpload = "#File.ServerFile#">
		<CFELSE><CFSET resumeUpload = " ">
		</CFIF>
	<CFELSE><CFSET resumeUpload = " ">
	</CFIF>

	<!--- Set date/time. Insert applicant into database. --->
	<CFSET dateTime = #CreateODBCDateTime(Now())#>
  	<CFQUERY NAME=createApplicant DATASOURCE="#ERdatasource#">
		INSERT INTO Applicant 
			(applicantID, applicantFirstName, applicantLastName, applicantEmail,
			applicantHomePhone, applicantWorkPhone, applicantFax, applicantAddress,
			applicantAddress2, applicantCity, applicantState, applicantZipCode,
			applicantCountry, resume, resumeText, salaryDemand, applicantStartDate,
			applicantSalutation, applicantDate)
		VALUES (#applicantID#, '#FirstName#', '#LastName#', '#Email#',
			'#HomePhone#', '#WorkPhone#', '#Fax#', '#Address#',
			'#Address2#', '#City#', '#State#', '#ZipCode#',
			'#Country#', '#resumeUpload#', '#resumeForm#', '#sDemand#', '#StartDate#',
			'#salutation#', #dateTime#)
	</CFQUERY>

	<!--- Insert applicant and job into list of jobs applicant has applied for. --->
  	<CFQUERY NAME=createApplicantJob DATASOURCE="#ERdatasource#">
		INSERT INTO ApplicantJob (applicantID, jobID, interviewRound, applicantStatus)
		VALUES (#applicantID#, #Form.jobID#, '0', 'New')
	</CFQUERY>

	<!--- Write cookie in case they apply for additional jobs. --->
	<CFINCLUDE TEMPLATE="../system/systemDomain.cfm">
	<CFCOOKIE NAME="EmazeRecruiter_applicant" VALUE="#applicantID#" DOMAIN="#systemDomain#">
</CFIF>

<!--- Send email to job owner, notifying them of new applicant. --->
<!--- Get location name, department name, job title and email address of job owner for job. --->
<CFQUERY NAME=getJobInfo DATASOURCE="#ERdatasource#">
	SELECT Interviewer.interviewerEmail, Department.departmentName,
		Location.locationName, Job.jobTitle
	FROM ((Job INNER JOIN Interviewer ON Job.interviewerID = Interviewer.interviewerID)
		INNER JOIN Department ON Job.departmentID = Department.departmentID)
		INNER JOIN Location ON Job.locationID = Location.locationID
	WHERE Job.jobID = #Form.jobID#
</CFQUERY>

<!--- Get applicant's name, either from form if new applicant
	or from database if previously entered information. --->
<CFIF #Form.button# EQ "Apply for this job too">
	<CFQUERY NAME=getApplicantName DATASOURCE="#ERdatasource#">
		SELECT applicantFirstName, applicantLastName
		FROM Applicant
		WHERE applicantID = #Cookie.EmazeRecruiter_applicant#
	</CFQUERY>
	<CFSET applicantName = "#getApplicantName.applicantFirstName# #getApplicantName.applicantLastName#">
<CFELSE>
	<CFSET applicantName = "#Form.applicantFirstName# #Form.applicantLastName#">
</CFIF>

<CFINCLUDE TEMPLATE="system/emailServer.cfm">
<!--- Send email to job owner. --->
<CFMAIL TO="#getJobInfo.interviewerEmail#"
		FROM="Emaze Recruiter <recruiter@emaze.com>"
       	SUBJECT="New applicant: #getJobInfo.jobTitle#"
		SERVER="#emailServer#"
>
Location: #getJobInfo.locationName#
Department: #getJobInfo.departmentName#
Job: #getJobInfo.jobTitle#
Name: #applicantName#
</CFMAIL>

<!--- Confirm to application that they successfully applief. Re-display job page. --->
<H3>You have successfully applied for the following job:  <CFOUTPUT>#getJobInfo.jobTitle#</CFOUTPUT>.</H3>
<HR NOSHADE ALIGN=left SIZE=3 WIDTH=300>
<!--- Tells jobView.cfm that page has already been started. --->
<CFSET displayHeader = 0>
<CFSET jobID = #Form.jobID#>
<CFINCLUDE TEMPLATE="jobsView.cfm">