<CFINCLUDE TEMPLATE="system/systemInfo.cfm">
<CFINCLUDE TEMPLATE="system/jobList.cfm">
<CFINCLUDE TEMPLATE="system/jobTitle.cfm">


<HTML>
<HEAD><TITLE><CFOUTPUT>#jobTitle#</CFOUTPUT></TITLE></HEAD>
<BODY BGCOLOR=white>

<!--- Insert job page header. --->
<CFINCLUDE TEMPLATE="system/jobHeader.cfm">

<!---
Get current job openings.
If there are job openings:
	If search is allowed, display link to search screen.
	Display job openings using jobsTemplate.cfm .
		This is a template since it is also used for displaying search results.
--->

<CFQUERY NAME=getPostedJobs DATASOURCE="#ERdatasource#">
	SELECT Job.jobID, Job.jobSummary, Job.jobTitle, Job.departmentID,
		Job.locationID, Location.locationName, Department.departmentName
	FROM (Department INNER JOIN Job ON Department.departmentID = Job.departmentID)
		INNER JOIN Location ON Job.locationID = Location.locationID
	WHERE Job.jobStatus = 1
	ORDER BY Location.locationName, Department.departmentName, Job.jobTitle
</CFQUERY>

<CFIF #getPostedJobs.RecordCount# EQ 0>
	<H3>Sorry, but there are no job openings at this time.</H3>
<CFELSE>
	<CFIF #searchFields# NEQ " ">
		<H2><A HREF="jobsSearch.cfm">Search the Jobs</A></H2>
	</CFIF>
	<CFINCLUDE TEMPLATE="jobsTemplate.cfm">
</CFIF>

<!--- Insert job page footer. --->
<CFINCLUDE TEMPLATE="system/jobFooter.cfm">

<CFINCLUDE TEMPLATE="program/copyright.cfm">
</BODY>
</HTML>