<CFINCLUDE TEMPLATE="system/systemInfo.cfm">
<CFINCLUDE TEMPLATE="system/systemDomain.cfm">

<!--- If this is not the first time the file was called, process the login info --->
<CFIF NOT IsDefined("Form.first")>
	<!--- Login either via cookie or form --->
	<!---
	1. Determine whether cookie login is allowed in this conference.
	2. If no, display login screen
	3. If yes, check whether login cookie exists in user's browser cookie file
	4. If cookie does not exist, display login screen
	5. If cookie exists, check that the userID and username combination exists
	6. If valid user, log them in. Display homepage.cfm .
	7. If not valid user, display login screen.
	--->
	<CFIF NOT #allowCookieLogin# EQ 1>
		<CFSET showLoginForm = 1>
	<CFELSEIF NOT IsDefined("Cookie.EmazeRecruiter_login")>
		<CFSET showLoginForm = 1>
	<CFELSE>
		<!---  Check that interviewerID and username combination exists --->
		<CFQUERY NAME="checkCookie" DATASOURCE="#ERdatasource#">
			SELECT interviewerID
			FROM Interviewer
			WHERE username = '#ListGetAt("#Cookie.EmazeRecruiter_login#",2)#'
				AND interviewerID = #ListGetAt("#Cookie.EmazeRecruiter_login#",1)#
		</CFQUERY>
		<CFIF #checkCookie.RecordCount# EQ 1><!--- user exists --->
			<CFSET interviewer = #checkCookie.interviewerID#>
			<CFINCLUDE TEMPLATE="system/systemDomain.cfm">
			<CFCOOKIE NAME="EmazeRecruiter_interviewer" VALUE="#interviewer#"
				 DOMAIN="#systemDomain#">
			<CFINCLUDE TEMPLATE="program/homepage.cfm">
		<CFELSE>
			<CFSET showLoginForm = 1>
		</CFIF>
	</CFIF>

	<!--- Need to display login screen because not a cookie login. --->	
	<CFIF IsDefined("showLoginForm")>
		<HTML><HEAD><TITLE>Emaze Recruiter: Login</TITLE></HEAD>
		<BODY BGCOLOR=white>
		<CFINCLUDE TEMPLATE="system/loginHeader.cfm">
		<FORM METHOD=post ACTION="index.cfm">
		<INPUT TYPE=hidden NAME=first VALUE=1>
		<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2>
		<TR><TD ALIGN=right>Username: </TD>
		<TD><INPUT TYPE=text NAME=username SIZE=20></TD></TR>
		<TR><TD ALIGN=right>Password: </TD>
		<TD><INPUT TYPE=password NAME=password SIZE=20></TD></TR>
		<TR><TD></TD><TD><INPUT TYPE=submit VALUE="Log In"></TD>
		</TABLE></FORM>
		<CFINCLUDE TEMPLATE="system/loginFooter.cfm">
		<CFINCLUDE TEMPLATE="program/copyright.cfm">
		</BODY></HTML>
	</CFIF>
	<!--- End of login via cookie or form --->

<CFELSE>
	<!---
	1. Check that username and password are correct
		If not correct, error message, re-display login screen.
	2. If correct, call homepage.cfm to determine permissions
		and display homepage.
	3. If no permissions, go away.
	--->
	
	<CFQUERY NAME="getInterviewerInfo" DATASOURCE="#ERdatasource#">
		SELECT interviewerID, password, useCookieLogin
		FROM Interviewer
		WHERE username = '#Form.username#'
	</CFQUERY>

	<CFIF #getInterviewerInfo.RecordCount# EQ 0 OR #Form.password# NEQ #getInterviewerInfo.password#>
		<HTML><HEAD><TITLE>Emaze Recruiter: Login</TITLE></HEAD>
		<BODY BGCOLOR=white>
		<H3>Your username and/or password are not correct. Please try again.</H3>
		<CFINCLUDE TEMPLATE="system/loginHeader.cfm">
		<FORM METHOD=post ACTION="index.cfm">
		<INPUT TYPE=hidden NAME=first VALUE=1>
		<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2>
		<TR><TD ALIGN=right>Username: </TD>
		<TD><INPUT TYPE=text NAME=username SIZE=20></TD></TR>
		<TR><TD ALIGN=right>Password: </TD>
		<TD><INPUT TYPE=password NAME=password SIZE=20></TD></TR>
		<TR><TD></TD><TD><INPUT TYPE=submit VALUE="Log In"></TD>
		</TABLE></FORM>
		<CFINCLUDE TEMPLATE="system/loginFooter.cfm">
		<CFINCLUDE TEMPLATE="program/copyright.cfm">
		</BODY></HTML>
	<CFELSE><!--- Username and password were fine. Check their permissions. --->
		<CFSET interviewer = #getInterviewerInfo.interviewerID#>
		<CFINCLUDE TEMPLATE="system/systemDomain.cfm">
		<CFCOOKIE NAME="EmazeRecruiter_interviewer" VALUE="#interviewer#"
			 DOMAIN="#systemDomain#">
		<CFIF #getInterviewerInfo.useCookieLogin# EQ 1
				AND #allowCookieLogin# EQ 1
				AND NOT IsDefined("Cookie.EmazeRecruiter_login")>
			<CFCOOKIE NAME="EmazeRecruiter_login"
				VALUE="#interviewer#,#username#"
				EXPIRES="Never"
				DOMAIN="#systemDomain#">
		</CFIF>
		<CFINCLUDE TEMPLATE="program/homepage.cfm">
	</CFIF>
</CFIF>