<CFINCLUDE TEMPLATE="../program/secure.cfm">
<!---
1. Get next msgiD
2. Increment next msgID
3. Set indent and reply value
4. Status:
	a. If moderated and not admin, approved=2 (ignored)
	b. If moderated and admin, or not moderated, approved=1 (approved)
5. Get datetime
6. Add message to msg table
7. If attachment, ensure name is not already taken; write to attachment/forum directory.
8. Update Forum msgCount and lastMsgDate
9. Reload forum at new message.
--->

<!---
If post to new forum:
1. Check name is not taken by forum in that conference
2. If name is taken, ask to enter a different forum name.
3. If name is not taken, call newForum.cfm to create the new forum.
--->
<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">

<!---
Stores forumID where message is being posted. Used to avoid constantly
having to check whether the message is being posted in the original
forum or a new forum.
--->
<CFIF #Form.message# EQ "">
	<CFLOCATION URL="readForum.cfm?confID=#Form.confID#&forumID=#Form.forumID#">
</CFIF>

<CFIF NOT IsDefined("Form.r_msgID")><!--- -If posting a new message (not a reply) --->
	<!--- Determine next msgID. Increment next msgID counter. --->
	<CFINCLUDE TEMPLATE="../system/nextMsgID.cfm">
	<CFSET newNextMsgID = nextMsgID + 1>
	<CFFILE ACTION="Write" FILE="#systemPath#\system\nextMsgID.cfm"
		OUTPUT="<CFSET nextMsgID = #NumberFormat(newNextMsgID, ""000000"")#>">

	<!--- Create msgID for a new message. --->
	<CFSET newMsgID = "#NumberFormat(nextMsgID, "000000")#-000000-000000-000000">
	<CFSET newIndent = 0><!--- Message is not indented --->
<CFELSE><!--- -If replying to a particular message --->
	<!--- Determine indent number. Increment, update number of responses for original message. --->
	<CFQUERY Name="ResponseNumber" Datasource="#ERdatasource#">
		SELECT responses, indent FROM Message WHERE msgID = '#Form.r_msgID#'
	</CFQUERY>
	<CFSET newResponseNumber = ResponseNumber.responses + 1>

	<!--- <CFSET newIndent = ResponseNumber.indent + 1> --->
	<CFIF #ListGetAt("#Form.r_msgID#",4,"-")# NEQ "000000">
		<CFSET newIndent = 4>
	<CFELSEIF #ListGetAt("#Form.r_msgID#",3,"-")# NEQ "000000">
		<CFSET newIndent = 4>
	<CFELSEIF #ListGetAt("#Form.r_msgID#",2,"-")# NEQ "000000">
		<CFSET newIndent = 3>
	<CFELSE>
		<CFSET newIndent = 2>
	</CFIF>

	<CFQUERY Name="ResponseNumberSet" Datasource="#ERdatasource#">
		UPDATE Message
		SET responses = #newResponseNumber#
		WHERE msgID = '#r_msgID#'
	</CFQUERY>
	<!--- Create msgID for the reply. --->
	<CFSET newMsgID = ListSetAt(Form.r_msgID, newIndent + 1, NumberFormat(newResponseNumber, "000000"), "-")>
</CFIF>

<!--- Get date and time of message --->
<CFSET dateTime = #CreateODBCDateTime(Now())#>

<!--- Replace carriage returns with BR so message displays correctly. --->
<CFSET messageBR = #Replace("#Form.message#", "
", "<BR>", "ALL")#>

<CFIF #Form.subject# EQ ""><CFSET newSubject = " ">
	<CFELSE><CFSET newSubject = "#Form.subject#"></CFIF>
<CFIF #Form.message# EQ ""><CFSET messageBR = " "></CFIF>
<CFIF IsDefined("Form.anonName")>
	<CFIF #Form.anonName# EQ ""><CFSET newAnonName = " ">
	<CFELSE><CFSET newAnonName = "#Form.anonName#"></CFIF>
<CFELSE><CFSET newAnonName = " ">
</CFIF>

<CFQUERY NAME="InsertMessage" DATASOURCE="#ERdatasource#">
	INSERT INTO Message (msgID, msgDateTime, indent, message, responses,
		subject, interviewerID, jobID, applicantID, anonName)
	VALUES ('#newMsgID#', #dateTime#, #newIndent#, '#messageBR#', 0,
		'#newSubject#', #interviewerID#, #Form.jobID#, #Form.applicantID#, '#newAnonName#')
</CFQUERY>

<!--- Reload forum, pointing to new message. --->
<CFLOCATION URL="readForum.cfm?jobID=#Form.jobID#&applicantID=#Form.applicantID####newMsgID#">