<CFINCLUDE TEMPLATE="system/systemInfo.cfm">
<CFSET ERdatasource = "make">
<HTML>
<HEAD><TITLE>Emaze Recruiter: Create Database</TITLE></HEAD>
<BODY BGCOLOR=white>

<H1 ALIGN=center><FONT COLOR=purple>Create Database</FONT></H1>

<CFQUERY NAME=Applicant DATASOURCE="#ERdatasource#">
	CREATE TABLE Applicant
	([applicantID] short,
	[applicantFirstName] text (50),
	[applicantLastName] text (50),
	[applicantEmail] text (50),
	[applicantHomePhone] text (50),
	[applicantWorkPhone] text (50),
	[applicantFax] text (50),
	[applicantAddress] text (50),
	[applicantAddress2] text (50),
	[applicantCity] text (50),
	[applicantState] text (50),
	[applicantZipCode] text (50),
	[applicantCountry] text (50),
	[resume] text (50),
	[resumeText] memo,
	[salaryDemand] text (50),
	[applicantStartDate] text (50),
	[applicantSalutation] text (50),
	[applicantDate] datetime,
	CONSTRAINT [Index1] PRIMARY KEY ([applicantID]))
</CFQUERY>

Applicant table created.<BR>

<CFQUERY NAME=ApplicantJob DATASOURCE="#ERdatasource#">
	CREATE TABLE ApplicantJob
	([applicantID] short,
	[jobID] short,
	[interviewRound] text (50),
	[applicantStatus] text (50),
	[locations] text (50),
	[locationDepartments] text (50),
	[interviewers] text (50),
	[departments] text (50),
	CONSTRAINT [Index1] PRIMARY KEY ([applicantID], [jobID]))
</CFQUERY>

ApplicantJob table created.<BR>

<CFQUERY NAME=Department DATASOURCE="#ERdatasource#">
	CREATE TABLE Department
	([departmentID] short,
	[departmentName] text (50),
	[departmentDescription] memo,
	CONSTRAINT [Index1] PRIMARY KEY ([departmentID]))
</CFQUERY>

Department table created.<BR>

<CFQUERY NAME=DepartmentLocation DATASOURCE="#ERdatasource#">
	CREATE TABLE DepartmentLocation
	([departmentID] short,
	[locationID] short,
	CONSTRAINT [Index1] PRIMARY KEY ([departmentID], [locationID]))
</CFQUERY>

DepartmentLocation table created.<BR>

<CFQUERY NAME=FileTable DATASOURCE="#ERdatasource#">
	CREATE TABLE File
	([fileID] short,
	[fileType] text (50),
	[fileCreatorName] text (50),
	[fileCreationDate] datetime,
	[fileLastModifiedDate] datetime,
	[applicantID] short,
	[jobID] short,
	CONSTRAINT [Index1] PRIMARY KEY ([fileID]))
</CFQUERY>

File table created. (Not currently used.)<BR>

<CFQUERY NAME=Interviewer DATASOURCE="#ERdatasource#">
	CREATE TABLE Interviewer
	([interviewerID] short,
	[interviewerFirstName] text (50),
	[interviewerLastName] text (50),
	[interviewerEmail] text (50),
	[interviewerPhone] text (50),
	[username] text (50),
	[password] text (50),
	[departmentID] short,
	[locationID] short,
	[useCookieLogin] short,
	[jobs] text (50),
	[departments] text (50),
	[locations] text (50),
	[locationDepartments] text (50),
	[createJobs] short,
	[postJobs] short,
	CONSTRAINT [Index1] PRIMARY KEY ([interviewerID]))
</CFQUERY>

Interviewer table created.<BR>

<CFQUERY NAME=insertInterviewerAnon DATASOURCE="#ERdatasource#">
	INSERT INTO Interviewer
		(interviewerID, interviewerFirstName, interviewerLastName,
		interviewerEmail, interviewerPhone, password, username)
	VALUES (-1, 'anon', 'anon', 'anon', 'anon', 'anon', 'anon')
</CFQUERY>

<CFQUERY NAME=insertInterviewerMaster DATASOURCE="#ERdatasource#">
	INSERT INTO Interviewer
		(interviewerID, interviewerFirstName, interviewerLastName,
		interviewerEmail, password, username)
	VALUES (0, 'Emaze', 'Webmaster', 'webmaster@emaze.com', 'emaze', 'master')
</CFQUERY>

<I>Interviewer table initial data inserted.</I><BR>

<CFQUERY NAME=Job DATASOURCE="#ERdatasource#">
	CREATE TABLE Job
	([jobID] short,
	[jobTitle] text (50),
	[jobDescription] memo,
	[jobSalary] text (50),
	[departmentID] short,
	[interviewerID] short,
	[jobStartDate] datetime,
	[jobStatus] short,
	[jobSummary] memo,
	[jobExperience] memo,
	[jobPostedDate] datetime,
	[jobType] text (50),
	[jobOpenings] short,
	CONSTRAINT [Index1] PRIMARY KEY ([jobID]))
</CFQUERY>

Job table created.<BR>

<CFQUERY NAME=LetterTemplates DATASOURCE="#ERdatasource#">
	CREATE TABLE LetterTemplates
	([template] text (50),
	[body] memo,
	[fromAddress] memo,
	[closingOther] memo,
	[fromAlign] text (50),
	[displayCountry] short,
	[greeting] text (50),
	[greetingName] text (50),
	[greetingPunctuation] text (50),
	[closing] text (50),
	[closingBlankLines] short,
	[emailSubject] text (50),
	[emailFrom] text (50),
	[emailCCInterviewer] short,
	[emailReplyTo] text (50),
	[emailCCOther] text (50),
	CONSTRAINT [Index1] PRIMARY KEY ([template]))
</CFQUERY>

LetterTemplates table created.<BR>

<CFQUERY NAME=LTinterviewEmail DATASOURCE="#ERdatasource#">
	INSERT INTO LetterTemplates
		(template, displayCountry, greeting, greetingName,
		greetingPunctuation, closing, closingBlankLines, emailFrom,
		emailCCInterviewer, emailReplyTo, emailCCOther)
	VALUES ('interviewEmail', 0, 'Dear', 'first', ',', 'Regards,', 1, 0, 1, 0, 0)
</CFQUERY>

<CFQUERY NAME=LTinterviewLetter DATASOURCE="#ERdatasource#">
	INSERT INTO LetterTemplates
		(template, fromAlign, displayCountry, greeting, greetingName,
		greetingPunctuation, closing, closingBlankLines)
	VALUES ('interviewLetter', 'right', 0, 'Dear', 'first', ':', 'Sincerely,', 2)
</CFQUERY>

<CFQUERY NAME=LTnoInterviewEmail DATASOURCE="#ERdatasource#">
	INSERT INTO LetterTemplates
		(template, displayCountry, greeting, greetingName,
		greetingPunctuation, closing, closingBlankLines, emailFrom,
		emailCCInterviewer, emailReplyTo, emailCCOther)
	VALUES ('noInterviewEmail', 0, 'Dear', 'first', ',', 'Regards,', 1, 0, 1, 0, 0)
</CFQUERY>

<CFQUERY NAME=LTnoInterviewLetter DATASOURCE="#ERdatasource#">
	INSERT INTO LetterTemplates
		(template, fromAlign, displayCountry, greeting, greetingName,
		greetingPunctuation, closing, closingBlankLines)
	VALUES ('noInterviewLetter', 'right', 0, 'Dear', 'first', ':', 'Sincerely,', 2)
</CFQUERY>

<CFQUERY NAME=LTnoOfferEmail DATASOURCE="#ERdatasource#">
	INSERT INTO LetterTemplates
		(template, displayCountry, greeting, greetingName,
		greetingPunctuation, closing, closingBlankLines, emailFrom,
		emailCCInterviewer, emailReplyTo, emailCCOther)
	VALUES ('noOfferEmail', 0, 'Dear', 'first', ',', 'Regards,', 1, 0, 1, 0, 0)
</CFQUERY>

<CFQUERY NAME=LTnoOfferLetter DATASOURCE="#ERdatasource#">
	INSERT INTO LetterTemplates
		(template, fromAlign, displayCountry, greeting, greetingName,
		greetingPunctuation, closing, closingBlankLines)
	VALUES ('noOfferLetter', 'right', 0, 'Dear', 'first', ':', 'Sincerely,', 2)
</CFQUERY>

<CFQUERY NAME=LTofferEmail DATASOURCE="#ERdatasource#">
	INSERT INTO LetterTemplates
		(template, displayCountry, greeting, greetingName,
		greetingPunctuation, closing, closingBlankLines, emailFrom,
		emailCCInterviewer, emailReplyTo, emailCCOther)
	VALUES ('offerEmail', 0, 'Dear', 'first', ',', 'Regards,', 1, 0, 1, 0, 0)
</CFQUERY>

<CFQUERY NAME=LTofferLetter DATASOURCE="#ERdatasource#">
	INSERT INTO LetterTemplates
		(template, fromAlign, displayCountry, greeting, greetingName,
		greetingPunctuation, closing, closingBlankLines)
	VALUES ('offerLetter', 'right', 0, 'Dear', 'first', ':', 'Sincerely,', 2)
</CFQUERY>

<I>LetterTemplates table initial data inserted.</I><BR>

<CFQUERY NAME=Location DATASOURCE="#ERdatasource#">
	CREATE TABLE Location
	([locationID] short,
	[locationName] text (50),
	[locationAddress] text (50),
	[locationAddress2] text (50),
	[locationCity] text (50),
	[locationState] text (50),
	[locationCountry] text (50),
	[locationPhone] text (50),
	[locationFax] text (50),
	[locationDirections] memo,
	[locationZipCode] text (50),
	CONSTRAINT [Index1] PRIMARY KEY ([locationID]))
</CFQUERY>

Location table created.<BR>

<CFQUERY NAME=Message DATASOURCE="#ERdatasource#">
	CREATE TABLE Message
	([msgID] text (50),
	[jobID] short,
	[applicantID] short,
	[interviewerID] short,
	[message] memo,
	[msgDateTime] datetime,
	[anonName] text (50),
	[subject] text (50),
	[responses] short,
	[indent] short,
	CONSTRAINT [Index1] PRIMARY KEY ([msgID]))
</CFQUERY>

Message table created.<BR>

<CFQUERY NAME=Notes DATASOURCE="#ERdatasource#">
	CREATE TABLE Notes
	([noteID] short,
	[noteDateTime] datetime,
	[noteInterviewerName] text (50),
	[theNote] memo,
	[applicantID] short,
	[jobID] short,
	CONSTRAINT [Index1] PRIMARY KEY ([noteID]))
</CFQUERY>

Notes table created.<BR>

<CFQUERY NAME=Schedule DATASOURCE="#ERdatasource#">
	CREATE TABLE Schedule
	([scheduleID] short,
	[applicantID] short,
	[jobID] short,
	[interviewerID] short,
	[schedule] text (50),
	[emailOption] text (50),
	CONSTRAINT [Index1] PRIMARY KEY ([scheduleID]))
</CFQUERY>

Schedule table created.<BR>

<H1>Database set up completed!</H1>

</BODY>
</HTML>