/* ========================================================================
   =================    TVicHW32  DLL interface        ====================
   ==========            Shareware Version 2.0                  ===========
   ==========     Copyright (c) 1997 Victor I.Ishikeev          ===========
   ========================================================================
   ==========         mail to "victor@ivi.ugatu.ac.ru"          ===========
   ======================================================================== */

//#define DEMOVERSION
// UNDEF THIS TO COMPILE REGISTERED VERSION OF THE DLL

//#define NT_ADMIN   
                     // uncomment this line if you do login to NT
                     // as "Administrator"
                     
                     // else:
                     // - comment this line
                     // - compile a dll
                     // - run "regini.exe tvichw32.ini"
                     // - reboot your PC

#include <windows.h>
#include <stdlib.h>
#include <stdio.h>

#include "TVicHW32.h"

#define	_DRV_MAP_MEMORY				2
#define	_DRV_UNMAP_MEMORY			3
#define	_DRV_GET_INTERRUPT_COUNTER  4
#define	_DRV_SET_POST_EVENT         5
#define	_DRV_SET_INT_VEC            6
#define	_DRV_MASK_INT_VEC           7
#define	_DRV_UNMASK_INT_VEC         8
#define	_DRV_STOP_INT_VEC           9
#define	_DRV_HARD_READ_PORT         11
#define	_DRV_HARD_WRITE_PORT        12
#define	_DRV_HARD_READ_PORTW        13
#define	_DRV_HARD_WRITE_PORTW       14
#define	_DRV_HARD_READ_PORTL        15
#define	_DRV_HARD_WRITE_PORTL       16
#define	_DRV_PULSE_EVENT            17
   

#define _DRV_SOFT_ACCESS            31
#define _DRV_HARD_ACCESS            32



#define	DRIVER_NOT_FOUND			0
#define	DRIVER_ALREADY_RUNNING		1
#define	DRIVER_OPEN_SUCCESS			2


typedef struct _TVicHW32Descriptor
{
    bool	fTerminated;

    bool	fMemoryMapped;

    DWORD	fInterface;     // Isa, Eisa, etc....
    DWORD	fBus;			// Bus number
    DWORD	fPhysLoPart;    // Bus-relative address
    DWORD	fPhysHiPart;    // Zero
    DWORD	fTypeMem;       // 0 is memory, 1 is I/O
    DWORD	fMemorySize;    // Length of section to map

    void*	fMemoryPointer;

    HANDLE	fLocEvent;
    long*	fpCounter;
    bool	fHardAccess;

    bool	fIsIRQSet;
    bool	fMasked;
    bool	fOpenDrive;
    HANDLE	hDRV;
    void	(*fOnHWInterrupt)();
    DWORD	fIRQNumber;
    HANDLE	fThreadId;
    HANDLE	fThreadHandle;
    //CRITICAL_SECTION	fHWCritSect_IO;
    CRITICAL_SECTION	fHWCritSect_IRQ;
    HANDLE	fEventIRQSet;

    DWORD	fHandled;
} TVicHW32Descriptor;

typedef HANDLE (__stdcall* TOpenVxDHandle)(HANDLE); 

//-------------------------------------------------------------


bool				fWin95;

SC_HANDLE			schSCManager;

TVicHW32Descriptor	HW32;

TOpenVxDHandle		OpenVxDHandle;

HANDLE				hDll;

#ifdef DEMOVERSION
const char DriverName[] = "VICHW00";
#else
const char DriverName[] = "VICHW11";
#endif

//-------------------------------------------------------------
BOOL
InstallDriver()
{
	SC_HANDLE	schService;
	char	ServiceExe[255];

	GetWindowsDirectory(ServiceExe, 128);

#ifdef DEMOVERSION
	strcat(ServiceExe, "\\SYSTEM32\\DRIVERS\\VICHW00.SYS");
#else
	strcat(ServiceExe, "\\SYSTEM32\\DRIVERS\\VICHW11.SYS");
#endif

	schService = CreateService( schSCManager,			// SCManager database
								DriverName,				// name of service
								DriverName,				// name to display
								SERVICE_ALL_ACCESS,		// desired access
								SERVICE_KERNEL_DRIVER,	// service type
								SERVICE_DEMAND_START,	// start type
								SERVICE_ERROR_NORMAL,	// error control type
								ServiceExe,				// service's binary
								NULL,                   // no load ordering group
								NULL,                   // no tag identifier
								NULL,                   // no dependencies
								NULL,                   // LocalSystem account
								NULL);                  // no password)

    BOOL Result = (schService != 0) || (GetLastError() == ERROR_SERVICE_EXISTS);
    CloseServiceHandle(schService);
	return Result;
}

//-------------------------------------------------------------
BOOL
StartDriver()
{
	SC_HANDLE	schService;
	BOOL		Result = FALSE;

	schService = OpenService (schSCManager, DriverName, SERVICE_ALL_ACCESS);
	if (schService != 0) {
		Result = StartService(schService, 0, NULL);
		Result |= (GetLastError() == ERROR_SERVICE_ALREADY_RUNNING);
		CloseServiceHandle (schService);
	}
	return Result;
}

//-------------------------------------------------------------
BOOL
StopDriver()
{
	SC_HANDLE schService;
	SERVICE_STATUS serviceStatus;
	BOOL Result = FALSE;

	schService = OpenService (schSCManager, DriverName, SERVICE_ALL_ACCESS);
	if (schService != NULL) {
		Result = ControlService (schService, SERVICE_CONTROL_STOP, &serviceStatus);
		CloseServiceHandle (schService);
	}
	return Result;
}

//-------------------------------------------------------------
BOOL
RemoveDriver()
{
	SC_HANDLE	schService;
	BOOL		Result = FALSE;

	schService = OpenService (schSCManager, DriverName, SERVICE_ALL_ACCESS);
	if (schService != 0) {
		Result = DeleteService (schService);
		CloseServiceHandle (schService);
	}
	return Result;
}

//-------------------------------------------------------------
HANDLE
Install_Start_Load_Driver()
{

HANDLE Result = INVALID_HANDLE_VALUE;

#ifdef NT_ADMIN

	
	schSCManager = OpenSCManager(0, 0, SC_MANAGER_ALL_ACCESS);
	if (schSCManager !=0) {
		if (InstallDriver()) {
			if (StartDriver()) {
          #ifdef DEMOVERSION
				Result = CreateFile("\\\\.\\VICHW00", GENERIC_READ | GENERIC_WRITE, 0, NULL,
                                         OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
          #else
				Result = CreateFile("\\\\.\\VICHW11", GENERIC_READ | GENERIC_WRITE, 0, NULL,
                                         OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
          #endif
			}
		}
		CloseServiceHandle (schSCManager);
	}

#else

    #ifdef DEMOVERSION
			Result = CreateFile("\\\\.\\VICHW00", GENERIC_READ | GENERIC_WRITE, 0, NULL,
                                         OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    #else
			Result = CreateFile("\\\\.\\VICHW11", GENERIC_READ | GENERIC_WRITE, 0, NULL,
                                         OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    #endif

#endif

	return Result;
}

//-------------------------------------------------------------
void
Close_Stop_Unload_Driver(HANDLE hDrv)
{
	CloseHandle(hDrv); 
   if ((GetVersion() & 0x80000000) != 0)
		return;

#ifdef NT_ADMIN

	schSCManager = OpenSCManager(0, 0, SC_MANAGER_ALL_ACCESS);
	if  (schSCManager !=0) {
		StopDriver();
		RemoveDriver();
		CloseServiceHandle(schSCManager);
	}

#endif

}

//-------------------------------------------------------------
DWORD 
CtlCode(WORD Code)
{
	DWORD Result;		
	if (fWin95)
		Result = (DWORD)Code;
	else
		Result = 0x80000000L | ((0x0800 + Code) << 2);

	return Result;
}

//-------------------------------------------------------------
void
__stdcall IRQProcNT(TVicHW32Descriptor& HW32)
{
	DWORD	nByte = 0;
    HANDLE  CurrentProcess;

    CurrentProcess = GetCurrentProcess();
    SetPriorityClass(CurrentProcess, REALTIME_PRIORITY_CLASS);
    SetThreadPriority(HW32.fThreadHandle, THREAD_PRIORITY_TIME_CRITICAL);
    EnterCriticalSection(&HW32.fHWCritSect_IRQ);
    HW32.fLocEvent = CreateSemaphore(NULL, 0, 1000, NULL);
    HW32.fMasked = true;
    DeviceIoControl(HW32.hDRV,
                    CtlCode(_DRV_SET_POST_EVENT),
                    &HW32.fLocEvent, sizeof(HW32.fLocEvent), 
					NULL, 0, &nByte, NULL);
    DeviceIoControl(HW32.hDRV,
                    CtlCode(_DRV_SET_INT_VEC),
                    &HW32.fIRQNumber, sizeof(HW32.fIRQNumber),
					NULL, 0, &nByte, NULL);
    HW32.fIsIRQSet = true;
    SetEvent(HW32.fEventIRQSet);

    while (true) {
		WaitForSingleObject(HW32.fLocEvent, INFINITE);
		if (!HW32.fTerminated) {
			if (HW32.fOnHWInterrupt != NULL)
				HW32.fOnHWInterrupt();
		}	else 
				break;
    }
    CurrentProcess = GetCurrentProcess();
    SetPriorityClass(CurrentProcess, NORMAL_PRIORITY_CLASS);
    LeaveCriticalSection(&HW32.fHWCritSect_IRQ);
	
}

//-------------------------------------------------------------
void
__stdcall IRQProc95(TVicHW32Descriptor& HW32)
{
	DWORD	nByte = 0;	
	HANDLE	CurrentProcess;
    DWORD	Count;
    HANDLE	hDRVEvent;

    CurrentProcess = GetCurrentProcess();
    SetPriorityClass(CurrentProcess, REALTIME_PRIORITY_CLASS);
    SetThreadPriority(HW32.fThreadHandle, THREAD_PRIORITY_TIME_CRITICAL);
    EnterCriticalSection(&HW32.fHWCritSect_IRQ);
    HW32.fLocEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
    ResetEvent(HW32.fLocEvent);
    HW32.fMasked  = true; 
	HW32.fHandled = 0;
    hDRVEvent = OpenVxDHandle(HW32.fLocEvent);
    DeviceIoControl(HW32.hDRV,
                    CtlCode(_DRV_SET_POST_EVENT),
                    &hDRVEvent, sizeof(hDRVEvent),
					&HW32.fpCounter, 0, &nByte, NULL);
    DeviceIoControl(HW32.hDRV,
                    CtlCode(_DRV_SET_INT_VEC),
                    &HW32.fIRQNumber, sizeof(HW32.fIRQNumber),
					NULL,0, &nByte, NULL);
    HW32.fIsIRQSet = true;
    SetEvent(HW32.fEventIRQSet);
    while (true) {
		WaitForSingleObject(HW32.fLocEvent, INFINITE);
		ResetEvent(HW32.fLocEvent);
		if (!HW32.fTerminated) {
			Count = *HW32.fpCounter;
			if (HW32.fOnHWInterrupt != NULL) {
				while (HW32.fHandled < Count) {
					HW32.fOnHWInterrupt();
					HW32.fHandled++;
				}
			}
		} else
			break;
	}
    CurrentProcess = GetCurrentProcess();
    SetPriorityClass(CurrentProcess, NORMAL_PRIORITY_CLASS);
    LeaveCriticalSection(&HW32.fHWCritSect_IRQ);
}

//-------------------------------------------------------------
void
__stdcall UnmapMemory()
{
	DWORD	nByte;

	if (HW32.fMemoryMapped) {
		DeviceIoControl(HW32.hDRV,
						CtlCode(_DRV_UNMAP_MEMORY),
						&HW32.fMemoryPointer, sizeof(HW32.fMemoryPointer),
						NULL, 0, &nByte, NULL);
		HW32.fMemoryMapped = false;
		HW32.fPhysLoPart   = 0;
		HW32.fMemorySize   = 0;
	}
}

//-------------------------------------------------------------
void*
__stdcall MapPhysToLinear(DWORD PhAddr, DWORD Size)
{
	DWORD nByte = 0;
	void* Result = HW32.fMemoryPointer;

	if (!HW32.fOpenDrive || ( (PhAddr == HW32.fPhysLoPart) && (Size == HW32.fMemorySize)) )
		return Result;

//	EnterCriticalSection(&HW32.fHWCritSect_IO);
	if (HW32.fMemoryMapped)
		UnmapMemory();
	HW32.fMemorySize = Size;
	HW32.fPhysLoPart = PhAddr;
	DeviceIoControl(HW32.hDRV,
					CtlCode(_DRV_MAP_MEMORY),
					&HW32.fInterface, 24,
					&HW32.fMemoryPointer, sizeof(HW32.fMemoryPointer),
                    &nByte, NULL);
	HW32.fMemoryMapped = true;
	Result = HW32.fMemoryPointer;
//	LeaveCriticalSection(&HW32.fHWCritSect_IO);
	return Result;
}

//-------------------------------------------------------------
bool
__stdcall OpenTVicHW32()
{
	if (HW32.fOpenDrive)
		return true;

	char buffer[255];

	memset(&HW32, 0, sizeof(HW32));		// clear-out HW32 struc
	HW32.fOpenDrive = false;
	HW32.fMasked    = true;
	HW32.fHardAccess= true;
	HW32.fMemoryMapped = false;

	HW32.fInterface		= 1;		// Isa, Eisa, etc....
	HW32.fBus           = 0;        // Bus number
	HW32.fPhysLoPart    = 0;        // Bus-relative address
	HW32.fPhysHiPart    = 0;
	HW32.fTypeMem       = 0;        // 0 is memory, 1 is I/O
	HW32.fMemorySize    = 0;        // Length of section to map

	HW32.hDRV = INVALID_HANDLE_VALUE;
//	InitializeCriticalSection(&HW32.fHWCritSect_IO);
    fWin95 =  ((GetVersion() & 0x80000000) != 0);

	hDll = 0;
	if (fWin95) {
		hDll = GetModuleHandle("kernel32");
		OpenVxDHandle = (TOpenVxDHandle)GetProcAddress(hDll, "OpenVxDHandle");
		strcpy(buffer, "\\\\.\\");
		strcat(buffer, DriverName);
		strcat(buffer, ".VXD");
		HW32.hDRV = CreateFile(buffer, 0, 0, NULL, 0,
							   FILE_FLAG_DELETE_ON_CLOSE, 0);
	} else {
        HW32.hDRV = Install_Start_Load_Driver();
        if (HW32.hDRV == INVALID_HANDLE_VALUE) {
			Close_Stop_Unload_Driver(HW32.hDRV);
			HW32.hDRV = Install_Start_Load_Driver();
		}
	}
	HW32.fOpenDrive = (HW32.hDRV != INVALID_HANDLE_VALUE);
	return HW32.fOpenDrive;
}

//-------------------------------------------------------------
void
__stdcall MaskIRQ()
{
	DWORD nByte = 0;

	if (!HW32.fOpenDrive || !HW32.fIsIRQSet || HW32.fMasked)
		return;

	HW32.fMasked = true;
//	EnterCriticalSection(&HW32.fHWCritSect_IO);
	DeviceIoControl(HW32.hDRV,
					CtlCode(_DRV_MASK_INT_VEC),
					NULL, 0, NULL, 0,
					&nByte, NULL);
//	LeaveCriticalSection(&HW32.fHWCritSect_IO);
}

//-------------------------------------------------------------
BYTE
__stdcall ReadPort(WORD nPort)
{
	DWORD nByte = 0, PortNumber= (DWORD)nPort, DataPort = 0;
	
	if (!HW32.fOpenDrive) 
		return 0xff;

	if (HW32.fHardAccess) {
		DeviceIoControl(HW32.hDRV,
						CtlCode(_DRV_HARD_READ_PORT),
						&PortNumber, sizeof(PortNumber),
						&DataPort, sizeof(DataPort),
						&nByte, NULL);
	} else {
		__asm {
           mov dx, word ptr PortNumber
           in  al,dx
           mov byte ptr DataPort, al
		}
	}
	return (BYTE)(LOWORD(DataPort));
}

//-------------------------------------------------------------
WORD
__stdcall ReadPortW(WORD nPort)
{
	DWORD nByte = 0, PortNumber= (DWORD)nPort, DataPort = 0;

	if (!HW32.fOpenDrive)
		return 0xffff;

	if (HW32.fHardAccess) {
		DeviceIoControl(HW32.hDRV,
						CtlCode(_DRV_HARD_READ_PORTW),
						&PortNumber, sizeof(PortNumber),
						&DataPort, sizeof(DataPort),
						&nByte, NULL);
	} else {
		__asm {
            mov dx,word ptr PortNumber
            in  ax,dx
            mov word ptr DataPort,ax
        }
    }
	return LOWORD(DataPort);
}

//-------------------------------------------------------------
DWORD
__stdcall ReadPortL(WORD nPort)
{
	DWORD nByte = 0, PortNumber= (DWORD)nPort, DataPort = 0;

	if (!HW32.fOpenDrive)
		return 0xffffffff;

	if (HW32.fHardAccess) {
		DeviceIoControl(HW32.hDRV,
						CtlCode(_DRV_HARD_READ_PORTL),
						&PortNumber, sizeof(PortNumber),
						&DataPort, sizeof(DataPort),
						&nByte, NULL);
	} else {
		__asm {
            mov dx,word ptr PortNumber
            in  eax,dx
            mov DataPort,eax
		}
	}
	return DataPort;
}

//-------------------------------------------------------------
void
__stdcall WritePort(WORD nPort, BYTE pval)
{
	DWORD nByte = 0;
	struct _Rec {
		DWORD PortNumber;
		DWORD DataPort;
	} Rec;

	if (!HW32.fOpenDrive)
		return;

	if (HW32.fHardAccess) {
		Rec.PortNumber	= (DWORD)nPort;
		Rec.DataPort	= (DWORD)pval;
		DeviceIoControl(HW32.hDRV,
						CtlCode(_DRV_HARD_WRITE_PORT),
						&Rec, sizeof(Rec), NULL, 0,
						&nByte, NULL);
	} else {
		__asm {
           mov al, pval
           mov dx, nPort
           out dx, al
        }
    }
}

//-------------------------------------------------------------
void
__stdcall WritePortW(WORD nPort, WORD pval)
{
	DWORD nByte = 0;
	struct _Rec {
		DWORD PortNumber;
		DWORD DataPort;
	} Rec;

	if (!HW32.fOpenDrive)
		return;

	if (HW32.fHardAccess) {
		Rec.PortNumber	= (DWORD)nPort;
		Rec.DataPort	= (DWORD)pval;
		DeviceIoControl(HW32.hDRV,
						CtlCode(_DRV_HARD_WRITE_PORTW),
						&Rec, sizeof(Rec), NULL, 0,
						&nByte, NULL);
	} else {
		__asm {
           mov ax, pval
           mov dx, nPort
           out dx, ax
        }
    }
}

//-------------------------------------------------------------
void
__stdcall WritePortL(WORD nPort, DWORD pval)
{
	DWORD nByte = 0;
	struct _Rec {
		DWORD PortNumber;
		DWORD DataPort;
	} Rec;

	if (!HW32.fOpenDrive)
		return;

	if (HW32.fHardAccess) {
		Rec.PortNumber	= (DWORD)nPort;
		Rec.DataPort	= pval;
		DeviceIoControl(HW32.hDRV,
						CtlCode(_DRV_HARD_WRITE_PORTL),
						&Rec, sizeof(Rec), NULL, 0,
						&nByte, NULL);
	} else {
		__asm {
           mov eax,pval
           mov dx,nPort
           out dx,eax
        }
    }
}

//-------------------------------------------------------------
DWORD 
__stdcall GetInterruptCounter()
{
	DWORD nByte = 0, Res = 0;

	if (HW32.fOpenDrive && HW32.fIsIRQSet) {
		if (fWin95) {
			if (  HW32.fpCounter != NULL)
				Res = *HW32.fpCounter;
		} else {
			DeviceIoControl(HW32.hDRV,
							CtlCode(_DRV_GET_INTERRUPT_COUNTER),
							NULL, 0, &Res, sizeof(Res),
							&nByte, NULL);
		}
	}
	return Res;
}

//-------------------------------------------------------------
void 
__stdcall SetIRQ(BYTE IRQNumber, void* Proc)
{
	if (!HW32.fIsIRQSet && HW32.fOpenDrive && Proc != NULL &&
												IRQNumber > 0) {
		HW32.fOnHWInterrupt = (void (__cdecl *)(void))Proc;
		HW32.fIRQNumber = IRQNumber;
		InitializeCriticalSection(&HW32.fHWCritSect_IRQ);
		HW32.fEventIRQSet = CreateEvent(NULL, TRUE, FALSE, NULL);
		ResetEvent(HW32.fEventIRQSet);
		HW32.fTerminated = false;
		if (fWin95)
			HW32.fThreadHandle = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)&IRQProc95, &HW32, 0, (LPDWORD)&HW32.fThreadId);
		else
			HW32.fThreadHandle = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)&IRQProcNT, &HW32, 0, (LPDWORD)&HW32.fThreadId);
		WaitForSingleObject(HW32.fEventIRQSet, INFINITE);
		CloseHandle(HW32.fEventIRQSet);
		HW32.fIsIRQSet = true;
	}
}

//-------------------------------------------------------------
void
__stdcall DestroyIRQ()
{
	DWORD nByte = 0;

	if (!HW32.fOpenDrive || !HW32.fIsIRQSet)
		return;

	if (!HW32.fMasked)
		MaskIRQ();

//	EnterCriticalSection(&HW32.fHWCritSect_IO);
	HW32.fTerminated = true;
	if(fWin95) {
		SetEvent(HW32.fLocEvent);
    } else {
		ReleaseSemaphore(HW32.fLocEvent, 1, NULL);
	}
	DeviceIoControl(HW32.hDRV,
					CtlCode(_DRV_STOP_INT_VEC),
					NULL, 0, NULL, 0,
					&nByte, NULL);
//	LeaveCriticalSection(&HW32.fHWCritSect_IO);
	HW32.fIsIRQSet = false;
	EnterCriticalSection(&HW32.fHWCritSect_IRQ);
	DeleteCriticalSection(&HW32.fHWCritSect_IRQ);
	CloseHandle(HW32.fLocEvent);
	HW32.fLocEvent = 0;
	
}

//-------------------------------------------------------------
void
__stdcall UnMaskIRQ()
{
	DWORD nByte  = 0;
    HANDLE CurrentProcess;

	if (!HW32.fOpenDrive || !HW32.fIsIRQSet || !HW32.fMasked)
		return;
	CurrentProcess = GetCurrentProcess();
	SetPriorityClass(CurrentProcess, REALTIME_PRIORITY_CLASS);
//	EnterCriticalSection(&HW32.fHWCritSect_IO);
	DeviceIoControl(HW32.hDRV,
					CtlCode(_DRV_UNMASK_INT_VEC),
					NULL, 0, NULL, 0,
					&nByte, NULL);
//	LeaveCriticalSection(&HW32.fHWCritSect_IO);
	HW32.fMasked = false;
}

//-------------------------------------------------------------
void
__stdcall SimulateHWInt()
{
	DWORD nByte = 0;
	if (!HW32.fOpenDrive || !HW32.fIsIRQSet)
		return;

//	EnterCriticalSection(&HW32.fHWCritSect_IO);
	DeviceIoControl(HW32.hDRV,
					CtlCode(_DRV_PULSE_EVENT),
					NULL, 0, NULL, 0,
					&nByte, NULL);
//	LeaveCriticalSection(&HW32.fHWCritSect_IO);
}

//-------------------------------------------------------------
void
__stdcall CloseTVicHW32()
{
	if (HW32.fOpenDrive) {
		if (!HW32.fMasked)
			MaskIRQ();
		if (HW32.fIsIRQSet)
			DestroyIRQ();
		if (HW32.fMemoryMapped)
			UnmapMemory();
		SetHardAccess(true);
		HW32.fOpenDrive = false;
//		DeleteCriticalSection(&HW32.fHWCritSect_IO);
		Close_Stop_Unload_Driver(HW32.hDRV);
	}
}

//-------------------------------------------------------------
bool
__stdcall TestHardAccess()
{
	return HW32.fHardAccess;
}

//-------------------------------------------------------------
bool
__stdcall IsIRQSet()
{
	return HW32.fIsIRQSet;
}

//-------------------------------------------------------------
bool
__stdcall IsDriverOpened()
{
	return HW32.fOpenDrive;
}

//-------------------------------------------------------------
bool 
__stdcall IsMasked()
{
	return HW32.fMasked;
}

//-------------------------------------------------------------
void
__stdcall SetHardAccess(bool Hard)
{
	DWORD nByte = 0;
	if (!HW32.fOpenDrive )
		return;

  if (!fWin95) {
  
    if (Hard)

			DeviceIoControl(HW32.hDRV,
					CtlCode(_DRV_HARD_ACCESS),
					NULL, 0, NULL, 0,
					&nByte, NULL);
	else

        	DeviceIoControl(HW32.hDRV,
					CtlCode(_DRV_SOFT_ACCESS),
					NULL, 0, NULL, 0,
					&nByte, NULL);
  } 

  HW32.fHardAccess = Hard;

}

//-------------------------------------------------------------
BOOL 
APIENTRY DllMain(HANDLE hModule, 
                 DWORD  ul_reason_for_call, 
                 LPVOID lpReserved)
{
    switch( ul_reason_for_call ) {
		case DLL_PROCESS_ATTACH:
		//case DLL_THREAD_ATTACH:
			memset(&HW32, 0, sizeof(HW32));
			HW32.fMasked = true;
			break;
	}
	return TRUE;
}

//-------------------------------------------------------------
