{========================================================================}
{=================  TVicHw32  component definition  =====================}
{==========            Shareware Version 1.21       =====================}
{==========     Copyright (c) 1997 Victor I.Ishikeev              =======}
{========================================================================}
{==========         mail to "victor@ivi.ugatu.ac.ru"              =======}
{========================================================================}

{$R-} {$S-} {$D-} {$Q-}

unit HW_32;

interface

uses SysUtils,Classes,Windows;

//{$DEFINE DEMOVERSION}

//{$DEFINE NT_ADMIN} // uncomment this line if you do login to NT
                     // as "Administrator"

                     // else:
                     // - comment this line,
                     // - run "regini.exe tvichw32.ini"
                     // - reboot your PC


const
      _DRV_MAP_MEMORY             = 2;
      _DRV_UNMAP_MEMORY           = 3;
      _DRV_GET_INTERRUPT_COUNTER  = 4;
      _DRV_SET_POST_EVENT         = 5;
      _DRV_SET_INT_VEC            = 6;
      _DRV_MASK_INT_VEC           = 7;
      _DRV_UNMASK_INT_VEC         = 8;
      _DRV_STOP_INT_VEC           = 9;

      _DRV_PORT_CONTROL           =10;

      _DRV_HARD_READ_PORT         =11;
      _DRV_HARD_WRITE_PORT        =12;
      _DRV_HARD_READ_PORTW        =13;
      _DRV_HARD_WRITE_PORTW       =14;
      _DRV_HARD_READ_PORTL        =15;
      _DRV_HARD_WRITE_PORTL       =16;
      _DRV_PULSE_EVENT            =17;

      _DRV_READ_FIFO              =18;
      _DRV_WRITE_FIFO             =19;

      _DRV_READ_FIFO_WORD         =20;
      _DRV_WRITE_FIFO_WORD        =21;

      _DRV_PORTW_CONTROL          =22;

      _DRV_SOFT_ACCESS            =31;
      _DRV_HARD_ACCESS            =32;


type PortRec = array[1..65535] of record
                                    PortAddr : Word;
                                    PortData : Byte;
                                    fWrite   : Boolean;
                                  end;
     pPortRec   =^PortRec;

type PortWRec = array[1..65535] of record
                                    PortAddr : Word;
                                    PortData : Word;
                                    fWrite   : Boolean;
                                  end;
     pPortWRec   =^PortWRec;

type

  TVicHw32 = class(TComponent)

  private

    fWin95          : Boolean;
    fTerminated     : Boolean;

    fMemoryMapped   : Boolean;

    fInterface      : dWord;        // Isa, Eisa, etc....
    fBus            : dWord;        // Bus number
    fPhysLoPart     : dWord;        // Bus-relative address
    fPhysHiPart     : dWord;        // Zero
    fTypeMem        : dWord;        // 0 is memory, 1 is I/O
    fMemorySize     : dWord;        // Length of section to map

    fMemoryPointer  : Pointer;

    fLocEvent       : THandle;
    fpCounter       :^Longint;
    fHardAccess     : Boolean;

    fIsIRQSet       : Boolean;
    fMasked         : Boolean;
    fOpenDrive      : Boolean;
    hDRV            : THandle;
    fOnHwInterrupt  : TNotifyEvent;
    fIRQNumber      : dWord;
    fThreadId       : THandle;
    fThreadHandle   : THandle;
    fHWCritSect_IO  : TRTLCriticalSection;
    fHWCritSect_IRQ : TRTLCriticalSection;
    fEventIRQSet    : THandle;
    function    GetInterruptCounter:dWord;
    function    CtlCode(Code:Word):dWord;
    procedure   SetActiveDriver(flag:Boolean);
    function    ReadPort  (nPort:Word):Byte;
    procedure   WritePort (nPort:Word; pval:Byte);
    function    ReadPortW (nPort:Word):Word;
    procedure   WritePortW(nPort:Word; pval:Word);
    function    ReadPortL (nPort:Word):dWord;
    procedure   WritePortL(nPort:Word; pval:dWord);
    procedure   SetHardAccess(Parm : Boolean);
    procedure   UnmapMemory;

protected

    fHandled  : LongInt;

  public

    constructor Create(Owner:TComponent); override;
    destructor  Destroy; override;
    procedure   OpenDriver;
    procedure   CloseDriver;

    procedure   SetIRQ;
    procedure   DestroyIRQ;
    procedure   MaskInterrupt;
    procedure   UnmaskInterrupt;

    function    MapPhysToLinear(PhAddr:dWord; Size:dWord):Pointer;

    procedure   PortControl  ( Ports:pPortRec; NumPorts:Word);
    procedure   PortWControl ( Ports:pPortWRec; NumPorts:Word);

    procedure   ReadPortFIFO ( PortAddr:Word; NumPorts:Word; var Buffer);
    procedure   WritePortFIFO( PortAddr:Word; NumPorts:Word; var Buffer);
    procedure   ReadPortWFIFO ( PortAddr:Word; NumPorts:Word; var Buffer);
    procedure   WritePortWFIFO( PortAddr:Word; NumPorts:Word; var Buffer);

    property    Port[Index:Word]  : Byte  read ReadPort  write WritePort;
    property    PortW[Index:Word] : Word  read ReadPortW write WritePortW;
    property    PortL[Index:Word] : dWord read ReadPortL write WritePortL;

    property    IsIRQSet   : Boolean read fIsIRQSet;
    property    Masked     : Boolean read fMasked;
    property    IRQCounter : dWord read GetInterruptCounter;

    procedure SimulateHwInt;


  published

    property ActiveHW : Boolean read fOpenDrive write SetActiveDriver;
    property OnHwInterrupt :TNotifyEvent read fOnHwInterrupt write fOnHwInterrupt;
    property IRQNumber : dWord read fIRQNumber write fIRQNumber;
    property HardAccess : Boolean read fHardAccess write SetHardAccess default TRUE;

  end;

procedure Register;

implementation


type TOpenVxdHandle = function (Ev:THandle):THandle;stdcall;
var  OpenVxDHandle  : TOpenVxDHandle;

const  DriverName =  {$IFDEF DEMOVERSION} 'VICHW00';
                     {$ELSE}              'VICHW11';
                     {$ENDIF}

type   SC_HANDLE    = THANDLE;

var    schSCManager : SC_HANDLE;


const  SC_MANAGER_CONNECT            = $0001;
const  SC_MANAGER_CREATE_SERVICE     = $0002;
const  SC_MANAGER_ENUMERATE_SERVICE  = $0004;
const  SC_MANAGER_LOCK               = $0008;
const  SC_MANAGER_QUERY_LOCK_STATUS  = $0010;
const  SC_MANAGER_MODIFY_BOOT_CONFIG = $0020;

const  SC_MANAGER_ALL_ACCESS         =(STANDARD_RIGHTS_REQUIRED      OR
                                       SC_MANAGER_CONNECT            OR
                                       SC_MANAGER_CREATE_SERVICE     OR
                                       SC_MANAGER_ENUMERATE_SERVICE  OR
                                       SC_MANAGER_LOCK               OR
                                       SC_MANAGER_QUERY_LOCK_STATUS  OR
                                       SC_MANAGER_MODIFY_BOOT_CONFIG);
const  SERVICE_QUERY_CONFIG          = $0001;
const  SERVICE_CHANGE_CONFIG         = $0002;
const  SERVICE_QUERY_STATUS          = $0004;
const  SERVICE_ENUMERATE_DEPENDENTS  = $0008;
const  SERVICE_START                 = $0010;
const  SERVICE_STOP                  = $0020;
const  SERVICE_PAUSE_CONTINUE        = $0040;
const  SERVICE_INTERROGATE           = $0080;
const  SERVICE_USER_DEFINED_CONTROL  = $0100;

const  SERVICE_ALL_ACCESS            =(STANDARD_RIGHTS_REQUIRED     OR
                                       SERVICE_QUERY_CONFIG         OR
                                       SERVICE_CHANGE_CONFIG        OR
                                       SERVICE_QUERY_STATUS         OR
                                       SERVICE_ENUMERATE_DEPENDENTS OR
                                       SERVICE_START                OR
                                       SERVICE_STOP                 OR
                                       SERVICE_PAUSE_CONTINUE       OR
                                       SERVICE_INTERROGATE          OR
                                       SERVICE_USER_DEFINED_CONTROL);

const  SERVICE_KERNEL_DRIVER         = $0000001;
const  SERVICE_FILE_SYSTEM_DRIVER    = $0000002;
const  SERVICE_ADAPTER               = $0000004;
const  SERVICE_RECOGNIZER_DRIVER     = $0000008;

const  SERVICE_DRIVER                =(SERVICE_KERNEL_DRIVER OR
                                       SERVICE_FILE_SYSTEM_DRIVER OR
                                       SERVICE_RECOGNIZER_DRIVER);

const  SERVICE_BOOT_START            = $0000000;
const  SERVICE_SYSTEM_START          = $0000001;
const  SERVICE_AUTO_START            = $0000002;
const  SERVICE_DEMAND_START          = $0000003;
const  SERVICE_DISABLED              = $0000004;
const  SERVICE_ERROR_IGNORE          = $0000000;
const  SERVICE_ERROR_NORMAL          = $0000001;
const  SERVICE_ERROR_SEVERE          = $0000002;
const  SERVICE_ERROR_CRITICAL        = $0000003;

const  SERVICE_CONTROL_STOP          = $0000001;
const  SERVICE_CONTROL_PAUSE         = $0000002;
const  SERVICE_CONTROL_CONTINUE      = $0000003;
const  SERVICE_CONTROL_INTERROGATE   = $0000004;
const  SERVICE_CONTROL_SHUTDOWN      = $0000005;


type   SERVICE_STATUS = record
         dwServiceType              : DWORD;
         dwCurrentState             : DWORD;
         dwControlsAccepted         : DWORD;
         dwWin32ExitCode            : DWORD;
         dwServiceSpecificExitCode  : DWORD;
         dwCheckPoint               : DWORD;
         dwWaitHint                 : DWORD;
       end;

function OpenScManager(N1,N2:dWord;A:dWord):SC_HANDLE; stdcall;
external 'advapi32.dll' name 'OpenSCManagerA';
function CloseServiceHandle(ScHandle:THandle)        :BOOL;          stdcall;
external 'advapi32.dll' name 'CloseServiceHandle';

function CreateService ( hSCManager         : SC_HANDLE;
                         lpServiceName      : LPCSTR   ;
                         lpDisplayName      : LPCSTR   ;
                         dwDesiredAccess    : DWORD    ;
                         dwServiceType      : DWORD    ;
                         dwStartType        : DWORD    ;
                         dwErrorControl     : DWORD    ;
                         lpBinaryPathName   : LPCSTR   ;
                         lpLoadOrderGroup   : LPCSTR   ;
                         lpdwTagId          : LPDWORD  ;
                         lpDependencies     : LPCSTR   ;
                         lpServiceStartName : LPCSTR   ;
                         lpPassword         : LPCSTR ): SC_HANDLE;   stdcall;

external 'advapi32.dll' name 'CreateServiceA';

function OpenService(    hSCManager         : SC_HANDLE;
                         lpServiceName      : LPCSTR;
                         dwDesiredAccess    : DWORD)  : SC_HANDLE;   stdcall;

external 'advapi32.dll' name 'OpenServiceA';

function StartService(   hService           : SC_HANDLE;
                         dwNumServiceArgs   : DWORD;
                         lpServiceArgVectors: LPCSTR) : BOOL;        stdcall;
external 'advapi32.dll' name 'StartServiceA';

function ControlService( hService           : SC_HANDLE;
                         dwControl          : DWORD;
                         lpServiceStatus    : Pointer)   : BOOL;     stdcall;
external 'advapi32.dll' name 'ControlService';

function DeleteService ( hService           : SC_HANDLE) : BOOL;     stdcall;
external 'advapi32.dll' name 'DeleteService';

function InstallDriver : BOOL;
var
  schService : SC_HANDLE;
  ServiceExe : array[0..255] of Char;
begin

  GetWindowsDirectory(ServiceExe,128);
  
  {$IFDEF DEMOVERSION}
     StrCat(ServiceExe,'\SYSTEM32\DRIVERS\VICHW00.SYS');
  {$ELSE}
     StrCat(ServiceExe,'\SYSTEM32\DRIVERS\VICHW11.SYS');
  {$ENDIF}

  schService := CreateService(SchSCManager,          // SCManager database
                              DriverName,            // name of service
                              DriverName,            // name to display
                              SERVICE_ALL_ACCESS,    // desired access
                              SERVICE_KERNEL_DRIVER, // service type
                              SERVICE_DEMAND_START,  // start type
                              SERVICE_ERROR_NORMAL,  // error control type
                              ServiceExe,            // service's binary
                              NIL,                   // no load ordering group
                              NIL,                   // no tag identifier
                              NIL,                   // no dependencies
                              NIL,                   // LocalSystem account
                              NIL);                  // no password)

    Result:=(schService <> 0) or (GetLastError=ERROR_SERVICE_EXISTS);
    CloseServiceHandle (schService);
end;

function StartDriver:BOOL;
var
  schService : SC_HANDLE;
  ret        : BOOL;
begin
  Result:=FALSE;
  schService := OpenService (SchSCManager,DriverName,SERVICE_ALL_ACCESS);
  if (schService = 0) then  Exit;
  ret := StartService (schService,0,NIL);
  Result:=ret or (GetLastError=ERROR_SERVICE_ALREADY_RUNNING);
  CloseServiceHandle (schService);
end;



function StopDriver : Boolean;
var
  schService       : SC_HANDLE;
  serviceStatus    : SERVICE_STATUS;
begin
  Result:=FALSE;
  schService := OpenService (SchSCManager,DriverName,SERVICE_ALL_ACCESS);
  if (schService = NULL) then Exit;
  Result:=ControlService (schService,SERVICE_CONTROL_STOP,@serviceStatus);
  CloseServiceHandle (schService);
end;

function RemoveDriver : Boolean;
var
  schService  : SC_HANDLE ;
begin
  Result:=FALSE;
  schService := OpenService (SchSCManager,DriverName,SERVICE_ALL_ACCESS);
  if (schService = 0) then Exit;
  Result := DeleteService (schService);
  CloseServiceHandle (schService);
end;

function Install_Start_Load_Driver:THandle;
begin

  if (GetVersion() and $80000000)<>0 then
  begin
    {$IFDEF DEMOVERSION}
    Result:=CreateFile('\\.\VICHW00.VXD',0,0,NIL,0,FILE_FLAG_DELETE_ON_CLOSE,0);
    {$ELSE}
    Result:=CreateFile('\\.\VICHW11.VXD',0,0,NIL,0,FILE_FLAG_DELETE_ON_CLOSE,0);
    {$ENDIF}
    Exit;
  end;

  {$IFDEF NT_ADMIN}
   Result:=INVALID_HANDLE_VALUE;
   schSCManager := OpenSCManager(0,0,SC_MANAGER_ALL_ACCESS);
   if schSCManager<>0 then
   begin
     if InstallDriver then
     begin
       if StartDriver then
       begin
         {$IFDEF DEMOVERSION}
         Result:=CreateFile('\\.\VICHW00',GENERIC_READ OR GENERIC_WRITE,0,NIL,
                                         OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
         {$ELSE}
         Result:=CreateFile('\\.\VICHW11',GENERIC_READ OR GENERIC_WRITE,0,NIL,
                                         OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
         {$ENDIF}
       end;
     end;
     CloseServiceHandle (schSCManager);
   end;
   {$ELSE}
     {$IFDEF DEMOVERSION}
       Result:=CreateFile('\\.\VICHW00',GENERIC_READ OR GENERIC_WRITE,0,NIL,
                                        OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
     {$ELSE}
       Result:=CreateFile('\\.\VICHW11',GENERIC_READ OR GENERIC_WRITE,0,NIL,
                                         OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
     {$ENDIF}
   {$ENDIF}     
end;


procedure Close_Stop_Unload_Driver(hDrv:tHandle);
begin
  CloseHandle(hDrv); 
  if (GetVersion() and $80000000)<>0 then Exit;
  {$IFDEF NT_ADMIN}
  schSCManager := OpenSCManager(0,0,SC_MANAGER_ALL_ACCESS);
  if  schSCManager<>0 then
  begin
    StopDriver;
    RemoveDriver;
    CloseServiceHandle (schSCManager);
  end;
  {$ENDIF}
end;



function TVicHw32.CtlCode(Code:word):dWord;
begin
  if fWin95 then Result:=Code
            else Result:=$80000000 or (($800+Code) shl 2);
end;

procedure IRQProcNT(HWControl: TVicHw32); stdcall;
var  nByte      : dWord;
     CurrentProcess : tHandle;
begin
  nByte:=0;
  with HWControl do
  begin
    CurrentProcess:=GetCurrentProcess();
    SetPriorityClass(CurrentProcess,REALTIME_PRIORITY_CLASS);
    SetThreadPriority(fThreadHandle,THREAD_PRIORITY_TIME_CRITICAL);
    EnterCriticalSection(fHWCritSect_IRQ);
    fLocEvent:=CreateSemaphore(NIL,0,1000,NIL);
    fMasked:=TRUE;
    DeviceIoControl(hDRV,
                    CtlCode(_DRV_SET_POST_EVENT),
                    @fLocEvent,4,NIL,0,
                           nByte,pOverlapped(NIL));
    DeviceIoControl(hDRV,
                    CtlCode(_DRV_SET_INT_VEC),
                    @fIRQNumber,4,NIL,0,
                    nByte,pOverlapped(NIL));
    fIsIRQSet:=TRUE;
    SetEvent(fEventIRQSet);
    while TRUE  do
    begin
      WaitForSingleObject(fLocEvent,INFINITE);
      if (not fTerminated) then
      begin
        if Assigned(fOnHwInterrupt) then  OnHwInterrupt(HWControl);
      end else Break;
    end;
    CurrentProcess:=GetCurrentProcess();
    SetPriorityClass(CurrentProcess,NORMAL_PRIORITY_CLASS);
    LeaveCriticalSection(fHWCritSect_IRQ);
  end;
end;


procedure IRQProc95(HWControl: TVicHw32); stdcall;
var  nByte      : dWord;
     CurrentProcess : tHandle;
     Count          : dWord;
     hDRVEvent      : tHandle;
begin
  with HWControl do
  begin
    CurrentProcess:=GetCurrentProcess();
    SetPriorityClass(CurrentProcess,REALTIME_PRIORITY_CLASS);
    SetThreadPriority(fThreadHandle,THREAD_PRIORITY_TIME_CRITICAL);
    EnterCriticalSection(fHWCritSect_IRQ);
    fLocEvent:=CreateEvent(NIL,TRUE,FALSE,NIL);
    ResetEvent(fLocEvent);
    fMasked:=TRUE; fHandled:=0;
    hDRVEvent:=OpenVxDHandle(fLocEvent);
    DeviceIoControl(hDRV,
                    CtlCode(_DRV_SET_POST_EVENT),
                    @hDRVEvent,4,@fpCounter,0,
                    nByte,pOverlapped(NIL));
    DeviceIoControl(hDRV,
                    CtlCode(_DRV_SET_INT_VEC),
                    @fIRQNumber,4,NIL,0,
                    nByte,pOverlapped(NIL));
    fIsIRQSet:=TRUE;
    SetEvent(fEventIRQSet);
    while TRUE  do
    begin
      WaitForSingleObject(fLocEvent,INFINITE);
      ResetEvent(fLocEvent);
      if (not fTerminated) then
      begin
        Count:=fpCounter^;
        if Assigned(fOnHwInterrupt) then
          while (fHandled<Count) do
          begin
            OnHwInterrupt(HWControl);
            Inc(fHandled);
          end;
      end else Break;
    end;
    CurrentProcess:=GetCurrentProcess();
    SetPriorityClass(CurrentProcess,NORMAL_PRIORITY_CLASS);
    LeaveCriticalSection(fHWCritSect_IRQ);
  end;
end;

procedure TVicHw32.UnmapMemory;
var nByte : dWord;
begin
  if fMemoryMapped then
    DeviceIoControl (hDRV,
                     CtlCode(_DRV_UNMAP_MEMORY),
                     @fMemoryPointer,4,NIL,0,
                     nByte,pOverlapped(NIL));
  fMemorySize    := 0;        
  fMemoryPointer := NIL;
  fPhysLoPart    := 0;
  fMemoryMapped  := FALSE;
end;

function  TVicHw32.MapPhysToLinear(PhAddr:dWord; Size:dWord):Pointer;
var nByte : DWord;
begin
  Result:=fMemoryPointer;
  if (not ActiveHW) or ((PhAddr=fPhysLoPart) and (Size=fMemorySize)) then Exit;
  nByte:=0;
  EnterCriticalSection(fHWCritSect_IO);
  if fMemoryMapped then UnmapMemory;
  fMemorySize:=Size;
  fPhysLoPart:=PhAddr;
  DeviceIoControl (hDRV,
                   CtlCode(_DRV_MAP_MEMORY),
                   @fInterface,24,@fMemoryPointer,4,
                   nByte,pOverlapped(NIL));
  fMemoryMapped:=TRUE;
  Result:=fMemoryPointer;
  LeaveCriticalSection(fHWCritSect_IO);
end;

procedure   TVicHw32.SetActiveDriver(flag:Boolean);
begin
  if flag then OpenDriver else CloseDriver;
end;

constructor TVicHw32.Create(Owner:TComponent); {==}
begin

  inherited Create(Owner);
  
  fWin95:= (GetVersion() and $80000000)<>0;

  fOpenDrive    := FALSE;
  ActiveHW      := FALSE;
  fMasked       := TRUE;
  fMemoryMapped := FALSE;
  fHardAccess   := TRUE;

  fInterface    := 1;        // Isa, Eisa, etc....
  fBus          := 0;        // Bus number
  fPhysLoPart   := 0;        // Bus-relative address
  fPhysHiPart   := 0;
  fTypeMem      := 0;        // 0 is memory, 1 is I/O
  fMemorySize   := 0;        // Length of section to map

  hDRV:=INVALID_HANDLE_VALUE;
  InitializeCriticalSection(fHWCritSect_IO);
end;

destructor TVicHw32.Destroy;                   {==}
begin
  CloseDriver;
  DeleteCriticalSection(fHWCritSect_IO);
  inherited Destroy;
end;

procedure TVicHw32.OpenDriver;
begin
  if ActiveHW then Exit;
  fHardAccess:=TRUE;
  hDRV:=Install_Start_Load_Driver;
  fOpenDrive:=hDRV<>INVALID_HANDLE_VALUE;
  if not fOpenDrive then
  begin
    Close_Stop_Unload_Driver(hDRV);
    hDRV:=Install_Start_Load_Driver;
    fOpenDrive:=hDRV<>INVALID_HANDLE_VALUE;
  end;
end;

procedure TVicHw32.CloseDriver;
begin
  if ActiveHW then
  begin
    if not fMasked then MaskInterrupt;
    if fIsIRQSet then DestroyIRQ;
    if fMemoryMapped then UnmapMemory;
    SetHardAccess(TRUE);
    Close_Stop_Unload_Driver(hDRV);
  end;
  fOpenDrive:=FALSE;
end;

function  TVicHw32.ReadPort(nPort:Word):Byte;
var nByte,PortNumber,DataPort : dWord;
begin
  if not ActiveHW then begin Result:=$ff; Exit; end;
  PortNumber:=nPort;
  if HardAccess then
  begin
      DeviceIoControl(hDRV,
                      CtlCode(_DRV_HARD_READ_PORT),
                      @PortNumber,4,@DataPort,4,
                      nByte,pOverlapped(NIL))
  end                    
  else begin
         asm
           mov dx,word ptr PortNumber
           in  al,dx
           mov byte ptr DataPort,al
         end;
       end;
  Result:=Lo(LoWord(DataPort));
end;

function  TVicHw32.ReadPortW(nPort:Word):Word;
var nByte,PortNumber,DataPort : dWord;
begin
  if not ActiveHW then begin Result:=$ff; Exit; end;
  PortNumber:=nPort;
  if HardAccess then
  begin
    DeviceIoControl(hDRV,
                    CtlCode(_DRV_HARD_READ_PORTW),
                    @PortNumber,4,@DataPort,4,
                    nByte,pOverlapped(NIL));
  end
  else begin
         asm
            mov dx,word ptr PortNumber
            in  ax,dx
            mov word ptr DataPort,ax
         end;
       end;
  Result:=LoWord(DataPort);
end;

function  TVicHw32.ReadPortL(nPort:Word):dWord;
var nByte,PortNumber,DataPort : dWord;
begin
  if not ActiveHW then begin Result:=$ff; Exit; end;
  PortNumber:=nPort; DataPort:=0;
  if HardAccess then
  begin
    DeviceIoControl(hDRV,
                    CtlCode(_DRV_HARD_READ_PORTL),
                    @PortNumber,4,@DataPort,4,
                    nByte,pOverlapped(NIL));
  end
  else begin
         asm
            mov dx,word ptr PortNumber
            in  eax,dx
            mov DataPort,eax
         end;
       end;
  Result:=DataPort;
end;

procedure   TVicHw32.WritePort(nPort:Word; pval:Byte);
var nByte : dWord;
    Rec   : record
     PortNumber:dWord;
     DataPort  :dWord;
    end;
begin
  if not ActiveHW then Exit;
  if HardAccess then
  begin
    Rec.PortNumber:=nPort; Rec.DataPort:=pval;
    DeviceIoControl(hDRV,
                    CtlCode(_DRV_HARD_WRITE_PORT),
                    @Rec,8,NIL,0,
                    nByte,pOverlapped(NIL));
  end
  else begin
         asm
           mov al,pval
           mov dx,nPort
           out dx,al
         end;
       end;
end;

procedure   TVicHw32.WritePortW(nPort:Word; pval:word);
var nByte : dWord;
    Rec   : record
     PortNumber:dWord;
     DataPort  :dWord;
    end;
begin
  if not ActiveHW then Exit;
  if HardAccess then
  begin
    Rec.PortNumber:=nPort; Rec.DataPort:=pval;
    DeviceIoControl(hDRV,
                    CtlCode(_DRV_HARD_WRITE_PORTW),
                    @Rec,8,NIL,0,
                    nByte,pOverlapped(NIL));
  end
  else begin
         asm
           mov ax,pval
           mov dx,nPort
           out dx,ax
         end;
       end;
end;

procedure   TVicHw32.WritePortL(nPort:Word; pval:dWord);
var nByte : dWord;
    Rec   : record
     PortNumber:dWord;
     DataPort  :dWord;
    end;
begin
  if not ActiveHW then Exit;
  if HardAccess then
  begin
    Rec.PortNumber:=nPort; Rec.DataPort:=pval;
    DeviceIoControl(hDRV,
                    CtlCode(_DRV_HARD_WRITE_PORTL),
                    @Rec,6,NIL,0,
                    nByte,pOverlapped(NIL));
  end
  else begin
         asm
           mov eax,pval
           mov dx,nPort
           out dx,eax
         end;
       end;
end;

procedure   TVicHW32.PortControl(Ports:pPortRec; NumPorts:Word);
var nByte : DWord;
    size     : dWord;
begin
  if not ActiveHW then Exit;
  Size:=4*NumPorts;
  DeviceIoControl(hDRV,
                  CtlCode(_DRV_PORT_CONTROL),
                  Ports,size,
                  Ports,size,
                  nByte,pOverlapped(NIL));
end;

procedure   TVicHW32.PortWControl(Ports:pPortWRec; NumPorts:Word);
var nByte : DWord;
    size     : dWord;
begin
  if not ActiveHW then Exit;
  Size:=5*NumPorts;
  DeviceIoControl(hDRV,
                  CtlCode(_DRV_PORTW_CONTROL),
                  Ports,size,
                  Ports,size,
                  nByte,pOverlapped(NIL));
end;

procedure   TVicHW32.ReadPortFIFO ( PortAddr:Word; NumPorts:Word; var Buffer);
type TPortRec = record
       nport : Word;
       size  : Word;
       Buf   : array[1..2] of Byte;
     end;
var nByte    : dWord;
    PortRec  :^TPortRec;
begin
  if not ActiveHW then Exit;

  if fHardAccess then
  begin

    GetMem(PortRec,4+NumPorts);
    PortRec^.nport:=PortAddr;
    PortRec^.size:=NumPorts;

    DeviceIOControl(hDRV,
                    CtlCode(_DRV_READ_FIFO),
                    PortRec,NumPorts+4,
                    PortRec,NumPorts+4,
                    nByte,pOverlapped(NIL));
    Move(PortRec^.Buf,Buffer,NumPorts);
    FreeMem(PortRec);
  end
  else
  begin
    nByte:=DWORD(@Buffer);
    asm
      cld
      mov dx,PortAddr
      xor ecx,ecx
      mov cx,NumPorts
      mov edi,nByte
      rep insb
    end;
  end;  
end;

procedure   TVicHW32.WritePortFIFO( PortAddr:Word; NumPorts:Word; var Buffer);
type TPortRec = record
       nport : Word;
       size  : Word;
       Buf   : array[1..2] of Byte;
     end;
var nByte    : dWord;
    PortRec  :^TPortRec;
begin
  if not ActiveHW then Exit;
  if fHardAccess then
  begin
    GetMem(PortRec,4+NumPorts);
    PortRec^.nport:=PortAddr;
    PortRec^.size:=NumPorts;
    Move(Buffer,PortRec^.Buf,NumPorts);
    DeviceIOControl(hDRV,
                    CtlCode(_DRV_WRITE_FIFO),
                    PortRec,NumPorts+4,
                    PortRec,NumPorts+4,
                    nByte,pOverlapped(NIL));
    FreeMem(PortRec);
  end
  else
  begin
    nByte:=DWORD(@Buffer);
    asm
      cld
      mov dx,PortAddr
      xor ecx,ecx
      mov cx,NumPorts
      mov esi,nByte
      rep outsb
    end;
  end;

end;
procedure   TVicHW32.ReadPortWFIFO ( PortAddr:Word; NumPorts:Word; var Buffer);
type TPortRec = record
       nport : Word;
       size  : Word;
       Buf   : array[1..2] of Word;
     end;
var nByte    : dWord;
    PortRec  :^TPortRec;
begin
  if not ActiveHW then Exit;
 if fHardAccess then
  begin

    GetMem(PortRec,4+2*NumPorts);
    PortRec^.nport:=PortAddr;
    PortRec^.size:=NumPorts;
    DeviceIOControl(hDRV,
                    CtlCode(_DRV_READ_FIFO_WORD),
                    PortRec,2*NumPorts+4,
                    PortRec,2*NumPorts+4,
                    nByte,pOverlapped(NIL));
    Move(PortRec^.Buf,Buffer,2*NumPorts);
    FreeMem(PortRec);
  end
  else
  begin

    nByte:=DWORD(@Buffer);
    asm
      cld
      mov dx,PortAddr
      xor ecx,ecx
      mov cx,NumPorts
      mov edi,nByte
      rep insw
    end;
  end;

end;

procedure   TVicHW32.WritePortWFIFO( PortAddr:Word; NumPorts:Word; var Buffer);
type TPortRec = record
       nport : Word;
       size  : Word;
       Buf   : array[1..2] of Word;
     end;
var nByte    : dWord;
    PortRec  :^TPortRec;
begin
  if not ActiveHW then Exit;
  if fHardAccess then
  begin
    GetMem(PortRec,4+2*NumPorts);
    PortRec^.nport:=PortAddr;
    PortRec^.size:=NumPorts;
    Move(Buffer,PortRec^.Buf,2*NumPorts);
    DeviceIOControl(hDRV,
                    CtlCode(_DRV_WRITE_FIFO_WORD),
                    PortRec,2*NumPorts+4,
                    PortRec,2*NumPorts+4,
                    nByte,pOverlapped(NIL));
    FreeMem(PortRec);
  end
  else
  begin
    nByte:=DWORD(@Buffer);
    asm
      cld
      mov dx,PortAddr
      xor ecx,ecx
      mov cx,NumPorts
      mov esi,nByte
      rep outsw
    end;
  end;

end;


function   TVicHw32.GetInterruptCounter:dWord;
var nByte,Res : DWord;
begin
  Res:=0;
  if IsIRQSet then
  begin
    if fWin95 then
    begin
      if (fpCounter<>NIL) then Res:=fpCounter^
    end
    else
      DeviceIoControl(hDRV,
                      CtlCode(_DRV_GET_INTERRUPT_COUNTER),
                      NIL,0,@Res,4,
                      nByte,pOverlapped(NIL));
  end;
  Result:=Res;
end;

procedure TVicHw32.SetIRQ;
begin
  if (not fIsIRQSet) and ActiveHW and Assigned(fOnHwInterrupt)
      and (IRQNumber>0) then
  begin
    InitializeCriticalSection(fHWCritSect_IRQ);
    fEventIRQSet:=CreateEvent(NIL,TRUE,FALSE,NIL);
    ResetEvent(fEventIRQSet);
    fTerminated:=FALSE;
    if fWin95 then
       fThreadHandle:=CreateThread(NIL,0,@IRQProc95,Self,0,fThreadID)
    else
       fThreadHandle:=CreateThread(NIL,0,@IRQProcNT,Self,0,fThreadID);
    WaitForSingleObject(fEventIRQSet,INFINITE);
    CloseHandle(fEventIRQSet);
    fIsIRQSet:=TRUE;
  end;
end;


procedure TVicHw32.DestroyIRQ;
var nByte : DWord;
begin
  nByte:=0;
  if (not ActiveHW) or (not fIsIRQSet) then Exit;
  if not fMasked then MaskInterrupt;
  EnterCriticalSection(fHWCritSect_IO);
  fTerminated:=TRUE;
  if fWin95 then SetEvent(fLocEvent)
            else ReleaseSemaphore(fLocEvent,1,NIL);
  DeviceIoControl(hDRV,
                  CtlCode(_DRV_STOP_INT_VEC),
                  NIL,0,NIL,0,
                  nByte,pOverlapped(NIL));
  LeaveCriticalSection(fHWCritSect_IO);
  fIsIRQSet:=FALSE;
  EnterCriticalSection(fHWCritSect_IRQ);
  DeleteCriticalSection(fHWCritSect_IRQ);
  CloseHandle(fLocEvent); fLocEvent:=0;
end;

procedure TVicHw32.MaskInterrupt;
var nByte : DWord;
begin
  nByte:=0;
  if (not ActiveHW) or (not fIsIRQSet) or fMasked then Exit;
  fMasked:=TRUE;
  EnterCriticalSection(fHWCritSect_IO);
  DeviceIoControl(hDRV,
                  CtlCode(_DRV_MASK_INT_VEC),
                  NIL,0,NIL,0,
                  nByte,POverlapped(NIL));
  LeaveCriticalSection(fHWCritSect_IO);
end;

procedure TVicHw32.UnMaskInterrupt;
var nByte : DWord;
    CurrentProcess : tHandle;
begin
  nByte:=0;
  if (not ActiveHW) or (not fIsIRQSet) or (not fMasked) then Exit;
  CurrentProcess:=GetCurrentProcess();
  SetPriorityClass(CurrentProcess,REALTIME_PRIORITY_CLASS);
  EnterCriticalSection(fHWCritSect_IO);
  DeviceIoControl(hDRV,
                  CtlCode(_DRV_UNMASK_INT_VEC),
                  NIL,0,NIL,0,
                  nByte,pOverlapped(NIL));
  LeaveCriticalSection(fHWCritSect_IO);
  fMasked:=FALSE;
end;

procedure TVicHw32.SimulateHwInt;
var nByte : DWord;
begin
  nByte:=0;
  if (not ActiveHW)  or (not IsIRQSet) then Exit;
  EnterCriticalSection(fHWCritSect_IO);
  DeviceIoControl(hDRV,
                  CtlCode(_DRV_PULSE_EVENT),
                  NIL,0,NIL,0,
                  nByte,pOverlapped(NIL));
  LeaveCriticalSection(fHWCritSect_IO);
end;

procedure   TVicHW32.SetHardAccess(Parm : Boolean);
var code,nByte : dWord;
begin
  if not fWin95 then
  begin
    if Parm then code:=CtlCode(_DRV_HARD_ACCESS)
            else code:=CtlCode(_DRV_SOFT_ACCESS);
    DeviceIoControl(hDRV,
                  Code,
                  NIL,0,NIL,0,
                  nByte,pOverlapped(NIL));
  end;
  fHardAccess:=PARM;
end;


procedure Register;
begin
  RegisterComponents('Drivers', [TVicHw32]);
end;

var hDll : tHandle;
    q    : Pointer;
initialization

  if (GetVersion() and $80000000)<>0 then
  begin
    hDll:=GetModuleHandle('kernel32');
    q:=GetProcAddress(hDll,'OpenVxDHandle');
    OpenVxDHandle:=q;
  end
  else hDll:=0;

finalization

  if (GetVersion() and $80000000)<>0 then CloseHandle(hDll);

end.
