/****************************************************************************
*
* (C) Copyright H. Jelonneck, All Rights Reserved.
*
* This header file includes all public symbols published by ABC.
*
*****************************************************************************/

#ifndef _ABC_H_INCLUDED

#include <nwtypes.h>
#include <advanced.h>

#ifdef __cplusplus
extern "C" {
#endif

/*

   Since ABC version 2.07 the following functions are exported for use
   by external .NLMs. It can be used to call many of the functions that
   ABC uses internally to do its job. Please note that syntax checking
   of the funtions below is very small. So please make sure that only
   correct parameters are passed to ABC.

   IMPORTANT NOTE FOR NETWARE 4.xx USERS:

   As described in the manual "ABC.DOC", ABC must be loaded in DOMAIN=OS
   when you run DOMAIN to protect your server memory. If you will use
   the following functions in your self written .NLM, it must also be
   loaded in ring 0 of server memory (DOMAIN=OS) to import and use
   the public symbols supplied by ABC.

   ------------------------------------------------------------------------

   BYTE ABCBroadcastMessage (char *User, char *Message)

   schedules one message for an immediate broadcast to ABC. This command
   uses the same syntax as described in the manual "ABC.DOC" in the
   chapters: "USER:" and "MESSAGE:".

   It supports all the features described there like multi user and
   multi groups in a multi server environment.

   The message text can include all the special characters that are
   described in the MESSAGE: chapter of the manual. The expanded message
   must not exceed 58 characters, but I recommend that you limit it to
   55 characters.

   ABCBroadcastMessage returns the following hex values:

        00 = broadcast text sucessfully scheduled.
        01 = Warning: broadcast text exceeds 55 characters after
                      expanding.
        02 = Error:   Previous broadcast text has been scheduled but not yet
                      sent by ABC. Wait until ABC has finished the previous
                      broadcast and call this function again. You can test if
                      ABC has finished the previous broadcast by calling this
                      function with empty strings (Both "User" and "Message"
                      must be set to ""). In this case it returns either 0 or
                      2.
        03 = Error:   broadcast text has a zero length or exceeds 58
                      characters after expanding.
        04 = Error:   broadcast text includes wrong %FN - parameters.
                      Please consult the manual for valid parameters
                      for this special message character.
        1x = Error:   "User" string has a zero length or exceeds 119
                      characters.

   All errors will suppress the schedule function. So, if you receive a
   return error, correct your parameters and call this function again.

   Example of a call:

   ReturnCode = ABCBroadcastMessage ("#supervisors,peter,MyServer/Mary",
                                     "Hello everyone its %ti");
*/

BYTE (*ABCBroadcastMessage) (char *User, char *Message) = NULL;

/*
   BYTE ABCDoCommand (char *CommandLines)

   schedules COMMAND: lines to the ABC COMMAND: processor for an immediate
   execution. It supports all the functions that are described in the chapter
   COMMAND: in the manual of "ABC.DOC".

   The string "CommandLines" consist of a NULL terminated string. Every
   COMMAND: line in this string must be terminated by a CR (\r). Line feeds
   (\n) are not allowed.

   ABCDoCommand does no syntax check of any kind on the input string. So it is
   on you NOT to supply a COMMAND: string that contains invalid values in
   subcommands. If you do, unpredictable results may occur. It's also possible
   that the server will abend. So please be careful.

   ABCDoCommand return the following hex values:

        00 = Contents of CommandLines sucessfully scheduled.
        01 = Error:   ABC is unable to allocate memory for a local copy of
                      CommandLines. If you split your CommandLines to less
                      than 120 characters per call, ABC uses an internal
                      static buffer for its local copy, not using dynamic
                      memory.
        02 = Error:   Previous "CommandLines" contents have been scheduled but
                      not yet finished by ABC. Wait until ABC has finished the
                      previous CommandLines and call this function again. You
                      can test if ABC has finished its job by calling this
                      function with an empty string. In this case it returns
                      either 0 or 2.

   All errors will suppress the execution of the CommandLines. So, if you
   receive a return error, wait or shorten your call parameter and call this
   function again.

   Example of a call:

   ReturnCode = ABCDoCommand ("screen: monitor\r %keyevt%dly%-cr\r
                               IF: 0 0 - SKIP 4 LINES\r screen: console\r
                               load monitor\r %dly%dly%-cr\r screen: monitor\r");

   Look at "MONITOR.ABC" for a further description of the above example.

   ReturnCode = ABCDoCommand ("");

   This checks if the last ABCDoCommand has been finished.

*/

BYTE (*ABCDoCommand) (char *CommandLines) = NULL;

/*
   The following 3 functions set, reset, or xor one of the 256 flags of
   ABC. The input parameter can vary from 1 to 256. If the input value
   exceeds these limits, the functions return a TRUE and no flag is
   altered. When the parameter is inside the limits these functions
   return a FALSE and the specified flag will be changed.

*/

BYTE (*ABCSetFlag) (BYTE FlagNo) = NULL;

BYTE (*ABCResetFlag) (BYTE FlagNo) = NULL;

BYTE (*ABCXorFlag) (BYTE FlagNo) = NULL;

/*
   int ABCReadFlags (BYTE FlagsNo)

   returns for every call 16 of the 256 ABC Flags. The input
   parameter "FlagsNo" can be set between 1 to 16. When 1 is given
   then the first 16 bits (flags 1 - 16) are returned, if a 2 is
   given then next 16 bits (flags 17 - 32) are returned,
   if a 3 is given then next 16 bits (flags 33 - 48) are
   returned (and so on). In every flag bit 0 represents the lowest
   flag and bit 15 represents the highest flag. If a value
   outside of 1-16 for "FlagsNo" is given then "ABCReadFlags"
   returns -1.
*/

int (*ABCReadFlags) (LONG *FlagsNo) = NULL;

/*
   The variables ABCFlags [16] gives you direct access to the
   flag variables of ABC. ABCFlags [0] represents the flags
   16 to 1, ABCFlags [1] represents the flags 32 to 17.
   ABCFlags [2] represents the flags 48 to 33 and so on.

*/

WORD *ABCFlags = NULL;

/*
    LONG ABCGetVersion (void)

    returns the ABC version number as an LONG integer. The value is
    returned without the '.'. E.g: if currently ABC version 2.08 is
    loaded then "ABCGetVersion" returns a value of 208.
*/

LONG (*ABCGetVersion) (void) = NULL;

/*
    int InitABCInterface (void) {

    dynamically initializes the function pointers to all exported ABC
    functions. Your program must call "InitABCInterface" once at startup.
    After that it can directly call the different ABC functions.
    "InitABCInterface" returns the ABC version number as a LONG integer.
    The value is returned without the '.'. E.g: if currently ABC version
    2.08 is loaded then "InitABCGetVersion" returns a value of 208.
    IF ABC is not loaded then this function return a -1. Please check
    in your program that a function pointers contains a value != NULL
    before you use it for a call or the server where is runs will crash.

    Please note also that the definition of "ABCFlags" has been changed
    since version 2.07 ABC. The definition in ABC version 2.07 was:

        LONG ABCFlags [2];

*/

int InitABCInterface (void) {

LONG NLMHandle;
int  Version;

   NLMHandle = GetNLMHandle ();
   ABCGetVersion = ImportSymbol (NLMHandle, "ABCGetVersion");
   Version = -1;
   if (ABCGetVersion != NULL) {
      Version = ABCGetVersion ();
      ABCBroadcastMessage = ImportSymbol (NLMHandle, "ABCBroadcastMessage");
      ABCDoCommand = ImportSymbol (NLMHandle, "ABCDoCommand");
      ABCSetFlag = ImportSymbol (NLMHandle, "ABCSetFlag");
      ABCResetFlag = ImportSymbol (NLMHandle, "ABCResetFlag");
      ABCXorFlag = ImportSymbol (NLMHandle, "ABCXorFlag");
      ABCReadFlags = ImportSymbol (NLMHandle, "ABCReadFlags");
      ABCFlags = ImportSymbol (NLMHandle, "ABCFlags");
   }
   return Version;
}

#ifdef __cplusplus
}
#endif

#define _ABC_H_INCLUDED
#endif  /* _ABC_H_INCLUDED  */

