;
;
; To assemble this example program:
;   CPL32 EXAMPLE.ASM TO EXAMPLE.COM EXAMPLE.LST
;
; The EXAMPLE.LST is optional
;

CPL32 ; optional dummy directive to indicate the assembler


BEGIN 100h ; in order to generate a .COM file

CPU PENTIUM ; assemble instructions upto Pentium (if ommited 386 is default)


;
; Both upper and lower case labels and instructions are allowed and have
; the same meaning.

test=50

   MOV AX,2
   ADD BX,AX
   MOV CX,[100h]
   MOV EDI,BUFFER
   MOV EAX,test
R1:MOV [EDI],EAX
   ADD EDI,4
   CALL L50
   DEC ECX
   JNZ R1
   ; addressing modes examples
   MOV AX,BUFFER ; AX=immediate
   MOV AX,[BUFFER] ; AX=memory
   MOV AX,[BX]
   MOV AX,[BX+10]
   MOV AX,[BX+test/2+10]
   MOV AX,[BX+SI]
   MOV AX,[BX+SI+10]
   MOV AX,[ESI]
   MOV AX,[ESI+10]
   MOV AX,[ESI+ECX]
   MOV AX,[ESI+ECX*4]
   MOV AX,[ESI+ECX*4+1000]
   ; conditional example
   CMP AL,10
   IF C {MOV BX,10 ; Carry (AL<10)
         NEG AL
        |MOV BX,20 ; Not Carry (AL>=10)
         SUB AL,10}
   ; Macro example

 AVRG MACRO
      MOV #2,[#1]
      ADD #2,[#1+2]
      ADD #2,[#1+4]
      ADD #2,[#1+6]
      SHR #2,2 ; /4
      #EM

    AVRG initial,AX ; this will calculate the average of the first 4 words starting at addr label "initial"
                    ; Look at .LST file to see how the #1/#2 were substituted

   ; Compiler example (this generates a full page of instructions!)
   IF CX+2>D[initial+10]/1024+BX {
         REPEAT BX-W[initial]+1 {
              ADD AX,AX
              INC CX}
         }

   ;
   ; tiny Machine Code demo program
   MOV AX,B800h ; text mode screen seg
   MOV ES,AX
   MOV DX,"M"
   XOR DI,DI
R2:MOV AX,DX
   STOSW
   XOR DL,0Eh
   INC DH
   MOV CX,BP
R3:NEG AX
   LOOP R3
   IN AL,61h
   SUB BP,B0H
   XOR AL,2
   OUT 61h,AL
   CMP DI,1000h
   JC R2
   INT 20h ; return to DOS


L50:ADD EAX,test/2
    CMP EAX,test & 0
    IF C RET
    MOV EAX,[initial]
    ADD W[initial],test
    RET

 DEVEN
initial:DD 100


COMPDATA


BUFFER: