//
// @(#)tabpanel4.java	2.5 97/03/28
//
// Copyright (c) 1996-1997 Neuron Data Inc.  All Rights Reserved.
//

// (c) Copyright 1994-1996 Microline Software, Inc. ALL RIGHTS RESERVED
//
// THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE COPIED AND USED
// ONLY IN ACCORDANCE WITH THE TERMS OF THAT LICENSE AND WITH THE INCLUSION
// OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE AND DOCUMENTATION, AND ITS
// COPYRIGHTS ARE OWNED BY MICROLINE SOFTWARE AND ARE PROTECTED BY UNITED
// STATES COPYRIGHT LAWS AND INTERNATIONAL TREATY PROVISIONS.
//
// THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE
// AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MICROLINE SOFTWARE.
//
// THIS SOFTWARE AND REFERENCE MATERIALS ARE PROVIDED "AS IS" WITHOUT
// WARRANTY AS TO THEIR PERFORMANCE, MERCHANTABILITY, FITNESS FOR ANY
// PARTICULAR PURPOSE, OR AGAINST INFRINGEMENT.  MICROLINE SOFTWARE
// ASSUMES NO RESPONSIBILITY FOR THE USE OR INABILITY TO USE THIS
// SOFTWARE.
//
// MICROLINE SOFTWARE SHALL NOT BE LIABLE FOR INDIRECT, SPECIAL OR
// CONSEQUENTIAL DAMAGES RESULTING FROM THE USE OF THIS PRODUCT. SOME
// STATES DO NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR
// CONSEQUENTIAL DAMAGES, SO THE ABOVE LIMITATIONS MIGHT NOT APPLY TO
// YOU.
//
// MICROLINE SOFTWARE SHALL HAVE NO LIABILITY OR RESPONSIBILITY FOR SOFTWARE
// ALTERED, MODIFIED, OR CONVERTED BY YOU OR A THIRD PARTY, DAMAGES
// RESULTING FROM ACCIDENT, ABUSE OR MISAPPLICATION, OR FOR PROBLEMS DUE
// TO THE MALFUNCTION OF YOUR EQUIPMENT OR SOFTWARE NOT SUPPLIED BY
// MICROLINE SOFTWARE.
//
// U.S. GOVERNMENT RESTRICTED RIGHTS
// This Software and documentation are provided with RESTRICTED RIGHTS.
// Use, duplication or disclosure by the Government is subject to
// restrictions as set forth in subparagraph (c)(1) of the Rights in
// Technical Data and Computer Software Clause at DFARS 252.227-7013 or
// subparagraphs (c)(1)(ii) and (2) of Commercial Computer Software -
// Restricted Rights at 48 CFR 52.227-19, as applicable, supplier is
// Microline Software, 41 Sutter St Suite 1374, San Francisco, CA 94104.

import java.awt.*;
import java.awt.event.*;
import mlsoft.mct.*;
import java.applet.Applet;

public class tabpanel4 extends Applet implements MlTabPanelListener,
                                                 ActionListener
{
MlTabPanel tabPanel;
Image dotImage, winImage;
Label pageArea;
Button removeButton, addButton;

public tabpanel4()
    {
    setBackground(new Color(192, 192, 192));
    makeIcons();

    tabPanel = new MlTabPanel();
    tabPanel.setValue("tabsPerRow", 4);
    pageArea = new Label("Page Area", Label.CENTER);
    tabPanel.add("Tab 1", pageArea);

    removeButton = new Button("Remove Tab");
    addButton = new Button("Add Tab");

    add(tabPanel);
    add(removeButton);
    add(addButton);
    tabPanel.addMlTabPanelListener(this);
    addButton.addActionListener(this);
    removeButton.addActionListener(this);
    }

public void doLayout()
    {
    tabPanel.setBounds(10, 10, getSize().width - 20, getSize().height - 60);
    removeButton.setBounds(getSize().width - 110, getSize().height - 40, 100, 30);
    addButton.setBounds(getSize().width - 220, getSize().height - 40, 100, 30);
    }

void addTab()
    {
    int count;
    Image image;

    // every other tab will have a sphere image
    count = tabPanel.getIntValue("tabCount");
    if (count % 2 > 0)
        image = dotImage;
    else
        image = winImage;
    tabPanel.addTab("Tab " + (count + 1),  image);
    tabPanel.validate();
    tabPanel.repaint();
    }

void removeTab()
    {
    int count;

    count = tabPanel.getIntValue("tabCount");
    if (count > 0)
        tabPanel.remove(count - 1);
    tabPanel.validate();
    tabPanel.repaint();
    }

public void actionPerformed(ActionEvent event)
    {
    // change the label to reflect the selected page name
    if (event.getSource() == removeButton)
        removeTab();
    else if (event.getSource() == addButton)
        addTab();
    }

public void onTabSelect(MlTabPanelEvent e)
    {
    pageArea.setText("Page for " + e.getName());
    }

public void makeIcons()
    {
    MlIconMaker im;

    im = new MlIconMaker();
    im.setDimensions(16, 16);
    im.setColor('B', 0xff000080);
    im.setColor('K', 0xff000000);
    im.setColor('G', 0xff808080);

    im.setPixels("                ");
    im.setPixels("                ");
    im.setPixels("      BBBBB     ");
    im.setPixels("     BBBBBBB    ");
    im.setPixels("    BBBBBBBBB   ");
    im.setPixels("   BBB  BBBBBB  ");
    im.setPixels("   BBB BBBBBBB  ");
    im.setPixels("   BBBBBBBBBBB  ");
    im.setPixels("   BBBBBBBBBBB  ");
    im.setPixels("   BBBBBBBBBBB  ");
    im.setPixels("    BBBBBBBBB   ");
    im.setPixels("     BBBBBBB    ");
    im.setPixels("      BBBBB     ");
    im.setPixels("                ");
    im.setPixels("                ");
    im.setPixels("                ");
    dotImage = im.createImage(this);

    im.clear();
    im.setPixels("                ");
    im.setPixels("   KKKKKKKKKKK  ");
    im.setPixels("   KGGGGGGGGGK  ");
    im.setPixels("   KG       GK  ");
    im.setPixels("   KG G GGG GK  ");
    im.setPixels("   KG       GK  ");
    im.setPixels("   KG G GGG GK  ");
    im.setPixels("   KG       GK  ");
    im.setPixels("   KGGGGGGGGGK  ");
    im.setPixels("   KKKKKKKKKKK  ");
    im.setPixels("       KGK      ");
    im.setPixels("       KGK      ");
    im.setPixels("    KKKKKKKKK   ");
    im.setPixels("    KKKKKKKKK   ");
    im.setPixels("                ");
    im.setPixels("                ");
    winImage = im.createImage(this);
    }
}
