//
// @(#)grid4.java	2.3 97/03/27
//
// Copyright (c) 1996-1997 Neuron Data Inc.  All Rights Reserved.
//

// (c) Copyright 1994-1996 Microline Software, Inc. ALL RIGHTS RESERVED
//
// THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE COPIED AND USED
// ONLY IN ACCORDANCE WITH THE TERMS OF THAT LICENSE AND WITH THE INCLUSION
// OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE AND DOCUMENTATION, AND ITS
// COPYRIGHTS ARE OWNED BY MICROLINE SOFTWARE AND ARE PROTECTED BY UNITED
// STATES COPYRIGHT LAWS AND INTERNATIONAL TREATY PROVISIONS.
//
// THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE
// AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MICROLINE SOFTWARE.
//
// THIS SOFTWARE AND REFERENCE MATERIALS ARE PROVIDED "AS IS" WITHOUT
// WARRANTY AS TO THEIR PERFORMANCE, MERCHANTABILITY, FITNESS FOR ANY
// PARTICULAR PURPOSE, OR AGAINST INFRINGEMENT.  MICROLINE SOFTWARE
// ASSUMES NO RESPONSIBILITY FOR THE USE OR INABILITY TO USE THIS
// SOFTWARE.
//
// MICROLINE SOFTWARE SHALL NOT BE LIABLE FOR INDIRECT, SPECIAL OR
// CONSEQUENTIAL DAMAGES RESULTING FROM THE USE OF THIS PRODUCT. SOME
// STATES DO NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR
// CONSEQUENTIAL DAMAGES, SO THE ABOVE LIMITATIONS MIGHT NOT APPLY TO
// YOU.
//
// MICROLINE SOFTWARE SHALL HAVE NO LIABILITY OR RESPONSIBILITY FOR SOFTWARE
// ALTERED, MODIFIED, OR CONVERTED BY YOU OR A THIRD PARTY, DAMAGES
// RESULTING FROM ACCIDENT, ABUSE OR MISAPPLICATION, OR FOR PROBLEMS DUE
// TO THE MALFUNCTION OF YOUR EQUIPMENT OR SOFTWARE NOT SUPPLIED BY
// MICROLINE SOFTWARE.
//
// U.S. GOVERNMENT RESTRICTED RIGHTS
// This Software and documentation are provided with RESTRICTED RIGHTS.
// Use, duplication or disclosure by the Government is subject to
// restrictions as set forth in subparagraph (c)(1) of the Rights in
// Technical Data and Computer Software Clause at DFARS 252.227-7013 or
// subparagraphs (c)(1)(ii) and (2) of Commercial Computer Software -
// Restricted Rights at 48 CFR 52.227-19, as applicable, supplier is
// Microline Software, 41 Sutter St Suite 1374, San Francisco, CA 94104.

import java.awt.*;
import mlsoft.mct.*;
import java.applet.Applet;

public class grid4 extends Applet
{
MlGrid grid;

public void init()
    {
    MlResources res;
    Font textFont, titleFont, boldFont;

    setLayout(new BorderLayout());

    textFont = new Font("Helvetica", Font.PLAIN, 12);
    boldFont = new Font("Helvetica", Font.BOLD, 12);
    titleFont = new Font("Helevtica", Font.BOLD, 14);

    grid = new MlGrid();

    grid.setLayoutFrozen(true);

    res = new MlResources();

    grid.setHeadingColumns(1);
    grid.setColumns(3);
    grid.setFooterColumns(1);
    grid.setSimpleWidths("24c 11c 11c 11c 11c");
    grid.setSelectionPolicy(MlGrid.SELECT_NONE);
    grid.setHighlightRowMode(false);

    // add 'Income Summary' heading row with yellow background
    res.clear();
    res.add("cellDefaults", true);
    res.add("cellBackground", "#FFFF00");
    res.add("cellForeground", "#000080");
    res.add("cellLeftBorderType",  "BORDER_NONE");
    res.add("cellRightBorderType", "BORDER_NONE");
    res.add("cellTopBorderType",   "BORDER_NONE");
    res.add("cellBottomBorderColor", "#000000");
    res.add("cellAlignment", "ALIGNMENT_CENTER");
    grid.setValues(res);

    grid.addRows(MlGrid.HEADING, -1, 1);

    // set span on '1996 Income Summary' cell in heading row
    res.clear();
    res.add("rowType", "HEADING");
    res.add("row", 0);
    res.add("column", 0);
    res.add("cellColumnSpan", 2);
    res.add("cellFont", titleFont);
    grid.setValues(res);

    // Add 'Shampoo Conditioner Soap' heading row with white background
    res.clear();
    res.add("cellDefaults", true);
    res.add("cellFont", boldFont);
    res.add("cellBackground", "#FFFFFF");
    res.add("cellForeground", "#000000");
    res.add("cellBottomBorderType", "BORDER_NONE");
    grid.setValues(res);

    grid.addRows(MlGrid.HEADING, -1, 1);

    // Add content and footer rows with heading column 0 left justified
    res.clear();
    res.add("cellDefaults", true);
    res.add("cellAlignment", "ALIGNMENT_RIGHT");
    res.add("cellFont", textFont);
    grid.setValues(res);

    res.clear();
    res.add("cellDefaults", true);
    res.add("columnType", "HEADING");
    res.add("column", 0);
    res.add("cellAlignment", "ALIGNMENT_LEFT");
    grid.setValues(res);

    grid.addRows(MlGrid.CONTENT, -1, 15);

    // Add footer row with blue background
    res.clear();
    res.add("cellDefaults", true);
    res.add("cellForeground", "#ffffff");
    res.add("cellBackground", "#000080");
    res.add("cellFont", boldFont);
    grid.setValues(res);

    grid.addRows(MlGrid.FOOTER, -1, 1);

    // Bold 'Revenues' cell
    res.clear();
    res.add("columnType", "HEADING");
    res.add("column", 0);
    res.add("row", 0);
    res.add("cellFont", boldFont);
    grid.setValues(res);

    // Bold 'Less Expenses' cell
    res.clear();
    res.add("columnType", "HEADING");
    res.add("column", 0);
    res.add("row", 6);
    res.add("cellFont", boldFont);
    grid.setValues(res);

    // Grey middle and footer content column
    res.clear();
    res.add("columnType", "ALL_TYPES");
    res.add("columnRangeStart", 2);
    res.add("columnRangeEnd", 4);
    res.add("columnStep", 2);
    res.add("cellBackground", "#aaaaaa");
    grid.setValues(res);

    // Grey 'Conditioner' and 'Total' cell in heading row 1
    res.clear();
    res.add("rowType", "HEADING");
    res.add("row", 1);
    res.add("columnType", "ALL_TYPES");
    res.add("columnRangeStart", 2);
    res.add("columnRangeEnd", 4);
    res.add("columnStep", 2);
    res.add("cellBackground", "#aaaaaa");
    grid.setValues(res);

    // Blue and bold 'Net Revenue' and 'Total Expenses' rows
    res.clear();
    res.add("rowRangeStart", 4);
    res.add("rowRangeEnd", 12);
    res.add("rowStep", 8);
    res.add("columnType", "ALL_TYPES");
    res.add("cellForeground", "#ffffff");
    res.add("cellBackground", "#000080");
    res.add("cellFont", boldFont);
    grid.setValues(res);

    grid.setStrings(MlGrid.HEADING, 0, MlGrid.HEADING, 0, "|1996 Income Summary");
    grid.setStrings(MlGrid.HEADING, 1, MlGrid.HEADING, 0, "|Shampoo|Conditioner|Soap|Total");

    grid.setStrings( 0, "Revenues:");
    grid.setStrings( 1, "Sales|$ 1,600,000|$ 1,000,000|$  800,000|$ 3,400,000");
    grid.setStrings( 2, "Less Discounts|(16,000)|(10,000)|(8,000)|(34,000)");
    grid.setStrings( 3, "Less Return Allowance|(8,000)|(5,000)|(4,000)|(17,000)");
    grid.setStrings( 4, "  Net Revenue|1,576,000|985,000|792,000|3,349,000");

    grid.setStrings( 6, "Less Expenses:");
    grid.setStrings( 7, "Cost of Goods Sold|(640,000)|(330,000)|(264,000)|(1,234,000)");
    grid.setStrings( 8, "Salary Expense|(380,000)|(280,000)|(180,000)|(840,000)");
    grid.setStrings( 9, "Marketing Expense|(157,600)|(98,500)|(79,200)|(335,300)");
    grid.setStrings(10, "Rent Expense|(36,000)|(36,000)|(36,000)|(108,000)");
    grid.setStrings(11, "Misc. Other Expense|(36,408)|(22,335)|(16,776)|(75,519)");
    grid.setStrings(12, "  Total Expenses|(1,250,008)|(766,835)|(575,976)|(2,592,819)");

    grid.setStrings(14, "Income Tax Expense|(130,397)|(87,266)|(86,410)|(304,072)");
    grid.setStrings(MlGrid.FOOTER, 0, MlGrid.HEADING, 0, "Net Income|195,595|130,899|129,614|456,109");

    grid.setLayoutFrozen(false);

    add("Center", grid);
    }
}
