//
// @(#)grid2.java	2.2 97/03/25
//
// Copyright (c) 1996-1997 Neuron Data Inc.  All Rights Reserved.
//

// (c) Copyright 1994-1996 Microline Software, Inc. ALL RIGHTS RESERVED
//
// THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE COPIED AND USED
// ONLY IN ACCORDANCE WITH THE TERMS OF THAT LICENSE AND WITH THE INCLUSION
// OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE AND DOCUMENTATION, AND ITS
// COPYRIGHTS ARE OWNED BY MICROLINE SOFTWARE AND ARE PROTECTED BY UNITED
// STATES COPYRIGHT LAWS AND INTERNATIONAL TREATY PROVISIONS.
//
// THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE
// AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MICROLINE SOFTWARE.
//
// THIS SOFTWARE AND REFERENCE MATERIALS ARE PROVIDED "AS IS" WITHOUT
// WARRANTY AS TO THEIR PERFORMANCE, MERCHANTABILITY, FITNESS FOR ANY
// PARTICULAR PURPOSE, OR AGAINST INFRINGEMENT.  MICROLINE SOFTWARE
// ASSUMES NO RESPONSIBILITY FOR THE USE OR INABILITY TO USE THIS
// SOFTWARE.
//
// MICROLINE SOFTWARE SHALL NOT BE LIABLE FOR INDIRECT, SPECIAL OR
// CONSEQUENTIAL DAMAGES RESULTING FROM THE USE OF THIS PRODUCT. SOME
// STATES DO NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR
// CONSEQUENTIAL DAMAGES, SO THE ABOVE LIMITATIONS MIGHT NOT APPLY TO
// YOU.
//
// MICROLINE SOFTWARE SHALL HAVE NO LIABILITY OR RESPONSIBILITY FOR SOFTWARE
// ALTERED, MODIFIED, OR CONVERTED BY YOU OR A THIRD PARTY, DAMAGES
// RESULTING FROM ACCIDENT, ABUSE OR MISAPPLICATION, OR FOR PROBLEMS DUE
// TO THE MALFUNCTION OF YOUR EQUIPMENT OR SOFTWARE NOT SUPPLIED BY
// MICROLINE SOFTWARE.
//
// U.S. GOVERNMENT RESTRICTED RIGHTS
// This Software and documentation are provided with RESTRICTED RIGHTS.
// Use, duplication or disclosure by the Government is subject to
// restrictions as set forth in subparagraph (c)(1) of the Rights in
// Technical Data and Computer Software Clause at DFARS 252.227-7013 or
// subparagraphs (c)(1)(ii) and (2) of Commercial Computer Software -
// Restricted Rights at 48 CFR 52.227-19, as applicable, supplier is
// Microline Software, 41 Sutter St Suite 1374, San Francisco, CA 94104.

import java.awt.*;
import mlsoft.mct.*;
import java.applet.Applet;

public class grid2 extends Applet
{
MlGrid grid;
Image upArrow, downArrow;

public void init()
    {
    MlResources res;

    setLayout(new BorderLayout());

    makeIcons();

    res = new MlResources();

    grid = new MlGrid();

    grid.setLayoutFrozen(true);

    grid.setAllowColumnResize(true);
    grid.setSelectionPolicy(MlGrid.SELECT_MULTIPLE_ROW);
    grid.setHeadingRows(1);
    grid.setColumns(7);
    grid.setSimpleWidths("18c 8c 16p 8c 12c 16c 6c");
    grid.setRightFixedCount(1);
    grid.setLeftFixedCount(1);
    grid.setSimpleHeadings("Name|Price||Change|Close Date|Location|Yield");

    // set defaults for content cells
    res.clear();
    res.add("cellDefaults", true);
    res.add("cellBackground", "#ffffff");
    res.add("cellLeftBorderType", "BORDER_NONE");
    res.add("cellRightBorderType", "BORDER_NONE");
    res.add("cellTopBorderType", "BORDER_NONE");
    res.add("cellBottomBorderType", "BORDER_NONE");
    grid.setValues(res);

    res.clear();
    res.add("rowType", "HEADING");
    res.add("column", 1);
    res.add("cellColumnSpan", 1);
    grid.setValues(res);

    res.clear();
    res.add("cellDefaults", true);
    res.add("cellAlignment", "ALIGNMENT_RIGHT");
    grid.setValues(res);

    res.clear();
    res.add("cellDefaults", true);
    res.add("column", 0);
    res.add("cellAlignment", "ALIGNMENT_LEFT");
    grid.setValues(res);

    res.clear();
    res.add("cellDefaults", true);
    res.add("column", 1);
    res.add("cellRightBorderType", "BORDER_NONE");
    grid.setValues(res);

    res.clear();
    res.add("cellDefaults", true);
    res.add("column", 2);
    res.add("cellType", "IMAGE_CELL");
    res.add("cellLeftBorderType", "BORDER_NONE");
    grid.setValues(res);

    grid.addRows(10);

    grid.setStrings(0, "TZZ 3.0 Tana Zin|102.23||-1.2|1/1/94|Tomano, RE|5.6%");
    grid.setStrings(1, "BLC 4.5 Board L|103.23||+2.5|2/15/94|Rino, LO|6.8%");
    grid.setStrings(2, "DGB 5.4 Dig Gen|101.53||+3.7|6/20/94|Carolana, CA|7.5%");
    grid.setStrings(3, "KLC 5.3 Kord L|108.98||-2.5|2/15/94|Cannes, CA|8.7%");
    grid.setStrings(4, "LLO 3.4 Liw Lol|107.24||+2.2|2/20/94|Tenise, MI|6.7%");
    grid.setStrings(5, "MMN 3.1 Mon Mor|105.63||+1.4|2/15/94|Waterton, MN|6.3%");
    grid.setStrings(6, "PLP 4.3 Pol Lab|102.12||-2.3|2/20/94|Holard, LM|7.6%");
    grid.setStrings(7, "SZN 4.5 Siml Zi|101.11||+1.6|2/15/94|Tempest, CA|5.4%");
    grid.setStrings(8, "TTL 5.6 Towa Tin|101.12||+2.7|3/15/94|Conila, OK|6.7%");
    grid.setStrings(9, "ULD 5.4 Upl La D|105.12||-2.2|4/15/94|Mandrill, HI|7.8%");


    res.clear();
    res.add("column", 2);
    res.add("cellImage", upArrow);
    grid.setValues(res);

    res.clear();
    res.add("column", 2);
    res.add("rowStep", 3);
    res.add("cellImage", downArrow);
    grid.setValues(res);

    grid.setLayoutFrozen(false);

    // This example uses double buffering and drawing to provide smooth
    // scrolling and increased drawing speed.  This can cause drawing
    // problems with some JDK release/runner combinations which don't
    // support multi-threaded drawing or double buffering correctly.
    // If you find this to be the case, you can remove the following two lines

    grid.setDoubleBuffer(true);
    grid.setImmediateDraw(false);

    add("Center", grid);
    }

public void makeIcons()
    {
    MlIconMaker im;

    im = new MlIconMaker();
    im.setDimensions(12, 16);
    im.setColor('G', 0xff008000);
    im.setColor('R', 0xff800000);

    im.setPixels("            ");
    im.setPixels("     GG     ");
    im.setPixels("    GGGG    ");
    im.setPixels("   GGGGGG   ");
    im.setPixels("  GGGGGGGG  ");
    im.setPixels(" GGGGGGGGGG ");
    im.setPixels(" GGGGGGGGGG ");
    im.setPixels(" GG GGGG GG ");
    im.setPixels(" G  GGGG  G ");
    im.setPixels("    GGGG    ");
    im.setPixels("    GGGG    ");
    im.setPixels("    GGGG    ");
    im.setPixels("    GGGG    ");
    im.setPixels("    GGGG    ");
    im.setPixels("    GGGG    ");
    im.setPixels("            ");
    upArrow = im.createImage(this);

    im.clear();
    im.setPixels("            ");
    im.setPixels("    RRRR    ");
    im.setPixels("    RRRR    ");
    im.setPixels("    RRRR    ");
    im.setPixels("    RRRR    ");
    im.setPixels("    RRRR    ");
    im.setPixels("    RRRR    ");
    im.setPixels(" R  RRRR  R ");
    im.setPixels(" RR RRRR RR ");
    im.setPixels(" RRRRRRRRRR ");
    im.setPixels(" RRRRRRRRRR ");
    im.setPixels("  RRRRRRRR  ");
    im.setPixels("   RRRRRR   ");
    im.setPixels("    RRRR    ");
    im.setPixels("     RR     ");
    im.setPixels("            ");
    downArrow = im.createImage(this);
    }
}
