//
// @(#)tree4.java	2.4 97/03/27
//
// Copyright (c) 1996-1997 Neuron Data Inc.  All Rights Reserved.
//

// (c) Copyright 1994-1996 Microline Software, Inc. ALL RIGHTS RESERVED
//
// THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE COPIED AND USED
// ONLY IN ACCORDANCE WITH THE TERMS OF THAT LICENSE AND WITH THE INCLUSION
// OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE AND DOCUMENTATION, AND ITS
// COPYRIGHTS ARE OWNED BY MICROLINE SOFTWARE AND ARE PROTECTED BY UNITED
// STATES COPYRIGHT LAWS AND INTERNATIONAL TREATY PROVISIONS.
//
// THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE
// AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MICROLINE SOFTWARE.
//
// THIS SOFTWARE AND REFERENCE MATERIALS ARE PROVIDED "AS IS" WITHOUT
// WARRANTY AS TO THEIR PERFORMANCE, MERCHANTABILITY, FITNESS FOR ANY
// PARTICULAR PURPOSE, OR AGAINST INFRINGEMENT.  MICROLINE SOFTWARE
// ASSUMES NO RESPONSIBILITY FOR THE USE OR INABILITY TO USE THIS
// SOFTWARE.
//
// MICROLINE SOFTWARE SHALL NOT BE LIABLE FOR INDIRECT, SPECIAL OR
// CONSEQUENTIAL DAMAGES RESULTING FROM THE USE OF THIS PRODUCT. SOME
// STATES DO NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR
// CONSEQUENTIAL DAMAGES, SO THE ABOVE LIMITATIONS MIGHT NOT APPLY TO
// YOU.
//
// MICROLINE SOFTWARE SHALL HAVE NO LIABILITY OR RESPONSIBILITY FOR SOFTWARE
// ALTERED, MODIFIED, OR CONVERTED BY YOU OR A THIRD PARTY, DAMAGES
// RESULTING FROM ACCIDENT, ABUSE OR MISAPPLICATION, OR FOR PROBLEMS DUE
// TO THE MALFUNCTION OF YOUR EQUIPMENT OR SOFTWARE NOT SUPPLIED BY
// MICROLINE SOFTWARE.
//
// U.S. GOVERNMENT RESTRICTED RIGHTS
// This Software and documentation are provided with RESTRICTED RIGHTS.
// Use, duplication or disclosure by the Government is subject to
// restrictions as set forth in subparagraph (c)(1) of the Rights in
// Technical Data and Computer Software Clause at DFARS 252.227-7013 or
// subparagraphs (c)(1)(ii) and (2) of Commercial Computer Software -
// Restricted Rights at 48 CFR 52.227-19, as applicable, supplier is
// Microline Software, 41 Sutter St Suite 1374, San Francisco, CA 94104.

import java.awt.*;
import java.util.*;
import mlsoft.mct.*;
import java.applet.Applet;

class DirData
{
public String path;
boolean loaded;

public DirData(String path)
    {
    this.path = path;
    loaded = false;
    }
}

public class tree4 extends Applet implements MlTreeListener
{
MlGrid grid;
MlTree tree;

public void init()
    {
    MlResources res;
    int w, rw;

    res = new MlResources();
    setLayout(null);
    setBackground(new Color(200, 200, 200));

    tree = new MlTree();

    tree.setValue("autoSelect", false);

    // add a single row containing the root path to the Tree
    tree.addRow(1, true, false, 0, null, "/");
    res.add("row", 0);
    res.add("rowUserObject", new DirData("/"));
    tree.setValues(res);

    grid = new MlGrid();
    grid.setColumns(3);
    grid.setHeadingRows(1);
    grid.setSimpleWidths("16c 12c 10c");
    grid.setSimpleHeadings("Name|Type|Size");
    grid.setAllowColumnResize(true);
    grid.setShadowThickness(0);

    res.clear();
    res.add("cellDefaults", true);
    res.add("cellBackground", "#ffffff");
    res.add("cellTopBorderType", "BORDER_NONE");
    res.add("cellBottomBorderType", "BORDER_NONE");
    res.add("cellRightBorderType", "BORDER_NONE");
    res.add("cellLeftBorderType", "BORDER_NONE");
    res.add("cellAlignment", "ALIGNMENT_LEFT");
    grid.setValues(res);

    res.clear();
    res.add("cellDefaults", true);
    res.add("column", 2);
    res.add("cellAlignment", "ALIGNMENT_RIGHT");
    grid.setValues(res);

    w = getBounds().width / 2 - 52;
    tree.setBounds(0, 0, w, getBounds().height);
    add(tree);

    rw = getBounds().width - w - 4;
    grid.setBounds(w + 4, 0, rw, getBounds().height);
    add(grid);

    // invoke the select callback for the first row in the Tree
    // to fill the Grid with the data for the root path
    tree.selectRow(0, true);

    // add Listener
    tree.addMlTreeListener(this);
    }

public void onTreeEvent(MlTreeEvent event)
    {

    if (event.getType() == MlTreeEvent.EXPAND_ROW)
        {
        expandRow(event.row);
        }
    else if (event.getType() == MlGridEvent.SELECT_ROW)
        {
        selectRow(event.row);
        }
    }

protected void expandRow(int r)
    {
    MlResources res;
    int i, pos;
    DirData data;
    String name;
    Integer level;

    // retrieve the DirData of the directory to expand.  This is kept
    // in the row's rowUserObject
    data = (DirData)tree.getRowValue(MlTree.CONTENT, r, "rowUserObject");
    if (data.loaded)
        return; // children already loaded

    res = new MlResources();
    level = (Integer)tree.getRowValue(MlTree.CONTENT, r, "rowLevel");
    // in a real application, we would take the path and read its
    // sub-directories and add it to the tree.  since we have no
    // data source, we fake one here
    tree.setLayoutFrozen(true);
    pos = r + 1;
    for (i = 0; i < 6; i++)
        {
        name = null;
        switch (i)
            {
            case 0: name = "etc";   break;
            case 1: name = "bin";   break;
            case 2: name = "cal";  break;
            case 3: name = "doc";   break;
            case 4: name = "pub";   break;
            case 5: name = "web";  break;
            case 6: name = "tmp";   break;
            }
        tree.addRow(level.intValue() + 1, true, false, pos, null, name);
        res.clear();
        res.add("row", pos);
        res.add("rowUserObject", new DirData(data.path + "/" + name));
        tree.setValues(res);
        pos++;
        }
    tree.setLayoutFrozen(false);
    data.loaded = true;
    }

protected void selectRow(int r)
    {
    DirData data;
    int i, pos;

    // retrieve the directory selected
    data = (DirData)tree.getRowValue(MlTree.CONTENT, r, "rowUserObject");

    // in a real application, we would take the selected directory
    // and load in its sub-files and add it to the Grid.  since we have
    // no data source, we fake one here
    grid.setLayoutFrozen(true);
    grid.deleteAllRows();
    pos = 0;
    for (i = 0; i < (r % 20) + 5; i++)
        {
        grid.addRows(1);
        // add semi-random sample data to the Grid
        if (r % 2 == i % 3)
            grid.setStrings(MlGrid.CONTENT, pos, MlGrid.CONTENT, 0,
                "site_" + i + "|Site|1080");
        else if (r % 3 == i % 3)
            grid.setStrings(MlGrid.CONTENT, pos, MlGrid.CONTENT, 0,
                "directory_" + (i * r) + "|Directory|1030");
        else
            grid.setStrings(MlGrid.CONTENT, pos, MlGrid.CONTENT, 0,
                "file_" + (i + r) + "|file|" + (r * 40));
        pos++;
        }
    grid.setLayoutFrozen(false);
    }
}
