//
// @(#)tree2.java	2.2 97/03/25
//
// Copyright (c) 1996-1997 Neuron Data Inc.  All Rights Reserved.
//

// (c) Copyright 1994-1996 Microline Software, Inc. ALL RIGHTS RESERVED
//
// THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE COPIED AND USED
// ONLY IN ACCORDANCE WITH THE TERMS OF THAT LICENSE AND WITH THE INCLUSION
// OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE AND DOCUMENTATION, AND ITS
// COPYRIGHTS ARE OWNED BY MICROLINE SOFTWARE AND ARE PROTECTED BY UNITED
// STATES COPYRIGHT LAWS AND INTERNATIONAL TREATY PROVISIONS.
//
// THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE
// AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MICROLINE SOFTWARE.
//
// THIS SOFTWARE AND REFERENCE MATERIALS ARE PROVIDED "AS IS" WITHOUT
// WARRANTY AS TO THEIR PERFORMANCE, MERCHANTABILITY, FITNESS FOR ANY
// PARTICULAR PURPOSE, OR AGAINST INFRINGEMENT.  MICROLINE SOFTWARE
// ASSUMES NO RESPONSIBILITY FOR THE USE OR INABILITY TO USE THIS
// SOFTWARE.
//
// MICROLINE SOFTWARE SHALL NOT BE LIABLE FOR INDIRECT, SPECIAL OR
// CONSEQUENTIAL DAMAGES RESULTING FROM THE USE OF THIS PRODUCT. SOME
// STATES DO NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR
// CONSEQUENTIAL DAMAGES, SO THE ABOVE LIMITATIONS MIGHT NOT APPLY TO
// YOU.
//
// MICROLINE SOFTWARE SHALL HAVE NO LIABILITY OR RESPONSIBILITY FOR SOFTWARE
// ALTERED, MODIFIED, OR CONVERTED BY YOU OR A THIRD PARTY, DAMAGES
// RESULTING FROM ACCIDENT, ABUSE OR MISAPPLICATION, OR FOR PROBLEMS DUE
// TO THE MALFUNCTION OF YOUR EQUIPMENT OR SOFTWARE NOT SUPPLIED BY
// MICROLINE SOFTWARE.
//
// U.S. GOVERNMENT RESTRICTED RIGHTS
// This Software and documentation are provided with RESTRICTED RIGHTS.
// Use, duplication or disclosure by the Government is subject to
// restrictions as set forth in subparagraph (c)(1) of the Rights in
// Technical Data and Computer Software Clause at DFARS 252.227-7013 or
// subparagraphs (c)(1)(ii) and (2) of Commercial Computer Software -
// Restricted Rights at 48 CFR 52.227-19, as applicable, supplier is
// Microline Software, 41 Sutter St Suite 1374, San Francisco, CA 94104.

import java.awt.*;
import java.util.*;
import mlsoft.mct.*;
import java.applet.Applet;

public class tree2 extends Applet
{
MlTree tree;
static boolean expands[] = { true, true, true, false, false,
        false, true, false, false, false };
static int levels[] = { 0, 1, 2, 3, 2, 2, 1, 2, 2, 2 };

public void init()
    {
    MlResources res;
    MlTreeRowDefinition rows[];
    int i, n;

    setLayout(new BorderLayout());
    res = new MlResources();
    tree = new MlTree();

    tree.setHeadingRows(1);
    tree.setColumns(5);
    tree.setSimpleHeadings("Object|Position|Size|Method|Note");
    tree.setSimpleWidths("1c 10c 10c 15c 15c");
    tree.setAllowColumnResize(true);

    res.clear();
    res.add("rowType", "HEADING");
    res.add("cellBackground", "#c0c0c0");
    res.add("cellLeftBorderType", "BORDER_LINE");
    res.add("cellRightBorderType", "BORDER_LINE");
    res.add("cellTopBorderType", "BORDER_LINE");
    res.add("cellBottomBorderType", "BORDER_LINE");
    tree.setValues(res);

    res.clear();
    res.add("cellDefaults", true);
    res.add("column", 2);
    res.add("cellAlignment", "ALIGNMENT_RIGHT");
    tree.setValues(res);

    n = 100;
    rows = new MlTreeRowDefinition[n];
    for (i = 0; i < n; i++)
        {
        rows[i] = new MlTreeRowDefinition();
        rows[i].level = levels[i % 10];
        rows[i].expands = expands[i % 10];
        rows[i].isExpanded = true;
        if (rows[i].expands)
            rows[i].string = "Composite";
        else if ((i % 5) > 0)
            rows[i].string = "Curve";
        else
            rows[i].string = "Surface";
        }

    tree.addRows(rows, 0);
    for (i = 0; i < n; i++)
        tree.setStrings(MlGrid.CONTENT, i, MlGrid.CONTENT, 1,
            (i % 20) + " " + (i % 15) + "|" + (i % 4) +
            " points|Open|In Progress");

    add("Center", tree);
    }
}
