//
// @(#)grid6.java	2.3 97/03/25
//
// Copyright (c) 1996-1997 Neuron Data Inc.  All Rights Reserved.
//

// (c) Copyright 1994-1996 Microline Software, Inc. ALL RIGHTS RESERVED
//
// THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE COPIED AND USED
// ONLY IN ACCORDANCE WITH THE TERMS OF THAT LICENSE AND WITH THE INCLUSION
// OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE AND DOCUMENTATION, AND ITS
// COPYRIGHTS ARE OWNED BY MICROLINE SOFTWARE AND ARE PROTECTED BY UNITED
// STATES COPYRIGHT LAWS AND INTERNATIONAL TREATY PROVISIONS.
//
// THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE
// AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MICROLINE SOFTWARE.
//
// THIS SOFTWARE AND REFERENCE MATERIALS ARE PROVIDED "AS IS" WITHOUT
// WARRANTY AS TO THEIR PERFORMANCE, MERCHANTABILITY, FITNESS FOR ANY
// PARTICULAR PURPOSE, OR AGAINST INFRINGEMENT.  MICROLINE SOFTWARE
// ASSUMES NO RESPONSIBILITY FOR THE USE OR INABILITY TO USE THIS
// SOFTWARE.
//
// MICROLINE SOFTWARE SHALL NOT BE LIABLE FOR INDIRECT, SPECIAL OR
// CONSEQUENTIAL DAMAGES RESULTING FROM THE USE OF THIS PRODUCT. SOME
// STATES DO NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR
// CONSEQUENTIAL DAMAGES, SO THE ABOVE LIMITATIONS MIGHT NOT APPLY TO
// YOU.
//
// MICROLINE SOFTWARE SHALL HAVE NO LIABILITY OR RESPONSIBILITY FOR SOFTWARE
// ALTERED, MODIFIED, OR CONVERTED BY YOU OR A THIRD PARTY, DAMAGES
// RESULTING FROM ACCIDENT, ABUSE OR MISAPPLICATION, OR FOR PROBLEMS DUE
// TO THE MALFUNCTION OF YOUR EQUIPMENT OR SOFTWARE NOT SUPPLIED BY
// MICROLINE SOFTWARE.
//
// U.S. GOVERNMENT RESTRICTED RIGHTS
// This Software and documentation are provided with RESTRICTED RIGHTS.
// Use, duplication or disclosure by the Government is subject to
// restrictions as set forth in subparagraph (c)(1) of the Rights in
// Technical Data and Computer Software Clause at DFARS 252.227-7013 or
// subparagraphs (c)(1)(ii) and (2) of Commercial Computer Software -
// Restricted Rights at 48 CFR 52.227-19, as applicable, supplier is
// Microline Software, 41 Sutter St Suite 1374, San Francisco, CA 94104.

import java.awt.*;
import java.util.*;
import mlsoft.mct.*;
import java.applet.Applet;

// ---- mini-database prototype

// database column
class DbColumn
{
public String name;
public int width;
public int alignment;
public boolean editable;

public DbColumn(String _name, int _width, int _alignment, boolean _editable)
    {
    name = _name;
    width = _width;
    alignment = _alignment;
    editable = _editable;
    }
}

// database row
class DbRow
{
public String key;
public String desc;
public double price;
public int qty;
public String buyer;

public DbRow(String _key, String _desc, double _price, int _qty, String _buyer)
    {
    key = _key;
    desc = _desc;
    price = _price;
    qty = _qty;
    buyer = _buyer;
    }
}

// database table
class DbTable extends MlArray 
{
Vector columns;
String sortColumn;

public DbTable()
    {
    columns = new Vector();

    addColumn("Description", 16, MlGrid.ALIGNMENT_LEFT,  true );
    addColumn("Price",       9,  MlGrid.ALIGNMENT_RIGHT, true );
    addColumn("Qty",         5,  MlGrid.ALIGNMENT_RIGHT, true );
    addColumn("Unit Prc",    9,  MlGrid.ALIGNMENT_RIGHT, false);
    addColumn("Buyer",       15, MlGrid.ALIGNMENT_LEFT,  true );

    addRow("key01", "Staples",        1.32, 100, "Tim Pick"     );
    addRow("key02", "Notebooks",      1.11,   4, "Mary Miner"   );
    addRow("key03", "3-Ring Binders", 2.59,   2, "Mary Miner"   );
    addRow("key04", "Pads",           1.23,   3, "Tim Pick"     );
    addRow("key05", "Scissors",       4.41,   1, "Mary Miner"   );
    addRow("key06", "Pens",            .29,   4, "Mary Miner"   );
    addRow("key07", "Pencils",         .10,   5, "Tim Pick"     );
    addRow("key08", "Markers",         .95,   3, "Mary Miner"   );
    addRow("key09", "Fax Paper",      3.89, 100, "Bob Coal"     );
    addRow("key10", "3.5\" Disks",   15.23,  30, "Tim Pick"     );
    addRow("key11", "8mm Tape",      32.22,   2, "Bob Coal"     );
    addRow("key12", "Toner",         35.69,   1, "Tim Pick"     );
    addRow("key13", "Paper Cups",     4.25,   3, "Bob Coal"     );
    addRow("key14", "Paper Clips",    2.09,   3, "Tim Pick"     );
    addRow("key15", "Small Post Its", 2.20,   4, "Ezra Epstein" );
    addRow("key16", "Pink Hi-Liters", 0.85,  30, "Olivia Semak" );
    addRow("key17", "Letter Folders", 4.25,  25, "Susan Redford");
    addRow("key18", "Legal Folders",  2.39,  10, "Jane Maple"   );
    addRow("key19", "Erasers",        8.00, 100, "Anna Nguyen"  );
    addRow("key20", "White-Out",     12.00,  12, "Joanna Keefe" );
    }

public void addColumn(String name, int width, int alignment, boolean editable)
    {
    columns.addElement(new DbColumn(name, width, alignment, editable));
    }

public void addRow(String key, String desc, double price,
    int qty, String buyer)
    {
    addItem(new DbRow(key, desc, price, qty, buyer));
    }

public DbColumn getColumn(int i)
    {
    return (DbColumn)columns.elementAt(i);
    }

public int getColumnCount()
    {
    return columns.size();
    }

public DbRow findRow(String key)
    {
    DbRow row;
    int i;

    for (i = 0; i < getCount(); i++)
        {
        row = (DbRow)get(i);
        if (key.equals(row.key))
            return row;
        }
    return null;
    }

public int compare(Object item1, Object item2)
    {
    DbRow row1, row2;
    double u1, u2;

    row1 = (DbRow)item1;
    row2 = (DbRow)item2;
    if (sortColumn.equals("Description"))
        return row1.desc.compareTo(row2.desc);
    if (sortColumn.equals("Price"))
        {
        u1 = row1.price - row2.price;
        if (u1 < 0)
            return -1;
        else if (u1 == 0)
            return 0;
        return 1;
        }
    if (sortColumn.equals("Qty"))
        return row1.qty - row2.qty;
    if (sortColumn.equals("Unit Prc"))
        {
        u1 = row1.price / row1.qty;
        u2 = row2.price / row2.qty;
        if (u1 < u2)
            return -1;
        else if (u1 == u2)
            return 0;
        else
            return 1;
        }
    if (sortColumn.equals("Buyer"))
        return row1.buyer.compareTo(row2.buyer);
    return super.compare(item1, item2);
    }

String []getRowKeysSorted(String columnName)
    {
    String keys[];
    int i, rowCount;

    sortColumn = columnName;
    sort();
    rowCount = getCount();
    keys = new String[rowCount];
    for (i = 0; i < rowCount; i++)
        keys[i] = ((DbRow)get(i)).key;
    return keys;
    }
}

// mini-database grid prototype

class DbGrid extends MlGrid implements MlGridListener
{
DbTable table;

public DbGrid()
    {
    setHorizontalSizePolicy(MlGrid.SIZE_TO_FIT);
    setVisibleRows(10);
    setVsbDisplayPolicy(MlGrid.DISPLAY_ALWAYS);
    setSelectionPolicy(MlGrid.SELECT_NONE);
    setShadowThickness(0);
    setHighlightRowMode(false);
    setHeadingRows(1);
 
    addMlGridListener(this);
    }

public void loadTable(DbTable _table)
    {
    MlResources res;
    DbColumn col;
    int i, numColumns;

    table = _table;
    res = new MlResources();
    setLayoutFrozen(true);

    deleteAllColumns();
    // delete all content rows, not heading row
    deleteAllRows();

    // set cell defaults for heading row
    res.clear();
    res.add("cellDefaults", true);
    res.add("cellLeftBorderType", "BORDER_LINE");
    res.add("cellRightBorderType", "BORDER_LINE");
    res.add("cellTopBorderType", "BORDER_LINE");
    res.add("cellBottomBorderType", "BORDER_LINE");
    res.add("cellBackground", "#C0C0C0");
    res.add("cellLeftMargin", 1);
    res.add("cellRightMargin", 1);
    setValues(res);

    // add columns - this creates cells in the heading row
    numColumns = table.columns.size();
    addColumns(numColumns);

    for (i = 0; i < numColumns; i++)
        {
        col = table.getColumn(i);

        // set the width and the key (name) on columns in the grid
        res.clear();
        res.add("column", i);
        res.add("columnUserObject", col.name);
        res.add("columnWidth", col.width);
        setValues(res);

        // set default cell alignment/editibility for cells in the column
        res.clear();
        res.add("cellDefaults", true);
        res.add("column", i);
        res.add("cellAlignment", col.alignment);
        res.add("cellEditable", col.editable);
        setValues(res);

        // set the column heading
        res.clear();
        res.add("rowType", "HEADING");
        res.add("row", 0);
        res.add("column", i);
        res.add("cellAlignment", col.alignment);
        res.add("cellString", col.name);
        setValues(res);
        }

    // set cell defaults for content rows
    res.clear();
    res.add("cellDefaults", true);
    res.add("cellLeftBorderType", "BORDER_NONE");
    res.add("cellRightBorderType", "BORDER_NONE");
    res.add("cellTopBorderType", "BORDER_NONE");
    res.add("cellBottomBorderType", "BORDER_NONE");
    res.add("cellBackground", "#FFFFFF");
    setValues(res);

    addRows(table.getCount());
    setLayoutFrozen(false);
    }

public void setRowKeysSorted(String sortColumn)
    {
    MlResources res;
    String keys[];
    int i;

    res = new MlResources();
    keys = table.getRowKeysSorted(sortColumn);
    // place row keys in each grid row's userObject
    for (i = 0; i < keys.length; i++)
        {
        res.clear();
        res.add("row", i);
        res.add("rowUserObject", keys[i]);
        setValues(res);
        }
    }

public void onGridEvent(MlGridEvent event)
    {

    if (event.getType() == MlGridEvent.SELECT_CELL)
        {
        if (event.rowType == HEADING)
            {
            sortByColumn(event.columnType, event.column);
            }
        }
    // for a full production version, this function should also
    // handle EDIT_INSERT by retrieving the current value
    // from the database and performing an setText() on
    // the text child of the grid with that value.  This allows
    // a user to hit insert or F2 to modify an existing cell value
    else if (event.getType() == MlGridEvent.EDIT_COMPLETE)
        {
        editCell(event.row, event.column);
        }
    }

public void sortByColumn(int colType, int col)
    {
    String columnName;

    editCancel();
    columnName = (String)getColumnValue(colType, col, "columnUserObject");
    setRowKeysSorted(columnName);
    redrawAll();
    }

public void editCell(int r, int c)
    {
    DbRow row;
    MlResources res;
    String string, rowKey, colKey;
    boolean redrawRow;

    // get value entered
    string = (String)getCellValue(CONTENT, r, CONTENT, c, "cellString");

    // retrieve row and column key
    rowKey = (String)getRowValue(CONTENT, r, "rowUserObject");
    colKey = (String)getColumnValue(CONTENT, c, "columnUserObject");

    // set new value in the database
    redrawRow = false;
    row = table.findRow(rowKey);
    if (colKey.equals("Description"))
        row.desc = string;
    else if (colKey.equals("Price"))
        {
        try
            {
            row.price = Double.valueOf(string).doubleValue();
            } catch (NumberFormatException e) {}
        redrawRow = true;
        }
    else if (colKey.equals("Qty"))
        {
        try
            {
            row.qty = Integer.valueOf(string).intValue();
            } catch (NumberFormatException e) {}
        redrawRow = true;
        }
    else if (colKey.equals("Buyer"))
        row.buyer = string;

    // set cellString to null since we draw the value
    res = new MlResources();
    res.add("row", r);
    res.add("column", c);
    res.add("cellString", null);
    setValues(res);

    // redraw the row if we need to redisplay/recompute unit price
    if (redrawRow)
        redrawRow(CONTENT, r);
    }

public void drawCell(MlGridCell cell, MlGridDrawInfo drawInfo)
    {
    Graphics g;
    String rowKey, colKey;
    DbRow row;
    String string;
    Rectangle rect;
    MlGridCellValues values;
    int horizMargin, vertMargin;

    super.drawCell(cell, drawInfo);
    if (drawInfo.rowType != CONTENT)
        return;

    // retrieve row key from userObject in row
    rowKey = (String)getRowValue(CONTENT, drawInfo.row, "rowUserObject");

    // retrieve column key (name) from userObject in column
    colKey = (String)getColumnValue(drawInfo.columnType, drawInfo.column,
        "columnUserObject");

    // retrieve value from the database
    row = table.findRow(rowKey);
    string = null;
    if (colKey.equals("Description"))
        string = row.desc;
    else if (colKey.equals("Price"))
        string = "$" + formatDouble(row.price);
    else if (colKey.equals("Qty"))
        string = Integer.toString(row.qty);
    else if (colKey.equals("Unit Prc"))
        string = "$" + formatDouble(row.price / (double)row.qty);
    else if (colKey.equals("Buyer"))
        string = row.buyer;

    // create a draw rectangle, adjusted for cell margins
    values = cell.getValues();
    horizMargin = values.leftMargin + values.rightMargin;
    vertMargin = values.topMargin + values.bottomMargin;
    if (horizMargin >= drawInfo.cellRect.width ||
        vertMargin >= drawInfo.cellRect.height)
        return;
    rect = new Rectangle();
    rect.x = drawInfo.cellRect.x + values.leftMargin;
    rect.y = drawInfo.cellRect.y + values.topMargin;
    rect.width = drawInfo.cellRect.width - horizMargin;
    rect.height = drawInfo.cellRect.height - vertMargin;

    // draw the string
    g = drawInfo.g;
    if (drawInfo.drawSelected)
        g.setColor(drawInfo.selectForeground);
    else
        g.setColor(values.foreground);
    MlUtil.drawString(g, string, values.font, values.alignment,
        rect, drawInfo.clipRect);
    }

String formatDouble(double d)
    {
    String string;
    int i;

    string = Double.toString(d);
    i = string.indexOf('.');
    if (i < 0 || string.length() - i <= 3)
        return string;
    return string.substring(0, i + 2);
    }
}

// --- the application

public class grid6 extends Applet
{
DbGrid grid;
DbTable table;

public void init()
    {
    Dimension d;

    setLayout(null);
    setBackground(Color.lightGray);

    grid = new DbGrid();
    table = new DbTable();

    grid.loadTable(table);
    grid.setRowKeysSorted("Description");

    d = grid.preferredSize();
    grid.setBounds((getBounds().width - d.width) / 2, (getBounds().height -
        d.height) / 2, d.width, d.height);
    add(grid);
    }
}
