//
// @(#)grid5.java	2.4 97/03/27
//
// Copyright (c) 1996-1997 Neuron Data Inc.  All Rights Reserved.
//

// (c) Copyright 1994-1996 Microline Software, Inc. ALL RIGHTS RESERVED
//
// THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE COPIED AND USED
// ONLY IN ACCORDANCE WITH THE TERMS OF THAT LICENSE AND WITH THE INCLUSION
// OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE AND DOCUMENTATION, AND ITS
// COPYRIGHTS ARE OWNED BY MICROLINE SOFTWARE AND ARE PROTECTED BY UNITED
// STATES COPYRIGHT LAWS AND INTERNATIONAL TREATY PROVISIONS.
//
// THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE
// AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MICROLINE SOFTWARE.
//
// THIS SOFTWARE AND REFERENCE MATERIALS ARE PROVIDED "AS IS" WITHOUT
// WARRANTY AS TO THEIR PERFORMANCE, MERCHANTABILITY, FITNESS FOR ANY
// PARTICULAR PURPOSE, OR AGAINST INFRINGEMENT.  MICROLINE SOFTWARE
// ASSUMES NO RESPONSIBILITY FOR THE USE OR INABILITY TO USE THIS
// SOFTWARE.
//
// MICROLINE SOFTWARE SHALL NOT BE LIABLE FOR INDIRECT, SPECIAL OR
// CONSEQUENTIAL DAMAGES RESULTING FROM THE USE OF THIS PRODUCT. SOME
// STATES DO NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR
// CONSEQUENTIAL DAMAGES, SO THE ABOVE LIMITATIONS MIGHT NOT APPLY TO
// YOU.
//
// MICROLINE SOFTWARE SHALL HAVE NO LIABILITY OR RESPONSIBILITY FOR SOFTWARE
// ALTERED, MODIFIED, OR CONVERTED BY YOU OR A THIRD PARTY, DAMAGES
// RESULTING FROM ACCIDENT, ABUSE OR MISAPPLICATION, OR FOR PROBLEMS DUE
// TO THE MALFUNCTION OF YOUR EQUIPMENT OR SOFTWARE NOT SUPPLIED BY
// MICROLINE SOFTWARE.
//
// U.S. GOVERNMENT RESTRICTED RIGHTS
// This Software and documentation are provided with RESTRICTED RIGHTS.
// Use, duplication or disclosure by the Government is subject to
// restrictions as set forth in subparagraph (c)(1) of the Rights in
// Technical Data and Computer Software Clause at DFARS 252.227-7013 or
// subparagraphs (c)(1)(ii) and (2) of Commercial Computer Software -
// Restricted Rights at 48 CFR 52.227-19, as applicable, supplier is
// Microline Software, 41 Sutter St Suite 1374, San Francisco, CA 94104.

import java.awt.*;
import java.awt.event.*;
import mlsoft.mct.*;
import java.applet.Applet;

public class grid5 extends Applet implements ActionListener
{
MlGrid grid;

public void init()
    {
    MlResources res;
    int i;

    setLayout(new BorderLayout());
    res = new MlResources();
    grid = new MlGrid();

    grid.setSelectionPolicy(MlGrid.SELECT_NONE);
    grid.setAllowColumnResize(true);
    grid.setHighlightRowMode(false);
    grid.setLayoutFrozen(true);

    // set default column width to 160 pixels
    res.clear();
    res.add("columnDefaults", true);
    res.add("columnSizePolicy", MlGrid.SIZE_FIXED);
    res.add("columnWidth", 160);
    grid.setValues(res);

    // add heading row and columns
    grid.setHeadingRows(1);
    grid.setColumns(3);
    grid.setSimpleHeadings("extArea|Row Num|Buttons");

    // set default row height to 40 pixels
    res.clear();
    res.add("rowDefaults", true);
    res.add("rowSizePolicy", MlGrid.SIZE_FIXED);
    res.add("rowHeight", 40);
    grid.setValues(res);

    // set default cell values
    res.add("cellDefaults", true);
    res.add("cellBackground", new Color(255, 255, 255));
    res.add("cellLeftBorderType", MlGrid.BORDER_NONE);
    res.add("cellRightBorderType", MlGrid.BORDER_NONE);
    res.add("cellTopBorderType", MlGrid.BORDER_NONE);
    res.add("cellBottomBorderType", MlGrid.BORDER_NONE);
    res.add("cellLeftMargin", 5);
    res.add("cellRightMargin", 5);
    res.add("cellTopMargin", 5);
    res.add("cellBottomMargin", 5);
    grid.setValues(res);

    grid.addRows(10);

    // set span for cell 0, 0
    res.clear();
    res.add("row", 0);
    res.add("column", 0);
    res.add("cellRowSpan", 10);
    grid.setValues(res);

    // add children
    grid.add(0, 0, new TextArea("TextArea"));
    for (i = 0; i < 10; i++)
        {
	Button btn;
	btn = new Button("Button " + (i + 1));
	btn.addActionListener(this);
        grid.setStrings(i, "|Row " + (i + 1));
        grid.add(i, 2, btn);
        }

    grid.setLayoutFrozen(false);
    add("Center", grid);
    }

public void actionPerformed(ActionEvent event)
    {
    MlGridPos pos;

    pos = grid.find((Component)event.getSource());
    if (pos != null)
        System.out.println("Button Activate: " + pos);
    }
}
