//
// @(#)grid3.java	2.2 97/03/25
//
// Copyright (c) 1996-1997 Neuron Data Inc.  All Rights Reserved.
//

// (c) Copyright 1994-1996 Microline Software, Inc. ALL RIGHTS RESERVED
//
// THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE COPIED AND USED
// ONLY IN ACCORDANCE WITH THE TERMS OF THAT LICENSE AND WITH THE INCLUSION
// OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE AND DOCUMENTATION, AND ITS
// COPYRIGHTS ARE OWNED BY MICROLINE SOFTWARE AND ARE PROTECTED BY UNITED
// STATES COPYRIGHT LAWS AND INTERNATIONAL TREATY PROVISIONS.
//
// THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE
// AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MICROLINE SOFTWARE.
//
// THIS SOFTWARE AND REFERENCE MATERIALS ARE PROVIDED "AS IS" WITHOUT
// WARRANTY AS TO THEIR PERFORMANCE, MERCHANTABILITY, FITNESS FOR ANY
// PARTICULAR PURPOSE, OR AGAINST INFRINGEMENT.  MICROLINE SOFTWARE
// ASSUMES NO RESPONSIBILITY FOR THE USE OR INABILITY TO USE THIS
// SOFTWARE.
//
// MICROLINE SOFTWARE SHALL NOT BE LIABLE FOR INDIRECT, SPECIAL OR
// CONSEQUENTIAL DAMAGES RESULTING FROM THE USE OF THIS PRODUCT. SOME
// STATES DO NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR
// CONSEQUENTIAL DAMAGES, SO THE ABOVE LIMITATIONS MIGHT NOT APPLY TO
// YOU.
//
// MICROLINE SOFTWARE SHALL HAVE NO LIABILITY OR RESPONSIBILITY FOR SOFTWARE
// ALTERED, MODIFIED, OR CONVERTED BY YOU OR A THIRD PARTY, DAMAGES
// RESULTING FROM ACCIDENT, ABUSE OR MISAPPLICATION, OR FOR PROBLEMS DUE
// TO THE MALFUNCTION OF YOUR EQUIPMENT OR SOFTWARE NOT SUPPLIED BY
// MICROLINE SOFTWARE.
//
// U.S. GOVERNMENT RESTRICTED RIGHTS
// This Software and documentation are provided with RESTRICTED RIGHTS.
// Use, duplication or disclosure by the Government is subject to
// restrictions as set forth in subparagraph (c)(1) of the Rights in
// Technical Data and Computer Software Clause at DFARS 252.227-7013 or
// subparagraphs (c)(1)(ii) and (2) of Commercial Computer Software -
// Restricted Rights at 48 CFR 52.227-19, as applicable, supplier is
// Microline Software, 41 Sutter St Suite 1374, San Francisco, CA 94104.

import java.awt.*;
import mlsoft.mct.*;
import java.applet.Applet;

public class grid3 extends Applet
{
MlGrid grid;

public void init()
    {
    MlResources res;
    Font boldFont;
    int i;

    setLayout(new BorderLayout());
    res = new MlResources();
    boldFont = new Font("Helvetica", Font.BOLD, 12);

    grid = new MlGrid();

    grid.setLayoutFrozen(true);

    grid.setHsbDisplayPolicy(MlGrid.DISPLAY_ALWAYS);
    grid.setVsbDisplayPolicy(MlGrid.DISPLAY_ALWAYS);
    grid.setHighlightRowMode(false);
    grid.setSelectionPolicy(MlGrid.SELECT_CELL);
    grid.setAllowColumnResize(true);
    grid.setAllowRowResize(true);
    grid.setShadowThickness(1);


    res.clear();
    res.add("cellDefaults", true);
    res.add("cellEditable", true);
    res.add("cellAlignment", "ALIGNMENT_RIGHT");
    res.add("cellBackground", "#ffffff");
    res.add("cellLeftBorderType", "BORDER_NONE");
    res.add("cellTopBorderType", "BORDER_NONE");
    grid.setValues(res);

    grid.setHeadingRows(1);
    grid.setHeadingColumns(1);
    grid.setColumns(26);
    grid.setRows(100);

    for (i = 0; i < 26; i++)
        grid.setStrings(MlGrid.HEADING, 0, MlGrid.CONTENT, i,
            "" + (char)('A' + i));

    for (i = 0; i < 100; i++)
        grid.setStrings(MlGrid.CONTENT, i, MlGrid.HEADING, 0,
            Integer.toString(i + 1));

    res.clear();
    res.add("rowType", "ALL_TYPES");
    res.add("columnType", "HEADING");
    res.add("column", 0);
    res.add("cellAlignment", "ALIGNMENT_CENTER");
    res.add("cellBackground", "#c0c0c0");
    res.add("cellFont", boldFont);
    res.add("cellLeftBorderType", "BORDER_LINE");
    res.add("cellTopBorderType", "BORDER_LINE");
    grid.setValues(res);

    res.clear();
    res.add("rowType", "HEADING");
    res.add("row", 0);
    res.add("cellAlignment", "ALIGNMENT_CENTER");
    res.add("cellBackground", "#c0c0c0");
    res.add("cellFont", boldFont);
    res.add("cellLeftBorderType", "BORDER_LINE");
    res.add("cellTopBorderType", "BORDER_LINE");
    grid.setValues(res);

    grid.setLayoutFrozen(false);

    add("Center", grid);
    }
}
