//
// @(#)demo.java	2.6 97/03/28
//
// Copyright (c) 1996-1997 Neuron Data Inc.  All Rights Reserved.
//

// (c) Copyright 1994-1996 Microline Software, Inc. ALL RIGHTS RESERVED
//
// THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE COPIED AND USED
// ONLY IN ACCORDANCE WITH THE TERMS OF THAT LICENSE AND WITH THE INCLUSION
// OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE AND DOCUMENTATION, AND ITS
// COPYRIGHTS ARE OWNED BY MICROLINE SOFTWARE AND ARE PROTECTED BY UNITED
// STATES COPYRIGHT LAWS AND INTERNATIONAL TREATY PROVISIONS.
//
// THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE
// AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MICROLINE SOFTWARE.
//
// THIS SOFTWARE AND REFERENCE MATERIALS ARE PROVIDED "AS IS" WITHOUT
// WARRANTY AS TO THEIR PERFORMANCE, MERCHANTABILITY, FITNESS FOR ANY
// PARTICULAR PURPOSE, OR AGAINST INFRINGEMENT.  MICROLINE SOFTWARE
// ASSUMES NO RESPONSIBILITY FOR THE USE OR INABILITY TO USE THIS
// SOFTWARE.
//
// MICROLINE SOFTWARE SHALL NOT BE LIABLE FOR INDIRECT, SPECIAL OR
// CONSEQUENTIAL DAMAGES RESULTING FROM THE USE OF THIS PRODUCT. SOME
// STATES DO NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR
// CONSEQUENTIAL DAMAGES, SO THE ABOVE LIMITATIONS MIGHT NOT APPLY TO
// YOU.
//
// MICROLINE SOFTWARE SHALL HAVE NO LIABILITY OR RESPONSIBILITY FOR SOFTWARE
// ALTERED, MODIFIED, OR CONVERTED BY YOU OR A THIRD PARTY, DAMAGES
// RESULTING FROM ACCIDENT, ABUSE OR MISAPPLICATION, OR FOR PROBLEMS DUE
// TO THE MALFUNCTION OF YOUR EQUIPMENT OR SOFTWARE NOT SUPPLIED BY
// MICROLINE SOFTWARE.
//
// U.S. GOVERNMENT RESTRICTED RIGHTS
// This Software and documentation are provided with RESTRICTED RIGHTS.
// Use, duplication or disclosure by the Government is subject to
// restrictions as set forth in subparagraph (c)(1) of the Rights in
// Technical Data and Computer Software Clause at DFARS 252.227-7013 or
// subparagraphs (c)(1)(ii) and (2) of Commercial Computer Software -
// Restricted Rights at 48 CFR 52.227-19, as applicable, supplier is
// Microline Software, 41 Sutter St Suite 1374, San Francisco, CA 94104.

import java.awt.*;
import java.awt.event.*;
import mlsoft.mct.*;
import java.applet.Applet;

class ExampleTabPanel extends MlTabPanel
{
Image dotImage, winImage, boxImage;

ExampleTabPanel(int num)
    {
    if (num == 0)
        {
        makeIcons();
        setValue("marginWidth", 5);
        setValue("spacing", 0);
        add("Tab One", winImage, new Label("Page One", Label.CENTER));
        add("Tab Two", dotImage, new Label("Page Two", Label.CENTER));
        add("Tab Three", boxImage, new Label("Page Three", Label.CENTER));
        }
    else if (num == 1)
        {
        setValue("tabsPerRow", 3);
        setValue("tabPlacement", "TABS_ON_BOTTOM");
        setValue("cornerStyle", "CORNER_NONE");
        add("Tab One", new Label("Page One", Label.CENTER));
        add("Tab Two", new Label("Page Two", Label.CENTER));
        add("Tab Three", new Label("Page Three", Label.CENTER));
        }
    else if (num == 2)
        {
        setValue("tabsPerRow", 3);
        setValue("tabPlacement", "TABS_ON_RIGHT");
        setValue("cornerStyle", "CORNER_LINE");
        add("One", new Label("Page One", Label.CENTER));
        add("Two", new Label("Page Two", Label.CENTER));
        add("Three", new Label("Page Three", Label.CENTER));
        }
    }

public Dimension getPreferredSize()
    {
    return new Dimension(140, 200);
    }

public void makeIcons()
    {
    MlIconMaker im;

    im = new MlIconMaker();
    im.setDimensions(16, 16);
    im.setColor('B', 0xff000080);
    im.setColor('K', 0xff000000);
    im.setColor('G', 0xff808080);

    im.setPixels("                ");
    im.setPixels("                ");
    im.setPixels("                ");
    im.setPixels("                ");
    im.setPixels("      BBBBB     ");
    im.setPixels("     BBBBBBB    ");
    im.setPixels("    BBBBBBBBB   ");
    im.setPixels("   BBB  BBBBBB  ");
    im.setPixels("   BBB BBBBBBB  ");
    im.setPixels("   BBBBBBBBBBB  ");
    im.setPixels("   BBBBBBBBBBB  ");
    im.setPixels("   BBBBBBBBBBB  ");
    im.setPixels("    BBBBBBBBB   ");
    im.setPixels("     BBBBBBB    ");
    im.setPixels("      BBBBB     ");
    im.setPixels("                ");
    dotImage = im.createImage(this);

    im.clear();
    im.setPixels("                ");
    im.setPixels("                ");
    im.setPixels("   KKKKKKKKKKK  ");
    im.setPixels("   KGGGGGGGGGK  ");
    im.setPixels("   KG       GK  ");
    im.setPixels("   KG G GGG GK  ");
    im.setPixels("   KG       GK  ");
    im.setPixels("   KG G GGG GK  ");
    im.setPixels("   KG       GK  ");
    im.setPixels("   KGGGGGGGGGK  ");
    im.setPixels("   KKKKKKKKKKK  ");
    im.setPixels("       KGK      ");
    im.setPixels("       KGK      ");
    im.setPixels("    KKKKKKKKK   ");
    im.setPixels("    KKKKKKKKK   ");
    im.setPixels("                ");
    winImage = im.createImage(this);

    im.clear();
    im.setPixels("                ");
    im.setPixels("                ");
    im.setPixels("   KKKKKKKKKKK  ");
    im.setPixels("   KGGGGGGGGGK  ");
    im.setPixels("   KG       GK  ");
    im.setPixels("   KG  GBG  GK  ");
    im.setPixels("   KG GBBBG GK  ");
    im.setPixels("   KG GBBBG GK  ");
    im.setPixels("   KG  GBG  GK  ");
    im.setPixels("   KGGGGBGGGGK  ");
    im.setPixels("   KGGGBBBGGGK  ");
    im.setPixels("   KGGB   BGGK  ");
    im.setPixels("   KGGBB BBGGK  ");
    im.setPixels("   KKKKKKKKKKK  ");
    im.setPixels("                ");
    im.setPixels("                ");
    boxImage = im.createImage(this);
    }
}

class ExampleGrid extends MlGrid
{
Image upArrow, downArrow;

ExampleGrid(int num)
    {
    MlResources res;
    int i;

    res = new MlResources();
    if (num == 0)
        {
        makeIcons();
        setLayoutFrozen(true);

        setAllowColumnResize(true);
        setSelectionPolicy(MlGrid.SELECT_MULTIPLE_ROW);
        setHeadingRows(1);
        setColumns(7);
        setSimpleWidths("18c 8c 16p 8c 12c 16c 6c");
        setRightFixedCount(1);
        setLeftFixedCount(1);
        setSimpleHeadings("Name|Price||Change|Close Date|Location|Yield");

        // set defaults for content cells
        res.clear();
        res.add("cellDefaults", true);
        res.add("cellBackground", "#ffffff");
        res.add("cellLeftBorderType", "BORDER_NONE");
        res.add("cellRightBorderType", "BORDER_NONE");
        res.add("cellTopBorderType", "BORDER_NONE");
        res.add("cellBottomBorderType", "BORDER_NONE");
        setValues(res);

        res.clear();
        res.add("rowType", "HEADING");
        res.add("column", 1);
        res.add("cellColumnSpan", 1);
        setValues(res);

        res.clear();
        res.add("cellDefaults", true);
        res.add("cellAlignment", "ALIGNMENT_RIGHT");
        setValues(res);

        res.clear();
        res.add("cellDefaults", true);
        res.add("column", 0);
        res.add("cellAlignment", "ALIGNMENT_LEFT");
        setValues(res);

        res.clear();
        res.add("cellDefaults", true);
        res.add("column", 1);
        res.add("cellRightBorderType", "BORDER_NONE");
        setValues(res);

        res.clear();
        res.add("cellDefaults", true);
        res.add("column", 2);
        res.add("cellType", "IMAGE_CELL");
        res.add("cellLeftBorderType", "BORDER_NONE");
        setValues(res);

        addRows(10);

        setStrings(0, "TZZ 3.0 Tana Zin|102.23||-1.2|1/1/94|Tomano, RE|5.6%");
        setStrings(1, "BLC 4.5 Board L|103.23||+2.5|2/15/94|Rino, LO|6.8%");
        setStrings(2, "DGB 5.4 Dig Gen|101.53||+3.7|6/20/94|Carolana, CA|7.5%");
        setStrings(3, "KLC 5.3 Kord L|108.98||-2.5|2/15/94|Cannes, CA|8.7%");
        setStrings(4, "LLO 3.4 Liw Lol|107.24||+2.2|2/20/94|Tenise, MI|6.7%");
        setStrings(5, "MMN 3.1 Mon Mor|105.63||+1.4|2/15/94|Waterton, MN|6.3%");
        setStrings(6, "PLP 4.3 Pol Lab|102.12||-2.3|2/20/94|Holard, LM|7.6%");
        setStrings(7, "SZN 4.5 Siml Zi|101.11||+1.6|2/15/94|Tempest, CA|5.4%");
        setStrings(8, "TTL 5.6 Towa Tin|101.12||+2.7|3/15/94|Conila, OK|6.7%");
        setStrings(9, "ULD 5.4 Upl La D|105.12||-2.2|4/15/94|Mandrill, HI|7.8%");

        res.clear();
        res.add("column", 2);
        res.add("cellImage", upArrow);
        setValues(res);

        res.clear();
        res.add("column", 2);
        res.add("rowStep", 3);
        res.add("cellImage", downArrow);
        setValues(res);

        setLayoutFrozen(false);
        }
    else if (num == 1)
        {
        Font textFont, titleFont, boldFont;

        textFont = new Font("Helvetica", Font.PLAIN, 12);
        boldFont = new Font("Helvetica", Font.BOLD, 12);
        titleFont = new Font("Helevtica", Font.BOLD, 14);

        setLayoutFrozen(true);

        setHeadingColumns(1);
        setColumns(3);
        setFooterColumns(1);
        setSimpleWidths("24c 11c 11c 11c 11c");
        setSelectionPolicy(MlGrid.SELECT_NONE);
        setHighlightRowMode(false);

        // add 'Income Summary' heading row with yellow background
        res.clear();
        res.add("cellDefaults", true);
        res.add("cellBackground", "#FFFF00");
        res.add("cellForeground", "#000080");
        res.add("cellLeftBorderType",  "BORDER_NONE");
        res.add("cellRightBorderType", "BORDER_NONE");
        res.add("cellTopBorderType",   "BORDER_NONE");
        res.add("cellBottomBorderColor", "#000000");
        res.add("cellAlignment", "ALIGNMENT_CENTER");
        setValues(res);

        addRows(MlGrid.HEADING, -1, 1);

        // set span on '1996 Income Summary' cell in heading row
        res.clear();
        res.add("rowType", "HEADING");
        res.add("row", 0);
        res.add("column", 0);
        res.add("cellColumnSpan", 2);
        res.add("cellFont", titleFont);
        setValues(res);

        // Add 'Shampoo Conditioner Soap' heading row with white background
        res.clear();
        res.add("cellDefaults", true);
        res.add("cellFont", boldFont);
        res.add("cellBackground", "#FFFFFF");
        res.add("cellForeground", "#000000");
        res.add("cellBottomBorderType", "BORDER_NONE");
        setValues(res);

        addRows(MlGrid.HEADING, -1, 1);

        // Add content and footer rows with heading column 0 left justified
        res.clear();
        res.add("cellDefaults", true);
        res.add("cellAlignment", "ALIGNMENT_RIGHT");
        res.add("cellFont", textFont);
        setValues(res);

        res.clear();
        res.add("cellDefaults", true);
        res.add("columnType", "HEADING");
        res.add("column", 0);
        res.add("cellAlignment", "ALIGNMENT_LEFT");
        setValues(res);

        addRows(MlGrid.CONTENT, -1, 15);

        // Add footer row with blue background
        res.clear();
        res.add("cellDefaults", true);
        res.add("cellForeground", "#ffffff");
        res.add("cellBackground", "#000080");
        res.add("cellFont", boldFont);
        setValues(res);

        addRows(MlGrid.FOOTER, -1, 1);

        // Bold 'Revenues' cell
        res.clear();
        res.add("columnType", "HEADING");
        res.add("column", 0);
        res.add("row", 0);
        res.add("cellFont", boldFont);
        setValues(res);

        // Bold 'Less Expenses' cell
        res.clear();
        res.add("columnType", "HEADING");
        res.add("column", 0);
        res.add("row", 6);
        res.add("cellFont", boldFont);
        setValues(res);

        // Grey middle and footer content column
        res.clear();
        res.add("columnType", "ALL_TYPES");
        res.add("columnRangeStart", 2);
        res.add("columnRangeEnd", 4);
        res.add("columnStep", 2);
        res.add("cellBackground", "#e0e0e0");
        setValues(res);

        // Grey 'Conditioner' and 'Total' cell in heading row 1
        res.clear();
        res.add("rowType", "HEADING");
        res.add("row", 1);
        res.add("columnType", "ALL_TYPES");
        res.add("columnRangeStart", 2);
        res.add("columnRangeEnd", 4);
        res.add("columnStep", 2);
        res.add("cellBackground", "#e0e0e0");
        setValues(res);

        // Blue and bold 'Net Revenue' and 'Total Expenses' rows
        res.clear();
        res.add("rowRangeStart", 4);
        res.add("rowRangeEnd", 12);
        res.add("rowStep", 8);
        res.add("columnType", "ALL_TYPES");
        res.add("cellForeground", "#ffffff");
        res.add("cellBackground", "#000080");
        res.add("cellFont", boldFont);
        setValues(res);

        setStrings(MlGrid.HEADING, 0, MlGrid.HEADING, 0, "|1996 Income Summary");
        setStrings(MlGrid.HEADING, 1, MlGrid.HEADING, 0, "|Shampoo|Conditioner|Soap|Total");

        setStrings( 0, "Revenues:");
        setStrings( 1, "Sales|$ 1,600,000|$ 1,000,000|$  800,000|$ 3,400,000");
        setStrings( 2, "Less Discounts|(16,000)|(10,000)|(8,000)|(34,000)");
        setStrings( 3, "Less Return Allowance|(8,000)|(5,000)|(4,000)|(17,000)");
        setStrings( 4, "  Net Revenue|1,576,000|985,000|792,000|3,349,000");

        setStrings( 6, "Less Expenses:");
        setStrings( 7, "Cost of Goods Sold|(640,000)|(330,000)|(264,000)|(1,234,000)");
        setStrings( 8, "Salary Expense|(380,000)|(280,000)|(180,000)|(840,000)");
        setStrings( 9, "Marketing Expense|(157,600)|(98,500)|(79,200)|(335,300)");
        setStrings(10, "Rent Expense|(36,000)|(36,000)|(36,000)|(108,000)");
        setStrings(11, "Misc. Other Expense|(36,408)|(22,335)|(16,776)|(75,519)");
        setStrings(12, "  Total Expenses|(1,250,008)|(766,835)|(575,976)|(2,592,819)");

        setStrings(14, "Income Tax Expense|(130,397)|(87,266)|(86,410)|(304,072)");
        setStrings(MlGrid.FOOTER, 0, MlGrid.HEADING, 0, "Net Income|195,595|130,899|129,614|456,109");

        setLayoutFrozen(false);
        }
    else if (num == 2)
        {
        Font boldFont;

        boldFont = new Font("Helvetica", Font.BOLD, 12);

        setLayoutFrozen(true);

        setHsbDisplayPolicy(MlGrid.DISPLAY_ALWAYS);
        setVsbDisplayPolicy(MlGrid.DISPLAY_ALWAYS);
        setHighlightRowMode(false);
        setSelectionPolicy(MlGrid.SELECT_CELL);
        setAllowColumnResize(true);
        setAllowRowResize(true);
        setShadowThickness(1);

        res.clear();
        res.add("cellDefaults", true);
        res.add("cellEditable", true);
        res.add("cellAlignment", "ALIGNMENT_RIGHT");
        res.add("cellBackground", "#ffffff");
        res.add("cellLeftBorderType", "BORDER_NONE");
        res.add("cellTopBorderType", "BORDER_NONE");
        setValues(res);

        res.clear();
        res.add("headingRows", 1);
        res.add("headingColumns", 1);
        res.add("columns", 26);
        res.add("rows", 100);
        setValues(res);

        for (i = 0; i < 26; i++)
            setStrings(MlGrid.HEADING, 0, MlGrid.CONTENT, i,
                "" + (char)('A' + i));

        for (i = 0; i < 100; i++)
            setStrings(MlGrid.CONTENT, i, MlGrid.HEADING, 0,
                Integer.toString(i + 1));

        res.clear();
        res.add("rowType", "ALL_TYPES");
        res.add("columnType", "HEADING");
        res.add("column", 0);
        res.add("cellAlignment", "ALIGNMENT_CENTER");
        res.add("cellBackground", "#c0c0c0");
        res.add("cellFont", boldFont);
        res.add("cellLeftBorderType", "BORDER_LINE");
        res.add("cellTopBorderType", "BORDER_LINE");
        setValues(res);

        res.clear();
        res.add("rowType", "HEADING");
        res.add("row", 0);
        res.add("cellAlignment", "ALIGNMENT_CENTER");
        res.add("cellBackground", "#c0c0c0");
        res.add("cellFont", boldFont);
        res.add("cellLeftBorderType", "BORDER_LINE");
        res.add("cellTopBorderType", "BORDER_LINE");
        setValues(res);

        setLayoutFrozen(false);
        }
    }

public Dimension getPreferredSize()
    {
    return new Dimension(140, 200);
    }

public void makeIcons()
    {
    MlIconMaker im;

    im = new MlIconMaker();
    im.setDimensions(12, 16);
    im.setColor('G', 0xff008000);
    im.setColor('R', 0xff800000);

    im.setPixels("            ");
    im.setPixels("     GG     ");
    im.setPixels("    GGGG    ");
    im.setPixels("   GGGGGG   ");
    im.setPixels("  GGGGGGGG  ");
    im.setPixels(" GGGGGGGGGG ");
    im.setPixels(" GGGGGGGGGG ");
    im.setPixels(" GG GGGG GG ");
    im.setPixels(" G  GGGG  G ");
    im.setPixels("    GGGG    ");
    im.setPixels("    GGGG    ");
    im.setPixels("    GGGG    ");
    im.setPixels("    GGGG    ");
    im.setPixels("    GGGG    ");
    im.setPixels("    GGGG    ");
    im.setPixels("            ");
    upArrow = im.createImage(this);

    im.clear();
    im.setPixels("            ");
    im.setPixels("    RRRR    ");
    im.setPixels("    RRRR    ");
    im.setPixels("    RRRR    ");
    im.setPixels("    RRRR    ");
    im.setPixels("    RRRR    ");
    im.setPixels("    RRRR    ");
    im.setPixels(" R  RRRR  R ");
    im.setPixels(" RR RRRR RR ");
    im.setPixels(" RRRRRRRRRR ");
    im.setPixels(" RRRRRRRRRR ");
    im.setPixels("  RRRRRRRR  ");
    im.setPixels("   RRRRRR   ");
    im.setPixels("    RRRR    ");
    im.setPixels("     RR     ");
    im.setPixels("            ");
    downArrow = im.createImage(this);
    }
}

class ExampleProgress extends MlProgress
{
ExampleProgress(int num)
    {

    if (num == 0)
        {
        setBackground(new Color(0xffffff));
        setForeground(new Color(0x000060));
        setValue(50);
        }
    else if (num == 1)
        {
        setBackground(new Color(0xffffff));
        setForeground(new Color(0x000060));
        setShadowThickness(1);
        setMeterStyle(MlProgress.METER_BOXES);
        setNumBoxes(20);
        setValue(60);
        }
    else if (num == 2)
        {
        setBackground(new Color(0xffffff));
        setForeground(new Color(0xaa0000));
        setValue(80);
        }
    }

public Dimension getPreferredSize()
    {
    return new Dimension(140, 20);
    }
}

class ExampleTree extends MlTree
{
Image dotImage, winImage;
static boolean expands1[] = { true, true, true, false, false,
    false, true, false, false, false };
static boolean expands2[] = { true, true, true, false, false,
    false, true, false, false, true };
static int levels[] = { 0, 1, 2, 3, 2, 2, 1, 2, 2, 2 };

ExampleTree(int num)
    {
    MlResources res;
    MlTreeRowDefinition rows[];
    String s;
    int i, n;

    res = new MlResources();
    if (num == 0)
        {
        setHeadingRows(1);
        setColumns(5);
        setSimpleHeadings("Object|Position|Size|Method|Note");
        setSimpleWidths("1c 10c 10c 15c 15c");
        setAllowColumnResize(true);

        res.clear();
        res.add("rowType", "HEADING");
        res.add("cellBackground", "#c0c0c0");
        res.add("cellLeftBorderType", "BORDER_LINE");
        res.add("cellRightBorderType", "BORDER_LINE");
        res.add("cellTopBorderType", "BORDER_LINE");
        res.add("cellBottomBorderType", "BORDER_LINE");
        setValues(res);

        res.clear();
        res.add("cellDefaults", true);
        res.add("column", 2);
        res.add("cellAlignment", "ALIGNMENT_RIGHT");
        setValues(res);

        n = 100;
        rows = new MlTreeRowDefinition[n];
        for (i = 0; i < n; i++)
            {
            rows[i] = new MlTreeRowDefinition();
            rows[i].level = levels[i % 10];
            rows[i].expands = expands1[i % 10];
            rows[i].isExpanded = true;
            if (rows[i].expands)
                rows[i].string = "Composite";
            else if ((i % 5) > 0)
                rows[i].string = "Curve";
            else
                rows[i].string = "Surface";
            }

        addRows(rows, 0);
        for (i = 0; i < n; i++)
            setStrings(MlGrid.CONTENT, i, MlGrid.CONTENT, 1,
                (i % 20) + " " + (i % 15) + "|" + (i % 4) +
                " points|Open|In Progress");
        }
    else if (num == 1)
        {
        makeIcons();

        setSelectionPolicy(MlTree.SELECT_MULTIPLE_ROW);
        setGlobalImageWidth(16);
        setGlobalImageHeight(16);

        n = 100;
        rows = new MlTreeRowDefinition[n];
        for (i = 0; i < n; i++)
            {
            rows[i] = new MlTreeRowDefinition();
            rows[i].level = levels[i % 10];
            if (i % 30 >= 10)
                rows[i].level += 3;
            if (i % 30 >= 20)
                rows[i].level += 3;
            rows[i].expands = expands2[i % 10];
            if (rows[i].expands)
                rows[i].image = dotImage;
            else
                rows[i].image = winImage;
            rows[i].isExpanded = true;
            if (rows[i].expands)
                rows[i].string = "Sector Number " + rows[i].level + "-" +
                    (i % 2) + (i + 413);
            else
                rows[i].string = "Item Number " + (i % 12) + (i % 3) + (i % 2);
            }
        addRows(rows, 0);
        }
    else if (num == 2)
        {
        setLayoutFrozen(true);
        addRow(0, true,"Root");
        addRow(1, true, "Level 1 Parent");
        addRow(2, false,"1st Child of Level 1 Parent");
        addRow(2, false,"2nd Child of Level 1 Parent");
        addRow(2, true, "Level 2 Parent");
        addRow(3, false, "Child of Level 2 Parent");
        addRow(1, true, "Level 1 Parent");
        addRow(2, false, "Child of Level 1 Parent");
        setLayoutFrozen(false);
        }
    }

public Dimension getPreferredSize()
    {
    return new Dimension(140, 200);
    }

public void makeIcons()
    {
    MlIconMaker im;

    im = new MlIconMaker();
    im.setDimensions(16, 16);
    im.setColor('B', 0xff000080);
    im.setColor('K', 0xff000000);
    im.setColor('G', 0xff808080);

    im.setPixels("                ");
    im.setPixels("                ");
    im.setPixels("                ");
    im.setPixels("                ");
    im.setPixels("      BBBBB     ");
    im.setPixels("     BBBBBBB    ");
    im.setPixels("    BBBBBBBBB   ");
    im.setPixels("   BBB  BBBBBB  ");
    im.setPixels("   BBB BBBBBBB  ");
    im.setPixels("   BBBBBBBBBBB  ");
    im.setPixels("   BBBBBBBBBBB  ");
    im.setPixels("   BBBBBBBBBBB  ");
    im.setPixels("    BBBBBBBBB   ");
    im.setPixels("     BBBBBBB    ");
    im.setPixels("      BBBBB     ");
    im.setPixels("                ");
    dotImage = im.createImage(this);

    im.clear();
    im.setPixels("                ");
    im.setPixels("                ");
    im.setPixels("   KKKKKKKKKKK  ");
    im.setPixels("   KGGGGGGGGGK  ");
    im.setPixels("   KG       GK  ");
    im.setPixels("   KG G GGG GK  ");
    im.setPixels("   KG       GK  ");
    im.setPixels("   KG G GGG GK  ");
    im.setPixels("   KG       GK  ");
    im.setPixels("   KGGGGGGGGGK  ");
    im.setPixels("   KKKKKKKKKKK  ");
    im.setPixels("       KGK      ");
    im.setPixels("       KGK      ");
    im.setPixels("    KKKKKKKKK   ");
    im.setPixels("    KKKKKKKKK   ");
    im.setPixels("                ");
    winImage = im.createImage(this);
    }
}

class CoverPage extends Panel
{
String string1, string2, string3;

CoverPage()
    {
    string1 = new String("A Quick Look at the");
    string2 = new String("Microline Component Toolkit");
    string3 = DemoText.getString("Version");
    setFont(new Font("TimesRoman", Font.PLAIN, 20));
    setLayout(new BorderLayout());
    }

public void paint(Graphics graphics)
    {
    Dimension size = this.getSize();
    graphics.setColor(new Color(255, 255, 255));
    graphics.drawChars(string1.toCharArray(), 0, string1.length(),
        15, size.height / 2 - 26);
    graphics.drawChars(string2.toCharArray(), 0, string2.length(),
        size.width - 290, size.height / 2);
    graphics.drawChars(string3.toCharArray(), 0, string3.length(),
        size.width - 70, size.height / 2 + 26);
    graphics.setColor(new Color(0, 0, 0));
    graphics.drawChars(string1.toCharArray(), 0, string1.length(),
        15 - 1, size.height / 2 - 26 - 1);
    graphics.drawChars(string2.toCharArray(), 0, string2.length(),
        size.width - 290 - 1, size.height / 2 - 1);
    graphics.drawChars(string3.toCharArray(), 0, string3.length(),
        size.width - 70 - 1, size.height / 2 + 26 - 1);
    }
}

// a Panel which places its children indented

class InsetPanel extends Panel
{
Insets insets;

InsetPanel(int lr, int tb)
    {
    insets = new Insets(tb, lr, tb, lr);
    setLayout(new BorderLayout());
    }

InsetPanel(int t, int l, int b, int r)
    {
    insets = new Insets(t, l, b, r);
    setLayout(new BorderLayout());
    }

public Insets getInsets()
    {
    return insets;
    }
}

// the sample Panel at the top of the window presenting three
// examples of each component

class SamplePanel extends Panel implements ActionListener
{
Panel pages;
CardLayout cards;
EmButton b1, b2, b3;

SamplePanel(String name)
    {
    Panel buttonPanel;

    setLayout(new BorderLayout(0, 10));
    pages = new Panel();
    cards = new CardLayout();
    pages.setLayout(cards);
    addPage(name, 0);
    addPage(name, 1);
    addPage(name, 2);
    add("Center", pages);

    buttonPanel = new Panel();
    buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 0));
    b1 = new EmButton("Sample 1", true);
    b1.addActionListener(this);
    buttonPanel.add(b1);
    b2 = new EmButton("Sample 2", false);
    b2.addActionListener(this);
    buttonPanel.add(b2);
    b3 = new EmButton("Sample 3", false);
    b3.addActionListener(this);
    buttonPanel.add(b3);
    add("South", buttonPanel);
    }

public void actionPerformed(ActionEvent event)
    {
    if (event.getSource() == b1)
        {
        cards.show(pages, "page1");
        b2.set(false);
        b3.set(false);
        }
    else if (event.getSource() == b2)
        {
        cards.show(pages, "page2");
        b1.set(false);
        b3.set(false);
        }
    else if (event.getSource() == b3)
        {
        cards.show(pages, "page3");
        b1.set(false);
        b2.set(false);
        }
    }

void addPage(String compName, int num)
    {
    Panel panel;
    Component comp;

    if (compName.equals("Progress"))
        {
        panel = new InsetPanel(2, 80);
        comp = new ExampleProgress(num);
        panel.add("North", comp);
        }
    else
        {
        panel = new Panel();
        panel.setLayout(new BorderLayout());
        if (compName.equals("Grid"))
            comp = new ExampleGrid(num);
        else if (compName.equals("Tree"))
            comp = new ExampleTree(num);
        else
            comp = new ExampleTabPanel(num);
        panel.add("Center", comp);
        }
    pages.add("page" + (num + 1), panel);
    }
}

// simple Embossed Button

class EmButton extends Canvas
{
String label;
Color topColor, botColor;
boolean set;
ActionListener actionListener;

EmButton(String label, boolean set)
    {
    setBackground(new Color(192, 192, 192));
    topColor = new Color(240, 240, 240);
    botColor = new Color(40 ,40, 40);
    setFont(new Font("Helvetica", Font.PLAIN, 12));
    this.label = label;
    this.set = set;
    enableEvents(AWTEvent.MOUSE_EVENT_MASK | AWTEvent.KEY_EVENT_MASK);
    }

public synchronized void addActionListener(ActionListener l)
    {
    actionListener = AWTEventMulticaster.add(actionListener, l);
    }

public synchronized void removeActionListener(ActionListener l)
    {
    actionListener = AWTEventMulticaster.remove(actionListener, l);
    }

public Dimension getPreferredSize()
    {
    return new Dimension(95, 22);
    }

public void paint(Graphics g)
    {
    Rectangle rect;
    int width, height;
    Color tc, bc;

    g.setColor(getBackground());
    g.fillRect(0, 0, getBounds().width, getBounds().height);
    width = getBounds().width;
    height = getBounds().height;
    MlUtil.drawShadow(g, 0, 0, width, height, 1, botColor, topColor);
    MlUtil.drawShadow(g, 1, 1, width - 2, height - 2, 2,
        new Color(192, 192, 192), new Color(192, 192, 192));
    if (set)
        {
        tc = botColor;
        bc = topColor;
        }
    else
        {
        tc = topColor;
        bc = botColor;
        }
    MlUtil.drawShadow(g, 2, 2, width - 4, height - 4, 1, tc, bc);
    g.setColor(new Color(0, 0, 0));
    rect = getBounds();
    rect.x = 0;
    rect.y = 0;
    MlUtil.drawString(g, label, getFont(), MlUtil.ALIGNMENT_CENTER,
        rect, rect);
    }

public void set(boolean flag)
    {
    this.set = flag;
    repaint();
    }

public void set(String label)
    {
    Graphics g = getGraphics();
    this.label = label;
    paint(g);
    g.dispose();
    }

public void processEvent(AWTEvent e)
    {
    switch (e.getID())
        {
        case MouseEvent.MOUSE_PRESSED:
        case KeyEvent.VK_ENTER:
            set(true);
            processActionEvent(
                new ActionEvent(this, ActionEvent.ACTION_PERFORMED, label));
            return;
        }
    super.processEvent(e);
    }

public void processActionEvent(ActionEvent e)
    {
    if (actionListener != null)
        actionListener.actionPerformed(e);
    }
}

// simple display of scrollable word-wrapped text

class VertText extends Panel implements AdjustmentListener
{
String string;
Scrollbar scrollbar;

VertText()
    {
    setBackground(new Color(192, 192, 192));
    setFont(new Font("Helvetica", Font.PLAIN, 12));
    string = new String();
    scrollbar = new Scrollbar();
    add(scrollbar);
    scrollbar.addAdjustmentListener(this);
    }

public void appendText(String s)
    {
    string += s;
    doLayout();
    }

public void doLayout()
    {
    int h, bh, bw;

    bh = getBounds().height;
    bw = getBounds().width;
    h = MlUtil.calcWrapTextHeight(getFont(), string, bw);
    if (bh <= 0 || h <= bh)
        {
        scrollbar.setVisible(false);
        scrollbar.setValue(0);
        }
    else
        {
        h = MlUtil.calcWrapTextHeight(getFont(), string, bw - 20);
        scrollbar.setBounds(bw - 15, 0, 15, bh);
        scrollbar.setValues(0, bh, 0, h);
        scrollbar.setVisible(true);
        }
    }

public void paint(Graphics g)
    {
    Dimension d;

    g.setColor(getBackground());
    g.fillRect(0, 0, getBounds().width, getBounds().height);
    d = getSize();
    if (scrollbar.isVisible())
        d.width -= 20;
    g.setColor(new Color(0, 0, 0));
    g.setFont(getFont());
    MlUtil.drawWrapText(g, getFont(), string, -(scrollbar.getValue()), d);
    }

public void adjustmentValueChanged(AdjustmentEvent e)
    {
    scroll(scrollbar.getValue());
/*
    switch (e.getAdjustmentType())
        {
        // work around scrollbar bugs in the JDK 1.02
        case AdjustmentEvent.UNIT_INCREMENT:
        scroll(scrollbar.getValue() - 10);
            break;
        case AdjustmentEvent.UNIT_DECREMENT:
             scroll(scrollbar.getValue() + 10);
             break;
        // case AdjustmentEvent.SCROLL_ABSOLUTE:
        case AdjustmentEvent.BLOCK_DECREMENT:
        case AdjustmentEvent.BLOCK_INCREMENT:
            scroll(scrollbar.getValue());
            break;
        }
*/
    }

void scroll(int pos)
    {
    // work around scrollbar bugs in the JDK 1.02
    /*
    if (pos < 0)
        pos = 0;
    if (pos > scrollbar.getMaximum())
        pos = scrollbar.getMaximum();
    scrollbar.setValues(pos, scrollbar.getVisibleAmount(),
    scrollbar.getMinimum(), scrollbar.getMaximum());
    */
    repaint();
    }
}

// wrapper for static strings

class DemoText
{
public static String getString(String name)
    {
    if (name.equals("Version"))
        {
        int majorVer = MlUtil.version() / 100;
        int minorVer = MlUtil.version() - majorVer * 100;
        return ("" + majorVer + "." + minorVer);
        }
    else if (name.equals("Cover"))
        return coverString();
    else if (name.equals("Intro"))
        return introString();
    else if (name.equals("TabPanel"))
        return tabPanelString();
    else if (name.equals("Grid"))
        return gridString();
    else if (name.equals("Progress"))
        return progressString();
    else
        return treeString();
    }

public static String coverString()
    {
    return "(c) Copyright 1996-1997 Neuron Data";
    }

public static String introString()
    {
    String s;

    s= "Welcome to a Quick Look at the Microline Component "
    +  "Toolkit " + DemoText.getString("Version") + ".\n\n"

    +  "This program presents an overview of the user-interface "
    +  "components contained in the Toolkit.\n\n"

    +  "Further information on the Microline Component Toolkit "
    +  "for Java including licensing, pricing, etc. may be "
    +  "found on our web site http://www.neurondata.com.  You can "
    +  "email us at mlsupport@neurondata.com.\n\n"

    +  "Microline Component Toolkit is a trademark of Neuron "
    +  "Data.  JAVA is a trademark of Sun Microsystems. All "
    +  "other trademarks are the property of their respective owners.";
    return s;
    }

public static String tabPanelString()
    {
    String s;

    s= "The TabPanel component provides a tabbed panel containing "
    +  "single or multiple rows of tabs along the top, "
    +  "bottom, left or right and an area managed by the "
    +  "tabs in the center.\n\n"

    +  "The first sample above contains a single row of tabs "
    +  "with arc-style corners and images in each tab.\n\n"

    +  "The second sample also contains a single row of "
    +  "tabs but placed on the bottom with the 'none' corner "
    +  "style.  If you increase the width of the demo program, "
    +  "you will notice that this row of tabs will always fill "
    +  "the entire row with the individual tabs taking up a "
    +  "width proportional to their contents and the width "
    +  "of the row.\n\n"

    +  "The third sample contains a row of tabs placed "
    +  "on the right.  Again, the size of the tabs are "
    +  "proportional to the size of their contents and will "
    +  "fit to the row.\n\n"

    +  "The TabPanel allows panels in the page area to be attached "
    +  "to tabs so selecting a tab changes the page, or an application "
    +  "can add tabs and manage changing the page area "
    +  "itself as tabs are selected.\n\n"

    +  "Resources (properties) exist to set the style of the corners, "
    +  "images to display in the tabs, number of tabs per "
    +  "row, various colors, sizes and spacing in and around "
    +  "the tabs.  Also, resources exist for the tabs, "
    +  "allowing you to get/set the font, string or image for "
    +  "individual tabs dynamically.\n\n"

    +  "Tabs may be be added or deleted at any position and "
    +  "events are generated when tabs are activated.\n\n"

    +  "Keyboard traversal and activation of the tabs is "
    +  "supported by using the arrow keys to move from one tab "
    +  "and the Space or Return key to select a tab.";
    return s;
    }

public static String gridString()
    {
    String s = new String();

    s= "The Grid component provides an editable grid of "
    +  "cells containing text, images or components in "
    +  "rows and columns.\n\n"

    +  "The first sample above is a multiple row selection "
    +  "Grid with one heading row displaying images (the up and "
    +  "down arrows) in cells.\n\n"

    +  "The second sample demonstrates cell spanning "
    +  "(the 1995 Income Summary heading spans 2 columns) "
    +  "and control of cell borders, colors and alignment.  "
    +  "This Grid is set to not allow selection.  You will "
    +  "may need to resize the window larger to see "
    +  "this Grid fully.\n\n"

    +  "The third sample allows editing and is set to allow "
    +  "selection of multiple rows, columns and/or cells.  "
    +  "Note that an edit may be accepted by pressing Return "
    +  "or by moving to a new location and may be rejected with "
    +  "the Escape key.  You may edit an existing cell's contents "
    +  "using the F2 key.  This Grid also supports "
    +  "interactive row and column resizing.\n\n"

    +  "The Grid includes a number of advanced features such as:\n"
    +  " - text, images or components in cells\n"
    +  " - a wide variety of selection policies\n"
    +  " - intuitive editing\n"
    +  " - keyboard traversal using arrow keys, page keys, etc.\n"
    +  " - add, delete, reorder, move and hiding of rows/columns\n"
    +  " - heading, content and footer rows/columns\n"
    +  " - top, bottom, left and/or right fixed rows/columns\n"
    +  " - rows/column intelligently size to cell fonts/images\n"
    +  " - user-adjustable row/column sizes\n"
    +  " - cells may span rows/columns\n"
    +  " - full control of cell borders and colors\n"
    +  " - 9 cell alignment options (top-left, center, etc)\n"
    +  " - uses reference-counted cell attributes to save memory\n"
    +  " - intuitive resource set/get on ranges of cells/rows/columns\n"
    +  " - events for select, activate, draw, edit, focus, etc.\n"
    +  "\n"

    +  "The Grid component is ideal for replacing single-column "
    +  "scrolled lists with multi-column lists.  It's "
    +  "also perfect for creating high-performance tables.  "
    +  "Tables may be created where the data displayed is not "
    +  "kept in the Grid itself but retrieved from a database "
    +  "when it needs to be displayed.  This direct database "
    +  "access can save memory and time loading/storing the "
    +  "table.  Click-sorting may be added to the table to "
    +  "allow a user to sort rows by clicking on a column "
    +  "heading.\n\n"

    +  "Cell attributes in the Grid are reference counted.  "
    +  "If a number of cells in the Grid have similar "
    +  "attributes (color, fonts, etc) they may all contain "
    +  "a pointer to the same attributes structure instead "
    +  "of creating an attributes structure for each individual "
    +  "cell.  This reference counting is transparent to a "
    +  "programmer creating a Grid.\n\n"

    +  "Cells may have borders set on the top, bottom, left "
    +  "and right and have a number of color/alignment "
    +  "options.  Keyboard traversal is supported using the "
    +  "page keys, arrow keys, home and end, etc. "
    +  "Selection modes are provided to allow "
    +  "selection of a single row (browse mode or single "
    +  "mode), multiple rows and arbitrary regions of rows, "
    +  "columns and cells.";
    return s;
    }

public static String progressString()
    {
    String s = new String();

    s= "The Progress component may be used to chart the "
    +  "completion of a task.\n\n"

    +  "The first sample displays a standard "
    +  "bar-style Progress component.\n\n"

    +  "The second sample displays a box-style Progress "
    +  "component with 20 boxes.\n\n"

    +  "The third sample contains a bar-style "
    +  "Progress component in red.\n\n"

    +  "Resources exist to set colors, fonts, shadows, the "
    +  "style of the meter bar and the values used to "
    +  "determine level of completeness. The Progress component "
    +  "also supports the display of estimated time to completion "
    +  "(when requested). This estimated time is displayed in "
    +  "the bar itself.";
    return s;
    }

public static String treeString()
    {
    String s = new String();

    s= "The Tree component may be used to display "
    +  "hierarchical data and parent-child relationships.\n\n"

    +  "The first sample displays a Tree in browse "
    +  "select mode containing multiple columns.  The columns "
    +  "support interactive resizing by dragging a column "
    +  "heading larger or smaller. The plus and minus indicators "
    +  "may be used to expand and collapse rows.  Activating a "
    +  "row with Return or by double clicking on it will toggle "
    +  "the expanded state of the row.\n\n"

    +  "The second sample contains a Tree in multiple "
    +  "select mode with customized images.  Note that when "
    +  "horizontal scrolling is required, it is on "
    +  "a per-pixel basis while vertical scrolling is on a "
    +  "per-row basis and the horizontal and vertical scrollbars "
    +  "only appear as needed.\n\n"

    +  "The third sample displays a simple Tree with the "
    +  "default images.\n\n"

    +  "The Tree is a subclass of the Grid, meaning "
    +  "it includes all the functionality of the Grid.  "
    +  "This includes selection policies of single row, "
    +  "multiple row, etc. as well as full control over colors, "
    +  "fonts, alignment, borders, etc. on a per-cell basis.  "
    +  "The Tree also supports all the other features of the "
    +  "Grid, including heading, content and footer rows and "
    +  "columns, various cell types etc.\n\n"

    +  "An application may add rows to the Tree and let the "
    +  "Tree handle the expansion and collapse of rows, "
    +  "or for large trees, an application may handle the "
    +  "expansion and collapse of rows by adding (creating) "
    +  "and hiding or deleting rows dynamically as needed.\n\n"

    +  "Events are generated for expansion and collapse of rows as "
    +  "well as for selection, resizing, etc."

    +  "Resources exist to set the indent level, various colors, "
    +  "etc. As stated earlier, the Tree also contains all the "
    +  "resources available in the Grid.";
    return s;
    }
}

class DemoPanel extends MlTabPanel
{
DemoPanel(EmButton progButton)
    {
    setHighlightThickness(1);
    setMarginHeight(0);
    setTabsPerRow(3);

    setFont(new Font("Helvetica", Font.PLAIN, 12));
    progButton.set("Loading..62%");
    addPage("Cover");
    progButton.set("Loading..64%");
    addPage("Intro");
    progButton.set("Loading..66%");
    addPage("Grid");
    progButton.set("Loading..68%");
    addPage("Tree");
    progButton.set("Loading..70%");
    addPage("TabPanel");
    progButton.set("Loading..72%");
    addPage("Progress");
    progButton.set("Loading..74%");
    }

void addPage(String name)
    {
    Panel panel;
    Label label;
    InsetPanel insetPanel, vpanel;
    VertText vtext;

    panel = new Panel();
    panel.setLayout(new BorderLayout());
    if (name.equals("Cover"))
        {
        panel.add("Center", new CoverPage());
        label = new Label(DemoText.getString(name));
        label.setAlignment(Label.CENTER);
        panel.add("South", label);
        }
    else if (name.equals("Intro"))
        {
        vpanel = new InsetPanel(10, 80);
        vtext = new VertText();
        vtext.appendText(DemoText.getString(name));
        vpanel.add("Center", vtext);
        panel.add("Center", vpanel);
        }
    else
        {
        panel.add("North", new SamplePanel(name));
        vtext = new VertText();
        vtext.appendText(DemoText.getString(name));
        vpanel = new InsetPanel(10, 0, 0, 0);
        vpanel.add("Center", vtext);
        panel.add("Center", vpanel);
        }
    insetPanel = new InsetPanel(15, 15);
    insetPanel.add("Center", panel);
    add(name, insetPanel);
    }
}

// button with standard (100, 24) size

class StButton extends Button
{
StButton(String label)
    {
    super(label);
    }

public Dimension getPreferredSize()
    {
    return new Dimension(100, 24);
    }
}

// main frame

class DemoFrame extends Frame implements ActionListener
{
DemoPanel demoPanel;
StButton closeButton;

DemoFrame(EmButton progButton)
    {
    super("Microline Component Toolkit Demo");
    Panel insetPanel, botPanel, buttonPanel;

    setLayout(new BorderLayout());
    setBackground(new Color(192, 192, 192));
    demoPanel = new DemoPanel(progButton);
    insetPanel = new InsetPanel(10, 10, 0, 10);
    insetPanel.add("Center", demoPanel);
    add("Center", insetPanel);

    botPanel = new InsetPanel(6, 0);
    buttonPanel = new Panel();
    buttonPanel.setLayout(new FlowLayout());

    closeButton = new StButton("Close");
    closeButton.addActionListener(this);
    buttonPanel.add(closeButton);
    botPanel.add("East", buttonPanel);
    add("South", botPanel);
    }

public void actionPerformed(ActionEvent event)
    {
    setVisible(false);
    }
}

public class demo extends Applet implements ActionListener
{
Frame demoFrame;
EmButton button;

public void init()
    {
    Panel insetPanel;

    setLayout(new BorderLayout());
    button = new EmButton("Show Demo", false);
    add("Center", button);
    button.addActionListener(this);
    }

public void actionPerformed(ActionEvent event)
    {
    if (demoFrame == null)
        {
        button.set(true);
        button.set("Loading..00%");
        new MlProgress();
        new MlResources();
        button.set("Loading..20%");
        new MlGrid();
        button.set("Loading..45%");
        new SamplePanel("Progress");
        button.set("Loading..60%");
        demoFrame = new DemoFrame(button);
        button.set("Loading..80%");
        // add(demoFrame);
        demoFrame.setSize(new Dimension(410, 560));
        button.set("Demo Created");
        }
    demoFrame.show();
    }
}
