/*
 * Decompiled with CFR 0.152.
 */
package com.activated.jimi.filters;

import com.activated.jimi.filters.ImageFilterPlus;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;

public abstract class RGBAllFilter
extends ImageFilterPlus {
    private int G = -1;
    private int H = -1;
    private int[][] I;

    public RGBAllFilter(ImageProducer imageProducer) {
        super(imageProducer);
    }

    public abstract void filterRGBAll(int var1, int var2, int[][] var3);

    public void setPixels(int n2, int n3, int[][] nArray) {
        this.consumer.setDimensions(n2, n3);
        int n4 = 0;
        while (n4 < n3) {
            this.consumer.setPixels(0, n4, n2, 1, ImageFilterPlus.rgbModel, nArray[n4], 0, n2);
            ++n4;
        }
    }

    public void setColorModel(ColorModel colorModel) {
        this.consumer.setColorModel(ImageFilterPlus.rgbModel);
    }

    public void setDimensions(int n2, int n3) {
        if (n2 == this.G && n3 == this.H) {
            return;
        }
        this.G = n2;
        this.H = n3;
        this.I = new int[n3][n2];
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, byte[] byArray, int n6, int n7) {
        int n8 = 0;
        while (n8 < n5) {
            int n9 = n8 * n7 + n6;
            int n10 = 0;
            while (n10 < n4) {
                this.I[n3 + n8][n2 + n10] = colorModel.getRGB(byArray[n9 + n10] & 0xFF);
                ++n10;
            }
            ++n8;
        }
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, int[] nArray, int n6, int n7) {
        int n8 = 0;
        while (n8 < n5) {
            int n9 = n8 * n7 + n6;
            if (colorModel == ImageFilterPlus.rgbModel) {
                System.arraycopy(nArray, n9, this.I[n3 + n8], n2, n4);
            } else {
                int n10 = 0;
                while (n10 < n4) {
                    this.I[n3 + n8][n2 + n10] = colorModel.getRGB(nArray[n9 + n10]);
                    ++n10;
                }
            }
            ++n8;
        }
    }

    public void imageComplete(int n2) {
        if (n2 == 1 || n2 == 4) {
            super.imageComplete(n2);
            return;
        }
        this.filterRGBAll(this.G, this.H, this.I);
        super.imageComplete(n2);
    }
}

