NETCFG(1)                P32 Programmer's Manual                  NETCFG(1)

NAME
        netcfg - display a network configuration dialog

SYNOPSIS
        netcfg ifn

DESCRIPTION
        Netcfg displays a network configuration dialog for the specified
        P32 network adapter. Argument ifn may have one of the following
        values:

            2   ETH1    generates netcfg2
            3   ETH2    generates netcfg3
            4   ETH3    generates netcfg4
            5   ETH4    generates netcfg5

        The dialog box writes its contents to the appropriate netcfg file
        when the OK button is clicked. The netcfg files have the following
        format:
        
            Ethernet Adapter      = 0001
            IP Addr               = 192.168.1.10
            Primary Interface     = false
            Mask                  = 255.255.255.0
            Gateway               = 0.0.0.0
            Name Server           = 137.92.1.1   
            Microsoft IP Address  = Auto 

        The Ethernet Adapter is the NDIS3 Adapter Name and available names
        are displayed in the drop-down list box.

        The IP Addr is the address which P32 is to use for this adapter.
        This address must be on the same network as the host stack.
        If no host stack is attached to the interface, or if the host stack
        has been released (via winipcfg release), the DHCP checkbox can be 
        selected. The DHCP bootstrap protocol will then be used to determine 
        most required values and only the Ethernet Adapter field and, 
        optionally, the Mask field will have significance.
        
        The Primary Interface is the default interface for all Internet
        communications. It's IP address is used as the target for all
        mappings. DNS requests are also performed over this interface.
        If PPP is up, it automatically becomes the Primary Interface.

        The Mask is the network mask which P32 is to use for this adapter.

        The Gateway is the IP address of a gateway on the attached network.

        The Name Server is the IP address of a name server anywhere on the 
        Internet. The default value is obtained from the Windows Registry.

        The Microsoft IP Adress is the address used by the host TCP/IP
        stack on this adapter. If Auto is specified, P32 will determine
        this address at startup. If 0.0.0.0 is specified, P32 assumes there
        is no host protocol stack attached to this interface.

NOTES
        Netcfg cannot be used to add Network Interfaces to a running system.
        The number of Network Interfaces to be used must be specified when
        P32 is invoked. However, the PPP interface can be initialised while
        the system is running.

        If the IP Addr is specified as 0.0.0.0 then the DHCP protocol will
        be invoked for this network adapter at startup. The netcfg file for
        this adapter then contains no relevant details, other than the NDIS
        Adapter Name and, optionally, a subnet mask which is to override the
        DHCP-supplied value.
        
SEE ALSO
        config(1), ipmap(1), netstat(1), ns(1), ppp(1), reg(1), setns(1)
