option explicit

sub showtriggers 

dim mylist
dim i

mylist = world.GetTriggerList

for i = lbound (mylist) to ubound (mylist)
  world.note mylist (i)
next

end sub

sub showvariables 

dim mylist
dim i

mylist = world.GetVariableList

for i = lbound (mylist) to ubound (mylist)
  world.note mylist (i) & " = " & world.GetVariable (mylist (i))
next

end sub

sub showaliases

dim mylist
dim i

mylist = world.GetAliasList

for i = lbound (mylist) to ubound (mylist)
  world.note mylist (i)
next

end sub

sub OnWorldOpen
world.note "---------- World Open ------------"
end sub

sub OnWorldClose
world.note "---------- World Close ------------"
end sub

sub OnWorldConnect
world.note "---------- World Connect ------------"
end sub

sub OnWorldDisconnect
world.note "---------- World Disconnect  ------------"
end sub

sub OnTeleport (thename, theoutput, theparameter)

dim sDestination
dim sRoomList
dim sHelp
dim iSubscript
dim iRoom

sDestination = Trim (theparameter)

' if nothing entered echo possible destinations
if sDestination = "" then
  world.note "-------- TELEPORT destinations ----------"	

  ' find list of all variables
  sRoomList = world.GetVariableList

  ' loop through each variable, and add to help if it starts with "teleport_"
  for iSubscript = lbound (sRoomList) to ubound (sRoomList)
     if Left (sRoomList (iSubscript), 9) = "teleport_" then
        if sHelp <> "" then
          sHelp = sHelp & ", "
        end if
        sHelp = sHelp & Mid (sRoomList (iSubscript), 10)
     end if   ' variable starts with "teleport_"
  next        ' loop through sRoomList

  ' if no destinations found, tell them
  if sHelp = "" then
    sHelp = "<no rooms in teleport list>"
  end if    ' no destinations found in list
  world.note sHelp
  exit sub

end if    ' no destination supplied

' get contents of the destination variable 
iRoom = world.GetVariable ("teleport_" & lCase (sDestination))

' if not found, or invalid name, that isn't in the list
if IsEmpty (iRoom) or IsNull (iRoom) then
  world.note "******** Destination " & sDestination & " unknown *********"
  exit sub
end if

world.note "------> Teleporting to " & sDestination
world.send "@teleport #" & cstr (iRoom)

end sub

sub OnAddTeleport (thename, theoutput, theparameter)

dim sDestination
dim sParameter
dim iSpace
dim iRoom
dim iStatus
dim sCurrentLocation

sParameter = Trim (theparameter)
iSpace = InStr (1, sParameter, " ", 1)

' if nothing entered tell them command syntax
if iSpace = 0 then
  world.note "Syntax: add_teleport name dbref"
  world.note "    eg. add_teleport LandingBay 4421"
  exit sub
end if

sDestination = Trim (Left (sParameter, iSpace))
iRoom = Trim (Mid (sParameter, iSpace + 1))

if not IsNumeric (iRoom) then
  world.note "Room to teleport to must be a number, you entered: " & iRoom
  exit sub
end if

' add room and destination location to variable list
iStatus = world.SetVariable ("teleport_" & sDestination, iRoom)

if iStatus <> 0 then
  world.note "Room name must be alphabetic, you entered: " & sDestination
  exit sub
end if

world.note "Teleport location " & sDestination & "(#" _
           & iRoom & ") added to teleport list"

end sub

world.note "Scripting enabled - script file processed"
