// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'ADODS.pas' rev: 3.00

#ifndef ADODSHPP
#define ADODSHPP
#include <DBCommon.hpp>
#include <SysUtils.hpp>
#include <ADO.hpp>
#include <ActiveX.hpp>
#include <Classes.hpp>
#include <Db.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Adods
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS ADOException;
class PASCALIMPLEMENTATION ADOException : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ __fastcall ADOException(const System::AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	/* Exception.CreateFmt */ __fastcall ADOException(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	/* Exception.CreateRes */ __fastcall ADOException(int Ident, Extended Dummy) : Sysutils::Exception(
		Ident, Dummy) { }
	/* Exception.CreateResFmt */ __fastcall ADOException(int Ident, const System::TVarRec * Args, const 
		int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	/* Exception.CreateHelp */ __fastcall ADOException(const System::AnsiString Msg, int AHelpContext) : 
		Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ __fastcall ADOException(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	/* Exception.CreateResHelp */ __fastcall ADOException(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ __fastcall ADOException(int Ident, const System::TVarRec * Args, const 
		int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext) { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~ADOException(void) { }
	
};

class DELPHICLASS TADODatabase;
typedef void __fastcall (__closure *TLoginEvent)(TADODatabase* Database);

typedef System::AnsiString TBlobData;

typedef System::AnsiString TBlobDataArray[1];

typedef TBlobDataArray *PBlobDataArray;

enum TTransIsolation { tiUnspecified, tiChaos, tiReadUncommitted, tiBrowse, tiCursorStability, tiReadCommitted, 
	tiRepeatableRead, tiSerializable, tiIsolated };

enum TConnectionMode { cmUnknown, cmRead, cmWrite, cmReadWrite, cmShareDenyRead, cmShareDenyWrite, cmShareExclusive, 
	cmShareDenyNone };

enum TConnectionAttribute { caTransCommitRetaining, caTransAbortRetaining };

typedef Set<TConnectionAttribute, caTransCommitRetaining, caTransAbortRetaining>  TConnectionAttributes
	;

class DELPHICLASS TADODataset;
class PASCALIMPLEMENTATION TADODatabase : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	Ado::_di__Connection FADOConnection;
	TConnectionAttributes FConnectionAttributes;
	TConnectionMode FConnectionMode;
	int FConnectionTimeout;
	System::AnsiString FDatabaseConnect;
	System::AnsiString FDatabaseProvider;
	Classes::TList* FDataSets;
	Ado::_di__Connection FHandle;
	bool FLoginPrompt;
	System::AnsiString FPassword;
	int FRefCount;
	bool FStreamedConnected;
	TTransIsolation FTransIsolation;
	System::AnsiString FUserName;
	TLoginEvent FOnLogin;
	void __fastcall CheckActive(void);
	void __fastcall CheckInactive(void);
	System::AnsiString __fastcall GetAbout();
	bool __fastcall GetConnected(void);
	TADODataset* __fastcall GetDataSet(int Index);
	int __fastcall GetDataSetCount(void);
	void __fastcall Login(void);
	void __fastcall SetAbout(const System::AnsiString Value);
	void __fastcall SetConnected(bool Value);
	void __fastcall SetConnectionAttributes(TConnectionAttributes Value);
	void __fastcall SetConnectionMode(TConnectionMode Value);
	void __fastcall SetConnectionTimeout(int Value);
	void __fastcall SetDatabaseConnect(const System::AnsiString Value);
	void __fastcall SetDatabaseProvider(const System::AnsiString Value);
	void __fastcall SetPassword(const System::AnsiString Value);
	void __fastcall SetTransIsolation(const TTransIsolation Value);
	void __fastcall SetUserName(const System::AnsiString Value);
	
protected:
	virtual void __fastcall Loaded(void);
	
public:
	__fastcall virtual TADODatabase(Classes::TComponent* AOwner);
	__fastcall virtual ~TADODatabase(void);
	void __fastcall Close(void);
	void __fastcall CloseDataSets(void);
	void __fastcall Commit(void);
	void __fastcall Open(void);
	void __fastcall Rollback(void);
	void __fastcall StartTransaction(void);
	__property int DataSetCount = {read=GetDataSetCount, nodefault};
	__property TADODataset* DataSets[int Index] = {read=GetDataSet};
	Ado::_di__Connection __fastcall GetHandle();
	__property Ado::_di__Connection Handle = {read=FHandle};
	__property Ado::_di__Connection ADOConnection = {read=FADOConnection, write=FADOConnection, stored=false
		};
	
__published:
	__property System::AnsiString About = {read=GetAbout, write=SetAbout, stored=false};
	__property bool Connected = {read=GetConnected, write=SetConnected, default=0};
	__property TConnectionAttributes ConnectionAttributes = {read=FConnectionAttributes, write=SetConnectionAttributes
		, nodefault};
	__property TConnectionMode ConnectionMode = {read=FConnectionMode, write=SetConnectionMode, default=3
		};
	__property int ConnectionTimeout = {read=FConnectionTimeout, write=SetConnectionTimeout, default=15
		};
	__property System::AnsiString DatabaseConnect = {read=FDatabaseConnect, write=SetDatabaseConnect};
	__property System::AnsiString DatabaseProvider = {read=FDatabaseProvider, write=SetDatabaseProvider
		};
	__property System::AnsiString Password = {read=FPassword, write=SetPassword};
	__property TTransIsolation TransIsolation = {read=FTransIsolation, write=SetTransIsolation, default=4
		};
	__property System::AnsiString UserName = {read=FUserName, write=SetUserName};
	__property TLoginEvent OnLogin = {read=FOnLogin, write=FOnLogin};
};

enum TParamType { ptUnknown, ptInput, ptOutput, ptInputOutput, ptResult };

class DELPHICLASS TParam;
class DELPHICLASS TParams;
class PASCALIMPLEMENTATION TParams : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	Classes::TList* FItems;
	TParam* __fastcall GetParam(Word Index);
	System::Variant __fastcall GetParamValue(const System::AnsiString ParamName);
	Word __fastcall GetVersion(void);
	void __fastcall ReadBinaryData(Classes::TStream* Stream);
	void __fastcall SetParamValue(const System::AnsiString ParamName, const System::Variant &Value);
	void __fastcall WriteBinaryData(Classes::TStream* Stream);
	
protected:
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	
public:
	__fastcall virtual TParams(void);
	__fastcall virtual ~TParams(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall AssignValues(TParams* Value);
	void __fastcall AddParam(TParam* Value);
	void __fastcall RemoveParam(TParam* Value);
	TParam* __fastcall CreateParam(Db::TFieldType FldType, const System::AnsiString ParamName, TParamType 
		ParamType);
	int __fastcall Count(void);
	void __fastcall Clear(void);
	void __fastcall GetParamList(Classes::TList* List, const System::AnsiString ParamNames);
	bool __fastcall IsEqual(TParams* Value);
	TParam* __fastcall ParamByName(const System::AnsiString Value);
	__property TParam* Items[Word Index] = {read=GetParam/*, default*/};
	__property System::Variant ParamValues[System::AnsiString ParamName] = {read=GetParamValue, write=SetParamValue
		};
};

class PASCALIMPLEMENTATION TParam : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	TParams* FParamList;
	System::Variant FData;
	System::AnsiString FNativeStr;
	System::AnsiString FName;
	TFieldType FDataType;
	bool FNull;
	bool FBound;
	TParamType FParamType;
	void __fastcall InitValue(void);
	
protected:
	void __fastcall AssignParam(TParam* Param);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	System::Currency __fastcall GetAsBCD(void);
	bool __fastcall GetAsBoolean(void);
	System::TDateTime __fastcall GetAsDateTime(void);
	double __fastcall GetAsFloat(void);
	int __fastcall GetAsInteger(void);
	System::AnsiString __fastcall GetAsMemo();
	System::AnsiString __fastcall GetAsString();
	System::Variant __fastcall GetAsVariant();
	bool __fastcall IsEqual(TParam* Value);
	int __fastcall RecBufDataSize(void);
	void __fastcall SetAsBCD(System::Currency Value);
	void __fastcall SetAsBlob(System::AnsiString Value);
	void __fastcall SetAsBoolean(bool Value);
	void __fastcall SetAsCurrency(double Value);
	void __fastcall SetAsDate(System::TDateTime Value);
	void __fastcall SetAsDateTime(System::TDateTime Value);
	void __fastcall SetAsFloat(double Value);
	void __fastcall SetAsInteger(int Value);
	void __fastcall SetAsMemo(const System::AnsiString Value);
	void __fastcall SetAsString(const System::AnsiString Value);
	void __fastcall SetAsSmallInt(int Value);
	void __fastcall SetAsTime(System::TDateTime Value);
	void __fastcall SetAsVariant(const System::Variant &Value);
	void __fastcall SetAsWord(int Value);
	void __fastcall SetDataType(Db::TFieldType Value);
	void __fastcall SetText(const System::AnsiString Value);
	
public:
	__fastcall TParam(TParams* AParamList, TParamType AParamType);
	__fastcall virtual ~TParam(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall AssignField(Db::TField* Field);
	void __fastcall AssignFieldValue(Db::TField* Field, const System::Variant &Value);
	void __fastcall Clear(void);
	void __fastcall GetData(void * Buffer);
	int __fastcall GetDataSize(void);
	void __fastcall LoadFromFile(const System::AnsiString FileName, Db::TBlobType BlobType);
	void __fastcall LoadFromStream(Classes::TStream* Stream, Db::TBlobType BlobType);
	void __fastcall SetBlobData(void * Buffer, int Size);
	void __fastcall SetData(void * Buffer);
	__property System::Currency AsBCD = {read=GetAsBCD, write=SetAsBCD};
	__property System::AnsiString AsBlob = {read=GetAsString, write=SetAsBlob};
	__property bool AsBoolean = {read=GetAsBoolean, write=SetAsBoolean, nodefault};
	__property double AsCurrency = {read=GetAsFloat, write=SetAsCurrency};
	__property System::TDateTime AsDate = {read=GetAsDateTime, write=SetAsDate};
	__property System::TDateTime AsDateTime = {read=GetAsDateTime, write=SetAsDateTime};
	__property double AsFloat = {read=GetAsFloat, write=SetAsFloat};
	__property int AsInteger = {read=GetAsInteger, write=SetAsInteger, nodefault};
	__property int AsSmallInt = {read=GetAsInteger, write=SetAsSmallInt, nodefault};
	__property System::AnsiString AsMemo = {read=GetAsMemo, write=SetAsMemo};
	__property System::AnsiString AsString = {read=GetAsString, write=SetAsString};
	__property System::TDateTime AsTime = {read=GetAsDateTime, write=SetAsTime};
	__property int AsWord = {read=GetAsInteger, write=SetAsWord, nodefault};
	__property bool Bound = {read=FBound, write=FBound, nodefault};
	__property Db::TFieldType DataType = {read=FDataType, write=SetDataType, nodefault};
	__property bool IsNull = {read=FNull, nodefault};
	__property System::AnsiString Name = {read=FName, write=FName};
	__property TParamType ParamType = {read=FParamType, write=FParamType, nodefault};
	__property System::AnsiString Text = {read=GetAsString, write=SetText};
	__property System::Variant Value = {read=GetAsVariant, write=SetAsVariant};
};

enum TCursorLocation { clUseNone, clServer, clClient };

enum TCursorType { ctUnspecified, ctForwardOnly, ctKeyset, ctDynamic, ctStatic };

enum TLockType { ltUnspecified, ltReadOnly, ltPessimistic, ltOptimistic, ltBatchOptimistic };

enum TCommandType { ctUnknown, ctText, ctTable, ctStoredProc };

enum TMarshalOptions { moAll, moModifiedOnly };

class PASCALIMPLEMENTATION TADODataset : public Db::TDataSet 
{
	typedef Db::TDataSet inherited;
	
private:
	System::AnsiString FDatabaseConnect;
	System::AnsiString FDatabaseProvider;
	System::AnsiString FTableName;
	System::AnsiString FSort;
	Classes::TStrings* FSQL;
	int FCacheSize;
	TCursorLocation FCursorLocation;
	TCursorType FCursorType;
	TLockType FLockType;
	TCommandType FCommandType;
	int FMaxRecords;
	int FRowsAffected;
	int FCommandTimeout;
	bool FCommandPrepared;
	TMarshalOptions FMarshalOptions;
	Ado::_di__Command FCommand;
	Ado::_di__Recordset FRecordset;
	Ado::_di__Recordset FADORecordset;
	Ado::_di__Command FADOCommand;
	Ado::_di__Connection FADOConnection;
	bool FSupportPrevious;
	bool FSupportBookmark;
	bool FIsBOF;
	int FRecordSize;
	int FRecBufSize;
	int FRecInfoOfs;
	Word FBlobCacheOfs;
	Dbcommon::TMasterDataLink* FMasterLink;
	System::AnsiString FDetailFields;
	Classes::TList* FIndexFields;
	System::AnsiString FRange;
	bool FRangeEnabled;
	System::AnsiString FText;
	TADODatabase* FDatabaseComponent;
	TParams* FParams;
	System::AnsiString __fastcall GetAbout();
	void __fastcall SetAbout(const System::AnsiString Value);
	void __fastcall SetDatabaseConnect(const System::AnsiString Value);
	void __fastcall SetDatabaseProvider(const System::AnsiString Value);
	void __fastcall SetTableName(const System::AnsiString Value);
	void __fastcall SetDatabaseComponent(const TADODatabase* Value);
	void __fastcall SetCacheSize(int Value);
	void __fastcall SetCursorLocation(TCursorLocation Value);
	void __fastcall SetCursorType(TCursorType Value);
	void __fastcall SetLockType(TLockType Value);
	void __fastcall SetCommandType(TCommandType Value);
	void __fastcall SetCommandTimeout(int Value);
	void __fastcall SetCommandPrepared(bool Value);
	void __fastcall SetMaxRecords(int Value);
	void __fastcall SetMarshalOptions(TMarshalOptions Value);
	void __fastcall SetSort(const System::AnsiString Value);
	void __fastcall SetSQL(Classes::TStrings* Value);
	bool __fastcall GetActiveRecBuf(char * &RecBuf);
	System::AnsiString __fastcall GetMasterFields();
	void __fastcall SetMasterFields(const System::AnsiString Value);
	System::AnsiString __fastcall GetDetailFields();
	void __fastcall SetDetailFields(const System::AnsiString Value);
	void __fastcall MasterChanged(System::TObject* Sender);
	void __fastcall MasterDisabled(System::TObject* Sender);
	System::AnsiString __fastcall GetBlobData(Db::TField* Field, char * Buffer);
	void __fastcall SetBlobData(Db::TField* Field, char * Buffer, System::AnsiString Value);
	int __fastcall GetBlobSize(Db::TField* Field, char * Buffer);
	void __fastcall ClearBlobCache(char * Buffer);
	void __fastcall UpdateIndexFields(void);
	void __fastcall QueryChanged(System::TObject* Sender);
	void __fastcall CreateParams(TParams* List, const char * Value);
	void __fastcall SetParamsList(TParams* Value);
	void __fastcall GetParams(void);
	void __fastcall SetParams(void);
	
protected:
	virtual char * __fastcall AllocRecordBuffer(void);
	virtual void __fastcall FreeRecordBuffer(char * &Buffer);
	virtual void __fastcall GetBookmarkData(char * Buffer, void * Data);
	virtual Db::TBookmarkFlag __fastcall GetBookmarkFlag(char * Buffer);
	virtual bool __fastcall GetFieldData(Db::TField* Field, void * Buffer);
	virtual Db::TGetResult __fastcall GetRecord(char * Buffer, Db::TGetMode GetMode, bool DoCheck);
	virtual Word __fastcall GetRecordSize(void);
	virtual void __fastcall InternalAddRecord(void * Buffer, bool Append);
	virtual void __fastcall InternalClose(void);
	virtual void __fastcall InternalDelete(void);
	virtual void __fastcall InternalFirst(void);
	virtual void __fastcall InternalGotoBookmark(void * Bookmark);
	virtual void __fastcall InternalHandleException(void);
	virtual void __fastcall InternalInitFieldDefs(void);
	virtual void __fastcall InternalInitRecord(char * Buffer);
	virtual void __fastcall InternalLast(void);
	virtual void __fastcall InternalOpen(void);
	virtual void __fastcall InternalPost(void);
	virtual void __fastcall InternalSetToRecord(char * Buffer);
	virtual void __fastcall InternalEdit(void);
	virtual void __fastcall InternalCancel(void);
	virtual bool __fastcall IsCursorOpen(void);
	virtual void __fastcall SetBookmarkFlag(char * Buffer, Db::TBookmarkFlag Value);
	virtual void __fastcall SetBookmarkData(char * Buffer, void * Data);
	virtual void __fastcall SetFieldData(Db::TField* Field, void * Buffer);
	virtual void __fastcall InitRecord(char * Buffer);
	virtual void __fastcall ClearCalcFields(char * Buffer);
	void __fastcall CheckMasterRange(void);
	Word __fastcall GetParamsCount(void);
	virtual void __fastcall SetFiltered(bool Value);
	virtual void __fastcall SetFilterText(const System::AnsiString Value);
	virtual void __fastcall SetFilterOptions(Db::TFilterOptions Value);
	void __fastcall SetFilterData(const System::AnsiString Text, Db::TFilterOptions Options);
	virtual int __fastcall GetRecordCount(void);
	virtual int __fastcall GetRecNo(void);
	virtual void __fastcall SetRecNo(int Value);
	virtual bool __fastcall GetCanModify(void);
	virtual void __fastcall InternalRefresh(void);
	virtual void __fastcall PrepareCursor(void);
	void __fastcall OpenRecordset(void);
	void __fastcall ReadRecordFields(char * Buffer);
	void __fastcall WriteRecordFields(char * Buffer);
	System::AnsiString __fastcall AddFilterExpression(const System::AnsiString FilterExpr, Db::TField* 
		Field, const System::Variant &Value, Db::TLocateOptions Options);
	virtual void __fastcall OpenCursor(bool InfoQuery);
	virtual void __fastcall CloseCursor(void);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	virtual Db::TDataSource* __fastcall GetDataSource(void);
	void __fastcall SetDataSource(Db::TDataSource* Value);
	void __fastcall SetLinkRanges(Classes::TList* MasterFields);
	bool __fastcall SetCursorRange(void);
	bool __fastcall ResetCursorRange(void);
	void __fastcall UpdateRange(void);
	void __fastcall ApplyRecordsetFilter(void);
	Db::TFieldType __fastcall GetFieldType(int ADOFieldType);
	bool __fastcall LocateRecord(const System::AnsiString KeyFields, const System::Variant &KeyValues, 
		Db::TLocateOptions Options, bool SyncCursor);
	void __fastcall CheckCachedUpdateMode(void);
	virtual void __fastcall CreateADOCommand(void);
	virtual void __fastcall CreateADORecordset(void);
	virtual void __fastcall OpenADORecordset(void);
	virtual void __fastcall CheckADOError(const System::AnsiString Msg);
	
public:
	__fastcall virtual TADODataset(Classes::TComponent* AOwner);
	__fastcall virtual ~TADODataset(void);
	void __fastcall ExecSQL(void);
	virtual bool __fastcall GetCurrentRecord(char * Buffer);
	virtual Classes::TStream* __fastcall CreateBlobStream(Db::TField* Field, Db::TBlobStreamMode Mode);
		
	__property Ado::_di__Recordset Recordset = {read=FRecordset, stored=false};
	__property int RowsAffected = {read=FRowsAffected, stored=false, nodefault};
	void __fastcall ApplyRange(void);
	void __fastcall CancelRange(void);
	virtual bool __fastcall Locate(const System::AnsiString KeyFields, const System::Variant &KeyValues
		, Db::TLocateOptions Options);
	virtual System::Variant __fastcall Lookup(const System::AnsiString KeyFields, const System::Variant 
		&KeyValues, const System::AnsiString ResultFields);
	void __fastcall ApplyUpdates(void);
	void __fastcall CancelUpdates(void);
	TParam* __fastcall ParamByName(const System::AnsiString Value);
	__property Word ParamCount = {read=GetParamsCount, nodefault};
	__property System::AnsiString Text = {read=FText};
	__property Ado::_di__Recordset ADORecordset = {read=FADORecordset, write=FADORecordset, stored=false
		};
	__property Ado::_di__Command ADOCommand = {read=FADOCommand, write=FADOCommand, stored=false};
	__property Ado::_di__Connection ADOConnection = {read=FADOConnection, write=FADOConnection, stored=false
		};
	
__published:
	__property System::AnsiString About = {read=GetAbout, write=SetAbout, stored=false};
	__property Active ;
	__property AutoCalcFields ;
	__property int CacheSize = {read=FCacheSize, write=SetCacheSize, default=1};
	__property bool CommandPrepared = {read=FCommandPrepared, write=SetCommandPrepared, default=0};
	__property int CommandTimeout = {read=FCommandTimeout, write=SetCommandTimeout, default=30};
	__property TCommandType CommandType = {read=FCommandType, write=SetCommandType, default=0};
	__property TCursorLocation CursorLocation = {read=FCursorLocation, write=SetCursorLocation, default=2
		};
	__property TCursorType CursorType = {read=FCursorType, write=SetCursorType, default=2};
	__property TADODatabase* Database = {read=FDatabaseComponent, write=SetDatabaseComponent};
	__property System::AnsiString DatabaseConnect = {read=FDatabaseConnect, write=SetDatabaseConnect};
	__property System::AnsiString DatabaseProvider = {read=FDatabaseProvider, write=SetDatabaseProvider
		};
	__property Filter ;
	__property Filtered ;
	__property TLockType LockType = {read=FLockType, write=SetLockType, default=3};
	__property TMarshalOptions MarshalOptions = {read=FMarshalOptions, write=SetMarshalOptions, default=1
		};
	__property int MaxRecords = {read=FMaxRecords, write=SetMaxRecords, default=0};
	__property System::AnsiString Sort = {read=FSort, write=SetSort};
	__property Classes::TStrings* SQL = {read=FSQL, write=SetSQL};
	__property System::AnsiString TableName = {read=FTableName, write=SetTableName};
	__property System::AnsiString DetailFields = {read=GetDetailFields, write=SetDetailFields};
	__property System::AnsiString MasterFields = {read=GetMasterFields, write=SetMasterFields};
	__property Db::TDataSource* MasterSource = {read=GetDataSource, write=SetDataSource};
	__property TParams* Params = {read=FParams, write=SetParamsList};
	__property BeforeOpen ;
	__property AfterOpen ;
	__property BeforeClose ;
	__property AfterClose ;
	__property BeforeInsert ;
	__property AfterInsert ;
	__property BeforeEdit ;
	__property AfterEdit ;
	__property BeforePost ;
	__property AfterPost ;
	__property BeforeCancel ;
	__property AfterCancel ;
	__property BeforeDelete ;
	__property AfterDelete ;
	__property BeforeScroll ;
	__property AfterScroll ;
	__property OnCalcFields ;
	__property OnDeleteError ;
	__property OnEditError ;
	__property OnNewRecord ;
	__property OnPostError ;
};

class DELPHICLASS TBlobStream;
class PASCALIMPLEMENTATION TBlobStream : public Classes::TMemoryStream 
{
	typedef Classes::TMemoryStream inherited;
	
private:
	Db::TBlobField* FField;
	TADODataset* FDataSet;
	bool FModified;
	
public:
	__fastcall TBlobStream(Db::TBlobField* Field, Db::TBlobStreamMode Mode);
	__fastcall virtual ~TBlobStream(void);
	virtual int __fastcall Write(const void *Buffer, int Count);
	void __fastcall Truncate(void);
};

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE System::AnsiString __fastcall GetADOVersion();
extern PACKAGE System::OleVariant __fastcall NotUsed();
extern PACKAGE void __fastcall Register(void);

}	/* namespace Adods */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Adods;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// ADODS
