/////////////////////////////
//	CAPTURE DLL Version 1.0 
/////////////////////////////

#include <windows.h>
#include <windowsx.h>

#ifndef	CAPTURE
#define CAPTURE	__declspec(dllimport)
#endif

#define	MONO_Colors		1
#define C_16_Colors		2
#define C_256_Colors	3
#define TRUE_COLOR		4

////////////////////////////////////////////
//	CAPTURE DLL functions

#ifdef __cplusplus
extern "C" {
#endif

////////////////////
//	For Debug only

CAPTURE void WINAPI GetDebugInfo(RECT *P_RECT_Ptr, RECT *D_RECT_Ptr, HWND *P_HWND_Ptr, HWND *D_HWND_Ptr);

////////////////////////////////
//	Return Current DLL Version

CAPTURE void WINAPI GetCaptureDllVersion(UINT *Major, UINT *Minor);

//////////////////////////
//  Return DC Information

CAPTURE void WINAPI GetDisplayInfo(int *MaxColors, int *Width, int *Height);

//////////////////////////////////////////////////
//	Save current DC to a BMP
//	and generate a palette if need
//	
//	Note:
//	Caller should use DeleteObject to
//	release DC_Bmp and Bmp_Palette
//	If bmp is a ture color, Bmp_Palette == NULL

CAPTURE void WINAPI SaveCurrentDC(HDC Source_DC, HBITMAP *DC_Bmp, HPALETTE *Bmp_Palette);

/////////////////////
//	Capture Desktop

CAPTURE void WINAPI CaptureDeskTop(long x, long y, long width, long height, HBITMAP *DC_Bmp, HPALETTE *Bmp_Palette);

/////////////////////////////////////////////
//	Let user set capture region	(Rectangle)
//
//	Note:
//	All mouse message will be 
//	captured until user define
//	the region
//  Click Left mouse button to start
//  Click Right button to finish
//	Use GetCaptureRegion() to get result
//	and release mouse hook
	
CAPTURE void WINAPI StartFindCaptureRegion(HWND Handle);

/////////////////////////////////////
//	Get capture region
//	
//	Return true if result is ready
//	otherwise return false

CAPTURE bool WINAPI GetCaptureRegion(POINT *StartPt, POINT *EndPt);

///////////////////////////////////////////////////////////
//	Let user set capture region (Ex version)	(Ellipse)
//
//	Note:
//	All mouse message will be 
//	captured until user define
//	the region
//  Click Left mouse button to start
//  Click Right button to finish
//	Use GetCaptureRegionEx() to get result
//	and release mouse hook
	
CAPTURE void WINAPI StartFindCaptureRegionEx(HWND Handle);

/////////////////////////////////////
//	Get capture region (Ex version)
//	
//	Return true if result is ready
//	otherwise return false

CAPTURE bool WINAPI GetCaptureRegionEx(HBITMAP *DC_Bmp, HPALETTE *Bmp_Palette, UINT *Width, UINT *Height);

///////////////////////////////////////////////////////////
//	Let user set capture region (Ex2 version)	(Polygon)
//
//	Note:
//	All mouse message will be 
//	captured until user define
//	the region
//  Click Left mouse button to start
//  Click Right button to finish
//	Use GetCaptureRegionEx2() to get result
//	and release mouse hook
	
CAPTURE void WINAPI StartFindCaptureRegionEx2(HWND Handle);

//////////////////////////////////////
//	Get capture region (Ex2 version)
//	
//	Return true if result is ready
//	otherwise return false

CAPTURE bool WINAPI GetCaptureRegionEx2(HBITMAP *DC_Bmp, HPALETTE *Bmp_Palette, UINT *Width, UINT *Height);

////////////////////////////////////////////////////////////////
//	Let user set capture region (Ex3 version)	(ClientWindow)
//
//	Note:
//	All mouse message will be 
//	captured until user define
//	the region
//  Click Left mouse button to start
//  Click Right button to finish
//	Use GetCaptureRegionEx3() to get result
//	and release mouse
	
CAPTURE void WINAPI StartFindCaptureRegionEx3(HWND Handle);

//////////////////////////////////////
//	Get capture region (Ex3 version)
//	
//	Return true if result is ready
//	otherwise return false

CAPTURE bool WINAPI GetCaptureRegionEx3(HBITMAP *DC_Bmp, HPALETTE *Bmp_Palette, UINT *Width, UINT *Height);

///////////////////////////////
//	Copy HBITMAP to Clipboard
//
//	Return true if OK

CAPTURE bool WINAPI CopyBmpToClipboard(HWND Handle, HBITMAP BMP, HPALETTE PAL);

////////////////////////////////////
//	Paste BMP from Clipboard
//
//	Return true if OK

CAPTURE bool WINAPI PasteBmpFromClipboard(HWND Handle, HBITMAP *BMP, UINT *Width, UINT *Height, HPALETTE *PAL);

///////////////////////////////
//	Copy DIB to Clipboard
//
//	Return true if OK

CAPTURE bool WINAPI CopyDibToClipboard(HWND Handle, HGLOBAL DIB);

#ifdef __cplusplus
}
#endif

