#ifndef _JPICT_H
#define _JPICT_H

// defined in jedit (used to display jedit message)
#define WM_JEDIT_DISPLAY_MESSAGE	WM_USER + 7894

// defined to give programmer a chance to paint his own bitmap
#define WM_JPICT_PAINT_BACKGROUND  	WM_USER + 7889

//////////////////
// background bitmap

BOOL AFX_EXT_API SetBackgroundBitmap(UINT nImageID);
void AFX_EXT_API DeleteBackgroundBitmap();
BOOL AFX_EXT_API PaintBackgroundBitmap(CDC* pDC);

//////////////////
// dialog bitmap

BOOL AFX_EXT_API SetDialogBitmap(UINT nImageID);
void AFX_EXT_API DeleteDialogBitmap();
BOOL AFX_EXT_API SetDialogModifyColor(COLORREF color);
BOOL AFX_EXT_API PaintDialogBitmap(CDC* pDC);

//////////////////
// DispMessageBox

int AFX_EXT_API DispMessageBox(LPCTSTR lpszText, UINT nType = MB_OK, UINT nIDHelp = 0);
int AFX_EXT_API DispMessageBox(UINT nIDPrompt, UINT nType = MB_OK, UINT nIDHelp = (UINT)-1);

void AFX_EXT_API SetPictMsgBoxImageID(UINT nImageID);
void AFX_EXT_API SetPictMsgBoxOKText(LPCSTR szOKText);
void AFX_EXT_API SetPictMsgBoxYesText(LPCSTR szYesText);
void AFX_EXT_API SetPictMsgBoxNoText(LPCSTR szNoText);


/***********************************************************************
  CLASS:		 CPictDialog

  BASE CLASS:	 CDialog
  
  Author:        Jan Xiang
  
  Date:          May 4, 1997
  
  Description:   This is the dialog class which handles displaying bitmap 
				 in the dialog background. It may work as a base class 
				 for other dialog. 
  *********************************************************************/
class AFX_EXT_CLASS CPictDialog : public CDialog
{
    DECLARE_DYNCREATE(CPictDialog)

// Construction
public:
	CPictDialog(UINT nIDD=0, CWnd* pParent = NULL);   // standard constructor
	~CPictDialog();

	void SetBitmapID(UINT nImageID) { m_nImageID = nImageID; }

	CDC* GetMemDC() const { return m_pMemDC; }
	UINT GetImageID() const { return m_nImageID; }

	// color setup
	void SetStaticColor(COLORREF color) { m_staticColor = color; }
	void SetRequireStaticColor(COLORREF color) { m_requireStaticColor = color; }
	void SetGroupTextColor(COLORREF color) { m_groupTextColor = color; }
	void SetCheckboxTextColor(COLORREF color) { m_checkboxTextColor = color; }
	void SetRadioboxTextColor(COLORREF color) { m_radioboxTextColor = color; }
	void SetButtonTextColor(COLORREF color) { m_buttonTextColor = color; }
	void SetDisableTextColor(COLORREF color) { m_disableTextColor = color; }

	// font setup
	void SetStaticFont(CFont* pFont);
	void SetGroupTextFont(CFont* pFont);
	void SetCheckboxTextFont(CFont* pFont);
	void SetRadioboxTextFont(CFont* pFont);
	void SetButtonTextFont(CFont* pFont);

// Dialog Data
	//{{AFX_DATA(CPictDialog)
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPictDialog)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CPictDialog)
	afx_msg void OnPaint();
	afx_msg void OnDestroy();
	virtual BOOL OnInitDialog();
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnMove(int x, int y);
	afx_msg LRESULT OnDisplayJEditMessage(UINT nCtrlID, WPARAM szText);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

protected:
	UINT m_nImageID;
	CDC* m_pMemDC;
	CBitmap* m_pMemDCBitmap;

	COLORREF m_staticColor;
	COLORREF m_requireStaticColor;
	COLORREF m_groupTextColor;
	COLORREF m_checkboxTextColor;
	COLORREF m_radioboxTextColor;
	COLORREF m_buttonTextColor;
	COLORREF m_disableTextColor;

	CFont* m_pStaticFont;
	CFont* m_pGroupTextFont;
	CFont* m_pCheckboxTextFont;
	CFont* m_pRadioboxTextFont;
	CFont* m_pButtonTextFont;

friend class CPictStatic;
friend class CPictGroup;
friend class CPictCheckBox;
friend class CPictRadioButton;
friend class CPictListBox;
friend class CPictButton;
};

/***********************************************************************
  CLASS:		 CPictFormView

  BASE CLASS:	 CFormView
  
  Author:        Jan Xiang
  
  Date:          May 4, 1997
  
  Description:   This is the formview class which handles displaying 
				 bitmap in the formview background. It may work as a 
				 base class for other formview. 
  **********************************************************************/
class AFX_EXT_CLASS CPictFormView : public CFormView
{
    DECLARE_DYNCREATE(CPictFormView)

// Construction
public:
	CPictFormView(UINT nIDD=0);   // standard constructor
	~CPictFormView();

	void SetBitmapID(UINT nImageID) { m_nImageID = nImageID; }

	CDC* GetMemDC() const { return m_pMemDC; }
	UINT GetImageID() const { return m_nImageID; }

	// color setup
	void SetStaticColor(COLORREF color) { m_staticColor = color; }
	void SetRequireStaticColor(COLORREF color) { m_requireStaticColor = color; }
	void SetGroupTextColor(COLORREF color) { m_groupTextColor = color; }
	void SetCheckboxTextColor(COLORREF color) { m_checkboxTextColor = color; }
	void SetRadioboxTextColor(COLORREF color) { m_radioboxTextColor = color; }
	void SetButtonTextColor(COLORREF color) { m_buttonTextColor = color; }
	void SetDisableTextColor(COLORREF color) { m_disableTextColor = color; }

	// font setup
	void SetStaticFont(CFont* pFont);
	void SetGroupTextFont(CFont* pFont);
	void SetCheckboxTextFont(CFont* pFont);
	void SetRadioboxTextFont(CFont* pFont);
	void SetButtonTextFont(CFont* pFont);

// Dialog Data
	//{{AFX_DATA(CPictFormView)
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPictFormView)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void OnInitialUpdate();
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CPictFormView)
	afx_msg void OnPaint();
	afx_msg void OnDestroy();
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnMove(int x, int y);
	afx_msg LRESULT OnDisplayJEditMessage(UINT nCtrlID, WPARAM szText);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

protected:
	UINT m_nImageID;
	CDC* m_pMemDC;
	CBitmap* m_pMemDCBitmap;

	COLORREF m_staticColor;
	COLORREF m_requireStaticColor;
	COLORREF m_groupTextColor;
	COLORREF m_checkboxTextColor;
	COLORREF m_radioboxTextColor;
	COLORREF m_buttonTextColor;
	COLORREF m_disableTextColor;

	CFont* m_pStaticFont;
	CFont* m_pGroupTextFont;
	CFont* m_pCheckboxTextFont;
	CFont* m_pRadioboxTextFont;
	CFont* m_pButtonTextFont;

friend class CPictStatic;
friend class CPictGroup;
friend class CPictCheckBox;
friend class CPictRadioButton;
friend class CPictListBox;
friend class CPictButton;
};

/***********************************************************************
  CLASS:		 CPictPage

  BASE CLASS:	 CPropertyPage
  
  Author:        Jan Xiang
  
  Date:          May 4, 1997
  
  Description:   This is the property page class which handles displaying 
				 bitmap in the property page background. It may work as a 
				 base class for other property page. 
 **********************************************************************/
class AFX_EXT_CLASS CPictPage : public CPropertyPage
{
    DECLARE_DYNCREATE(CPictPage)

// Construction
public:
	CPictPage(UINT nIDD=0, UINT nIDCaption=0);   // standard constructor
	~CPictPage();

	void SetBitmapID(UINT nImageID) { m_nImageID = nImageID; }

	CDC* GetMemDC() const { return m_pMemDC; }
	UINT GetImageID() const { return m_nImageID; }

	// color setup
	void SetStaticColor(COLORREF color) { m_staticColor = color; }
	void SetRequireStaticColor(COLORREF color) { m_requireStaticColor = color; }
	void SetGroupTextColor(COLORREF color) { m_groupTextColor = color; }
	void SetCheckboxTextColor(COLORREF color) { m_checkboxTextColor = color; }
	void SetRadioboxTextColor(COLORREF color) { m_radioboxTextColor = color; }
	void SetButtonTextColor(COLORREF color) { m_buttonTextColor = color; }
	void SetDisableTextColor(COLORREF color) { m_disableTextColor = color; }

	// font setup
	void SetStaticFont(CFont* pFont);
	void SetGroupTextFont(CFont* pFont);
	void SetCheckboxTextFont(CFont* pFont);
	void SetRadioboxTextFont(CFont* pFont);
	void SetButtonTextFont(CFont* pFont);

// Dialog Data
	//{{AFX_DATA(CPictPage)
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPictPage)
	virtual BOOL OnApply();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CPictPage)
	afx_msg void OnPaint();
	afx_msg void OnDestroy();
	virtual BOOL OnInitDialog();
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnMove(int x, int y);
	afx_msg LRESULT OnDisplayJEditMessage(UINT nCtrlID, WPARAM szText);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

protected:
	UINT m_nImageID;
	CDC* m_pMemDC;
	CBitmap* m_pMemDCBitmap;

	COLORREF m_staticColor;
	COLORREF m_requireStaticColor;
	COLORREF m_groupTextColor;
	COLORREF m_checkboxTextColor;
	COLORREF m_radioboxTextColor;
	COLORREF m_buttonTextColor;
	COLORREF m_disableTextColor;

	CFont* m_pStaticFont;
	CFont* m_pGroupTextFont;
	CFont* m_pCheckboxTextFont;
	CFont* m_pRadioboxTextFont;
	CFont* m_pButtonTextFont;

	BOOL m_bModified;

friend class CPictStatic;
friend class CPictGroup;
friend class CPictCheckBox;
friend class CPictRadioButton;
friend class CPictListBox;
friend class CPictButton;
friend class CPictSheet;
};

/***********************************************************************
  CLASS:		 CPictToolBar

  BASE CLASS:	 CToolBar
  
  Author:        Jan Xiang
  
  Date:          May 4, 1997
  
  Description:   This is the toolbar class which handles displaying bitmap 
				 in the toolbar background. 
  *********************************************************************/
class AFX_EXT_CLASS CPictToolBar : public CToolBar
{
// Construction
public:
	CPictToolBar();

// Attributes
public:

// Operations
public:
	void SetBitmapID(UINT nImageID) { m_nImageID = nImageID; }
	void SetModifyColor(COLORREF color) { m_modifyColor = color; }
	void SetMaskColor(COLORREF color) { m_clrMaskColor = color; }

	BOOL LoadToolBar(UINT nIDResource);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPictToolBar)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CPictToolBar();

	// Generated message map functions
protected:
	//{{AFX_MSG(CPictToolBar)
	afx_msg void OnPaint();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnNcPaint();
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

protected:
	struct IDCSTRUCT
	{
		UINT nIDC;
		CRect rect;
		BOOL bEnabled;
		int index;
		int pos;
	};
	int m_iIdcCount;
	int* m_aSeparator;
	int m_iSeparatorCount;

	BOOL m_bCaptured;
	CRect m_drawRect;
	UINT m_nImageID;
	CDC* m_pMemDC;
	CDC* m_pNonClientMemDC;
	CBitmap* m_pMemDCBitmap;
	CBitmap* m_pNonClientMemDCBitmap;
	CDC* m_pToolbarDC;
	CBitmap* m_pToolbarDCBitmap;

	int m_iWidth;
	int m_iHeight;
	int m_iSeparator;
	COLORREF m_clrMaskColor;
	int	m_iIDCCount;
	IDCSTRUCT* m_aIDCList;
	COLORREF m_modifyColor;

	BOOL m_bUseBackGroundBitmap;
	UINT m_nIDResource;
	int m_iNonClientHorOffset;
	int m_iNonClientVerOffset;

	void RestoreRect();
	void CreateDCFromMainFrameDC(CDC* pDC);
	void LoadToolbarBitmap(CDC* pDC);
	void CreateDCFromToolbarBitmap(CDC* pDC);
	void SetToolBarResource(UINT aToolBarResource[], int count);
	void PrepareDisableButtons();
};

/***********************************************************************
  CLASS:		 CPictDialogBar

  BASE CLASS:	 CDialogBar
  
  Author:        Jan Xiang
  
  Date:          May 4, 1997
  
  Description:   This is the dialogBar class which handles displaying bitmap 
				 in the dialog background. It may work as a base class 
				 for other dialog. 
  *********************************************************************/
class AFX_EXT_CLASS CPictDialogBar : public CDialogBar
{
    DECLARE_DYNCREATE(CPictDialogBar)

// Construction
public:
	CPictDialogBar();   
	~CPictDialogBar();

	BOOL Create(CWnd* pParentWnd, LPCTSTR lpszTemplateName, UINT nStyle, UINT nID);
	BOOL Create(CWnd* pParentWnd, UINT nIDTemplate, UINT nStyle, UINT nID);

	void SetBitmapID(UINT nImageID) { m_nImageID = nImageID; }
	void SetModifyColor(COLORREF color) { m_modifyColor = color; }

	CDC* GetMemDC() const { return m_pMemDC; }
	UINT GetImageID() const { return m_nImageID; }

	// color setup
	void SetStaticColor(COLORREF color) { m_staticColor = color; }
	void SetRequireStaticColor(COLORREF color) { m_requireStaticColor = color; }
	void SetGroupTextColor(COLORREF color) { m_groupTextColor = color; }
	void SetCheckboxTextColor(COLORREF color) { m_checkboxTextColor = color; }
	void SetRadioboxTextColor(COLORREF color) { m_radioboxTextColor = color; }
	void SetButtonTextColor(COLORREF color) { m_buttonTextColor = color; }
	void SetDisableTextColor(COLORREF color) { m_disableTextColor = color; }

	// font setup
	void SetStaticFont(CFont* pFont);
	void SetGroupTextFont(CFont* pFont);
	void SetCheckboxTextFont(CFont* pFont);
	void SetRadioboxTextFont(CFont* pFont);
	void SetButtonTextFont(CFont* pFont);

// Dialog Data
	//{{AFX_DATA(CPictDialogBar)
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPictDialogBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDlgBar();
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CPictDialogBar)
	afx_msg void OnPaint();
	afx_msg void OnDestroy();
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnMove(int x, int y);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg LRESULT OnDisplayJEditMessage(UINT nCtrlID, WPARAM szText);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

protected:
	UINT m_nImageID;
	CDC* m_pMemDC;
	CBitmap* m_pMemDCBitmap;
	COLORREF m_modifyColor;

	COLORREF m_staticColor;
	COLORREF m_requireStaticColor;
	COLORREF m_groupTextColor;
	COLORREF m_checkboxTextColor;
	COLORREF m_radioboxTextColor;
	COLORREF m_buttonTextColor;
	COLORREF m_disableTextColor;

	CFont* m_pStaticFont;
	CFont* m_pGroupTextFont;
	CFont* m_pCheckboxTextFont;
	CFont* m_pRadioboxTextFont;
	CFont* m_pButtonTextFont;

	BOOL m_bUseBackGroundBitmap;

friend class CPictStatic;
friend class CPictGroup;
friend class CPictCheckBox;
friend class CPictRadioButton;
friend class CPictListBox;
friend class CPictButton;
};

/***********************************************************************
  CLASS:		 CPictStatic

  BASE CLASS:	 CStatic
  
  Author:        Jan Xiang
  
  Date:          May 4, 1997
  
  Description:   This class makes static control transparent.
 **********************************************************************/
class AFX_EXT_CLASS CPictStatic : public CStatic
{
// Construction
public:
	CPictStatic();

// Attributes
public:
	void SetRequired(BOOL bRequired) { m_bRequired = bRequired; }

// Operations
public:
	void SetWindowText(LPCTSTR lpszString);
	BOOL EnableWindow(BOOL bEnable=TRUE);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPictStatic)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CPictStatic();

	// Generated message map functions
protected:
	//{{AFX_MSG(CPictStatic)
	afx_msg void OnPaint();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

protected:
	BOOL m_bRequired;
};

/***********************************************************************
  CLASS:		 CPictCheckBox

  BASE CLASS:	 CButton
  
  Author:        Jan Xiang
  
  Date:          May 4, 1997
  
  Description:   This class makes checkbox control transparent.
 **********************************************************************/
class AFX_EXT_CLASS CPictCheckBox : public CButton
{
	DECLARE_DYNCREATE(CPictCheckBox)

// Construction
public:
	CPictCheckBox();

// Attributes
public:

// Operations
public:
	int GetCheck() const { return m_bSelected; }
	void SetCheck(int iCheck);

	void SetWindowText(LPCTSTR lpszString);
	BOOL EnableWindow(BOOL bEnable=TRUE);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPictCheckBox)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CPictCheckBox();

	// Generated message map functions
protected:
	//{{AFX_MSG(CPictCheckBox)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnPaint();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

protected:
	BOOL m_bSelected;
	BOOL m_bHasFocus;
};

/***********************************************************************
  CLASS:		 CPictButton

  BASE CLASS:	 CButton
  
  Author:        Jan Xiang
  
  Date:          May 4, 1997
  
  Description:   This class makes button control transparent, or displays
				 a bitmap as background.

				 SetBitmapFile - set the bitmap file name if the button is
								not transparent.
				 SetBitmapID - set the bitmap IDB if the button is
							  not transparent.
 **********************************************************************/
class AFX_EXT_CLASS CPictButton : public CButton
{
// Construction
public:
	CPictButton();

// Attributes
public:

// Operations
public:
	void SetBitmapID(UINT nImageID) { m_nImageID = nImageID; m_bIsTransparent = FALSE; }

	void SetWindowText(LPCTSTR lpszString);
	BOOL EnableWindow(BOOL bEnable=TRUE);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPictButton)
	virtual void PreSubclassWindow();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CPictButton();

	// Generated message map functions
protected:
	//{{AFX_MSG(CPictButton)
	afx_msg void OnPaint();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg UINT OnGetDlgCode();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSysKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

protected:
//    void InitComboBox(CComboBox* pCombo1);
//    void InitListBox(CListBox* pList1);

//    void SetupEdit();

	CDC* m_pMemDC;
	CBitmap* m_pMemDCBitmap;
	BOOL m_bLButtonDown;
	BOOL m_bHasFocus;	

	UINT m_nImageID;
	BOOL m_bIsTransparent;
	UINT m_nShorcutKey;
};

/***********************************************************************
  CLASS:		 CPictGroup

  BASE CLASS:	 CButton
  
  Author:        Jan Xiang
  
  Date:          May 4, 1997
  
  Description:   This class makes group control transparent.
 **********************************************************************/
class AFX_EXT_CLASS CPictGroup : public CButton
{
// Construction
public:
	CPictGroup();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPictGroup)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CPictGroup();

	// Generated message map functions
protected:
	//{{AFX_MSG(CPictGroup)
	afx_msg void OnPaint();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/***********************************************************************
  CLASS:		 CPictRadioButton

  BASE CLASS:	 CButton
  
  Author:        Jan Xiang
  
  Date:          May 4, 1997
  
  Description:   This class makes radio button control transparent.
 **********************************************************************/
class AFX_EXT_CLASS CPictRadioButton : public CButton
{
	DECLARE_DYNCREATE(CPictRadioButton)

// Construction
public:
	CPictRadioButton();

// Attributes
public:

// Operations
public:
	void SetCheck(int iCheck);
	int GetCheck() const { return m_bSelected; }

	void SetWindowText(LPCTSTR lpszString);
	BOOL EnableWindow(BOOL bEnable=TRUE);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPictRadioButton)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CPictRadioButton();

	// Generated message map functions
protected:
	//{{AFX_MSG(CPictRadioButton)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnPaint();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

protected:
	BOOL m_bSelected;
	BOOL m_bHasFocus;

	void SelectRadio(CWnd* pWnd, BOOL bSelected);
};

/***********************************************************************
  CLASS:		 CPictListBox

  BASE CLASS:	 CListBox
  
  Author:        Jan Xiang
  
  Date:          May 4, 1997
  
  Description:   This list box has transparent scroll bar. It is also used
				 as the internal list box for CPictComboBox control.
 **********************************************************************/
class CPictComboBox;
class CPictScrollBar;
class AFX_EXT_CLASS CPictListBox : public CListBox
{
    DECLARE_DYNCREATE(CPictListBox)

// Construction
public:
	CPictListBox();

// Attributes
public:

// Operations
public:
	int AddString(LPCTSTR lpszItem);
	int InsertString(int nIndex, LPCTSTR lpszItem);
	int DeleteString(UINT nIndex);
	void ResetContent();
	int SetCurSel(int nSelect);

	BOOL ShowWindow(int nCmdShow);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPictListBox)
	public:
	virtual void PreSubclassWindow();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CPictListBox();

	void PageUp();
	void PageDown();
	void LineUp();
	void LineDown();
	void ThumbScroll(int pos);

	// Generated message map functions
protected:
	//{{AFX_MSG(CPictListBox)
	afx_msg void OnDestroy();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

protected:
	int m_iListBoxWidth;
	CPictComboBox* m_pComboBox;
	int m_iItemsPerScreen;
	CPictScrollBar* m_pScrollBar;
	BOOL m_bScrollBarVisible;
	BOOL m_bIsDropDownCombo;
	BOOL m_bNoResize;

	void InitialScrollBar();
	void ShowScrollBar();
	void HideScrollBar();

	void HandleMouseDown();

protected:
	CPictScrollBar* GetScrollBar() const { return m_pScrollBar; }
	int GetItemsPerScreen() const { return m_iItemsPerScreen; }
	void SetComboBox(CPictComboBox* pComboBox) { m_pComboBox = pComboBox; }
	CPictComboBox* GetComboBox() const { return m_pComboBox; }
	void SetDropDownComboFlag(BOOL bIsDropDownCombo) { m_bIsDropDownCombo = bIsDropDownCombo; }

friend class CPictComboBox;
friend class CPictScrollBar;
};

/***********************************************************************
  CLASS:		 CPictComboBox

  BASE CLASS:	 CComboBox
  
  Author:        Jan Xiang
  
  Date:          May 4, 1997
  
  Description:   This is the transparent combo box control. 
 **********************************************************************/
class CPictComboList;
class CComboEdit;
class AFX_EXT_CLASS CPictComboBox : public CComboBox
{
	DECLARE_DYNCREATE(CPictComboBox)

// Construction
public:
	CPictComboBox();

// Attributes
public:

// Operations
public:
	int AddString(LPCTSTR lpszItem);
	int InsertString(int nIndex, LPCTSTR lpszItem);
	int DeleteString(UINT nIndex);
	void ResetContent();

	int FindString(int nStartAfter, LPCTSTR lpszString) const;
	int FindStringExact(int nIndexStart, LPCTSTR lpszFind) const;
	int SelectString(int nStartAfter, LPCTSTR lpszString);

	int GetCount() const;
	int GetCurSel() const;
	int SetCurSel(int nSelect);

	int SetItemData(int nIndex, DWORD dwItemData);
	int SetItemDataPtr(int nIndex, void* pData);
	DWORD GetItemData(int nIndex ) const;
	void* GetItemDataPtr(int nIndex ) const;

	int GetLBText(int nIndex, LPTSTR lpszText) const;
	void GetLBText(int nIndex, CString& rString) const;
	int GetLBTextLen(int nIndex) const;

	int GetTopIndex() const;
	int SetTopIndex(int nIndex);

	void SetHorizontalExtent(UINT nExtent);
	UINT GetHorizontalExtent() const;

	int SetItemHeight(int nIndex, UINT cyItemHeight);

	DWORD GetEditSel() const;
	BOOL SetEditSel(int nStartChar, int nEndChar); 

	void GetWindowText(CString& rString) const;
	void SetWindowText(LPCTSTR lpszString);
	void Clear();
	void Copy();
	void Cut();
	void Paste();
	BOOL LimitText(int nMaxChars);

	BOOL GetDroppedState() const { return m_bDropDownDisplayed; }
	void ShowDropDown(BOOL bShowIt=TRUE);

	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	virtual void MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct);
	virtual int CompareItem(LPCOMPAREITEMSTRUCT lpCompareItemStruct);
	virtual void DeleteItem(LPDELETEITEMSTRUCT lpDeleteItemStruct);

	void HideListBox();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPictComboBox)
	virtual void PreSubclassWindow( );
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CPictComboBox();

	// Generated message map functions
protected:
	//{{AFX_MSG(CPictComboBox)
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnPaint();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnNcPaint();
	afx_msg void OnDestroy();
	afx_msg int OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

protected:
	CRect m_clientRect;
	BOOL m_bIgnoreFocus;
	DWORD m_dwStyle;
	CRect* m_pButtonRect;
	BOOL m_bLButtonDown;
	CFont* m_pFont;
	BOOL m_bFirstTime;
	CRect m_simpleComboRect;
	BOOL m_bHasFocus;

	CPictComboList* m_pListBoxDlg;
	CString m_csSelectedText;
	BOOL m_bDropDownDisplayed;

	CComboEdit* m_pComboEdit;
	BOOL m_bIsDropDownCombo;

	void CreateComboListBox();
	void SetComboListboxSize();
	void HandleMouseDown(UINT nFlags, CPoint point);
	void RedrawStatic();

protected:
	void ItemSelected(LPSTR szText, BOOL bSetTextOnly=FALSE);
	void EditChanged(LPCTSTR lpszString);
	CPictScrollBar* GetScrollBar() const;
	CPictListBox* GetListBox() const;
	CPictComboList* GetListBoxDlg() const { return m_pListBoxDlg; }
	BOOL IsDropDownDisplayed() const { return m_bDropDownDisplayed; }

friend class CComboEdit;
friend class CPictListBox;
friend class CPictScrollBar;
};

/***********************************************************************
  CLASS:		 CPictStatusBar

  BASE CLASS:	 CStatusBar
  
  Author:        Jan Xiang
  
  Date:          June 1, 1997
  
  Description:   enable status bar to display bitmap background. 
 **********************************************************************/
class AFX_EXT_CLASS CPictStatusBar : public CStatusBar
{
// Construction
public:
	CPictStatusBar();

// Attributes
public:
	void SetBitmapID(UINT nImageID) { m_nImageID = nImageID; }

	void SetModifyColor(COLORREF color) { m_modifyColor = color; }
	void SetTextColor(COLORREF textColor) { m_textColor = textColor; }
	void SetFont(CFont* pFont);

// Operations
public:
	BOOL SetIndicators(const UINT* lpIDArray, int nIDCount);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPictStatusBar)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CPictStatusBar();

	// Generated message map functions
protected:
	//{{AFX_MSG(CPictStatusBar)
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

protected:
	UINT m_nImageID;
	int m_iIDCount;
	COLORREF m_modifyColor;

	CDC* m_pMemDC;
	CBitmap* m_pMemDCBitmap;
	BOOL m_bUseBackGroundBitmap;

	COLORREF m_textColor;
	CFont* m_pFont;
};

/***********************************************************************
  CLASS:		 CPictMenuBar

  BASE CLASS:	 CToolBar
  
  Author:        Jan Xiang
  
  Date:          June 1, 1997
  
  Description:   enable menu to display bitmap background. 
 **********************************************************************/
class AFX_EXT_CLASS CPictMenuBar : public CToolBar
{
    DECLARE_DYNCREATE(CPictMenuBar)

// Construction
public:
	CPictMenuBar();

// Attributes
public:
	void SetBitmapID(UINT nImageID) { m_nImageID = nImageID; }

	void SetModifyColor(COLORREF color) { m_modifyColor = color; }
	void SetTextColor(COLORREF textColor) { m_textColor = textColor; }
	void SetDisableTextColor(COLORREF textColor) { m_disableTextColor = textColor; }
	void SetFont(CFont* pFont);

	BOOL Create(CWnd* pParentWnd, DWORD dwStyle = WS_CHILD | WS_VISIBLE | CBRS_TOP,	UINT nID = 0);
	BOOL LoadMenu(UINT nIDResource);
	void GetChildFrameMenu(CWnd* pChildFrame, HMENU hChildFrameMenu);

// Operations
public:
	BOOL IsSelectChanged(CPoint point, UINT& nIndex);
	void EndAllSubMenu();
	void DisplaySubMenu(UINT nIndex);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPictMenuBar)
	virtual void OnUpdateCmdUI(CFrameWnd* pTarget, BOOL bDisableIfNoHndler);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CPictMenuBar();

	// Generated message map functions
protected:
	//{{AFX_MSG(CPictMenuBar)
	afx_msg void OnPaint();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point); 
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point); 
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point); 
	afx_msg void OnNcPaint(); 
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnClose();
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnSysChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnDestroy();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	afx_msg LRESULT OnDisplaySubMenu(UINT nIndex, LPARAM);

	DECLARE_MESSAGE_MAP()

protected:
	struct IDCSTRUCT
	{
		UINT nIDC;
		CRect rect;
		BOOL bEnable;
		CString csMenuText;
	};
	struct WINDOWMENU
	{
		CWnd* pWnd;
		HMENU hMenu;
	};
	IDCSTRUCT* m_aIDCList;
	CFont* m_pFont;
	COLORREF m_textColor;
	COLORREF m_disableTextColor;
	UINT m_nImageID;
	CPtrList* m_pMenuList;
	COLORREF m_modifyColor;

	CWnd* m_pParentWnd;
	CMenu m_mainMenu;
	CMenu* m_pCurMenu;
	BOOL m_bMaximized;
	UINT m_nMenuCount;
	BOOL m_bLButtonDown;
	BOOL m_bUseBackGroundBitmap;

	UINT m_nCurSubmenuIndex;
	BOOL m_bCaptured;
	CRect m_drawRect;
	CDC* m_pMemDC;
	CDC* m_pNonClientMemDC;
	CBitmap* m_pMemDCBitmap;
	CBitmap* m_pNonClientMemDCBitmap;

	int m_iNonClientHorOffset;
	int m_iNonClientVerOffset;

	void DisplayMainMenu();
	void DisplaySubMenu(CMenu* pSubMenu, UINT nIndex);
	void SwitchMenu();

	void CreateDCFromMainFrameDC(CDC* pDC);
	void CreateDCFromMenuBitmap(CDC* pDC);
	void RestoreRect();
	void PaintZoomBox(CDC* pDC, CRect& rect, CRect& btnRect, UINT nUpBitmap, UINT nDnBitmap, BOOL bIsCloseBtn);
	BOOL RePaintZoomBox(CPoint point, BOOL bFromLButtonDown=FALSE);
	void GetHighlightRect(CRect& rect);
};

/***********************************************************************
  CLASS:		 CPictTabCtrl

  BASE CLASS:	 CTabCtrl
  
  Author:        Jan Xiang
  
  Date:          June 1, 1997
  
  Description:   Transparent tab control.
 **********************************************************************/
class AFX_EXT_CLASS CPictTabCtrl : public CTabCtrl
{
// Construction
public:
	CPictTabCtrl();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPictTabCtrl)
	public:
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CPictTabCtrl();

	// Generated message map functions
protected:
	//{{AFX_MSG(CPictTabCtrl)
	afx_msg void OnPaint();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/***********************************************************************
  CLASS:		 CPictSheet

  BASE CLASS:	 CPropertySheet
  
  Author:        Jan Xiang
  
  Date:          June 21, 1997
  
  Description:   enable property sheet to display bitmap background. 
 **********************************************************************/
class AFX_EXT_CLASS CPictSheet : public CPropertySheet
{
	DECLARE_DYNAMIC(CPictSheet)

// Construction
public:
	CPictSheet(UINT nIDCaption, CWnd* pParentWnd = NULL, UINT iSelectPage = 0);
	CPictSheet(LPCTSTR pszCaption, CWnd* pParentWnd = NULL, UINT iSelectPage = 0);

// Attributes
public:
	void SetBitmapID(UINT nImageID) { m_nImageID = nImageID; }
	CDC* GetMemDC() const { return m_pMemDC; }
	UINT GetImageID() const { return m_nImageID; }

	void SetButtonTextFont(CFont* pFont);
	void SetButtonTextColor(COLORREF color) { m_buttonTextColor = color; }
	void SetDisableTextColor(COLORREF color) { m_disableTextColor = color; }

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPictSheet)
	public:
	virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CPictSheet();

	// Generated message map functions
protected:
	//{{AFX_MSG(CPictSheet)
	afx_msg void OnPaint();
	afx_msg void OnNcDestroy();
	afx_msg LRESULT OnPageModified(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnPageUnModified(WPARAM wParam, LPARAM lParam);
	//}}AFX_MSG
	afx_msg LRESULT OnApplyBtnClicked(WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()

protected:
	UINT m_nImageID;
	CDC* m_pMemDC;
	CBitmap* m_pMemDCBitmap;
	BOOL m_bModified;

	CPictTabCtrl m_ctTabCtrl;
	CPictButton m_ctOK;
	CPictButton m_ctCancel;
	CPictButton m_ctApply;

	COLORREF m_buttonTextColor;
	CFont* m_pButtonTextFont;
	COLORREF m_disableTextColor;

	void ConstructorInit();
	void AttachControls(CWnd* pWnd, UINT nIDC, int type);
	void DoPageModify(BOOL bPageModified, HWND hWnd);

friend class CPictButton;
friend class CPictPage;
};

#endif // _JPICT_H
