Attribute VB_Name = "basMAIN"
Option Explicit
'  MetaGif converts Windows Metafiles to CompuServe Gif files. This
'  32 bit DLL allows image resizeing without distortion. With this
'  library you can create WEB documents on the fly, from your Windows
'  application. With MetaGif you can create a Gif file that is larger
'  than the screen.
'
'  The main() program is a simple example of how to use MetaGif. The program
'  will convert the two Windows (placeable) Metafiles to CompuServe Gif
'  files. You can use Microsoft Word to view the metafiles and the gif file
'  results.
'
'  See the MetaGif function declarations for a full description of usage.
'  This 32 bit MetaGif DLL is a registered copy. If you want additional
'  copies please see the readme.txt file for registration information.
'
'  The author of this program accepts no responsibility for damages
'  resulting from the use of this product and makes no warranty or
'  representation, either express or implied, including but not limited
'  to, any implied warranty of merchantability or fitness for a particular
'  purpose. This software is provided "AS IS", and you, its user, assume
'  all risks when using it.
'
'  Author:
'     David E. Suffield
'     Eckler Software
'     620 101st Court
'     Vancouver, WA 98664
'     dsuffiel@worldaccessnet.com
'

'
' Function: MetaGif()
'
' Purpose: Convert Placeable Metafiles to Gif files.
'
' Parameters:
'          szWmf    placeable metafile file name (input)
'          szGif    gif file name (output)
'          scaleX   scale factor percentage (100 = width*1)
'          scaleY   scale factor percentage (150 = height*1.5)
'
' Returns:
'          -3    could not open placeable metafile
'          -2    could not write gif file
'          -1    not a placeable metafile
'           0    not enough memory
'           1    ok
'
' Discription:
'          This function is provided for backward compatibility. It
'          is now superseded by MetaGifEx(). The gif file will be
'          created with the following defaults - background is white,
'          background is not transparent and not interlaced.
'

'
' Function: MetaGifEx()
'
' Purpose: Convert Placeable Metafiles to Gif files.
'
' Parameters:
'          szWmf    placeable metafile file name (input)
'          szGif    gif file name (output)
'          scaleX   scale factor percentage (100 = width*1)
'          scaleY   scale factor percentage (150 = height*1.5)
'          opt      conversion options
'          param    conversion parameter
'
' Returns:
'          -3    could not open placeable metafile
'          -2    could not write gif file
'          -1    not a placeable metafile
'           0    not enough memory
'           1    ok
'
' Discription:
'          This function supersedes MetaGif(). With MetaGifEx() you
'          can 1)change the gif default background from white to any
'          color 2)make the gif background color transparent 3)create
'          an interlaced gif.
'
' History:
'          1.00 Converted from 16 bit MetaGif.
'
'          2.00 Rewritten for 32 bit WIN95/NT OS.  Up to 32 times faster than
'          MetaGif 1.00.  MetaGif 2.00 supports the following display modes -
'          1, 4, 8, 16 and 24 color bits per pixel.  This corresponds to
'          monochrome, 16, 256, 32k and 16meg color displays.  MetaGif memory
'          usage depends on the size of your gif file in pixels and your default
'          color display settings.  A 24 bit color display would use 3 times
'          more memory than a 8 bit color display.
'
'          MetaGif 2.00 uses the default display settings when converting wmf files to
'          gif.  If you want the same results between Win95 and WinNT the display
'          mode setting must be identical.  For example, if you are using 24 bit
'          color on Win95 you must use the 24 bit color setting on WinNT.  This
'          requirement is also true for two different PCs.  If you create wmf
'          files on one PC and do conversions to gif on another PC make sure the
'          display mode setting are the same for both machines.
'
'          MetaGif 2.1 adds a new api call - MetaGifEx().
'
Declare Function MetaGif Lib "METAGIF32.DLL" (ByVal szWmf As String, ByVal szGif As String, ByVal scaleX As Long, ByVal scaleY As Long) As Long
Declare Function MetaGifEx Lib "METAGIF32.DLL" (ByVal szWmf As String, ByVal szGif As String, ByVal scaleX As Long, ByVal scaleY As Long, ByVal opt As Long, ByVal param As Long) As Long

'Defines for MetaGifEx() "opt" parameter. Note, constants are additive.
Global Const OPT_DEFAULT = 0
Global Const OPT_TRANSPARENT = &H1000000  'make gif background transparent
Global Const OPT_INTERLACED = &H2000000   'make gif interlaced
Global Const OPT_BACKGROUND = &H8000000   'set gif background color, use "param" to specify rgb color

Global stopit As Integer

Sub main()
   Dim r As Integer, i As Integer, hInst As Long
   Dim exePath As String
   Dim t1 As Long, t2 As Long
     
   t1 = Timer
   Screen.MousePointer = 11   ' Change pointer to hourglass.
   
   frmTest.txtMax = 10
   frmTest.txtCnt = 0
   frmTest.Show
   frmTest.Refresh

   If (Right$(App.Path, 1) <> "\") Then
      exePath = App.Path + "\"
   Else
      exePath = App.Path   'probably app.path="A:\"
   End If

   stopit = False
   
   For i = 1 To frmTest.txtMax
      'Convert metafile to gif, output is 50% bigger.
      r = MetaGif(exePath + "anchor.wmf", exePath + "anchor.gif", 150, 150)
      If (r <> 1) Then
         MsgBox ("MetaGif() return: " + Format$(r))
      End If
      
      'Convert metafile to gif, output is 50% smaller, gif background is transparent, interlaced, background is light gray.
      r = MetaGifEx(exePath + "coins.wmf", exePath + "coins.gif", 50, 50, OPT_TRANSPARENT + OPT_INTERLACED + OPT_BACKGROUND, frmTest.shape1.FillColor)
      If (r <> 1) Then
         MsgBox ("MetaGifEx() return: " + Format$(r))
      End If
      
      frmTest.txtCnt = i
      r = DoEvents()
      If (stopit) Then Exit For
   Next
   
   Unload frmTest
   Screen.MousePointer = 0
   t2 = Timer - t1
   MsgBox ("time in seconds: " + Format$(t2))

End Sub

