' ACCURACY.BAS: 8087 compiler math accuracy tester, v 1.7, Oct 1987
'          (c) 1987 PC Tech Journal and Ziff Communications Co.
'                         written by Jim Roberts.
'
' The strings COMPIL$ and MACHIN$ should be set for each system.
'
' THIS PROGRAM CONTAINS MANY LOOPS THAT SERVE NO PURPOSE OTHER
'     THAN TO ASSURE THAT ALL COMPUTATIONS ARE PERFORMED ON
'     QUANTITIES THAT HAVE BEEN SAVED TO 64 BIT FORM.
'
'
REM $INCLUDE : 'ACC.INC1'
   for I = 1 to  10
      testerr(I) = 0.0D0
   NEXT I
   toterr = 0.0D0
'
   CALL header
   CALL arith(KK,a(),b(),c(),errq(),logerr(),diverr(),_
             th(),valq(),funct(),testerr())
   CALL trig(KK,errq(),logerr(),th(),valq(),funct(),testerr())
   CALL transc(KK,errq(),logerr(),th(),valq(),funct(),testerr())
   CALL roots(KK,errq(),logerr(),th(),valq(),funct(),testerr())
'
   for I = 1 to ITEST
      toterr = toterr + testerr(I)
   NEXT I
   toterr = toterr / ITEST
   PRINT "Overall rating: ";
   PRINT USING "###.##" ; toterr
END   'of ACCURACY program

DEF FNosgn#(I)
   IF (I=2*(I/2)) THEN FNosgn#=1.0D0 ELSE FNosgn#=-1.0D0
END DEF

SUB filla (a,JJ) STATIC
   SHARED X, Y
   for I = 1 to JJ
      for J = 1 to JJ
         if (I <> J) then a(I,J) = Y  else a(I,J) = X + Y
      NEXT J
   NEXT I
end SUB

SUB fillb (b,JJ) STATIC
   SHARED X, Y
   f = X + JJ*Y
   d = 1.0D0/(X*f)
   for I = 1 to JJ
      for J = 1 to JJ
         if (I <> J) then b(I,J) = -Y*d  else b(I,J) = (-Y+f)*d
      NEXT J
   NEXT I
end SUB

SUB fillc (c,JJ) STATIC
   for I = 1 to JJ
      for J = 1 to JJ
         c(I,J) = 0.0D0 : NEXT J
   NEXT I
end SUB

SUB mult (a,b,c,JJ) STATIC
   for I = 1 to JJ
      for J = 1 to JJ
         sum = 0.0D0
         for K = 1 to JJ
            sum = sum + a(I,K) * b(K,J) : NEXT K
         c(I,J) = sum
      NEXT J
   NEXT I
end  SUB

SUB sumit (c,JJ,sum) STATIC
   sum = 0.0D0
   for I = 1 to JJ
      c(I,I) = c(I,I) - 1.0D0 : NEXT I
   for I = 1 to JJ
      for J = 1 to JJ
         sum = sum + ABS(c(I,J)) :  NEXT J
   NEXT I
end SUB

SUB header STATIC
   SHARED COMPIL$, MACHIN$
   CLS
   PRINT "ACCURACY: double precision math tester: "
   PRINT USING "&"; COMPIL$ ; : PRINT USING "&"; MACHIN$
   PRINT "     V 1.7 (c) 1987, PC Tech Journal and Ziff Communications Co."
   PRINT "                   written by Jim Roberts."
   PRINT "Test 1 checks multiplication and addition, then division and subtraction."
   PRINT "Test 2 measures the accuracy of the trig functions sine, tan, and arctan."
   PRINT "Test 3 finds the truncation error in some exponential and sqrt identities."
   PRINT "ACCURACY is the rounded negative log of error.  Program may exit abnormally."
   PRINT "NOTE: an increase of 1 in the rating means a factor of TEN less accurate."
   PRINT "Interpretation  <0.0 - 0.5 => Excellent     1.0 - 1.5 => Fair"
   PRINT "  of RATING:     0.5 - 1.0 => Good          1.5 <     => Poor"
   PRINT
   PRINT "      TESTS                       ACCURACY            RATING  "
end SUB

SUB arith(KK,a,b,c,errq,logerr,diverr,_
           th,valq,funct,testerr) STATIC
'TEST 1: well-conditioned combinatorial matrix times its inverse.
   SHARED LOG10E,PI,ROOT2,ROOT3,MINERR,LOGMIN,X,Y
   zz =  0.30     'factor used to control decrease of condition of matrix
   for IL = 1 to 5
      xx =  zz*(3-IL)
      X  =  exp(xx/LOG10E)   'slowly decreases conditioning
      CALL filla (a(),KK)
      CALL fillb (b(),KK)
      CALL fillc (c(),KK)
      CALL mult  (a(),b(),c(),KK)
      CALL sumit (c(),KK,sum)
      errq(IL) = sum/(KK*KK)    'error is average absolute error per element
      if (errq(IL) > MINERR) then
         logerr(IL) = -LOG(errq(IL))*LOG10E
      else
         logerr(IL) = LOGMIN
      END IF
      testerr(1) = testerr(1) + (LOGMIN - logerr(IL))
   NEXT IL
   testerr(1) = testerr(1)/5.0D0

   PRINT "#1a: 10x10 matrix       " ;
   for I = 1 to 5
      PRINT USING "###.#"; logerr(I);
   NEXT I
   PRINT USING "    ###.##"; testerr(1)


' infinite product for 1-x: run in reverse to test division
   sum = 0.0D0
   for IL = 1 to 5
      xx = (1 - IL) / 4.0D0
      zz = exp((xx-2.0D0)/LOG10E)  'increases number of factors for convergence
      xx = 1.0D0 - zz     'cancellation error
'      The following formula for the number of factors is designed to give
'      sufficient accuracy, while avoiding underflow in the powers of xx.
'      It gives a more uniform computation from compiler to compiler.
      JM = 12+IL
      quot = 1.0D0
      for K = 1 to JM
         quot = quot / (1.0D0 + xx)
         xx = xx * xx
      NEXT K
      errq(IL) = ABS(1.0D0 - quot/zz)*0.01
      if (errq(IL) > MINERR) then
         diverr(IL) = -LOG(errq(IL))*LOG10E
      else
         diverr(IL) = LOGMIN
      END IF
      sum = sum + (LOGMIN - diverr(IL))
      logerr(IL) = diverr(IL)   'needed for later average
   NEXT IL
   sum = sum / 5.0D0

   PRINT "#1 : infinite product   ";
   for I = 1 to 5
      PRINT USING "###.#" ; diverr(I);
   NEXT I
   PRINT USING "    ###.##" ; sum
'
' test continued fraction for tangent against exact values for five angles:
'   this is a test of division and subtraction, not of the tangent.
   th(1) = PI/12.0D0
   th(2) = PI/6.0D0
   th(3) = PI/4.0D0
   th(4) = PI/3.0D0
   th(5) = 5.0D0*PI/12.0D0
   valq(1) = 2.0D0 - ROOT3
   valq(2) = 1.0D0 / ROOT3
   valq(3) = 1.0D0
   valq(4) = ROOT3
   valq(5) = 2.0D0 + ROOT3
   sum = 0.0D0
   JM = 8     ' this number of iterations gives sufficient accuracy
   for IL = 1 to 5
      a0 = 2.0D0 * JM + 1.0D0
      p2 = th(IL)
      p  = p2*p2
      d0 = a0 - p / (a0 + 2.0D0)
      for K = 1 to JM
         a1 = a0 - 2.0D0
         d1 = a1 - p / d0
         a0 = a1
         d0 = d1
      NEXT K
      frac = p2 / d0
      funct(IL) = frac
   NEXT IL
   for IL = 1 to 5
      errq(IL) = ABS(1.0D0 - valq(IL)/funct(IL))
      if (errq(IL) > MINERR) then
         diverr(IL) = -LOG(errq(IL))*LOG10E
      else
         diverr(IL) = LOGMIN
      END IF
      sum = sum + (LOGMIN - diverr(IL))
   NEXT IL
   sum = sum / 5.0D0

   PRINT "#1 : continued fraction " ;
   for I = 1 to 5
      PRINT USING "###.#"; diverr(I);
   NEXT I
   PRINT USING "    ###.##"; sum

   PRINT "#1b: division average   " ;
   for I = 1 to 5
      logerr(I) = 0.5D0*(logerr(I) + diverr(I))
      testerr(2) = testerr(2) + (LOGMIN - logerr(I))
   NEXT I
   testerr(2) = testerr(2)/5.0D0
   for I = 1 to 5
      PRINT USING "###.#" ; logerr(I);
   NEXT I
   PRINT USING "    ###.##" ; testerr(2)
   'the estimated standard deviation of the average accuracy is not meaningful
end SUB
'
SUB trig(KK,errq(1),logerr(1),th(1),valq(1),funct(1),testerr(1)) STATIC
'TEST 2: truncation in some sine identities
   SHARED LOG10E,PI,PIO2,ROOT2,ROOT3,SQRTO2,MINERR,LOGMIN,SALT,ITER,ITERTRIG
   FOR IL = 1 TO 5
     logerr(IL) = 0.0D0
   NEXT IL
   FOR J = 1 TO ITERTRIG
      MJ = J-1
      IF (J=2*(J\2)) THEN osgn=-1.0D0 ELSE osgn=1.0D0
      th(1) = PI/12.0D0 + MJ*PI
      th(2) = PI/6.0D0 + MJ*PI
      th(3) = PI/4.0D0 + MJ*PI
      th(4) = PI/3.0D0 + MJ*PI
      th(5) = 5.0D0*PI/12.0D0 + MJ*PI
      valq(1) = osgn*ROOT2*(ROOT3-1.0D0)*0.25D0
      valq(2) = osgn*0.5D0
      valq(3) = osgn*SQRTO2
      valq(4) = osgn*0.5D0*ROOT3
      valq(5) = osgn*ROOT2*(ROOT3+1.0D0)*0.25D0
      for IL = 1 to 5
         funct(IL) = SIN(th(IL))
      NEXT IL
      FOR IL = 1 TO 5
         errq(IL) = ABS(1.0D0 - valq(IL)/funct(IL))
         IF (errq(IL) > MINERR) then
            logerr(IL) = logerr(IL) - LOG(errq(IL))*LOG10E
         ELSE
            logerr(IL) = logerr(IL) + LOGMIN
         END IF
      NEXT IL
   NEXT J
   FOR IL = 1 TO 5
      logerr(IL) = logerr(IL) / ITERTRIG
      testerr(3) = testerr(3) + (LOGMIN - logerr(IL))
   NEXT IL
   testerr(3) = testerr(3)/5.0D0

   PRINT "#2a: SIN()              " ;
   for I = 1 to 5
      PRINT USING "###.#"; logerr(I);
   NEXT I
   PRINT USING "    ###.##"; testerr(3)

' compare TAN() with exact values
   FOR IL = 1 TO 5
      logerr(IL) = 0.0D0
   NEXT IL
   FOR J = 1 TO ITERTRIG
      MJ = J-1
      th(1) = PI/12.0D0 + MJ*PI
      th(2) = PI/6.0D0 + MJ*PI
      th(3) = PI/4.0D0 + MJ*PI
      th(4) = PI/3.0D0 + MJ*PI
      th(5) = 5.0D0*PI/12.0D0 + MJ*PI
      valq(1) = 2.0D0 - ROOT3
      valq(2) = 1.0D0 / ROOT3
      valq(3) = 1.0D0
      valq(4) = ROOT3
      valq(5) = 2.0D0 + ROOT3
      for IL = 1 to 5
         funct(IL) = TAN(th(IL))
      NEXT IL
      for IL = 1 to 5
         errq(IL) = ABS(1.0D0 - valq(IL)/funct(IL))
         if (errq(IL) > MINERR) then
            logerr(IL) = logerr(IL) - LOG(errq(IL))*LOG10E
         else
            logerr(IL) = logerr(IL) + LOGMIN
         END IF
      NEXT IL
   NEXT J
   FOR IL = 1 TO 5
      logerr(IL) = logerr(IL) / ITERTRIG
      testerr(4) = testerr(4) + (LOGMIN - logerr(IL))
   next IL
   testerr(4) = testerr(4)/5.0D0

   PRINT "#2b: TAN()              " ;
   for I = 1 to 5
      PRINT USING "###.#"; logerr(I);
   NEXT I
   PRINT USING "    ###.##"; testerr(4)

'compare arctan, ATN(), with exact values
   FOR IL = 1 TO 5
      logerr(IL) = 0.0D0
   NEXT IL
   FOR J = 1 TO ITER
      FOR IL = 1 TO 5
         denum = 5*J+IL-5
         denom = 5*ITER+1
         th(IL) = denum * PIO2 / denom
      NEXT IL
      FOR IL = 1 TO 5
         valq(IL) = TAN(th(IL))
      NEXT IL
      FOR IL = 1 TO 5
         funct(IL) = ATN(valq(IL))
      NEXT IL
      for IL = 1 to 5
         errq(IL) = ABS(1.0D0 - th(IL)/funct(IL))
         if (errq(IL) > MINERR) then
            logerr(IL) = logerr(IL) - LOG(errq(IL))*LOG10E
         else
            logerr(IL) = logerr(IL) + LOGMIN
         END IF
      NEXT IL
   NEXT J
   FOR IL = 1 TO 5
      logerr(IL) = logerr(IL) / ITER
      testerr(5) = testerr(5) + (LOGMIN - logerr(IL))
   NEXT IL
   testerr(5) = testerr(5)/5.0D0

   PRINT "#2c: ATN() (arctan)     " ;
   for I = 1 to 5
      PRINT USING "###.#"; logerr(I);
   NEXT I
   PRINT USING "    ###.##"; testerr(5)

end SUB

SUB transc(KK,errq(1),logerr(1),th(1),valq(1),funct(1),testerr(1)) STATIC
    'TEST 3: LOG() and EXP() identities.
   SHARED LOG10E,PI,PIO2,ROOT2,ROOT3,SQRTO2,MINERR,LOGMIN,SALT,ITER
   FOR IL = 1 TO 5
      logerr(IL) = 0.0D0
   NEXT IL
   FOR J = 1 TO ITER
      FOR IL = 1 TO 5
         th(IL) = (5*J+IL-5) * SALT
      NEXT IL
      for IL = 1 to 5
         valq(IL) = exp(th(IL))
      NEXT IL
      for IL = 1 to 5
         funct(IL) = log(valq(IL))
      NEXT IL
      for IL = 1 to 5
         errq(IL) = ABS(1.0D0 - th(IL)/funct(IL))
         if (errq(IL) > MINERR) then
            logerr(IL) = logerr(IL) - log(errq(IL))*LOG10E
         else
            logerr(IL) = logerr(IL) + LOGMIN
         END IF
      NEXT IL
   NEXT J
   FOR IL = 1 TO 5
      logerr(IL) = logerr(IL) / ITER
      testerr(6) = testerr(6) + (LOGMIN - logerr(IL))
   NEXT IL
   testerr(6) = testerr(6)/5.0D0

   PRINT "#3a: LOG() & EXP()      " ;
   for I = 1 to 5
      PRINT USING "###.#"; logerr(I);
   NEXT I
   PRINT USING "    ###.##"; testerr(6)

end SUB

SUB roots(KK,errq(1),logerr(1),th(1),valq(1),funct(1),testerr(1)) STATIC
' SQR()  identities
   SHARED LOG10E,PI,PIO2,ROOT2,ROOT3,SQRTO2,MINERR,LOGMIN,SALT,ITER
   FOR IL = 1 TO 5
      logerr(IL) = 0.0D0
   NEXT IL
   FOR J = 1 TO ITER
      FOR IL = 1 TO 5
         th(IL) = (5*J+IL-5) * SALT
      NEXT IL
      for IL = 1 to 5
         valq(IL) = SQR(th(IL))
      NEXT IL
      for IL = 1 to 5
         funct(IL) = valq(IL)*valq(IL)
      NEXT IL
      for IL = 1 to 5
         errq(IL) = ABS(1.0D0 - th(IL)/funct(IL))
         if (errq(IL) > MINERR) then
            logerr(IL) = logerr(IL) - LOG(errq(IL))*LOG10E
         else
            logerr(IL) = logerr(IL) + LOGMIN
         END IF
      NEXT IL
   NEXT J
   FOR IL = 1 TO 5
      logerr(IL) = logerr(IL) / ITER
      testerr(7) = testerr(7) + (LOGMIN - logerr(IL))
   next il
   testerr(7) = testerr(7)/5.0D0

   PRINT "#3b: SQR()              " ;
   for I = 1 to 5
      PRINT USING "###.#"; logerr(I);
   NEXT I
   PRINT USING "    ###.##"; testerr(7)

end SUB

'end of source
