import java.awt.*;
import com.sun.java.swing.*;
import com.sun.java.swing.tree.*;
import multilizer.*;

public class TreePanel extends JPanel
{
  BorderLayout borderLayout1 = new BorderLayout();
  SwingTranslator swingTranslator1 = new SwingTranslator();
  JTree jTree1 = new JTree();
	JScrollPane scrollPane = new JScrollPane(jTree1);

  public TreePanel(Dictionary dictionary)
  {
    try
    {
      jbInit();

      // Inits the translator and translates the panel

      swingTranslator1.setDictionary(dictionary);
      swingTranslator1.translate();
    }
    catch (Exception ex)
    {
      ex.printStackTrace();
    }
  }

  private void jbInit() throws Exception
  {
  	//Create the nodes.
    DefaultMutableTreeNode top = new DefaultMutableTreeNode("The Java Series");
    DefaultMutableTreeNode category;
    DefaultMutableTreeNode book;

    category = new DefaultMutableTreeNode("Books for Java Programmers");
    top.add(category);

    book = new DefaultMutableTreeNode("The Java Tutorial: Object-Oriented Programming for the Internet");
    book.add(new DefaultMutableTreeNode("Mary Campione"));
    book.add(new DefaultMutableTreeNode("Kathy Walrath"));
    category.add(book);

    book = new DefaultMutableTreeNode("The Java Programming Language");
    book.add(new DefaultMutableTreeNode("Ken Arnold"));
    book.add(new DefaultMutableTreeNode("James Gosling"));
    category.add(book);

    book.add(new DefaultMutableTreeNode("Jonni Kanerva"));
    category.add(book);
    book = new DefaultMutableTreeNode("The Java Class Libraries: An Annotated Reference");
    book.add(new DefaultMutableTreeNode("Patrick Chan"));
    book.add(new DefaultMutableTreeNode("Rosanna Lee"));
    category.add(book);

    book = new DefaultMutableTreeNode("Concurrent Programming in Java: Design Principles and Patterns");
    book.add(new DefaultMutableTreeNode("Doug Lea"));
    category.add(book);

    category = new DefaultMutableTreeNode("Books for Java Implementers");
    top.add(category);
    book = new DefaultMutableTreeNode("The Java Virtual Machine Specification");
    book.add(new DefaultMutableTreeNode("Tim Lindholm"));
    book.add(new DefaultMutableTreeNode("Frank Yellin"));
    category.add(book);

    book = new DefaultMutableTreeNode("The Java Language Specification");
    book.add(new DefaultMutableTreeNode("James Gosling"));
    book.add(new DefaultMutableTreeNode("Bill Joy"));
    book.add(new DefaultMutableTreeNode("Guy Steele"));
    category.add(book);

    jTree1.setModel(new DefaultTreeModel(top));

    this.setLayout(borderLayout1);
    this.add(scrollPane, BorderLayout.CENTER);

    swingTranslator1.setTargets("+*.text;+*.label;+*.title;+*.items;+*.toolTipText");
    swingTranslator1.setHost(this);
  }
}

