import java.awt.*;
import multilizer.*;
import com.sun.java.swing.*;
import com.sun.java.swing.table.*;

public class TablePanel extends JPanel
{
  BorderLayout borderLayout1 = new BorderLayout();
  SwingTranslator swingTranslator1 = new SwingTranslator();
  JTable jTable1 = new JTable(new MyTableModel());
  JScrollPane scrollPane = new JScrollPane(jTable1);

  public TablePanel(Dictionary dictionary)
  {
    try
    {
      jbInit();

      // Inits the translator and translates the panel

      swingTranslator1.setDictionary(dictionary);
      swingTranslator1.translate();
    }
    catch (Exception ex)
    {
      ex.printStackTrace();
    }
  }

  private void jbInit() throws Exception
  {
    scrollPane.setPreferredSize(new Dimension(400, 100));
    this.setLayout(borderLayout1);
    swingTranslator1.setTargets("+*.text;+*.label;+*.title;+*.items;+*.toolTipText");
    swingTranslator1.setHost(this);
    this.add(scrollPane, BorderLayout.CENTER);
  }
}

class MyTableModel extends AbstractTableModel implements MTableModel
{
  final String[] columnNames =
  {
    "First Name", //ivlm
    "Last Name", //ivlm
    "Sport", //ivlm
    "Est. Years Experience" //ivlm
  };

  final String[][] data =
  {
    {"Mary", "Campione", "Snowboarding", "5"},
    {"Alison", "Huml", "Rowing", "3"},
    {"Kathy", "Walrath", "Chasing toddlers", "2"},
    {"Mark", "Andrews", "Speed reading", "20"},
    {"Angela", "Lih", "Teaching high school", "4"}
  };

  public int getColumnCount()
  {
    return columnNames.length;
  }

  public int getRowCount()
  {
    return data.length;
  }

  public String getColumnName(int col)
  {
    return columnNames[col];
  }

  public void setColumnName(String string, int col)
  {
    columnNames[col] = string;
    fireTableStructureChanged();
  }

  public Object getValueAt(int row, int col)
  {
    return data[row][col];
  }
}

