import java.awt.*;
import java.awt.event.*;
import multilizer.*;

public class MainFrame extends Frame
{
  Button button1 = new Button();
  Label label1 = new Label();
  Checkbox checkbox1 = new Checkbox();
  GridLayout gridLayout1 = new GridLayout();
  TestDictionary dictionary = new TestDictionary();
  Translator translator = new Translator();

  public MainFrame()
  {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try
    {
      jbInit();
      translator.translate();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception
  {
    setTitle("Frame Title"); //ivlm
    setBackground(SystemColor.control);
    setLayout(gridLayout1);
    setSize(new Dimension(400, 300));
    button1.setLabel("This label is translated normally"); //ivlm
    button1.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        button1_actionPerformed(e);
      }
    });
    label1.setText("This label is restricted"); //ivlm
    checkbox1.setLabel("The label property of this check box is restricted"); //ivlm
    gridLayout1.setRows(3);
    gridLayout1.setColumns(1);
    translator.setHost(this);
    translator.setDictionary(dictionary);
    translator.setTargets("+*.text;+*.label;+*.title;+*.items");
    translator.addRestrictPropertyListener(new multilizer.RestrictPropertyListener()
    {
      public void restrictProperty(RestrictPropertyEventObject e)
      {
        translator_restrictProperty(e);
      }
    });
    translator.addRestrictObjectListener(new multilizer.RestrictObjectListener()
    {
      public void restrictObject(RestrictObjectEventObject e)
      {
        translator_restrictObject(e);
      }
    });
    this.add(button1, null);
    this.add(checkbox1, null);
    this.add(label1, null);
  }

  protected void processWindowEvent(WindowEvent e)
  {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING)
    {
      System.exit(0);
    }
  }

  void button1_actionPerformed(ActionEvent e)
  {
    // Shows the language select dialog that let the user select a new language.

    try
    {
      int language = SelectLanguageDialog.select(
        this,
        new Translator(dictionary),
        false);

      if (language >= 0)
        dictionary.setLanguage(language);
    }
    catch (Exception ex)
    {
      MessageDialog.messageBox(
        this,
        "Could not change the language",
        ex.getMessage(),
        MessageDialog.OK,
        null);
    }
  }

  void translator_restrictObject(RestrictObjectEventObject e)
  {
    // If the object to be translated is label1, disables the translation of it.

    if (e.getObject() == label1)
      e.setTranslate(false);
  }

  void translator_restrictProperty(RestrictPropertyEventObject e)
  {
    // If the object to be translated is checkbox1,
    // and the property to be translated is label, disables the translation of it.

    if ((e.getObject() == checkbox1) && (e.getProperty().equals("label")))
      e.setTranslate(false);
  }
}

