package test;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import multilizer.*;

public class MainFrame extends JFrame
{
  BorderLayout borderLayout1 = new BorderLayout();
  JMenuBar menuBar1 = new JMenuBar();
  JMenu menuFile = new JMenu();
  JMenuItem menuFileExit = new JMenuItem();
  JMenu menuHelp = new JMenu();
  JMenuItem menuHelpAbout = new JMenuItem();
  JToolBar toolBar = new JToolBar();
  JButton jButton1 = new JButton();
  JButton jButton2 = new JButton();
  JButton jButton3 = new JButton();
  ImageIcon image1;
  ImageIcon image2;
  ImageIcon image3;
  JLabel statusBar = new JLabel();
  TestDictionary testDictionary1 = new TestDictionary();
  SwingTranslator swingTranslator1 = new SwingTranslator();
  
  public MainFrame()
  {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try 
    {
      jbInit();
      jButton1.setIcon(image1);
      jButton2.setIcon(image2);
      jButton3.setIcon(image3);
      testDictionary1.open();
      swingTranslator1.translate();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }
//Component initialization
  
  private void jbInit() throws Exception
  {
    image1 = new ImageIcon(getClass().getResource("openFile.gif"));
    image2 = new ImageIcon(getClass().getResource("closeFile.gif"));
    image3 = new ImageIcon(getClass().getResource("help.gif"));
    this.getContentPane().setLayout(borderLayout1);
    this.setSize(new Dimension(400, 300));
    this.setTitle("Frame Title");
    statusBar.setText(" ");
    swingTranslator1.setHost(this);
    swingTranslator1.setDictionary(testDictionary1);
    swingTranslator1.setTargets("+*.text;+*.label;+*.title;+*.items;+*.toolTipText");
    menuFile.setText("File");
    menuFileExit.setText("Exit");
    menuFileExit.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        fileExit_actionPerformed(e);
      }
    });
    menuHelp.setText("Help");
    menuHelpAbout.setText("About");
    menuHelpAbout.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        helpAbout_actionPerformed(e);
      }
    });
    jButton1.setToolTipText("Open File");
    jButton2.setToolTipText("Close File");
    jButton3.setToolTipText("Help");
    toolBar.add(jButton1);
    toolBar.add(jButton2);
    toolBar.add(jButton3);
    menuFile.add(menuFileExit);
    menuHelp.add(menuHelpAbout);
    menuBar1.add(menuFile);
    menuBar1.add(menuHelp);
    this.setJMenuBar(menuBar1);
    this.getContentPane().add(toolBar, BorderLayout.NORTH);
    this.getContentPane().add(statusBar, BorderLayout.SOUTH);
  }
//File | Exit action performed
  
  public void fileExit_actionPerformed(ActionEvent e)
  {
    System.exit(0);
  }
//Help | About action performed
  
  public void helpAbout_actionPerformed(ActionEvent e)
  {
    Frame1_AboutBox dlg = new Frame1_AboutBox(this);
    Dimension dlgSize = dlg.getPreferredSize();
    Dimension frmSize = getSize();
    Point loc = getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.setModal(true);
    dlg.show();
  }
//Overriden so we can exit on System Close
  
  protected void processWindowEvent(WindowEvent e)
  {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING)
    {
      fileExit_actionPerformed(null);
    }
  }
}

 