import java.awt.*;
import java.awt.event.*;
import multilizer.*;

public class MainFrame extends Frame implements ActionListener
{
  private List style = new List(4, false);
  private Checkbox bold = new Checkbox("Bold"); //ivde
  private Checkbox italic = new Checkbox("Italic"); //ivde
  private TextField size = new TextField();
  private TextField sample = new TextField();
  private Button button = new Button("Language..."); //ivde
  private BidiTranslator translator = new BidiTranslator();
  private TextDictionary dictionary = new TextDictionary();

  private void add(
    Component component,
    BidiGridBagLayout layout,
    BidiGridBagConstraints constrainsts,
    int x,
    int y,
    int w,
    int h)
  {
    constrainsts.gridx = x;
    constrainsts.gridy = y;
    constrainsts.gridwidth = w;
    constrainsts.gridheight = h;
    layout.setConstraints(component, constrainsts);
    add(component);
  }

  public MainFrame()
  {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);

    setTitle("Font Dialog"); //ivde
    setBackground(SystemColor.control);
    BidiGridBagLayout layout = new BidiGridBagLayout();
    setLayout(layout);

    style.addItem("Times Roman");
    style.addItem("Helvetica");
    style.addItem("Courier");
    style.addItem("Zapf Dingbats");
    style.addItem("Dialog");
    style.addItem("DialogInput");
    style.select(0);

    Label label = new Label("Size: "); //ivde

    BidiGridBagConstraints constrainsts = new BidiGridBagConstraints();
    constrainsts.fill = GridBagConstraints.BOTH;
    constrainsts.weightx = 20;
    constrainsts.weighty = 100;
    constrainsts.insets = new Insets(2, 2, 2, 2);
    add(style, layout, constrainsts, 0, 0, 1, 3);

    constrainsts.weightx = 100;
    constrainsts.fill = GridBagConstraints.NONE;
    constrainsts.anchor = GridBagConstraints.WEST;
    add(bold, layout, constrainsts, 1, 0, 2, 1);
    add(italic, layout, constrainsts, 1, 1, 2, 1);
    add(label, layout, constrainsts, 1, 2, 1, 1);

    constrainsts.fill = GridBagConstraints.HORIZONTAL;
    add(size, layout, constrainsts, 2, 2, 1, 1);

    constrainsts.anchor = GridBagConstraints.SOUTH;
    constrainsts.weighty = 0;
    add(sample, layout, constrainsts, 0, 3, 2, 1);
    sample.setText("This is a sample text"); //ivde

    constrainsts.fill = GridBagConstraints.NONE;
    constrainsts.weightx = 0;
    button.addActionListener(this);
    add(button, layout, constrainsts, 2, 3, 1, 1);

    // Center the window

    setSize(300, 180);
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = getSize();
    if (frameSize.height > screenSize.height)
      frameSize.height = screenSize.height;
    if (frameSize.width > screenSize.width)
      frameSize.width = screenSize.width;
    setLocation(
      (screenSize.width - frameSize.width)/2,
      (screenSize.height - frameSize.height)/2);

    // Translates the frame

    dictionary.setDictionaryName("font");
    translator.setDictionary(dictionary);
    translator.setHost(this);
    translator.addDefaultTargets();
    try
    {
      dictionary.open();
      translator.translate();
    }
    catch (Exception e)
    {
      MessageDialog.messageBox(
        this,
        "Error opening the dictionary",
        e.getMessage(),
        MessageDialog.OK,
        null);
    }

    setVisible(true);
  }

  protected void processWindowEvent(WindowEvent e)
  {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING)
      System.exit(0);
  }

  private void selectLanguage()
  {
    try
    {
      int language = SelectLanguageDialog.select(
        this,
        new BidiTranslator(dictionary),
        false);

      if (language >= 0)
        dictionary.setLanguage(language);
    }
    catch (Exception ex)
    {
      MessageDialog.messageBox(
        this,
        "Could not change the language",
        ex.getMessage(),
        MessageDialog.OK,
        null);
    }
  }

  public void actionPerformed(ActionEvent e)
  {
    if (e.getSource() == button)
      selectLanguage();
  }
}

