import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.applet.*;
import java.text.*;
import multilizer.*;

public class MainFrame extends Frame implements
  ActionListener, ItemListener, DictionaryListener, RestrictObjectListener, RestrictPropertyListener
{
  boolean showNative = false;
  Applet applet = null;
  MenuItem languageMenu = new MenuItem();
  MenuItem sublanguageMenu = new MenuItem();
  MenuItem localeMenu = new MenuItem();
  MenuItem exitMenu = new MenuItem();
  CheckboxMenuItem nativeMenu = new CheckboxMenuItem();
  CheckboxMenuItem allMenu = new CheckboxMenuItem();
  CheckboxMenuItem bindMenu = new CheckboxMenuItem();
  MenuItem aboutMenu = new MenuItem();
  TextField textField = new TextField();
  Button calculateButton = new Button();
  Label unitLabel = new Label();
  Label fineLabel = new Label();
  Label dateLabel = new Label();
  Label localeLabel = new Label();
  Label languageLabel = new Label();
  multilizer.Dictionary dictionary = null;
  BidiTranslator translator = new BidiTranslator();

  public MainFrame(Applet applet)
  {
    this.applet = applet;

    // Builds up the frame

    setTitle("Driving Time Calculator"); //ivde
    setBackground(SystemColor.control);
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);

    setLayout(new GridLayout(6, 1));

    Panel panel = new Panel(new BidiBorderLayout());
    panel.add(
      new Label("Give the driving distance"), //ivde
      new String("West"));
    add(panel);

    panel = new Panel(new FlowLayout(FlowLayout.LEFT));
    textField.setColumns(5);
    panel.add(textField);
    unitLabel = new Label();
    panel.add(unitLabel);
    calculateButton.setLabel("Calculate"); //ivde
    calculateButton.addActionListener(this);
    panel.add(calculateButton);
    add(panel);

    panel = new Panel(new FlowLayout(FlowLayout.LEFT));
    panel.add(new Label("Speeding file:")); //ivde
    fineLabel = new Label("fine");
    panel.add(fineLabel);
    add(panel);

    panel = new Panel(new FlowLayout(FlowLayout.LEFT));
    panel.add(new Label("Date and time:")); //ivde
    dateLabel = new Label("date");
    panel.add(dateLabel);
    add(panel);

    panel = new Panel(new FlowLayout(FlowLayout.LEFT));
    panel.add(new Label("Current locale:")); //ivde
    localeLabel = new Label("locale");
    panel.add(localeLabel);
    add(panel);

    panel = new Panel(new FlowLayout(FlowLayout.LEFT));
    panel.add(new Label("User interface language:")); //ivde
    languageLabel = new Label("language");
    panel.add(languageLabel);
    add(panel);

    if (applet == null)
      setSize(360, 220);
    else
      setSize(360, 240);

    // Builds up the menu
    //
    // Language menu

    Menu languageM = new Menu("Language"); //ivde

    languageMenu.setLabel("Language..."); //ivde
    languageMenu.addActionListener(this);
    languageM.add(languageMenu);

    sublanguageMenu.setLabel("Sublanguage..."); //ivde
    sublanguageMenu.addActionListener(this);
    languageM.add(sublanguageMenu);

    localeMenu.setLabel("Locale..."); //ivde
    localeMenu.addActionListener(this);
    languageM.add(localeMenu);

    languageM.add(new MenuItem("-"));

    exitMenu.setLabel("Exit"); //ivde
    exitMenu.addActionListener(this);
    languageM.add(exitMenu);

    // Options menu

    Menu optionsM = new Menu("Options"); //ivde

    nativeMenu.setLabel("Show native names"); //ivde
    nativeMenu.setState(showNative);
    nativeMenu.addItemListener(this);
    optionsM.add(nativeMenu);

    bindMenu.setLabel("Bind language and locale"); //ivde
    bindMenu.setState(true);
    bindMenu.addItemListener(this);
    optionsM.add(bindMenu);

    // Help menu

    Menu helpM = new Menu("Help"); //ivde

    aboutMenu.setLabel("About..."); //ivde
    aboutMenu.addActionListener(this);
    helpM.add(aboutMenu);

    MenuBar menuBar = new MenuBar();

    menuBar.add(languageM);
    menuBar.add(optionsM);
    menuBar.add(helpM);
    setMenuBar(menuBar);

    // Sets up translator.

    translator.addDefaultTargets();

    // If you want to restrict the translation of components or properties
    // comment out the two following lines and write the restrictObject and
    // restrictProperty events.

    //translator.addObjectRestrictionListener(this);
    //translator.addPropertyRestrictionListener(this);
  }

  protected void translate(multilizer.Dictionary dictionary)
  {
    // Sets up the dictionary

    this.dictionary = dictionary;
    dictionary.addLanguageChangeListener(this);
    if (applet != null)
      dictionary.setUpdateDefaultLocale(false);

    // Translates the frame

    translator.setDictionary(dictionary);
    translator.setHost(this);
    try
    {
      dictionary.open();
      translator.translate();
    }
    catch (Exception e)
    {
      MessageDialog.messageBox(
        this,
        "Error opening the dictionary",
        e.getMessage(),
        MessageDialog.OK,
        null);
    }

    // Center the window

    validate();
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = getSize();
    if (frameSize.height > screenSize.height)
      frameSize.height = screenSize.height;
    if (frameSize.width > screenSize.width)
      frameSize.width = screenSize.width;
    setLocation(
      (screenSize.width - frameSize.width)/2,
      (screenSize.height - frameSize.height)/2);
    setVisible(true);
  }

  // The dictionary calls this event every time the user has changed
  // the language

  public void languageChanged(DictionaryEventObject event)
  {
    // Updates the measurement unit

    if (Utils.getMeasurementSystem(dictionary.getActiveLocale()) == Utils.METRIC_MEASUREMENT)
      unitLabel.setText(dictionary.translate("in kilometres")); //ivde
    else
      unitLabel.setText(dictionary.translate("in miles")); //ivde

    // Updates the fine

    fineLabel.setText(NumberFormat.getCurrencyInstance(
      dictionary.getActiveLocale()).format(new Integer(100)));

    // Updates the date

    dateLabel.setText(DateFormat.getDateTimeInstance(
      DateFormat.LONG,
      DateFormat.MEDIUM,
      dictionary.getActiveLocale()).format(new Date()));

    // Updates the locale and language

    localeLabel.setText(Utils.getLocaleName(dictionary.getActiveLocale(), dictionary));
    languageLabel.setText(dictionary.translate(dictionary.getLanguageData().englishName));
  }

  public void restrictObject(RestrictObjectEventObject event)
  {
/*
    if (event.getObject() == menuLanguage)
      event.setTranslate(false);
*/
  }

  public void restrictProperty(RestrictPropertyEventObject event)
  {
/*
    if ((event.getObject() == menuLanguage) && (event.getProperty().equalsIgnoreCase("Label")))
      event.setTranslate(false);
*/
  }

  private void exit()
  {
    if (applet == null)
      System.exit(0);
    else
      setVisible(false);
  }

  protected void processWindowEvent(WindowEvent e)
  {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING)
      exit();
  }

  void selectLanguage()
  {
    try
    {
      int language = SelectLanguageDialog.select(
        this,
        new BidiTranslator(dictionary),
        showNative);

      if (language >= 0)
        dictionary.setLanguage(language);
    }
    catch (Exception ex)
    {
      MessageDialog.messageBox(
        this,
        "Could not change the language",
        ex.getMessage(),
        MessageDialog.OK,
        null);
    }
  }

  void selectSublanguage()
  {
    try
    {
      Locale locale = SelectSublanguageDialog.select(
        this,
        new BidiTranslator(dictionary),
        showNative);

      if (locale != null)
        dictionary.setLocale(locale);
    }
    catch (Exception ex)
    {
      MessageDialog.messageBox(
        this,
        "Could not change the sublanguage",
        ex.getMessage(),
        MessageDialog.OK,
        null);
    }
  }

  void selectLocale()
  {
    try
    {
      Locale locale = SelectLocaleDialog.select(
        this,
        new BidiTranslator(dictionary),
        showNative);

      if (locale != null)
        dictionary.setLocale(locale);
    }
    catch (Exception ex)
    {
      MessageDialog.messageBox(
        this,
        "Could not change the locale",
        ex.getMessage(),
        MessageDialog.OK,
        null);
    }
  }

  public void itemStateChanged(ItemEvent e)
  {
    if (e.getSource() == bindMenu)
      try
      {
        dictionary.setBindLocale(!dictionary.getBindLocale());
      }
      catch (Exception ex)
      {
        MessageDialog.messageBox(
          this,
          "Could not bind the locale",
          ex.getMessage(),
          MessageDialog.OK,
          null);
      }
    else if (e.getSource() == nativeMenu)
      showNative = nativeMenu.getState();
  }

  public void actionPerformed(ActionEvent e)
  {
    if (e.getSource() == languageMenu)
      selectLanguage();
    else if (e.getSource() == sublanguageMenu)
      selectSublanguage();
    else if (e.getSource() == localeMenu)
      selectLocale();
    else if (e.getSource() == exitMenu)
      exit();
    else if (e.getSource() == aboutMenu)
      MessageDialog.messageBox(
        this,
        "About DCALC", //ivde
        "DCALC calculates the driving time.", //ivde
        MessageDialog.OK,
        new BidiTranslator(dictionary));
    else if (e.getSource() == calculateButton)
    {
      int distance;

      try
      {
        distance = Integer.valueOf(textField.getText().trim()).intValue();
        if (distance < 0)
          throw new NumberFormatException();

        // If the current locale uses US measurement system instead of metric
        // converts the give distance (in miles) to kilometers

        if (Utils.getMeasurementSystem(dictionary.getActiveLocale()) == Utils.US_MEASUREMENT)
          distance = (int)Utils.MILE_IN_METERS*distance/1000;

        String[] params =
        {
          new Integer(distance/100).toString(),
          new Integer((int)(60*(distance%100)/100)).toString()
        };

        MessageDialog.messageBox(
          this,
          "Driving Time", //ivde
          Utils.formatMessage(
            "The avarage driving time is {0} hours and {1} minutes", //ivde
            params,
            dictionary),
          MessageDialog.OK,
          new BidiTranslator(dictionary));
      }
      catch (NumberFormatException ex)
      {
        String[] params = { textField.getText() };

        MessageDialog.messageBox(
          this,
          "Invalid value", //ivde
          Utils.formatMessage(
            "\"{0}\" in not a valid distance", //ivde
            params,
            dictionary),
          MessageDialog.OK,
          new BidiTranslator(dictionary));
        textField.requestFocus();
      }
    }
  }
}

