// This is a sample DCALC frame using the database dictionary.
//
// Database dictionary gets the dictionary data from two database tables.
//
// This code contains sample to get the dictionary data from
//
// 1) Access database through ODBC-JDBC Bridge
//    This only works on Windows 95 and Windows NT
//
// 2) InterBase database through JDBC (InterClient)
//    This is pure Java and works on every Java platform.
//    The database is located at Innoview's site.
//    It may not always be running.
//
// 3) Solid database through JDBC (SolidDriver)
//    This is pure Java and works on every Java platform.
//    The database is located at Innoview's site.
//    It may not always be running.

import java.applet.*;
import multilizer.*;

public class DatabaseMainFrame extends MainFrame
{
  public DatabaseMainFrame(Applet applet)
  {
    super(applet);

    DatabaseDictionary dictionary = new DatabaseDictionary();

    // Sets the drive, URL, the language table name and
    // the translation table name.

    if ((applet != null) && (applet.getParameter("Driver") != null))
      dictionary.setDriver(applet.getParameter("Driver"));
    else
      // By default Access is used.
      // To enable InterBase or Solid change the comments below.

      dictionary.setDriver("sun.jdbc.odbc.JdbcOdbcDriver");
      //dictionary.setDriver("interbase.interclient.Driver");
      //dictionary.setDriver("solid.jdbc.SolidDriver");

    if ((applet != null) && (applet.getParameter("URL") != null))
      dictionary.setURL(applet.getParameter("URL"));
    else
      // By default Access is used.
      // To enable InterBase or Solid change the comments below.

      dictionary.setURL("jdbc:odbc:JavaDcalcAccess");
      //dictionary.setURL("jdbc:interbase://innoview.fi/d:/database/javadcalc.gdb");
      //dictionary.setURL("jdbc:solid://innoview.fi:1313");

    if ((applet != null) && (applet.getParameter("User") != null))
      dictionary.setUser(applet.getParameter("User"));
    else
      dictionary.setUser("dcalc");

    if ((applet != null) && (applet.getParameter("Password") != null))
      dictionary.setPassword(applet.getParameter("Password"));
    else
      dictionary.setPassword("dcalc");

    if ((applet != null) && (applet.getParameter("LanguageTable") != null))
      dictionary.setLanguageTable(applet.getParameter("LanguageTable"));
    else
      dictionary.setLanguageTable("LanguageTable");

    if ((applet != null) && (applet.getParameter("TranslationTable") != null))
      dictionary.setTranslationTable(applet.getParameter("TranslationTable"));
    else
      dictionary.setTranslationTable("TranslationTable");

    translate(dictionary);
  }
}
