// This is a sample DCALC frame using the binary dictionary.
//
// Binary dictionary gets the dictionary data from a MLD file.
// It is a propiertary Multilizer dictionary file format.
// The user has two choices to access this file. Either he or she can
// give the file name or he or she can implement the BinaryStreamListener
// interface that contains one event to get the stream to the dictionary data.
//
// By default this sample uses the event stream. It has the advantage to
// work in applications and applets. The file name only works in applications.
// If you choose to use the file name you can comment out the
// LanguageStreamListener and TranslationStreamListener implematations.

import java.io.*;
import java.net.*;
import java.applet.*;
import multilizer.*;

public class BinaryMainFrame extends MainFrame implements
  LanguageStreamListener, TranslationStreamListener
{
  public BinaryMainFrame(Applet applet)
  {
    super(applet);

    BinaryDictionary dictionary = new BinaryDictionary();

    dictionary.addLanguageStreamListener(this);
    dictionary.addTranslationStreamListener(this);
    //dictionary.setDictionaryName("binary");

    translate(dictionary);
  }

  // The BinaryDictionary calls this event every time it need to get the stream
  // to the language data

  public void getLanguageStream(StreamEventObject e) throws IOException
  {
    if (applet == null)
      e.setStream(new FileInputStream("binary.languages"));
    else
      e.setStream(new URL(applet.getDocumentBase(), "binary.languages").openStream());
  }

  // The BinaryDictionary calls this event every time it need to get the stream
  // to the translation data

  public void getTranslationStream(StreamEventObject e) throws IOException
  {
    String fileName = "binary" + e.getBundleExtension() + ".mld";

    if (applet == null)
      e.setStream(new FileInputStream(fileName));
    else
      e.setStream(new URL(applet.getDocumentBase(), fileName).openStream());
  }
}

