/*
 * Decompiled with CFR 0.152.
 */
package multilizer;

import java.util.Locale;
import multilizer.Dictionary;
import multilizer.Language;

public class TestDictionary
extends Dictionary {
    public static final int TT_COVER = 0;
    public static final int TT_MINIMUM = 1;
    public static final int TT_TRANSLATE = 2;
    private int testType = 2;
    private String testLanguage = new String();
    private boolean expand = false;
    private boolean enclose = false;
    private boolean alternateCase = false;
    private boolean upperCase = true;
    private boolean diacritic = false;
    private String reductionChar = new String();
    private char replaceChar = (char)46;
    private char expandChar = (char)95;
    private char lastChar = (char)88;
    private int from1To5 = 200;
    private int from6To10 = 100;
    private int from11To20 = 70;
    private int from21To30 = 50;
    private int from31To50 = 30;
    private int over50 = 20;

    protected String translateJapanese(String string) {
        return string;
    }

    protected String translateKorean(String string) {
        return string;
    }

    protected String translateSimplifiedChinese(String string) {
        return string;
    }

    protected String translateTraditionalChinese(String string) {
        return string;
    }

    protected String translateArabic(String string) {
        return string;
    }

    protected String translateHebrew(String string) {
        return string;
    }

    protected String translateCyrillic(String string) {
        return string;
    }

    protected String translateGreek(String string) {
        return string;
    }

    protected String translateLatin(String string) {
        int n;
        if (this.expand) {
            int n2;
            n = n2 = string.length();
            n = n2 <= 5 ? n2 + this.from1To5 * n2 / 100 : (n2 <= 10 ? n2 + this.from6To10 * n2 / 100 : (n2 <= 20 ? n2 + this.from11To20 * n2 / 100 : (n2 <= 30 ? n2 + this.from21To30 * n2 / 100 : (n2 <= 50 ? n2 + this.from31To50 * n2 / 100 : n2 + this.over50 * n2 / 100))));
            if (this.enclose) {
                n -= 2;
            }
            int n3 = n2;
            while (n3 < n - 2) {
                string = String.valueOf(string) + this.expandChar;
                ++n3;
            }
            string = String.valueOf(string) + this.lastChar;
        }
        if (this.enclose) {
            string = String.valueOf('{') + string + '}';
        }
        if (this.alternateCase) {
            String string2 = new String();
            n = 0;
            while (n < string.length()) {
                String string3 = string.substring(n, n + 1);
                if (n % 2 == 0) {
                    string2.concat(string3.toUpperCase(this.getLanguageLocale()));
                } else {
                    string2.concat(string3);
                }
                ++n;
            }
            string = string2;
        }
        if (this.upperCase) {
            string = string.toUpperCase(this.getLanguageLocale());
        }
        if (this.diacritic) {
            // empty if block
        }
        return string;
    }

    protected Locale getTestLocale() {
        if (this.testLanguage.length() == 0) {
            return Locale.getDefault();
        }
        return new Locale(this.testLanguage, "");
    }

    protected String translateString(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (this.getActiveLanguage() == 1) {
            switch (this.testType) {
                case 0: {
                    String string2 = new String();
                    int n = 0;
                    while (n < string.length()) {
                        string2 = String.valueOf(string2) + this.replaceChar;
                        ++n;
                    }
                    return string2;
                }
                case 1: {
                    if (this.reductionChar.length() == 0) {
                        return string.substring(0, 1);
                    }
                    return this.reductionChar;
                }
            }
            char[] cArray = new char[]{this.expandChar, this.lastChar};
            if (string.charAt(0) == '{' || string.indexOf(new String(cArray)) >= 0) {
                return string;
            }
            Language language = this.getLanguageData();
            if (language.language.equals("jp")) {
                return this.translateJapanese(string);
            }
            if (language.language.equals("ko")) {
                return this.translateKorean(string);
            }
            if (language.language.equals("zh")) {
                if (language.defaultCountry.equals("CN") || language.defaultCountry.equals("SG")) {
                    return this.translateSimplifiedChinese(string);
                }
                return this.translateTraditionalChinese(string);
            }
            if (language.language.equals("ar")) {
                return this.translateArabic(string);
            }
            if (language.language.equals("he")) {
                return this.translateHebrew(string);
            }
            if (language.language.equals("be") || language.language.equals("bg") || language.language.equals("ru") || language.language.equals("sr") || language.language.equals("uk")) {
                return this.translateCyrillic(string);
            }
            if (language.language.equals("el")) {
                return this.translateGreek(string);
            }
            return this.translateLatin(string);
        }
        return string;
    }

    public int getLanguageCount() {
        return 3;
    }

    public Language getLanguageData(int n) {
        Language language = new Language();
        switch (n) {
            case 0: {
                language.language = "  ";
                language.defaultCountry = "  ";
                language.englishName = "Native";
                language.nativeName = "Native";
                break;
            }
            case 1: {
                Locale locale = this.getTestLocale();
                language.language = locale.getLanguage();
                language.defaultCountry = locale.getCountry();
                language.englishName = String.valueOf(locale.getDisplayLanguage(Locale.ENGLISH)) + " (Translated test)";
                language.nativeName = locale.getDisplayLanguage();
                break;
            }
            case 2: {
                Locale locale = this.getTestLocale();
                language.language = locale.getLanguage();
                language.defaultCountry = locale.getCountry();
                language.englishName = String.valueOf(locale.getDisplayLanguage(Locale.ENGLISH)) + " (Native test)";
                language.nativeName = locale.getDisplayLanguage();
            }
        }
        return language;
    }

    public int getTestType() {
        return this.testType;
    }

    public void setTestType(int n) {
        this.testType = n;
    }

    public String getTestLanguage() {
        return this.testLanguage;
    }

    public void setTestLanguage(String string) {
        this.testLanguage = string;
    }

    public String getReductionChar() {
        return this.reductionChar;
    }

    public void setReductionChar(String string) {
        this.reductionChar = string;
    }

    public char getReplaceChar() {
        return this.replaceChar;
    }

    public void setReplaceChar(char c) {
        this.replaceChar = c;
    }

    public char getExpandChar() {
        return this.expandChar;
    }

    public void setExpandChar(char c) {
        this.expandChar = c;
    }

    public char getLastChar() {
        return this.lastChar;
    }

    public void setLastChar(char c) {
        this.lastChar = c;
    }

    public int getFrom1To5() {
        return this.from1To5;
    }

    public void setFrom1To5(int n) {
        this.from1To5 = n;
    }

    public int getFrom6To10() {
        return this.from6To10;
    }

    public void setFrom6To10(int n) {
        this.from6To10 = n;
    }

    public int getFrom11To20() {
        return this.from11To20;
    }

    public void setFrom11To20(int n) {
        this.from11To20 = n;
    }

    public int getFrom21To30() {
        return this.from21To30;
    }

    public void setFrom21To30(int n) {
        this.from21To30 = n;
    }

    public int getFrom31To50() {
        return this.from31To50;
    }

    public void setFrom31To50(int n) {
        this.from31To50 = n;
    }

    public int getOver50() {
        return this.over50;
    }

    public void setOver50(int n) {
        this.over50 = n;
    }

    public boolean getExpand() {
        return this.expand;
    }

    public void setExpand(boolean bl) {
        this.expand = bl;
    }

    public boolean getEnclose() {
        return this.enclose;
    }

    public void setEnclose(boolean bl) {
        this.enclose = bl;
    }

    public boolean getAlternateCase() {
        return this.alternateCase;
    }

    public void setAlternateCase(boolean bl) {
        this.alternateCase = bl;
    }

    public boolean getUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean bl) {
        this.upperCase = bl;
    }

    public boolean getDiacritic() {
        return this.diacritic;
    }

    public void setDiacritic(boolean bl) {
        this.diacritic = bl;
    }
}

