/*
 * Decompiled with CFR 0.152.
 */
package multilizer;

import java.awt.Button;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.StringTokenizer;
import multilizer.Target;
import multilizer.TargetDialog;
import multilizer.Translator;

public class TargetsPanel
extends Panel
implements ActionListener,
ItemListener {
    protected List list = new List(8);
    private Button addButton = new Button("Add");
    private Button editButton = new Button("Edit");
    private Button removeButton = new Button("Remove");
    private Button defaultButton = new Button("Default");
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public TargetsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.list.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagLayout.setConstraints(this.list, gridBagConstraints);
        this.add(this.list);
        this.addButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.addButton, gridBagConstraints);
        this.add(this.addButton);
        this.editButton.addActionListener(this);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.editButton, gridBagConstraints);
        this.add(this.editButton);
        this.removeButton.addActionListener(this);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.removeButton, gridBagConstraints);
        this.add(this.removeButton);
        this.defaultButton.addActionListener(this);
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.defaultButton, gridBagConstraints);
        this.add(this.defaultButton);
        this.setSize(350, 300);
    }

    public String getTargets() {
        String string = "";
        int n = 0;
        while (n < this.list.getItemCount()) {
            if (string.length() > 0) {
                string = String.valueOf(string) + ";";
            }
            string = String.valueOf(string) + TargetsPanel.displayStringToString(this.list.getItem(n));
            ++n;
        }
        return string;
    }

    public void setTargets(String string) {
        this.list.removeAll();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            this.add(Translator.stringToTarget(stringTokenizer.nextToken()));
        }
        if (this.list.getItemCount() > 0) {
            this.list.select(0);
        }
        this.updateButtons();
    }

    public static String displayStringToString(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        string2 = stringTokenizer.nextToken().equals("include") ? "+" : "-";
        string2 = String.valueOf(string2) + stringTokenizer.nextToken();
        return string2;
    }

    protected void add(Target target) {
        this.list.add(Translator.targetToString(target, true));
    }

    protected void updateButtons() {
        this.editButton.setEnabled(this.list.getItemCount() > 0);
        this.removeButton.setEnabled(this.list.getItemCount() > 0);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateButtons();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addButton) {
            TargetDialog targetDialog = new TargetDialog(null, new Target("", ""));
            if (targetDialog.showModal()) {
                this.add(targetDialog.getValue());
            }
            this.list.select(this.list.getItemCount() - 1);
        } else if (actionEvent.getSource() == this.editButton) {
            TargetDialog targetDialog = new TargetDialog(null, Translator.stringToTarget(TargetsPanel.displayStringToString(this.list.getItem(this.list.getSelectedIndex()))));
            if (targetDialog.showModal()) {
                this.list.replaceItem(Translator.targetToString(targetDialog.getValue(), true), this.list.getSelectedIndex());
            }
        } else if (actionEvent.getSource() == this.removeButton) {
            int n = this.list.getSelectedIndex();
            this.list.remove(n);
            if (n >= this.list.getItemCount()) {
                --n;
            }
            this.list.select(n);
        } else if (actionEvent.getSource() == this.defaultButton) {
            this.list.removeAll();
            this.add(new Target("", "text"));
            this.add(new Target("", "label"));
            this.add(new Target("", "title"));
            this.add(new Target("", "items"));
            this.add(new Target("", "toolTipText"));
            this.list.select(0);
        }
        this.changed();
        this.updateButtons();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    protected void changed() {
        this.support.firePropertyChange("", null, null);
    }
}

