/*
 * Decompiled with CFR 0.152.
 */
package multilizer;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import multilizer.Language;
import multilizer.SelectDialog;
import multilizer.Translator;

public class SelectLanguageDialog
extends SelectDialog {
    private int language;

    public SelectLanguageDialog(Frame frame, Translator translator, boolean bl) throws Exception {
        super(frame, "Select Language", translator);
        translator.setHost(this);
        if (bl) {
            translator.translate();
        }
        int n = 0;
        while (n < translator.getDictionary().getLanguageCount()) {
            Language language = translator.getDictionary().getLanguageData(n);
            if (language.language.equals("") || language.language.equals("  ")) {
                this.startAt = 1;
            } else if (bl) {
                this.list.add(language.nativeName);
            } else {
                this.list.add(language.englishName);
            }
            ++n;
        }
        this.language = translator.getDictionary().getActiveLanguage();
        this.list.select(this.language - this.startAt);
        if (!bl) {
            translator.translate();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton || actionEvent.getSource() == this.list) {
            this.language = this.startAt + this.list.getSelectedIndex();
        }
        super.actionPerformed(actionEvent);
    }

    public int getLanguage() {
        return this.language;
    }

    public static int select(Frame frame, Translator translator, boolean bl) {
        int n = translator.getDictionary().getActiveLanguage();
        try {
            SelectLanguageDialog selectLanguageDialog = new SelectLanguageDialog(frame, translator, bl);
            if (selectLanguageDialog.showModal()) {
                return selectLanguageDialog.getLanguage();
            }
            return -1;
        }
        catch (Exception exception) {
            return n;
        }
    }
}

